/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava.redis.client;

import rx.Observable;
import rx.Single;
import io.vertx.rx.java.RxHelper;
import io.vertx.rx.java.WriteStreamSubscriber;
import io.vertx.rx.java.SingleOnSubscribeAdapter;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * <b>Auto generated</b> Redis API client wrapper.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.redis.client.RedisAPI original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.redis.client.RedisAPI.class)
public class RedisAPI {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    RedisAPI that = (RedisAPI) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<RedisAPI> __TYPE_ARG = new TypeArg<>(    obj -> new RedisAPI((io.vertx.redis.client.RedisAPI) obj),
    RedisAPI::getDelegate
  );

  private final io.vertx.redis.client.RedisAPI delegate;
  
  public RedisAPI(io.vertx.redis.client.RedisAPI delegate) {
    this.delegate = delegate;
  }

  public RedisAPI(Object delegate) {
    this.delegate = (io.vertx.redis.client.RedisAPI)delegate;
  }

  public io.vertx.redis.client.RedisAPI getDelegate() {
    return delegate;
  }

  public void close() { 
    delegate.close();
  }

  /**
   * Redis command <a href="https://redis.io/commands/FT.ADD">ftAdd</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI ftAdd(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.ftAdd(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/FT.ADD">ftAdd</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI ftAdd(java.util.List<java.lang.String> args) {
    return 
ftAdd(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/FT.ADD">ftAdd</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxFtAdd(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      ftAdd(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/FT.AGGREGATE">ftAggregate</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI ftAggregate(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.ftAggregate(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/FT.AGGREGATE">ftAggregate</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI ftAggregate(java.util.List<java.lang.String> args) {
    return 
ftAggregate(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/FT.AGGREGATE">ftAggregate</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxFtAggregate(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      ftAggregate(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/FT.ALIASADD">ftAliasadd</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI ftAliasadd(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.ftAliasadd(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/FT.ALIASADD">ftAliasadd</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI ftAliasadd(java.util.List<java.lang.String> args) {
    return 
ftAliasadd(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/FT.ALIASADD">ftAliasadd</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxFtAliasadd(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      ftAliasadd(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/FT.ALIASDEL">ftAliasdel</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI ftAliasdel(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.ftAliasdel(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/FT.ALIASDEL">ftAliasdel</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI ftAliasdel(java.util.List<java.lang.String> args) {
    return 
ftAliasdel(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/FT.ALIASDEL">ftAliasdel</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxFtAliasdel(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      ftAliasdel(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/FT.ALIASUPDATE">ftAliasupdate</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI ftAliasupdate(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.ftAliasupdate(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/FT.ALIASUPDATE">ftAliasupdate</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI ftAliasupdate(java.util.List<java.lang.String> args) {
    return 
ftAliasupdate(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/FT.ALIASUPDATE">ftAliasupdate</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxFtAliasupdate(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      ftAliasupdate(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/FT.ALTER">ftAlter</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI ftAlter(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.ftAlter(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/FT.ALTER">ftAlter</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI ftAlter(java.util.List<java.lang.String> args) {
    return 
ftAlter(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/FT.ALTER">ftAlter</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxFtAlter(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      ftAlter(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/FT.CONFIG">ftConfig</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI ftConfig(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.ftConfig(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/FT.CONFIG">ftConfig</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI ftConfig(java.util.List<java.lang.String> args) {
    return 
ftConfig(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/FT.CONFIG">ftConfig</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxFtConfig(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      ftConfig(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/FT.CREATE">ftCreate</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI ftCreate(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.ftCreate(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/FT.CREATE">ftCreate</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI ftCreate(java.util.List<java.lang.String> args) {
    return 
ftCreate(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/FT.CREATE">ftCreate</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxFtCreate(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      ftCreate(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/FT.CURSOR">ftCursor</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI ftCursor(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.ftCursor(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/FT.CURSOR">ftCursor</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI ftCursor(java.util.List<java.lang.String> args) {
    return 
ftCursor(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/FT.CURSOR">ftCursor</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxFtCursor(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      ftCursor(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/FT.DEBUG">ftDebug</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI ftDebug(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.ftDebug(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/FT.DEBUG">ftDebug</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI ftDebug(java.util.List<java.lang.String> args) {
    return 
ftDebug(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/FT.DEBUG">ftDebug</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxFtDebug(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      ftDebug(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/FT.DEL">ftDel</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI ftDel(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.ftDel(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/FT.DEL">ftDel</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI ftDel(java.util.List<java.lang.String> args) {
    return 
ftDel(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/FT.DEL">ftDel</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxFtDel(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      ftDel(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/FT.DICTADD">ftDictadd</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI ftDictadd(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.ftDictadd(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/FT.DICTADD">ftDictadd</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI ftDictadd(java.util.List<java.lang.String> args) {
    return 
ftDictadd(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/FT.DICTADD">ftDictadd</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxFtDictadd(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      ftDictadd(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/FT.DICTDEL">ftDictdel</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI ftDictdel(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.ftDictdel(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/FT.DICTDEL">ftDictdel</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI ftDictdel(java.util.List<java.lang.String> args) {
    return 
ftDictdel(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/FT.DICTDEL">ftDictdel</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxFtDictdel(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      ftDictdel(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/FT.DICTDUMP">ftDictdump</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI ftDictdump(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.ftDictdump(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/FT.DICTDUMP">ftDictdump</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI ftDictdump(java.util.List<java.lang.String> args) {
    return 
ftDictdump(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/FT.DICTDUMP">ftDictdump</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxFtDictdump(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      ftDictdump(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/FT.DROP">ftDrop</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI ftDrop(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.ftDrop(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/FT.DROP">ftDrop</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI ftDrop(java.util.List<java.lang.String> args) {
    return 
ftDrop(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/FT.DROP">ftDrop</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxFtDrop(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      ftDrop(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/FT.DROPINDEX">ftDropindex</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI ftDropindex(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.ftDropindex(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/FT.DROPINDEX">ftDropindex</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI ftDropindex(java.util.List<java.lang.String> args) {
    return 
ftDropindex(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/FT.DROPINDEX">ftDropindex</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxFtDropindex(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      ftDropindex(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/FT.EXPLAIN">ftExplain</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI ftExplain(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.ftExplain(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/FT.EXPLAIN">ftExplain</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI ftExplain(java.util.List<java.lang.String> args) {
    return 
ftExplain(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/FT.EXPLAIN">ftExplain</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxFtExplain(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      ftExplain(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/FT.EXPLAINCLI">ftExplaincli</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI ftExplaincli(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.ftExplaincli(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/FT.EXPLAINCLI">ftExplaincli</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI ftExplaincli(java.util.List<java.lang.String> args) {
    return 
ftExplaincli(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/FT.EXPLAINCLI">ftExplaincli</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxFtExplaincli(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      ftExplaincli(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/FT.GET">ftGet</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI ftGet(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.ftGet(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/FT.GET">ftGet</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI ftGet(java.util.List<java.lang.String> args) {
    return 
ftGet(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/FT.GET">ftGet</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxFtGet(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      ftGet(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/FT.INFO">ftInfo</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI ftInfo(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.ftInfo(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/FT.INFO">ftInfo</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI ftInfo(java.util.List<java.lang.String> args) {
    return 
ftInfo(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/FT.INFO">ftInfo</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxFtInfo(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      ftInfo(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/FT.MGET">ftMget</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI ftMget(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.ftMget(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/FT.MGET">ftMget</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI ftMget(java.util.List<java.lang.String> args) {
    return 
ftMget(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/FT.MGET">ftMget</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxFtMget(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      ftMget(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/FT.PROFILE">ftProfile</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI ftProfile(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.ftProfile(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/FT.PROFILE">ftProfile</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI ftProfile(java.util.List<java.lang.String> args) {
    return 
ftProfile(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/FT.PROFILE">ftProfile</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxFtProfile(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      ftProfile(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/FT.SAFEADD">ftSafeadd</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI ftSafeadd(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.ftSafeadd(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/FT.SAFEADD">ftSafeadd</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI ftSafeadd(java.util.List<java.lang.String> args) {
    return 
ftSafeadd(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/FT.SAFEADD">ftSafeadd</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxFtSafeadd(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      ftSafeadd(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/FT.SEARCH">ftSearch</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI ftSearch(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.ftSearch(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/FT.SEARCH">ftSearch</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI ftSearch(java.util.List<java.lang.String> args) {
    return 
ftSearch(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/FT.SEARCH">ftSearch</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxFtSearch(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      ftSearch(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/FT.SPELLCHECK">ftSpellcheck</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI ftSpellcheck(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.ftSpellcheck(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/FT.SPELLCHECK">ftSpellcheck</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI ftSpellcheck(java.util.List<java.lang.String> args) {
    return 
ftSpellcheck(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/FT.SPELLCHECK">ftSpellcheck</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxFtSpellcheck(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      ftSpellcheck(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/FT.SUGADD">ftSugadd</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI ftSugadd(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.ftSugadd(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/FT.SUGADD">ftSugadd</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI ftSugadd(java.util.List<java.lang.String> args) {
    return 
ftSugadd(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/FT.SUGADD">ftSugadd</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxFtSugadd(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      ftSugadd(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/FT.SUGDEL">ftSugdel</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI ftSugdel(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.ftSugdel(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/FT.SUGDEL">ftSugdel</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI ftSugdel(java.util.List<java.lang.String> args) {
    return 
ftSugdel(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/FT.SUGDEL">ftSugdel</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxFtSugdel(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      ftSugdel(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/FT.SUGGET">ftSugget</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI ftSugget(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.ftSugget(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/FT.SUGGET">ftSugget</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI ftSugget(java.util.List<java.lang.String> args) {
    return 
ftSugget(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/FT.SUGGET">ftSugget</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxFtSugget(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      ftSugget(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/FT.SUGLEN">ftSuglen</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI ftSuglen(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.ftSuglen(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/FT.SUGLEN">ftSuglen</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI ftSuglen(java.util.List<java.lang.String> args) {
    return 
ftSuglen(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/FT.SUGLEN">ftSuglen</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxFtSuglen(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      ftSuglen(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/FT.SYNADD">ftSynadd</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI ftSynadd(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.ftSynadd(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/FT.SYNADD">ftSynadd</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI ftSynadd(java.util.List<java.lang.String> args) {
    return 
ftSynadd(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/FT.SYNADD">ftSynadd</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxFtSynadd(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      ftSynadd(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/FT.SYNDUMP">ftSyndump</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI ftSyndump(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.ftSyndump(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/FT.SYNDUMP">ftSyndump</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI ftSyndump(java.util.List<java.lang.String> args) {
    return 
ftSyndump(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/FT.SYNDUMP">ftSyndump</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxFtSyndump(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      ftSyndump(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/FT.SYNUPDATE">ftSynupdate</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI ftSynupdate(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.ftSynupdate(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/FT.SYNUPDATE">ftSynupdate</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI ftSynupdate(java.util.List<java.lang.String> args) {
    return 
ftSynupdate(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/FT.SYNUPDATE">ftSynupdate</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxFtSynupdate(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      ftSynupdate(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/FT.TAGVALS">ftTagvals</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI ftTagvals(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.ftTagvals(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/FT.TAGVALS">ftTagvals</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI ftTagvals(java.util.List<java.lang.String> args) {
    return 
ftTagvals(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/FT.TAGVALS">ftTagvals</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxFtTagvals(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      ftTagvals(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/FT._ALIASADDIFNX">ftAliasaddifnx</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI ftAliasaddifnx(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.ftAliasaddifnx(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/FT._ALIASADDIFNX">ftAliasaddifnx</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI ftAliasaddifnx(java.util.List<java.lang.String> args) {
    return 
ftAliasaddifnx(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/FT._ALIASADDIFNX">ftAliasaddifnx</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxFtAliasaddifnx(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      ftAliasaddifnx(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/FT._ALIASDELIFX">ftAliasdelifx</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI ftAliasdelifx(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.ftAliasdelifx(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/FT._ALIASDELIFX">ftAliasdelifx</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI ftAliasdelifx(java.util.List<java.lang.String> args) {
    return 
ftAliasdelifx(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/FT._ALIASDELIFX">ftAliasdelifx</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxFtAliasdelifx(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      ftAliasdelifx(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/FT._ALTERIFNX">ftAlterifnx</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI ftAlterifnx(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.ftAlterifnx(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/FT._ALTERIFNX">ftAlterifnx</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI ftAlterifnx(java.util.List<java.lang.String> args) {
    return 
ftAlterifnx(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/FT._ALTERIFNX">ftAlterifnx</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxFtAlterifnx(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      ftAlterifnx(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/FT._CREATEIFNX">ftCreateifnx</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI ftCreateifnx(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.ftCreateifnx(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/FT._CREATEIFNX">ftCreateifnx</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI ftCreateifnx(java.util.List<java.lang.String> args) {
    return 
ftCreateifnx(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/FT._CREATEIFNX">ftCreateifnx</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxFtCreateifnx(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      ftCreateifnx(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/FT._DROPIFX">ftDropifx</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI ftDropifx(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.ftDropifx(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/FT._DROPIFX">ftDropifx</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI ftDropifx(java.util.List<java.lang.String> args) {
    return 
ftDropifx(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/FT._DROPIFX">ftDropifx</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxFtDropifx(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      ftDropifx(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/FT._DROPINDEXIFX">ftDropindexifx</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI ftDropindexifx(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.ftDropindexifx(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/FT._DROPINDEXIFX">ftDropindexifx</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI ftDropindexifx(java.util.List<java.lang.String> args) {
    return 
ftDropindexifx(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/FT._DROPINDEXIFX">ftDropindexifx</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxFtDropindexifx(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      ftDropindexifx(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/FT._LIST">ftList</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI ftList(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.ftList(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/FT._LIST">ftList</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI ftList(java.util.List<java.lang.String> args) {
    return 
ftList(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/FT._LIST">ftList</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxFtList(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      ftList(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/acl">acl</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI acl(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.acl(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/acl">acl</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI acl(java.util.List<java.lang.String> args) {
    return 
acl(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/acl">acl</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxAcl(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      acl(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/append">append</a>.
   * @param arg0 
   * @param arg1 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI append(java.lang.String arg0, java.lang.String arg1, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.append(arg0, arg1, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/append">append</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI append(java.lang.String arg0, java.lang.String arg1) {
    return 
append(arg0, arg1, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/append">append</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxAppend(java.lang.String arg0, java.lang.String arg1) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      append(arg0, arg1, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/asking">asking</a>.
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI asking(io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.asking(new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/asking">asking</a>.
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI asking() {
    return 
asking(ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/asking">asking</a>.
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxAsking() { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      asking(fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/auth">auth</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI auth(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.auth(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/auth">auth</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI auth(java.util.List<java.lang.String> args) {
    return 
auth(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/auth">auth</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxAuth(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      auth(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/bf.add">bfAdd</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI bfAdd(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.bfAdd(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/bf.add">bfAdd</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI bfAdd(java.util.List<java.lang.String> args) {
    return 
bfAdd(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/bf.add">bfAdd</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxBfAdd(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      bfAdd(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/bf.debug">bfDebug</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI bfDebug(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.bfDebug(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/bf.debug">bfDebug</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI bfDebug(java.util.List<java.lang.String> args) {
    return 
bfDebug(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/bf.debug">bfDebug</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxBfDebug(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      bfDebug(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/bf.exists">bfExists</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI bfExists(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.bfExists(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/bf.exists">bfExists</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI bfExists(java.util.List<java.lang.String> args) {
    return 
bfExists(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/bf.exists">bfExists</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxBfExists(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      bfExists(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/bf.info">bfInfo</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI bfInfo(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.bfInfo(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/bf.info">bfInfo</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI bfInfo(java.util.List<java.lang.String> args) {
    return 
bfInfo(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/bf.info">bfInfo</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxBfInfo(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      bfInfo(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/bf.insert">bfInsert</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI bfInsert(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.bfInsert(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/bf.insert">bfInsert</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI bfInsert(java.util.List<java.lang.String> args) {
    return 
bfInsert(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/bf.insert">bfInsert</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxBfInsert(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      bfInsert(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/bf.loadchunk">bfLoadchunk</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI bfLoadchunk(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.bfLoadchunk(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/bf.loadchunk">bfLoadchunk</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI bfLoadchunk(java.util.List<java.lang.String> args) {
    return 
bfLoadchunk(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/bf.loadchunk">bfLoadchunk</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxBfLoadchunk(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      bfLoadchunk(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/bf.madd">bfMadd</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI bfMadd(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.bfMadd(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/bf.madd">bfMadd</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI bfMadd(java.util.List<java.lang.String> args) {
    return 
bfMadd(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/bf.madd">bfMadd</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxBfMadd(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      bfMadd(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/bf.mexists">bfMexists</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI bfMexists(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.bfMexists(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/bf.mexists">bfMexists</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI bfMexists(java.util.List<java.lang.String> args) {
    return 
bfMexists(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/bf.mexists">bfMexists</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxBfMexists(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      bfMexists(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/bf.reserve">bfReserve</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI bfReserve(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.bfReserve(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/bf.reserve">bfReserve</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI bfReserve(java.util.List<java.lang.String> args) {
    return 
bfReserve(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/bf.reserve">bfReserve</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxBfReserve(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      bfReserve(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/bf.scandump">bfScandump</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI bfScandump(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.bfScandump(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/bf.scandump">bfScandump</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI bfScandump(java.util.List<java.lang.String> args) {
    return 
bfScandump(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/bf.scandump">bfScandump</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxBfScandump(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      bfScandump(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/bgrewriteaof">bgrewriteaof</a>.
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI bgrewriteaof(io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.bgrewriteaof(new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/bgrewriteaof">bgrewriteaof</a>.
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI bgrewriteaof() {
    return 
bgrewriteaof(ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/bgrewriteaof">bgrewriteaof</a>.
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxBgrewriteaof() { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      bgrewriteaof(fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/bgsave">bgsave</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI bgsave(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.bgsave(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/bgsave">bgsave</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI bgsave(java.util.List<java.lang.String> args) {
    return 
bgsave(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/bgsave">bgsave</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxBgsave(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      bgsave(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/bitcount">bitcount</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI bitcount(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.bitcount(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/bitcount">bitcount</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI bitcount(java.util.List<java.lang.String> args) {
    return 
bitcount(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/bitcount">bitcount</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxBitcount(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      bitcount(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/bitfield">bitfield</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI bitfield(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.bitfield(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/bitfield">bitfield</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI bitfield(java.util.List<java.lang.String> args) {
    return 
bitfield(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/bitfield">bitfield</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxBitfield(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      bitfield(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/bitfield_ro">bitfieldRo</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI bitfieldRo(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.bitfieldRo(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/bitfield_ro">bitfieldRo</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI bitfieldRo(java.util.List<java.lang.String> args) {
    return 
bitfieldRo(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/bitfield_ro">bitfieldRo</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxBitfieldRo(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      bitfieldRo(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/bitop">bitop</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI bitop(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.bitop(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/bitop">bitop</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI bitop(java.util.List<java.lang.String> args) {
    return 
bitop(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/bitop">bitop</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxBitop(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      bitop(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/bitpos">bitpos</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI bitpos(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.bitpos(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/bitpos">bitpos</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI bitpos(java.util.List<java.lang.String> args) {
    return 
bitpos(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/bitpos">bitpos</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxBitpos(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      bitpos(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/blmove">blmove</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @param arg3 
   * @param arg4 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI blmove(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2, java.lang.String arg3, java.lang.String arg4, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.blmove(arg0, arg1, arg2, arg3, arg4, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/blmove">blmove</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @param arg3 
   * @param arg4 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI blmove(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2, java.lang.String arg3, java.lang.String arg4) {
    return 
blmove(arg0, arg1, arg2, arg3, arg4, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/blmove">blmove</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @param arg3 
   * @param arg4 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxBlmove(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2, java.lang.String arg3, java.lang.String arg4) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      blmove(arg0, arg1, arg2, arg3, arg4, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/blmpop">blmpop</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI blmpop(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.blmpop(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/blmpop">blmpop</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI blmpop(java.util.List<java.lang.String> args) {
    return 
blmpop(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/blmpop">blmpop</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxBlmpop(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      blmpop(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/blpop">blpop</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI blpop(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.blpop(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/blpop">blpop</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI blpop(java.util.List<java.lang.String> args) {
    return 
blpop(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/blpop">blpop</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxBlpop(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      blpop(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/brpop">brpop</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI brpop(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.brpop(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/brpop">brpop</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI brpop(java.util.List<java.lang.String> args) {
    return 
brpop(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/brpop">brpop</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxBrpop(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      brpop(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/brpoplpush">brpoplpush</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI brpoplpush(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.brpoplpush(arg0, arg1, arg2, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/brpoplpush">brpoplpush</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI brpoplpush(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) {
    return 
brpoplpush(arg0, arg1, arg2, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/brpoplpush">brpoplpush</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxBrpoplpush(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      brpoplpush(arg0, arg1, arg2, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/bzmpop">bzmpop</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI bzmpop(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.bzmpop(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/bzmpop">bzmpop</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI bzmpop(java.util.List<java.lang.String> args) {
    return 
bzmpop(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/bzmpop">bzmpop</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxBzmpop(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      bzmpop(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/bzpopmax">bzpopmax</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI bzpopmax(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.bzpopmax(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/bzpopmax">bzpopmax</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI bzpopmax(java.util.List<java.lang.String> args) {
    return 
bzpopmax(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/bzpopmax">bzpopmax</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxBzpopmax(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      bzpopmax(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/bzpopmin">bzpopmin</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI bzpopmin(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.bzpopmin(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/bzpopmin">bzpopmin</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI bzpopmin(java.util.List<java.lang.String> args) {
    return 
bzpopmin(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/bzpopmin">bzpopmin</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxBzpopmin(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      bzpopmin(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/cf.add">cfAdd</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI cfAdd(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.cfAdd(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/cf.add">cfAdd</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI cfAdd(java.util.List<java.lang.String> args) {
    return 
cfAdd(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/cf.add">cfAdd</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxCfAdd(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      cfAdd(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/cf.addnx">cfAddnx</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI cfAddnx(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.cfAddnx(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/cf.addnx">cfAddnx</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI cfAddnx(java.util.List<java.lang.String> args) {
    return 
cfAddnx(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/cf.addnx">cfAddnx</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxCfAddnx(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      cfAddnx(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/cf.compact">cfCompact</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI cfCompact(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.cfCompact(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/cf.compact">cfCompact</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI cfCompact(java.util.List<java.lang.String> args) {
    return 
cfCompact(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/cf.compact">cfCompact</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxCfCompact(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      cfCompact(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/cf.count">cfCount</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI cfCount(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.cfCount(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/cf.count">cfCount</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI cfCount(java.util.List<java.lang.String> args) {
    return 
cfCount(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/cf.count">cfCount</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxCfCount(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      cfCount(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/cf.debug">cfDebug</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI cfDebug(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.cfDebug(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/cf.debug">cfDebug</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI cfDebug(java.util.List<java.lang.String> args) {
    return 
cfDebug(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/cf.debug">cfDebug</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxCfDebug(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      cfDebug(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/cf.del">cfDel</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI cfDel(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.cfDel(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/cf.del">cfDel</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI cfDel(java.util.List<java.lang.String> args) {
    return 
cfDel(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/cf.del">cfDel</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxCfDel(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      cfDel(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/cf.exists">cfExists</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI cfExists(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.cfExists(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/cf.exists">cfExists</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI cfExists(java.util.List<java.lang.String> args) {
    return 
cfExists(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/cf.exists">cfExists</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxCfExists(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      cfExists(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/cf.info">cfInfo</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI cfInfo(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.cfInfo(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/cf.info">cfInfo</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI cfInfo(java.util.List<java.lang.String> args) {
    return 
cfInfo(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/cf.info">cfInfo</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxCfInfo(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      cfInfo(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/cf.insert">cfInsert</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI cfInsert(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.cfInsert(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/cf.insert">cfInsert</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI cfInsert(java.util.List<java.lang.String> args) {
    return 
cfInsert(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/cf.insert">cfInsert</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxCfInsert(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      cfInsert(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/cf.insertnx">cfInsertnx</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI cfInsertnx(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.cfInsertnx(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/cf.insertnx">cfInsertnx</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI cfInsertnx(java.util.List<java.lang.String> args) {
    return 
cfInsertnx(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/cf.insertnx">cfInsertnx</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxCfInsertnx(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      cfInsertnx(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/cf.loadchunk">cfLoadchunk</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI cfLoadchunk(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.cfLoadchunk(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/cf.loadchunk">cfLoadchunk</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI cfLoadchunk(java.util.List<java.lang.String> args) {
    return 
cfLoadchunk(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/cf.loadchunk">cfLoadchunk</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxCfLoadchunk(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      cfLoadchunk(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/cf.mexists">cfMexists</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI cfMexists(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.cfMexists(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/cf.mexists">cfMexists</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI cfMexists(java.util.List<java.lang.String> args) {
    return 
cfMexists(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/cf.mexists">cfMexists</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxCfMexists(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      cfMexists(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/cf.reserve">cfReserve</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI cfReserve(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.cfReserve(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/cf.reserve">cfReserve</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI cfReserve(java.util.List<java.lang.String> args) {
    return 
cfReserve(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/cf.reserve">cfReserve</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxCfReserve(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      cfReserve(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/cf.scandump">cfScandump</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI cfScandump(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.cfScandump(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/cf.scandump">cfScandump</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI cfScandump(java.util.List<java.lang.String> args) {
    return 
cfScandump(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/cf.scandump">cfScandump</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxCfScandump(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      cfScandump(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/client">client</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI client(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.client(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/client">client</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI client(java.util.List<java.lang.String> args) {
    return 
client(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/client">client</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxClient(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      client(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/cluster">cluster</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI cluster(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.cluster(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/cluster">cluster</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI cluster(java.util.List<java.lang.String> args) {
    return 
cluster(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/cluster">cluster</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxCluster(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      cluster(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/cms.incrby">cmsIncrby</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI cmsIncrby(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.cmsIncrby(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/cms.incrby">cmsIncrby</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI cmsIncrby(java.util.List<java.lang.String> args) {
    return 
cmsIncrby(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/cms.incrby">cmsIncrby</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxCmsIncrby(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      cmsIncrby(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/cms.info">cmsInfo</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI cmsInfo(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.cmsInfo(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/cms.info">cmsInfo</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI cmsInfo(java.util.List<java.lang.String> args) {
    return 
cmsInfo(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/cms.info">cmsInfo</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxCmsInfo(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      cmsInfo(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/cms.initbydim">cmsInitbydim</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI cmsInitbydim(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.cmsInitbydim(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/cms.initbydim">cmsInitbydim</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI cmsInitbydim(java.util.List<java.lang.String> args) {
    return 
cmsInitbydim(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/cms.initbydim">cmsInitbydim</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxCmsInitbydim(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      cmsInitbydim(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/cms.initbyprob">cmsInitbyprob</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI cmsInitbyprob(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.cmsInitbyprob(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/cms.initbyprob">cmsInitbyprob</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI cmsInitbyprob(java.util.List<java.lang.String> args) {
    return 
cmsInitbyprob(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/cms.initbyprob">cmsInitbyprob</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxCmsInitbyprob(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      cmsInitbyprob(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/cms.merge">cmsMerge</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI cmsMerge(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.cmsMerge(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/cms.merge">cmsMerge</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI cmsMerge(java.util.List<java.lang.String> args) {
    return 
cmsMerge(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/cms.merge">cmsMerge</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxCmsMerge(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      cmsMerge(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/cms.query">cmsQuery</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI cmsQuery(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.cmsQuery(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/cms.query">cmsQuery</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI cmsQuery(java.util.List<java.lang.String> args) {
    return 
cmsQuery(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/cms.query">cmsQuery</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxCmsQuery(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      cmsQuery(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/command">command</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI command(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.command(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/command">command</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI command(java.util.List<java.lang.String> args) {
    return 
command(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/command">command</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxCommand(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      command(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/config">config</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI config(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.config(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/config">config</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI config(java.util.List<java.lang.String> args) {
    return 
config(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/config">config</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxConfig(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      config(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/copy">copy</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI copy(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.copy(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/copy">copy</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI copy(java.util.List<java.lang.String> args) {
    return 
copy(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/copy">copy</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxCopy(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      copy(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/dbsize">dbsize</a>.
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI dbsize(io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.dbsize(new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/dbsize">dbsize</a>.
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI dbsize() {
    return 
dbsize(ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/dbsize">dbsize</a>.
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxDbsize() { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      dbsize(fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/debug">debug</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI debug(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.debug(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/debug">debug</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI debug(java.util.List<java.lang.String> args) {
    return 
debug(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/debug">debug</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxDebug(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      debug(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/decr">decr</a>.
   * @param arg0 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI decr(java.lang.String arg0, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.decr(arg0, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/decr">decr</a>.
   * @param arg0 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI decr(java.lang.String arg0) {
    return 
decr(arg0, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/decr">decr</a>.
   * @param arg0 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxDecr(java.lang.String arg0) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      decr(arg0, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/decrby">decrby</a>.
   * @param arg0 
   * @param arg1 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI decrby(java.lang.String arg0, java.lang.String arg1, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.decrby(arg0, arg1, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/decrby">decrby</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI decrby(java.lang.String arg0, java.lang.String arg1) {
    return 
decrby(arg0, arg1, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/decrby">decrby</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxDecrby(java.lang.String arg0, java.lang.String arg1) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      decrby(arg0, arg1, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/del">del</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI del(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.del(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/del">del</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI del(java.util.List<java.lang.String> args) {
    return 
del(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/del">del</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxDel(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      del(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/discard">discard</a>.
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI discard(io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.discard(new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/discard">discard</a>.
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI discard() {
    return 
discard(ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/discard">discard</a>.
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxDiscard() { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      discard(fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/dump">dump</a>.
   * @param arg0 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI dump(java.lang.String arg0, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.dump(arg0, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/dump">dump</a>.
   * @param arg0 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI dump(java.lang.String arg0) {
    return 
dump(arg0, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/dump">dump</a>.
   * @param arg0 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxDump(java.lang.String arg0) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      dump(arg0, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/echo">echo</a>.
   * @param arg0 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI echo(java.lang.String arg0, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.echo(arg0, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/echo">echo</a>.
   * @param arg0 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI echo(java.lang.String arg0) {
    return 
echo(arg0, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/echo">echo</a>.
   * @param arg0 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxEcho(java.lang.String arg0) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      echo(arg0, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/eval">eval</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI eval(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.eval(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/eval">eval</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI eval(java.util.List<java.lang.String> args) {
    return 
eval(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/eval">eval</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxEval(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      eval(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/eval_ro">evalRo</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI evalRo(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.evalRo(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/eval_ro">evalRo</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI evalRo(java.util.List<java.lang.String> args) {
    return 
evalRo(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/eval_ro">evalRo</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxEvalRo(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      evalRo(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/evalsha">evalsha</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI evalsha(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.evalsha(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/evalsha">evalsha</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI evalsha(java.util.List<java.lang.String> args) {
    return 
evalsha(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/evalsha">evalsha</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxEvalsha(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      evalsha(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/evalsha_ro">evalshaRo</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI evalshaRo(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.evalshaRo(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/evalsha_ro">evalshaRo</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI evalshaRo(java.util.List<java.lang.String> args) {
    return 
evalshaRo(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/evalsha_ro">evalshaRo</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxEvalshaRo(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      evalshaRo(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/exec">exec</a>.
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI exec(io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.exec(new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/exec">exec</a>.
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI exec() {
    return 
exec(ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/exec">exec</a>.
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxExec() { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      exec(fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/exists">exists</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI exists(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.exists(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/exists">exists</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI exists(java.util.List<java.lang.String> args) {
    return 
exists(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/exists">exists</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxExists(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      exists(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/expire">expire</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI expire(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.expire(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/expire">expire</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI expire(java.util.List<java.lang.String> args) {
    return 
expire(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/expire">expire</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxExpire(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      expire(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/expireat">expireat</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI expireat(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.expireat(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/expireat">expireat</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI expireat(java.util.List<java.lang.String> args) {
    return 
expireat(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/expireat">expireat</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxExpireat(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      expireat(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/expiretime">expiretime</a>.
   * @param arg0 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI expiretime(java.lang.String arg0, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.expiretime(arg0, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/expiretime">expiretime</a>.
   * @param arg0 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI expiretime(java.lang.String arg0) {
    return 
expiretime(arg0, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/expiretime">expiretime</a>.
   * @param arg0 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxExpiretime(java.lang.String arg0) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      expiretime(arg0, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/failover">failover</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI failover(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.failover(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/failover">failover</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI failover(java.util.List<java.lang.String> args) {
    return 
failover(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/failover">failover</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxFailover(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      failover(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/fcall">fcall</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI fcall(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.fcall(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/fcall">fcall</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI fcall(java.util.List<java.lang.String> args) {
    return 
fcall(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/fcall">fcall</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxFcall(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      fcall(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/fcall_ro">fcallRo</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI fcallRo(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.fcallRo(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/fcall_ro">fcallRo</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI fcallRo(java.util.List<java.lang.String> args) {
    return 
fcallRo(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/fcall_ro">fcallRo</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxFcallRo(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      fcallRo(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/flushall">flushall</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI flushall(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.flushall(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/flushall">flushall</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI flushall(java.util.List<java.lang.String> args) {
    return 
flushall(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/flushall">flushall</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxFlushall(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      flushall(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/flushdb">flushdb</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI flushdb(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.flushdb(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/flushdb">flushdb</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI flushdb(java.util.List<java.lang.String> args) {
    return 
flushdb(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/flushdb">flushdb</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxFlushdb(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      flushdb(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/function">function</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI function(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.function(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/function">function</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI function(java.util.List<java.lang.String> args) {
    return 
function(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/function">function</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxFunction(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      function(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/geoadd">geoadd</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI geoadd(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.geoadd(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/geoadd">geoadd</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI geoadd(java.util.List<java.lang.String> args) {
    return 
geoadd(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/geoadd">geoadd</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxGeoadd(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      geoadd(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/geodist">geodist</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI geodist(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.geodist(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/geodist">geodist</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI geodist(java.util.List<java.lang.String> args) {
    return 
geodist(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/geodist">geodist</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxGeodist(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      geodist(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/geohash">geohash</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI geohash(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.geohash(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/geohash">geohash</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI geohash(java.util.List<java.lang.String> args) {
    return 
geohash(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/geohash">geohash</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxGeohash(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      geohash(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/geopos">geopos</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI geopos(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.geopos(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/geopos">geopos</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI geopos(java.util.List<java.lang.String> args) {
    return 
geopos(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/geopos">geopos</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxGeopos(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      geopos(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/georadius">georadius</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI georadius(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.georadius(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/georadius">georadius</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI georadius(java.util.List<java.lang.String> args) {
    return 
georadius(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/georadius">georadius</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxGeoradius(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      georadius(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/georadius_ro">georadiusRo</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI georadiusRo(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.georadiusRo(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/georadius_ro">georadiusRo</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI georadiusRo(java.util.List<java.lang.String> args) {
    return 
georadiusRo(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/georadius_ro">georadiusRo</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxGeoradiusRo(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      georadiusRo(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/georadiusbymember">georadiusbymember</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI georadiusbymember(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.georadiusbymember(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/georadiusbymember">georadiusbymember</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI georadiusbymember(java.util.List<java.lang.String> args) {
    return 
georadiusbymember(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/georadiusbymember">georadiusbymember</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxGeoradiusbymember(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      georadiusbymember(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/georadiusbymember_ro">georadiusbymemberRo</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI georadiusbymemberRo(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.georadiusbymemberRo(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/georadiusbymember_ro">georadiusbymemberRo</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI georadiusbymemberRo(java.util.List<java.lang.String> args) {
    return 
georadiusbymemberRo(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/georadiusbymember_ro">georadiusbymemberRo</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxGeoradiusbymemberRo(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      georadiusbymemberRo(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/geosearch">geosearch</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI geosearch(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.geosearch(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/geosearch">geosearch</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI geosearch(java.util.List<java.lang.String> args) {
    return 
geosearch(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/geosearch">geosearch</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxGeosearch(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      geosearch(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/geosearchstore">geosearchstore</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI geosearchstore(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.geosearchstore(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/geosearchstore">geosearchstore</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI geosearchstore(java.util.List<java.lang.String> args) {
    return 
geosearchstore(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/geosearchstore">geosearchstore</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxGeosearchstore(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      geosearchstore(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/get">get</a>.
   * @param arg0 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI get(java.lang.String arg0, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.get(arg0, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/get">get</a>.
   * @param arg0 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI get(java.lang.String arg0) {
    return 
get(arg0, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/get">get</a>.
   * @param arg0 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxGet(java.lang.String arg0) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      get(arg0, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/getbit">getbit</a>.
   * @param arg0 
   * @param arg1 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI getbit(java.lang.String arg0, java.lang.String arg1, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.getbit(arg0, arg1, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/getbit">getbit</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI getbit(java.lang.String arg0, java.lang.String arg1) {
    return 
getbit(arg0, arg1, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/getbit">getbit</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxGetbit(java.lang.String arg0, java.lang.String arg1) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      getbit(arg0, arg1, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/getdel">getdel</a>.
   * @param arg0 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI getdel(java.lang.String arg0, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.getdel(arg0, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/getdel">getdel</a>.
   * @param arg0 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI getdel(java.lang.String arg0) {
    return 
getdel(arg0, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/getdel">getdel</a>.
   * @param arg0 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxGetdel(java.lang.String arg0) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      getdel(arg0, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/getex">getex</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI getex(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.getex(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/getex">getex</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI getex(java.util.List<java.lang.String> args) {
    return 
getex(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/getex">getex</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxGetex(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      getex(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/getrange">getrange</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI getrange(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.getrange(arg0, arg1, arg2, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/getrange">getrange</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI getrange(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) {
    return 
getrange(arg0, arg1, arg2, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/getrange">getrange</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxGetrange(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      getrange(arg0, arg1, arg2, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/getset">getset</a>.
   * @param arg0 
   * @param arg1 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI getset(java.lang.String arg0, java.lang.String arg1, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.getset(arg0, arg1, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/getset">getset</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI getset(java.lang.String arg0, java.lang.String arg1) {
    return 
getset(arg0, arg1, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/getset">getset</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxGetset(java.lang.String arg0, java.lang.String arg1) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      getset(arg0, arg1, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/graph.BULK">graphBulk</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI graphBulk(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.graphBulk(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/graph.BULK">graphBulk</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI graphBulk(java.util.List<java.lang.String> args) {
    return 
graphBulk(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/graph.BULK">graphBulk</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxGraphBulk(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      graphBulk(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/graph.CONFIG">graphConfig</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI graphConfig(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.graphConfig(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/graph.CONFIG">graphConfig</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI graphConfig(java.util.List<java.lang.String> args) {
    return 
graphConfig(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/graph.CONFIG">graphConfig</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxGraphConfig(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      graphConfig(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/graph.DEBUG">graphDebug</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI graphDebug(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.graphDebug(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/graph.DEBUG">graphDebug</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI graphDebug(java.util.List<java.lang.String> args) {
    return 
graphDebug(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/graph.DEBUG">graphDebug</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxGraphDebug(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      graphDebug(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/graph.DELETE">graphDelete</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI graphDelete(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.graphDelete(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/graph.DELETE">graphDelete</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI graphDelete(java.util.List<java.lang.String> args) {
    return 
graphDelete(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/graph.DELETE">graphDelete</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxGraphDelete(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      graphDelete(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/graph.EXPLAIN">graphExplain</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI graphExplain(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.graphExplain(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/graph.EXPLAIN">graphExplain</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI graphExplain(java.util.List<java.lang.String> args) {
    return 
graphExplain(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/graph.EXPLAIN">graphExplain</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxGraphExplain(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      graphExplain(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/graph.LIST">graphList</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI graphList(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.graphList(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/graph.LIST">graphList</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI graphList(java.util.List<java.lang.String> args) {
    return 
graphList(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/graph.LIST">graphList</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxGraphList(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      graphList(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/graph.PROFILE">graphProfile</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI graphProfile(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.graphProfile(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/graph.PROFILE">graphProfile</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI graphProfile(java.util.List<java.lang.String> args) {
    return 
graphProfile(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/graph.PROFILE">graphProfile</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxGraphProfile(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      graphProfile(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/graph.QUERY">graphQuery</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI graphQuery(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.graphQuery(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/graph.QUERY">graphQuery</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI graphQuery(java.util.List<java.lang.String> args) {
    return 
graphQuery(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/graph.QUERY">graphQuery</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxGraphQuery(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      graphQuery(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/graph.RO_QUERY">graphRoQuery</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI graphRoQuery(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.graphRoQuery(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/graph.RO_QUERY">graphRoQuery</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI graphRoQuery(java.util.List<java.lang.String> args) {
    return 
graphRoQuery(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/graph.RO_QUERY">graphRoQuery</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxGraphRoQuery(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      graphRoQuery(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/graph.SLOWLOG">graphSlowlog</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI graphSlowlog(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.graphSlowlog(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/graph.SLOWLOG">graphSlowlog</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI graphSlowlog(java.util.List<java.lang.String> args) {
    return 
graphSlowlog(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/graph.SLOWLOG">graphSlowlog</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxGraphSlowlog(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      graphSlowlog(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/hdel">hdel</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI hdel(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.hdel(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/hdel">hdel</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI hdel(java.util.List<java.lang.String> args) {
    return 
hdel(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/hdel">hdel</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxHdel(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      hdel(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/hello">hello</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI hello(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.hello(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/hello">hello</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI hello(java.util.List<java.lang.String> args) {
    return 
hello(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/hello">hello</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxHello(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      hello(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/hexists">hexists</a>.
   * @param arg0 
   * @param arg1 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI hexists(java.lang.String arg0, java.lang.String arg1, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.hexists(arg0, arg1, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/hexists">hexists</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI hexists(java.lang.String arg0, java.lang.String arg1) {
    return 
hexists(arg0, arg1, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/hexists">hexists</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxHexists(java.lang.String arg0, java.lang.String arg1) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      hexists(arg0, arg1, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/hget">hget</a>.
   * @param arg0 
   * @param arg1 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI hget(java.lang.String arg0, java.lang.String arg1, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.hget(arg0, arg1, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/hget">hget</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI hget(java.lang.String arg0, java.lang.String arg1) {
    return 
hget(arg0, arg1, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/hget">hget</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxHget(java.lang.String arg0, java.lang.String arg1) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      hget(arg0, arg1, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/hgetall">hgetall</a>.
   * @param arg0 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI hgetall(java.lang.String arg0, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.hgetall(arg0, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/hgetall">hgetall</a>.
   * @param arg0 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI hgetall(java.lang.String arg0) {
    return 
hgetall(arg0, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/hgetall">hgetall</a>.
   * @param arg0 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxHgetall(java.lang.String arg0) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      hgetall(arg0, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/hincrby">hincrby</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI hincrby(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.hincrby(arg0, arg1, arg2, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/hincrby">hincrby</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI hincrby(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) {
    return 
hincrby(arg0, arg1, arg2, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/hincrby">hincrby</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxHincrby(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      hincrby(arg0, arg1, arg2, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/hincrbyfloat">hincrbyfloat</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI hincrbyfloat(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.hincrbyfloat(arg0, arg1, arg2, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/hincrbyfloat">hincrbyfloat</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI hincrbyfloat(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) {
    return 
hincrbyfloat(arg0, arg1, arg2, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/hincrbyfloat">hincrbyfloat</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxHincrbyfloat(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      hincrbyfloat(arg0, arg1, arg2, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/hkeys">hkeys</a>.
   * @param arg0 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI hkeys(java.lang.String arg0, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.hkeys(arg0, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/hkeys">hkeys</a>.
   * @param arg0 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI hkeys(java.lang.String arg0) {
    return 
hkeys(arg0, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/hkeys">hkeys</a>.
   * @param arg0 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxHkeys(java.lang.String arg0) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      hkeys(arg0, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/hlen">hlen</a>.
   * @param arg0 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI hlen(java.lang.String arg0, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.hlen(arg0, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/hlen">hlen</a>.
   * @param arg0 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI hlen(java.lang.String arg0) {
    return 
hlen(arg0, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/hlen">hlen</a>.
   * @param arg0 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxHlen(java.lang.String arg0) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      hlen(arg0, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/hmget">hmget</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI hmget(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.hmget(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/hmget">hmget</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI hmget(java.util.List<java.lang.String> args) {
    return 
hmget(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/hmget">hmget</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxHmget(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      hmget(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/hmset">hmset</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI hmset(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.hmset(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/hmset">hmset</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI hmset(java.util.List<java.lang.String> args) {
    return 
hmset(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/hmset">hmset</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxHmset(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      hmset(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/hrandfield">hrandfield</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI hrandfield(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.hrandfield(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/hrandfield">hrandfield</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI hrandfield(java.util.List<java.lang.String> args) {
    return 
hrandfield(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/hrandfield">hrandfield</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxHrandfield(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      hrandfield(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/hscan">hscan</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI hscan(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.hscan(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/hscan">hscan</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI hscan(java.util.List<java.lang.String> args) {
    return 
hscan(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/hscan">hscan</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxHscan(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      hscan(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/hset">hset</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI hset(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.hset(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/hset">hset</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI hset(java.util.List<java.lang.String> args) {
    return 
hset(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/hset">hset</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxHset(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      hset(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/hsetnx">hsetnx</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI hsetnx(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.hsetnx(arg0, arg1, arg2, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/hsetnx">hsetnx</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI hsetnx(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) {
    return 
hsetnx(arg0, arg1, arg2, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/hsetnx">hsetnx</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxHsetnx(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      hsetnx(arg0, arg1, arg2, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/hstrlen">hstrlen</a>.
   * @param arg0 
   * @param arg1 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI hstrlen(java.lang.String arg0, java.lang.String arg1, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.hstrlen(arg0, arg1, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/hstrlen">hstrlen</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI hstrlen(java.lang.String arg0, java.lang.String arg1) {
    return 
hstrlen(arg0, arg1, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/hstrlen">hstrlen</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxHstrlen(java.lang.String arg0, java.lang.String arg1) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      hstrlen(arg0, arg1, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/hvals">hvals</a>.
   * @param arg0 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI hvals(java.lang.String arg0, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.hvals(arg0, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/hvals">hvals</a>.
   * @param arg0 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI hvals(java.lang.String arg0) {
    return 
hvals(arg0, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/hvals">hvals</a>.
   * @param arg0 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxHvals(java.lang.String arg0) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      hvals(arg0, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/incr">incr</a>.
   * @param arg0 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI incr(java.lang.String arg0, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.incr(arg0, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/incr">incr</a>.
   * @param arg0 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI incr(java.lang.String arg0) {
    return 
incr(arg0, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/incr">incr</a>.
   * @param arg0 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxIncr(java.lang.String arg0) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      incr(arg0, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/incrby">incrby</a>.
   * @param arg0 
   * @param arg1 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI incrby(java.lang.String arg0, java.lang.String arg1, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.incrby(arg0, arg1, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/incrby">incrby</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI incrby(java.lang.String arg0, java.lang.String arg1) {
    return 
incrby(arg0, arg1, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/incrby">incrby</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxIncrby(java.lang.String arg0, java.lang.String arg1) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      incrby(arg0, arg1, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/incrbyfloat">incrbyfloat</a>.
   * @param arg0 
   * @param arg1 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI incrbyfloat(java.lang.String arg0, java.lang.String arg1, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.incrbyfloat(arg0, arg1, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/incrbyfloat">incrbyfloat</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI incrbyfloat(java.lang.String arg0, java.lang.String arg1) {
    return 
incrbyfloat(arg0, arg1, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/incrbyfloat">incrbyfloat</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxIncrbyfloat(java.lang.String arg0, java.lang.String arg1) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      incrbyfloat(arg0, arg1, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/info">info</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI info(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.info(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/info">info</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI info(java.util.List<java.lang.String> args) {
    return 
info(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/info">info</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxInfo(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      info(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.arrappend">jsonArrappend</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI jsonArrappend(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.jsonArrappend(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.arrappend">jsonArrappend</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI jsonArrappend(java.util.List<java.lang.String> args) {
    return 
jsonArrappend(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/json.arrappend">jsonArrappend</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxJsonArrappend(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      jsonArrappend(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.arrindex">jsonArrindex</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI jsonArrindex(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.jsonArrindex(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.arrindex">jsonArrindex</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI jsonArrindex(java.util.List<java.lang.String> args) {
    return 
jsonArrindex(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/json.arrindex">jsonArrindex</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxJsonArrindex(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      jsonArrindex(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.arrinsert">jsonArrinsert</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI jsonArrinsert(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.jsonArrinsert(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.arrinsert">jsonArrinsert</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI jsonArrinsert(java.util.List<java.lang.String> args) {
    return 
jsonArrinsert(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/json.arrinsert">jsonArrinsert</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxJsonArrinsert(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      jsonArrinsert(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.arrlen">jsonArrlen</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI jsonArrlen(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.jsonArrlen(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.arrlen">jsonArrlen</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI jsonArrlen(java.util.List<java.lang.String> args) {
    return 
jsonArrlen(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/json.arrlen">jsonArrlen</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxJsonArrlen(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      jsonArrlen(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.arrpop">jsonArrpop</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI jsonArrpop(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.jsonArrpop(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.arrpop">jsonArrpop</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI jsonArrpop(java.util.List<java.lang.String> args) {
    return 
jsonArrpop(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/json.arrpop">jsonArrpop</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxJsonArrpop(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      jsonArrpop(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.arrtrim">jsonArrtrim</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI jsonArrtrim(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.jsonArrtrim(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.arrtrim">jsonArrtrim</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI jsonArrtrim(java.util.List<java.lang.String> args) {
    return 
jsonArrtrim(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/json.arrtrim">jsonArrtrim</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxJsonArrtrim(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      jsonArrtrim(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.clear">jsonClear</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI jsonClear(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.jsonClear(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.clear">jsonClear</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI jsonClear(java.util.List<java.lang.String> args) {
    return 
jsonClear(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/json.clear">jsonClear</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxJsonClear(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      jsonClear(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.debug">jsonDebug</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI jsonDebug(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.jsonDebug(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.debug">jsonDebug</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI jsonDebug(java.util.List<java.lang.String> args) {
    return 
jsonDebug(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/json.debug">jsonDebug</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxJsonDebug(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      jsonDebug(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.del">jsonDel</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI jsonDel(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.jsonDel(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.del">jsonDel</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI jsonDel(java.util.List<java.lang.String> args) {
    return 
jsonDel(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/json.del">jsonDel</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxJsonDel(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      jsonDel(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.forget">jsonForget</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI jsonForget(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.jsonForget(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.forget">jsonForget</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI jsonForget(java.util.List<java.lang.String> args) {
    return 
jsonForget(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/json.forget">jsonForget</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxJsonForget(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      jsonForget(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.get">jsonGet</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI jsonGet(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.jsonGet(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.get">jsonGet</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI jsonGet(java.util.List<java.lang.String> args) {
    return 
jsonGet(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/json.get">jsonGet</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxJsonGet(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      jsonGet(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.mget">jsonMget</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI jsonMget(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.jsonMget(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.mget">jsonMget</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI jsonMget(java.util.List<java.lang.String> args) {
    return 
jsonMget(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/json.mget">jsonMget</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxJsonMget(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      jsonMget(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.numincrby">jsonNumincrby</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI jsonNumincrby(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.jsonNumincrby(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.numincrby">jsonNumincrby</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI jsonNumincrby(java.util.List<java.lang.String> args) {
    return 
jsonNumincrby(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/json.numincrby">jsonNumincrby</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxJsonNumincrby(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      jsonNumincrby(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.nummultby">jsonNummultby</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI jsonNummultby(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.jsonNummultby(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.nummultby">jsonNummultby</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI jsonNummultby(java.util.List<java.lang.String> args) {
    return 
jsonNummultby(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/json.nummultby">jsonNummultby</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxJsonNummultby(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      jsonNummultby(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.numpowby">jsonNumpowby</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI jsonNumpowby(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.jsonNumpowby(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.numpowby">jsonNumpowby</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI jsonNumpowby(java.util.List<java.lang.String> args) {
    return 
jsonNumpowby(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/json.numpowby">jsonNumpowby</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxJsonNumpowby(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      jsonNumpowby(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.objkeys">jsonObjkeys</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI jsonObjkeys(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.jsonObjkeys(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.objkeys">jsonObjkeys</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI jsonObjkeys(java.util.List<java.lang.String> args) {
    return 
jsonObjkeys(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/json.objkeys">jsonObjkeys</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxJsonObjkeys(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      jsonObjkeys(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.objlen">jsonObjlen</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI jsonObjlen(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.jsonObjlen(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.objlen">jsonObjlen</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI jsonObjlen(java.util.List<java.lang.String> args) {
    return 
jsonObjlen(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/json.objlen">jsonObjlen</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxJsonObjlen(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      jsonObjlen(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.resp">jsonResp</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI jsonResp(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.jsonResp(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.resp">jsonResp</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI jsonResp(java.util.List<java.lang.String> args) {
    return 
jsonResp(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/json.resp">jsonResp</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxJsonResp(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      jsonResp(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.set">jsonSet</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI jsonSet(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.jsonSet(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.set">jsonSet</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI jsonSet(java.util.List<java.lang.String> args) {
    return 
jsonSet(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/json.set">jsonSet</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxJsonSet(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      jsonSet(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.strappend">jsonStrappend</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI jsonStrappend(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.jsonStrappend(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.strappend">jsonStrappend</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI jsonStrappend(java.util.List<java.lang.String> args) {
    return 
jsonStrappend(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/json.strappend">jsonStrappend</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxJsonStrappend(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      jsonStrappend(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.strlen">jsonStrlen</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI jsonStrlen(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.jsonStrlen(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.strlen">jsonStrlen</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI jsonStrlen(java.util.List<java.lang.String> args) {
    return 
jsonStrlen(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/json.strlen">jsonStrlen</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxJsonStrlen(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      jsonStrlen(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.toggle">jsonToggle</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI jsonToggle(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.jsonToggle(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.toggle">jsonToggle</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI jsonToggle(java.util.List<java.lang.String> args) {
    return 
jsonToggle(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/json.toggle">jsonToggle</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxJsonToggle(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      jsonToggle(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.type">jsonType</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI jsonType(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.jsonType(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/json.type">jsonType</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI jsonType(java.util.List<java.lang.String> args) {
    return 
jsonType(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/json.type">jsonType</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxJsonType(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      jsonType(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/keys">keys</a>.
   * @param arg0 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI keys(java.lang.String arg0, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.keys(arg0, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/keys">keys</a>.
   * @param arg0 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI keys(java.lang.String arg0) {
    return 
keys(arg0, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/keys">keys</a>.
   * @param arg0 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxKeys(java.lang.String arg0) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      keys(arg0, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/lastsave">lastsave</a>.
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI lastsave(io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.lastsave(new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/lastsave">lastsave</a>.
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI lastsave() {
    return 
lastsave(ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/lastsave">lastsave</a>.
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxLastsave() { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      lastsave(fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/latency">latency</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI latency(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.latency(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/latency">latency</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI latency(java.util.List<java.lang.String> args) {
    return 
latency(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/latency">latency</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxLatency(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      latency(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/lcs">lcs</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI lcs(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.lcs(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/lcs">lcs</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI lcs(java.util.List<java.lang.String> args) {
    return 
lcs(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/lcs">lcs</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxLcs(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      lcs(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/lindex">lindex</a>.
   * @param arg0 
   * @param arg1 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI lindex(java.lang.String arg0, java.lang.String arg1, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.lindex(arg0, arg1, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/lindex">lindex</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI lindex(java.lang.String arg0, java.lang.String arg1) {
    return 
lindex(arg0, arg1, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/lindex">lindex</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxLindex(java.lang.String arg0, java.lang.String arg1) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      lindex(arg0, arg1, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/linsert">linsert</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @param arg3 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI linsert(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2, java.lang.String arg3, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.linsert(arg0, arg1, arg2, arg3, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/linsert">linsert</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @param arg3 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI linsert(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2, java.lang.String arg3) {
    return 
linsert(arg0, arg1, arg2, arg3, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/linsert">linsert</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @param arg3 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxLinsert(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2, java.lang.String arg3) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      linsert(arg0, arg1, arg2, arg3, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/llen">llen</a>.
   * @param arg0 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI llen(java.lang.String arg0, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.llen(arg0, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/llen">llen</a>.
   * @param arg0 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI llen(java.lang.String arg0) {
    return 
llen(arg0, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/llen">llen</a>.
   * @param arg0 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxLlen(java.lang.String arg0) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      llen(arg0, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/lmove">lmove</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @param arg3 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI lmove(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2, java.lang.String arg3, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.lmove(arg0, arg1, arg2, arg3, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/lmove">lmove</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @param arg3 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI lmove(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2, java.lang.String arg3) {
    return 
lmove(arg0, arg1, arg2, arg3, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/lmove">lmove</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @param arg3 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxLmove(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2, java.lang.String arg3) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      lmove(arg0, arg1, arg2, arg3, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/lmpop">lmpop</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI lmpop(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.lmpop(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/lmpop">lmpop</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI lmpop(java.util.List<java.lang.String> args) {
    return 
lmpop(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/lmpop">lmpop</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxLmpop(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      lmpop(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/lolwut">lolwut</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI lolwut(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.lolwut(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/lolwut">lolwut</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI lolwut(java.util.List<java.lang.String> args) {
    return 
lolwut(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/lolwut">lolwut</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxLolwut(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      lolwut(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/lpop">lpop</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI lpop(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.lpop(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/lpop">lpop</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI lpop(java.util.List<java.lang.String> args) {
    return 
lpop(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/lpop">lpop</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxLpop(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      lpop(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/lpos">lpos</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI lpos(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.lpos(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/lpos">lpos</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI lpos(java.util.List<java.lang.String> args) {
    return 
lpos(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/lpos">lpos</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxLpos(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      lpos(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/lpush">lpush</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI lpush(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.lpush(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/lpush">lpush</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI lpush(java.util.List<java.lang.String> args) {
    return 
lpush(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/lpush">lpush</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxLpush(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      lpush(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/lpushx">lpushx</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI lpushx(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.lpushx(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/lpushx">lpushx</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI lpushx(java.util.List<java.lang.String> args) {
    return 
lpushx(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/lpushx">lpushx</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxLpushx(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      lpushx(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/lrange">lrange</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI lrange(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.lrange(arg0, arg1, arg2, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/lrange">lrange</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI lrange(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) {
    return 
lrange(arg0, arg1, arg2, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/lrange">lrange</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxLrange(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      lrange(arg0, arg1, arg2, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/lrem">lrem</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI lrem(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.lrem(arg0, arg1, arg2, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/lrem">lrem</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI lrem(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) {
    return 
lrem(arg0, arg1, arg2, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/lrem">lrem</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxLrem(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      lrem(arg0, arg1, arg2, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/lset">lset</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI lset(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.lset(arg0, arg1, arg2, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/lset">lset</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI lset(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) {
    return 
lset(arg0, arg1, arg2, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/lset">lset</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxLset(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      lset(arg0, arg1, arg2, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/ltrim">ltrim</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI ltrim(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.ltrim(arg0, arg1, arg2, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ltrim">ltrim</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI ltrim(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) {
    return 
ltrim(arg0, arg1, arg2, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/ltrim">ltrim</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxLtrim(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      ltrim(arg0, arg1, arg2, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/memory">memory</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI memory(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.memory(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/memory">memory</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI memory(java.util.List<java.lang.String> args) {
    return 
memory(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/memory">memory</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxMemory(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      memory(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/mget">mget</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI mget(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.mget(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/mget">mget</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI mget(java.util.List<java.lang.String> args) {
    return 
mget(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/mget">mget</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxMget(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      mget(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/migrate">migrate</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI migrate(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.migrate(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/migrate">migrate</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI migrate(java.util.List<java.lang.String> args) {
    return 
migrate(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/migrate">migrate</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxMigrate(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      migrate(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/module">module</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI module(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.module(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/module">module</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI module(java.util.List<java.lang.String> args) {
    return 
module(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/module">module</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxModule(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      module(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/monitor">monitor</a>.
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI monitor(io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.monitor(new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/monitor">monitor</a>.
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI monitor() {
    return 
monitor(ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/monitor">monitor</a>.
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxMonitor() { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      monitor(fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/move">move</a>.
   * @param arg0 
   * @param arg1 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI move(java.lang.String arg0, java.lang.String arg1, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.move(arg0, arg1, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/move">move</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI move(java.lang.String arg0, java.lang.String arg1) {
    return 
move(arg0, arg1, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/move">move</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxMove(java.lang.String arg0, java.lang.String arg1) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      move(arg0, arg1, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/mset">mset</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI mset(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.mset(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/mset">mset</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI mset(java.util.List<java.lang.String> args) {
    return 
mset(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/mset">mset</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxMset(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      mset(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/msetnx">msetnx</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI msetnx(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.msetnx(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/msetnx">msetnx</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI msetnx(java.util.List<java.lang.String> args) {
    return 
msetnx(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/msetnx">msetnx</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxMsetnx(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      msetnx(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/multi">multi</a>.
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI multi(io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.multi(new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/multi">multi</a>.
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI multi() {
    return 
multi(ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/multi">multi</a>.
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxMulti() { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      multi(fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/object">object</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI object(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.object(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/object">object</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI object(java.util.List<java.lang.String> args) {
    return 
object(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/object">object</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxObject(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      object(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/persist">persist</a>.
   * @param arg0 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI persist(java.lang.String arg0, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.persist(arg0, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/persist">persist</a>.
   * @param arg0 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI persist(java.lang.String arg0) {
    return 
persist(arg0, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/persist">persist</a>.
   * @param arg0 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxPersist(java.lang.String arg0) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      persist(arg0, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/pexpire">pexpire</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI pexpire(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.pexpire(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/pexpire">pexpire</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI pexpire(java.util.List<java.lang.String> args) {
    return 
pexpire(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/pexpire">pexpire</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxPexpire(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      pexpire(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/pexpireat">pexpireat</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI pexpireat(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.pexpireat(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/pexpireat">pexpireat</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI pexpireat(java.util.List<java.lang.String> args) {
    return 
pexpireat(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/pexpireat">pexpireat</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxPexpireat(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      pexpireat(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/pexpiretime">pexpiretime</a>.
   * @param arg0 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI pexpiretime(java.lang.String arg0, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.pexpiretime(arg0, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/pexpiretime">pexpiretime</a>.
   * @param arg0 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI pexpiretime(java.lang.String arg0) {
    return 
pexpiretime(arg0, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/pexpiretime">pexpiretime</a>.
   * @param arg0 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxPexpiretime(java.lang.String arg0) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      pexpiretime(arg0, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/pfadd">pfadd</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI pfadd(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.pfadd(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/pfadd">pfadd</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI pfadd(java.util.List<java.lang.String> args) {
    return 
pfadd(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/pfadd">pfadd</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxPfadd(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      pfadd(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/pfcount">pfcount</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI pfcount(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.pfcount(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/pfcount">pfcount</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI pfcount(java.util.List<java.lang.String> args) {
    return 
pfcount(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/pfcount">pfcount</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxPfcount(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      pfcount(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/pfdebug">pfdebug</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI pfdebug(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.pfdebug(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/pfdebug">pfdebug</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI pfdebug(java.util.List<java.lang.String> args) {
    return 
pfdebug(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/pfdebug">pfdebug</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxPfdebug(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      pfdebug(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/pfmerge">pfmerge</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI pfmerge(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.pfmerge(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/pfmerge">pfmerge</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI pfmerge(java.util.List<java.lang.String> args) {
    return 
pfmerge(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/pfmerge">pfmerge</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxPfmerge(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      pfmerge(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/pfselftest">pfselftest</a>.
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI pfselftest(io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.pfselftest(new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/pfselftest">pfselftest</a>.
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI pfselftest() {
    return 
pfselftest(ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/pfselftest">pfselftest</a>.
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxPfselftest() { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      pfselftest(fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/ping">ping</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI ping(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.ping(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ping">ping</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI ping(java.util.List<java.lang.String> args) {
    return 
ping(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/ping">ping</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxPing(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      ping(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/psetex">psetex</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI psetex(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.psetex(arg0, arg1, arg2, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/psetex">psetex</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI psetex(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) {
    return 
psetex(arg0, arg1, arg2, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/psetex">psetex</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxPsetex(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      psetex(arg0, arg1, arg2, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/psubscribe">psubscribe</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI psubscribe(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.psubscribe(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/psubscribe">psubscribe</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI psubscribe(java.util.List<java.lang.String> args) {
    return 
psubscribe(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/psubscribe">psubscribe</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxPsubscribe(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      psubscribe(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/psync">psync</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI psync(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.psync(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/psync">psync</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI psync(java.util.List<java.lang.String> args) {
    return 
psync(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/psync">psync</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxPsync(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      psync(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/pttl">pttl</a>.
   * @param arg0 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI pttl(java.lang.String arg0, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.pttl(arg0, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/pttl">pttl</a>.
   * @param arg0 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI pttl(java.lang.String arg0) {
    return 
pttl(arg0, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/pttl">pttl</a>.
   * @param arg0 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxPttl(java.lang.String arg0) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      pttl(arg0, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/publish">publish</a>.
   * @param arg0 
   * @param arg1 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI publish(java.lang.String arg0, java.lang.String arg1, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.publish(arg0, arg1, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/publish">publish</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI publish(java.lang.String arg0, java.lang.String arg1) {
    return 
publish(arg0, arg1, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/publish">publish</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxPublish(java.lang.String arg0, java.lang.String arg1) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      publish(arg0, arg1, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/pubsub">pubsub</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI pubsub(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.pubsub(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/pubsub">pubsub</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI pubsub(java.util.List<java.lang.String> args) {
    return 
pubsub(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/pubsub">pubsub</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxPubsub(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      pubsub(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/punsubscribe">punsubscribe</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI punsubscribe(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.punsubscribe(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/punsubscribe">punsubscribe</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI punsubscribe(java.util.List<java.lang.String> args) {
    return 
punsubscribe(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/punsubscribe">punsubscribe</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxPunsubscribe(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      punsubscribe(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/quit">quit</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI quit(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.quit(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/quit">quit</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI quit(java.util.List<java.lang.String> args) {
    return 
quit(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/quit">quit</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxQuit(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      quit(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/randomkey">randomkey</a>.
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI randomkey(io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.randomkey(new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/randomkey">randomkey</a>.
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI randomkey() {
    return 
randomkey(ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/randomkey">randomkey</a>.
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxRandomkey() { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      randomkey(fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/readonly">readonly</a>.
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI readonly(io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.readonly(new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/readonly">readonly</a>.
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI readonly() {
    return 
readonly(ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/readonly">readonly</a>.
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxReadonly() { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      readonly(fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/readwrite">readwrite</a>.
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI readwrite(io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.readwrite(new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/readwrite">readwrite</a>.
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI readwrite() {
    return 
readwrite(ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/readwrite">readwrite</a>.
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxReadwrite() { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      readwrite(fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/rename">rename</a>.
   * @param arg0 
   * @param arg1 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI rename(java.lang.String arg0, java.lang.String arg1, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.rename(arg0, arg1, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/rename">rename</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI rename(java.lang.String arg0, java.lang.String arg1) {
    return 
rename(arg0, arg1, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/rename">rename</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxRename(java.lang.String arg0, java.lang.String arg1) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      rename(arg0, arg1, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/renamenx">renamenx</a>.
   * @param arg0 
   * @param arg1 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI renamenx(java.lang.String arg0, java.lang.String arg1, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.renamenx(arg0, arg1, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/renamenx">renamenx</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI renamenx(java.lang.String arg0, java.lang.String arg1) {
    return 
renamenx(arg0, arg1, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/renamenx">renamenx</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxRenamenx(java.lang.String arg0, java.lang.String arg1) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      renamenx(arg0, arg1, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/replconf">replconf</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI replconf(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.replconf(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/replconf">replconf</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI replconf(java.util.List<java.lang.String> args) {
    return 
replconf(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/replconf">replconf</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxReplconf(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      replconf(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/replicaof">replicaof</a>.
   * @param arg0 
   * @param arg1 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI replicaof(java.lang.String arg0, java.lang.String arg1, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.replicaof(arg0, arg1, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/replicaof">replicaof</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI replicaof(java.lang.String arg0, java.lang.String arg1) {
    return 
replicaof(arg0, arg1, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/replicaof">replicaof</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxReplicaof(java.lang.String arg0, java.lang.String arg1) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      replicaof(arg0, arg1, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/reset">reset</a>.
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI reset(io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.reset(new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/reset">reset</a>.
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI reset() {
    return 
reset(ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/reset">reset</a>.
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxReset() { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      reset(fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/restore">restore</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI restore(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.restore(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/restore">restore</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI restore(java.util.List<java.lang.String> args) {
    return 
restore(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/restore">restore</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxRestore(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      restore(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/restore-asking">restoreAsking</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI restoreAsking(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.restoreAsking(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/restore-asking">restoreAsking</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI restoreAsking(java.util.List<java.lang.String> args) {
    return 
restoreAsking(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/restore-asking">restoreAsking</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxRestoreAsking(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      restoreAsking(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/role">role</a>.
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI role(io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.role(new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/role">role</a>.
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI role() {
    return 
role(ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/role">role</a>.
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxRole() { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      role(fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/rpop">rpop</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI rpop(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.rpop(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/rpop">rpop</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI rpop(java.util.List<java.lang.String> args) {
    return 
rpop(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/rpop">rpop</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxRpop(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      rpop(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/rpoplpush">rpoplpush</a>.
   * @param arg0 
   * @param arg1 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI rpoplpush(java.lang.String arg0, java.lang.String arg1, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.rpoplpush(arg0, arg1, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/rpoplpush">rpoplpush</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI rpoplpush(java.lang.String arg0, java.lang.String arg1) {
    return 
rpoplpush(arg0, arg1, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/rpoplpush">rpoplpush</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxRpoplpush(java.lang.String arg0, java.lang.String arg1) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      rpoplpush(arg0, arg1, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/rpush">rpush</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI rpush(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.rpush(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/rpush">rpush</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI rpush(java.util.List<java.lang.String> args) {
    return 
rpush(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/rpush">rpush</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxRpush(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      rpush(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/rpushx">rpushx</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI rpushx(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.rpushx(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/rpushx">rpushx</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI rpushx(java.util.List<java.lang.String> args) {
    return 
rpushx(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/rpushx">rpushx</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxRpushx(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      rpushx(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/sadd">sadd</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI sadd(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.sadd(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/sadd">sadd</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI sadd(java.util.List<java.lang.String> args) {
    return 
sadd(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/sadd">sadd</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxSadd(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      sadd(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/save">save</a>.
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI save(io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.save(new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/save">save</a>.
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI save() {
    return 
save(ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/save">save</a>.
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxSave() { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      save(fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/scan">scan</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI scan(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.scan(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/scan">scan</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI scan(java.util.List<java.lang.String> args) {
    return 
scan(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/scan">scan</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxScan(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      scan(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/scard">scard</a>.
   * @param arg0 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI scard(java.lang.String arg0, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.scard(arg0, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/scard">scard</a>.
   * @param arg0 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI scard(java.lang.String arg0) {
    return 
scard(arg0, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/scard">scard</a>.
   * @param arg0 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxScard(java.lang.String arg0) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      scard(arg0, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/script">script</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI script(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.script(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/script">script</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI script(java.util.List<java.lang.String> args) {
    return 
script(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/script">script</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxScript(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      script(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/sdiff">sdiff</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI sdiff(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.sdiff(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/sdiff">sdiff</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI sdiff(java.util.List<java.lang.String> args) {
    return 
sdiff(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/sdiff">sdiff</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxSdiff(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      sdiff(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/sdiffstore">sdiffstore</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI sdiffstore(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.sdiffstore(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/sdiffstore">sdiffstore</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI sdiffstore(java.util.List<java.lang.String> args) {
    return 
sdiffstore(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/sdiffstore">sdiffstore</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxSdiffstore(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      sdiffstore(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/select">select</a>.
   * @param arg0 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI select(java.lang.String arg0, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.select(arg0, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/select">select</a>.
   * @param arg0 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI select(java.lang.String arg0) {
    return 
select(arg0, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/select">select</a>.
   * @param arg0 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxSelect(java.lang.String arg0) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      select(arg0, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/set">set</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI set(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.set(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/set">set</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI set(java.util.List<java.lang.String> args) {
    return 
set(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/set">set</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxSet(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      set(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/setbit">setbit</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI setbit(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.setbit(arg0, arg1, arg2, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/setbit">setbit</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI setbit(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) {
    return 
setbit(arg0, arg1, arg2, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/setbit">setbit</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxSetbit(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      setbit(arg0, arg1, arg2, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/setex">setex</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI setex(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.setex(arg0, arg1, arg2, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/setex">setex</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI setex(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) {
    return 
setex(arg0, arg1, arg2, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/setex">setex</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxSetex(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      setex(arg0, arg1, arg2, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/setnx">setnx</a>.
   * @param arg0 
   * @param arg1 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI setnx(java.lang.String arg0, java.lang.String arg1, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.setnx(arg0, arg1, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/setnx">setnx</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI setnx(java.lang.String arg0, java.lang.String arg1) {
    return 
setnx(arg0, arg1, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/setnx">setnx</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxSetnx(java.lang.String arg0, java.lang.String arg1) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      setnx(arg0, arg1, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/setrange">setrange</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI setrange(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.setrange(arg0, arg1, arg2, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/setrange">setrange</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI setrange(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) {
    return 
setrange(arg0, arg1, arg2, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/setrange">setrange</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxSetrange(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      setrange(arg0, arg1, arg2, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/shutdown">shutdown</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI shutdown(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.shutdown(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/shutdown">shutdown</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI shutdown(java.util.List<java.lang.String> args) {
    return 
shutdown(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/shutdown">shutdown</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxShutdown(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      shutdown(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/sinter">sinter</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI sinter(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.sinter(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/sinter">sinter</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI sinter(java.util.List<java.lang.String> args) {
    return 
sinter(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/sinter">sinter</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxSinter(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      sinter(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/sintercard">sintercard</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI sintercard(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.sintercard(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/sintercard">sintercard</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI sintercard(java.util.List<java.lang.String> args) {
    return 
sintercard(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/sintercard">sintercard</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxSintercard(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      sintercard(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/sinterstore">sinterstore</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI sinterstore(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.sinterstore(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/sinterstore">sinterstore</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI sinterstore(java.util.List<java.lang.String> args) {
    return 
sinterstore(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/sinterstore">sinterstore</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxSinterstore(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      sinterstore(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/sismember">sismember</a>.
   * @param arg0 
   * @param arg1 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI sismember(java.lang.String arg0, java.lang.String arg1, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.sismember(arg0, arg1, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/sismember">sismember</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI sismember(java.lang.String arg0, java.lang.String arg1) {
    return 
sismember(arg0, arg1, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/sismember">sismember</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxSismember(java.lang.String arg0, java.lang.String arg1) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      sismember(arg0, arg1, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/slaveof">slaveof</a>.
   * @param arg0 
   * @param arg1 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI slaveof(java.lang.String arg0, java.lang.String arg1, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.slaveof(arg0, arg1, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/slaveof">slaveof</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI slaveof(java.lang.String arg0, java.lang.String arg1) {
    return 
slaveof(arg0, arg1, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/slaveof">slaveof</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxSlaveof(java.lang.String arg0, java.lang.String arg1) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      slaveof(arg0, arg1, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/slowlog">slowlog</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI slowlog(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.slowlog(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/slowlog">slowlog</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI slowlog(java.util.List<java.lang.String> args) {
    return 
slowlog(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/slowlog">slowlog</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxSlowlog(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      slowlog(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/smembers">smembers</a>.
   * @param arg0 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI smembers(java.lang.String arg0, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.smembers(arg0, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/smembers">smembers</a>.
   * @param arg0 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI smembers(java.lang.String arg0) {
    return 
smembers(arg0, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/smembers">smembers</a>.
   * @param arg0 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxSmembers(java.lang.String arg0) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      smembers(arg0, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/smismember">smismember</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI smismember(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.smismember(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/smismember">smismember</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI smismember(java.util.List<java.lang.String> args) {
    return 
smismember(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/smismember">smismember</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxSmismember(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      smismember(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/smove">smove</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI smove(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.smove(arg0, arg1, arg2, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/smove">smove</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI smove(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) {
    return 
smove(arg0, arg1, arg2, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/smove">smove</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxSmove(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      smove(arg0, arg1, arg2, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/sort">sort</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI sort(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.sort(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/sort">sort</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI sort(java.util.List<java.lang.String> args) {
    return 
sort(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/sort">sort</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxSort(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      sort(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/sort_ro">sortRo</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI sortRo(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.sortRo(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/sort_ro">sortRo</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI sortRo(java.util.List<java.lang.String> args) {
    return 
sortRo(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/sort_ro">sortRo</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxSortRo(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      sortRo(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/spop">spop</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI spop(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.spop(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/spop">spop</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI spop(java.util.List<java.lang.String> args) {
    return 
spop(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/spop">spop</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxSpop(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      spop(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/spublish">spublish</a>.
   * @param arg0 
   * @param arg1 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI spublish(java.lang.String arg0, java.lang.String arg1, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.spublish(arg0, arg1, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/spublish">spublish</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI spublish(java.lang.String arg0, java.lang.String arg1) {
    return 
spublish(arg0, arg1, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/spublish">spublish</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxSpublish(java.lang.String arg0, java.lang.String arg1) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      spublish(arg0, arg1, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/srandmember">srandmember</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI srandmember(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.srandmember(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/srandmember">srandmember</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI srandmember(java.util.List<java.lang.String> args) {
    return 
srandmember(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/srandmember">srandmember</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxSrandmember(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      srandmember(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/srem">srem</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI srem(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.srem(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/srem">srem</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI srem(java.util.List<java.lang.String> args) {
    return 
srem(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/srem">srem</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxSrem(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      srem(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/sscan">sscan</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI sscan(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.sscan(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/sscan">sscan</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI sscan(java.util.List<java.lang.String> args) {
    return 
sscan(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/sscan">sscan</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxSscan(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      sscan(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/ssubscribe">ssubscribe</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI ssubscribe(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.ssubscribe(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ssubscribe">ssubscribe</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI ssubscribe(java.util.List<java.lang.String> args) {
    return 
ssubscribe(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/ssubscribe">ssubscribe</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxSsubscribe(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      ssubscribe(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/strlen">strlen</a>.
   * @param arg0 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI strlen(java.lang.String arg0, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.strlen(arg0, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/strlen">strlen</a>.
   * @param arg0 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI strlen(java.lang.String arg0) {
    return 
strlen(arg0, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/strlen">strlen</a>.
   * @param arg0 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxStrlen(java.lang.String arg0) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      strlen(arg0, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/subscribe">subscribe</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI subscribe(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.subscribe(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/subscribe">subscribe</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI subscribe(java.util.List<java.lang.String> args) {
    return 
subscribe(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/subscribe">subscribe</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxSubscribe(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      subscribe(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/substr">substr</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI substr(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.substr(arg0, arg1, arg2, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/substr">substr</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI substr(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) {
    return 
substr(arg0, arg1, arg2, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/substr">substr</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxSubstr(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      substr(arg0, arg1, arg2, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/sunion">sunion</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI sunion(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.sunion(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/sunion">sunion</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI sunion(java.util.List<java.lang.String> args) {
    return 
sunion(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/sunion">sunion</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxSunion(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      sunion(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/sunionstore">sunionstore</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI sunionstore(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.sunionstore(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/sunionstore">sunionstore</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI sunionstore(java.util.List<java.lang.String> args) {
    return 
sunionstore(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/sunionstore">sunionstore</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxSunionstore(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      sunionstore(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/sunsubscribe">sunsubscribe</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI sunsubscribe(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.sunsubscribe(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/sunsubscribe">sunsubscribe</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI sunsubscribe(java.util.List<java.lang.String> args) {
    return 
sunsubscribe(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/sunsubscribe">sunsubscribe</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxSunsubscribe(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      sunsubscribe(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/swapdb">swapdb</a>.
   * @param arg0 
   * @param arg1 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI swapdb(java.lang.String arg0, java.lang.String arg1, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.swapdb(arg0, arg1, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/swapdb">swapdb</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI swapdb(java.lang.String arg0, java.lang.String arg1) {
    return 
swapdb(arg0, arg1, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/swapdb">swapdb</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxSwapdb(java.lang.String arg0, java.lang.String arg1) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      swapdb(arg0, arg1, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/sync">sync</a>.
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI sync(io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.sync(new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/sync">sync</a>.
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI sync() {
    return 
sync(ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/sync">sync</a>.
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxSync() { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      sync(fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/time">time</a>.
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI time(io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.time(new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/time">time</a>.
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI time() {
    return 
time(ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/time">time</a>.
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxTime() { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      time(fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/timeseries.CLUSTERSET">timeseriesClusterset</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI timeseriesClusterset(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.timeseriesClusterset(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/timeseries.CLUSTERSET">timeseriesClusterset</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI timeseriesClusterset(java.util.List<java.lang.String> args) {
    return 
timeseriesClusterset(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/timeseries.CLUSTERSET">timeseriesClusterset</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxTimeseriesClusterset(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      timeseriesClusterset(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/timeseries.CLUSTERSETFROMSHARD">timeseriesClustersetfromshard</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI timeseriesClustersetfromshard(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.timeseriesClustersetfromshard(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/timeseries.CLUSTERSETFROMSHARD">timeseriesClustersetfromshard</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI timeseriesClustersetfromshard(java.util.List<java.lang.String> args) {
    return 
timeseriesClustersetfromshard(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/timeseries.CLUSTERSETFROMSHARD">timeseriesClustersetfromshard</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxTimeseriesClustersetfromshard(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      timeseriesClustersetfromshard(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/timeseries.HELLO">timeseriesHello</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI timeseriesHello(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.timeseriesHello(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/timeseries.HELLO">timeseriesHello</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI timeseriesHello(java.util.List<java.lang.String> args) {
    return 
timeseriesHello(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/timeseries.HELLO">timeseriesHello</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxTimeseriesHello(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      timeseriesHello(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/timeseries.INFOCLUSTER">timeseriesInfocluster</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI timeseriesInfocluster(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.timeseriesInfocluster(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/timeseries.INFOCLUSTER">timeseriesInfocluster</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI timeseriesInfocluster(java.util.List<java.lang.String> args) {
    return 
timeseriesInfocluster(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/timeseries.INFOCLUSTER">timeseriesInfocluster</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxTimeseriesInfocluster(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      timeseriesInfocluster(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/timeseries.INNERCOMMUNICATION">timeseriesInnercommunication</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI timeseriesInnercommunication(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.timeseriesInnercommunication(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/timeseries.INNERCOMMUNICATION">timeseriesInnercommunication</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI timeseriesInnercommunication(java.util.List<java.lang.String> args) {
    return 
timeseriesInnercommunication(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/timeseries.INNERCOMMUNICATION">timeseriesInnercommunication</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxTimeseriesInnercommunication(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      timeseriesInnercommunication(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/timeseries.NETWORKTEST">timeseriesNetworktest</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI timeseriesNetworktest(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.timeseriesNetworktest(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/timeseries.NETWORKTEST">timeseriesNetworktest</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI timeseriesNetworktest(java.util.List<java.lang.String> args) {
    return 
timeseriesNetworktest(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/timeseries.NETWORKTEST">timeseriesNetworktest</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxTimeseriesNetworktest(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      timeseriesNetworktest(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/timeseries.REFRESHCLUSTER">timeseriesRefreshcluster</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI timeseriesRefreshcluster(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.timeseriesRefreshcluster(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/timeseries.REFRESHCLUSTER">timeseriesRefreshcluster</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI timeseriesRefreshcluster(java.util.List<java.lang.String> args) {
    return 
timeseriesRefreshcluster(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/timeseries.REFRESHCLUSTER">timeseriesRefreshcluster</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxTimeseriesRefreshcluster(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      timeseriesRefreshcluster(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/topk.add">topkAdd</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI topkAdd(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.topkAdd(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/topk.add">topkAdd</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI topkAdd(java.util.List<java.lang.String> args) {
    return 
topkAdd(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/topk.add">topkAdd</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxTopkAdd(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      topkAdd(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/topk.count">topkCount</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI topkCount(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.topkCount(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/topk.count">topkCount</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI topkCount(java.util.List<java.lang.String> args) {
    return 
topkCount(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/topk.count">topkCount</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxTopkCount(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      topkCount(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/topk.incrby">topkIncrby</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI topkIncrby(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.topkIncrby(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/topk.incrby">topkIncrby</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI topkIncrby(java.util.List<java.lang.String> args) {
    return 
topkIncrby(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/topk.incrby">topkIncrby</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxTopkIncrby(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      topkIncrby(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/topk.info">topkInfo</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI topkInfo(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.topkInfo(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/topk.info">topkInfo</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI topkInfo(java.util.List<java.lang.String> args) {
    return 
topkInfo(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/topk.info">topkInfo</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxTopkInfo(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      topkInfo(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/topk.list">topkList</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI topkList(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.topkList(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/topk.list">topkList</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI topkList(java.util.List<java.lang.String> args) {
    return 
topkList(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/topk.list">topkList</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxTopkList(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      topkList(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/topk.query">topkQuery</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI topkQuery(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.topkQuery(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/topk.query">topkQuery</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI topkQuery(java.util.List<java.lang.String> args) {
    return 
topkQuery(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/topk.query">topkQuery</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxTopkQuery(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      topkQuery(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/topk.reserve">topkReserve</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI topkReserve(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.topkReserve(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/topk.reserve">topkReserve</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI topkReserve(java.util.List<java.lang.String> args) {
    return 
topkReserve(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/topk.reserve">topkReserve</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxTopkReserve(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      topkReserve(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/touch">touch</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI touch(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.touch(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/touch">touch</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI touch(java.util.List<java.lang.String> args) {
    return 
touch(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/touch">touch</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxTouch(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      touch(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/ts.add">tsAdd</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI tsAdd(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.tsAdd(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ts.add">tsAdd</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI tsAdd(java.util.List<java.lang.String> args) {
    return 
tsAdd(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/ts.add">tsAdd</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxTsAdd(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      tsAdd(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/ts.alter">tsAlter</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI tsAlter(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.tsAlter(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ts.alter">tsAlter</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI tsAlter(java.util.List<java.lang.String> args) {
    return 
tsAlter(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/ts.alter">tsAlter</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxTsAlter(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      tsAlter(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/ts.create">tsCreate</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI tsCreate(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.tsCreate(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ts.create">tsCreate</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI tsCreate(java.util.List<java.lang.String> args) {
    return 
tsCreate(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/ts.create">tsCreate</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxTsCreate(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      tsCreate(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/ts.createrule">tsCreaterule</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI tsCreaterule(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.tsCreaterule(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ts.createrule">tsCreaterule</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI tsCreaterule(java.util.List<java.lang.String> args) {
    return 
tsCreaterule(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/ts.createrule">tsCreaterule</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxTsCreaterule(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      tsCreaterule(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/ts.decrby">tsDecrby</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI tsDecrby(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.tsDecrby(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ts.decrby">tsDecrby</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI tsDecrby(java.util.List<java.lang.String> args) {
    return 
tsDecrby(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/ts.decrby">tsDecrby</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxTsDecrby(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      tsDecrby(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/ts.del">tsDel</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI tsDel(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.tsDel(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ts.del">tsDel</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI tsDel(java.util.List<java.lang.String> args) {
    return 
tsDel(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/ts.del">tsDel</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxTsDel(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      tsDel(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/ts.deleterule">tsDeleterule</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI tsDeleterule(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.tsDeleterule(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ts.deleterule">tsDeleterule</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI tsDeleterule(java.util.List<java.lang.String> args) {
    return 
tsDeleterule(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/ts.deleterule">tsDeleterule</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxTsDeleterule(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      tsDeleterule(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/ts.get">tsGet</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI tsGet(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.tsGet(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ts.get">tsGet</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI tsGet(java.util.List<java.lang.String> args) {
    return 
tsGet(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/ts.get">tsGet</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxTsGet(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      tsGet(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/ts.incrby">tsIncrby</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI tsIncrby(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.tsIncrby(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ts.incrby">tsIncrby</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI tsIncrby(java.util.List<java.lang.String> args) {
    return 
tsIncrby(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/ts.incrby">tsIncrby</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxTsIncrby(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      tsIncrby(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/ts.info">tsInfo</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI tsInfo(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.tsInfo(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ts.info">tsInfo</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI tsInfo(java.util.List<java.lang.String> args) {
    return 
tsInfo(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/ts.info">tsInfo</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxTsInfo(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      tsInfo(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/ts.madd">tsMadd</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI tsMadd(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.tsMadd(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ts.madd">tsMadd</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI tsMadd(java.util.List<java.lang.String> args) {
    return 
tsMadd(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/ts.madd">tsMadd</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxTsMadd(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      tsMadd(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/ts.mget">tsMget</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI tsMget(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.tsMget(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ts.mget">tsMget</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI tsMget(java.util.List<java.lang.String> args) {
    return 
tsMget(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/ts.mget">tsMget</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxTsMget(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      tsMget(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/ts.mrange">tsMrange</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI tsMrange(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.tsMrange(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ts.mrange">tsMrange</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI tsMrange(java.util.List<java.lang.String> args) {
    return 
tsMrange(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/ts.mrange">tsMrange</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxTsMrange(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      tsMrange(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/ts.mrevrange">tsMrevrange</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI tsMrevrange(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.tsMrevrange(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ts.mrevrange">tsMrevrange</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI tsMrevrange(java.util.List<java.lang.String> args) {
    return 
tsMrevrange(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/ts.mrevrange">tsMrevrange</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxTsMrevrange(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      tsMrevrange(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/ts.queryindex">tsQueryindex</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI tsQueryindex(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.tsQueryindex(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ts.queryindex">tsQueryindex</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI tsQueryindex(java.util.List<java.lang.String> args) {
    return 
tsQueryindex(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/ts.queryindex">tsQueryindex</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxTsQueryindex(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      tsQueryindex(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/ts.range">tsRange</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI tsRange(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.tsRange(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ts.range">tsRange</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI tsRange(java.util.List<java.lang.String> args) {
    return 
tsRange(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/ts.range">tsRange</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxTsRange(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      tsRange(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/ts.revrange">tsRevrange</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI tsRevrange(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.tsRevrange(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ts.revrange">tsRevrange</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI tsRevrange(java.util.List<java.lang.String> args) {
    return 
tsRevrange(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/ts.revrange">tsRevrange</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxTsRevrange(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      tsRevrange(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/ttl">ttl</a>.
   * @param arg0 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI ttl(java.lang.String arg0, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.ttl(arg0, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ttl">ttl</a>.
   * @param arg0 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI ttl(java.lang.String arg0) {
    return 
ttl(arg0, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/ttl">ttl</a>.
   * @param arg0 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxTtl(java.lang.String arg0) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      ttl(arg0, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/type">type</a>.
   * @param arg0 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI type(java.lang.String arg0, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.type(arg0, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/type">type</a>.
   * @param arg0 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI type(java.lang.String arg0) {
    return 
type(arg0, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/type">type</a>.
   * @param arg0 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxType(java.lang.String arg0) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      type(arg0, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/unlink">unlink</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI unlink(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.unlink(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/unlink">unlink</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI unlink(java.util.List<java.lang.String> args) {
    return 
unlink(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/unlink">unlink</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxUnlink(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      unlink(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/unsubscribe">unsubscribe</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI unsubscribe(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.unsubscribe(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/unsubscribe">unsubscribe</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI unsubscribe(java.util.List<java.lang.String> args) {
    return 
unsubscribe(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/unsubscribe">unsubscribe</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxUnsubscribe(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      unsubscribe(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/unwatch">unwatch</a>.
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI unwatch(io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.unwatch(new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/unwatch">unwatch</a>.
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI unwatch() {
    return 
unwatch(ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/unwatch">unwatch</a>.
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxUnwatch() { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      unwatch(fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/wait">wait</a>.
   * @param arg0 
   * @param arg1 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI wait(java.lang.String arg0, java.lang.String arg1, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.wait(arg0, arg1, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/wait">wait</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI wait(java.lang.String arg0, java.lang.String arg1) {
    return 
wait(arg0, arg1, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/wait">wait</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxWait(java.lang.String arg0, java.lang.String arg1) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      wait(arg0, arg1, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/watch">watch</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI watch(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.watch(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/watch">watch</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI watch(java.util.List<java.lang.String> args) {
    return 
watch(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/watch">watch</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxWatch(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      watch(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/xack">xack</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI xack(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.xack(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/xack">xack</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI xack(java.util.List<java.lang.String> args) {
    return 
xack(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/xack">xack</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxXack(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      xack(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/xadd">xadd</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI xadd(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.xadd(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/xadd">xadd</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI xadd(java.util.List<java.lang.String> args) {
    return 
xadd(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/xadd">xadd</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxXadd(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      xadd(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/xautoclaim">xautoclaim</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI xautoclaim(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.xautoclaim(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/xautoclaim">xautoclaim</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI xautoclaim(java.util.List<java.lang.String> args) {
    return 
xautoclaim(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/xautoclaim">xautoclaim</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxXautoclaim(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      xautoclaim(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/xclaim">xclaim</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI xclaim(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.xclaim(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/xclaim">xclaim</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI xclaim(java.util.List<java.lang.String> args) {
    return 
xclaim(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/xclaim">xclaim</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxXclaim(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      xclaim(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/xdel">xdel</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI xdel(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.xdel(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/xdel">xdel</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI xdel(java.util.List<java.lang.String> args) {
    return 
xdel(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/xdel">xdel</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxXdel(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      xdel(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/xgroup">xgroup</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI xgroup(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.xgroup(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/xgroup">xgroup</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI xgroup(java.util.List<java.lang.String> args) {
    return 
xgroup(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/xgroup">xgroup</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxXgroup(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      xgroup(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/xinfo">xinfo</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI xinfo(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.xinfo(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/xinfo">xinfo</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI xinfo(java.util.List<java.lang.String> args) {
    return 
xinfo(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/xinfo">xinfo</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxXinfo(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      xinfo(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/xlen">xlen</a>.
   * @param arg0 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI xlen(java.lang.String arg0, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.xlen(arg0, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/xlen">xlen</a>.
   * @param arg0 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI xlen(java.lang.String arg0) {
    return 
xlen(arg0, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/xlen">xlen</a>.
   * @param arg0 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxXlen(java.lang.String arg0) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      xlen(arg0, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/xpending">xpending</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI xpending(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.xpending(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/xpending">xpending</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI xpending(java.util.List<java.lang.String> args) {
    return 
xpending(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/xpending">xpending</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxXpending(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      xpending(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/xrange">xrange</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI xrange(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.xrange(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/xrange">xrange</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI xrange(java.util.List<java.lang.String> args) {
    return 
xrange(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/xrange">xrange</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxXrange(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      xrange(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/xread">xread</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI xread(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.xread(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/xread">xread</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI xread(java.util.List<java.lang.String> args) {
    return 
xread(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/xread">xread</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxXread(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      xread(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/xreadgroup">xreadgroup</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI xreadgroup(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.xreadgroup(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/xreadgroup">xreadgroup</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI xreadgroup(java.util.List<java.lang.String> args) {
    return 
xreadgroup(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/xreadgroup">xreadgroup</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxXreadgroup(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      xreadgroup(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/xrevrange">xrevrange</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI xrevrange(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.xrevrange(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/xrevrange">xrevrange</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI xrevrange(java.util.List<java.lang.String> args) {
    return 
xrevrange(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/xrevrange">xrevrange</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxXrevrange(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      xrevrange(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/xsetid">xsetid</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI xsetid(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.xsetid(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/xsetid">xsetid</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI xsetid(java.util.List<java.lang.String> args) {
    return 
xsetid(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/xsetid">xsetid</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxXsetid(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      xsetid(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/xtrim">xtrim</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI xtrim(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.xtrim(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/xtrim">xtrim</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI xtrim(java.util.List<java.lang.String> args) {
    return 
xtrim(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/xtrim">xtrim</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxXtrim(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      xtrim(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/zadd">zadd</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI zadd(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.zadd(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/zadd">zadd</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI zadd(java.util.List<java.lang.String> args) {
    return 
zadd(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/zadd">zadd</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxZadd(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      zadd(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/zcard">zcard</a>.
   * @param arg0 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI zcard(java.lang.String arg0, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.zcard(arg0, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/zcard">zcard</a>.
   * @param arg0 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI zcard(java.lang.String arg0) {
    return 
zcard(arg0, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/zcard">zcard</a>.
   * @param arg0 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxZcard(java.lang.String arg0) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      zcard(arg0, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/zcount">zcount</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI zcount(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.zcount(arg0, arg1, arg2, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/zcount">zcount</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI zcount(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) {
    return 
zcount(arg0, arg1, arg2, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/zcount">zcount</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxZcount(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      zcount(arg0, arg1, arg2, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/zdiff">zdiff</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI zdiff(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.zdiff(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/zdiff">zdiff</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI zdiff(java.util.List<java.lang.String> args) {
    return 
zdiff(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/zdiff">zdiff</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxZdiff(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      zdiff(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/zdiffstore">zdiffstore</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI zdiffstore(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.zdiffstore(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/zdiffstore">zdiffstore</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI zdiffstore(java.util.List<java.lang.String> args) {
    return 
zdiffstore(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/zdiffstore">zdiffstore</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxZdiffstore(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      zdiffstore(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/zincrby">zincrby</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI zincrby(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.zincrby(arg0, arg1, arg2, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/zincrby">zincrby</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI zincrby(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) {
    return 
zincrby(arg0, arg1, arg2, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/zincrby">zincrby</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxZincrby(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      zincrby(arg0, arg1, arg2, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/zinter">zinter</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI zinter(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.zinter(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/zinter">zinter</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI zinter(java.util.List<java.lang.String> args) {
    return 
zinter(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/zinter">zinter</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxZinter(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      zinter(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/zintercard">zintercard</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI zintercard(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.zintercard(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/zintercard">zintercard</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI zintercard(java.util.List<java.lang.String> args) {
    return 
zintercard(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/zintercard">zintercard</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxZintercard(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      zintercard(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/zinterstore">zinterstore</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI zinterstore(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.zinterstore(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/zinterstore">zinterstore</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI zinterstore(java.util.List<java.lang.String> args) {
    return 
zinterstore(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/zinterstore">zinterstore</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxZinterstore(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      zinterstore(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/zlexcount">zlexcount</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI zlexcount(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.zlexcount(arg0, arg1, arg2, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/zlexcount">zlexcount</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI zlexcount(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) {
    return 
zlexcount(arg0, arg1, arg2, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/zlexcount">zlexcount</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxZlexcount(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      zlexcount(arg0, arg1, arg2, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/zmpop">zmpop</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI zmpop(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.zmpop(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/zmpop">zmpop</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI zmpop(java.util.List<java.lang.String> args) {
    return 
zmpop(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/zmpop">zmpop</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxZmpop(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      zmpop(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/zmscore">zmscore</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI zmscore(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.zmscore(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/zmscore">zmscore</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI zmscore(java.util.List<java.lang.String> args) {
    return 
zmscore(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/zmscore">zmscore</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxZmscore(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      zmscore(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/zpopmax">zpopmax</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI zpopmax(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.zpopmax(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/zpopmax">zpopmax</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI zpopmax(java.util.List<java.lang.String> args) {
    return 
zpopmax(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/zpopmax">zpopmax</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxZpopmax(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      zpopmax(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/zpopmin">zpopmin</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI zpopmin(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.zpopmin(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/zpopmin">zpopmin</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI zpopmin(java.util.List<java.lang.String> args) {
    return 
zpopmin(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/zpopmin">zpopmin</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxZpopmin(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      zpopmin(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/zrandmember">zrandmember</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI zrandmember(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.zrandmember(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/zrandmember">zrandmember</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI zrandmember(java.util.List<java.lang.String> args) {
    return 
zrandmember(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/zrandmember">zrandmember</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxZrandmember(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      zrandmember(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/zrange">zrange</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI zrange(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.zrange(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/zrange">zrange</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI zrange(java.util.List<java.lang.String> args) {
    return 
zrange(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/zrange">zrange</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxZrange(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      zrange(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/zrangebylex">zrangebylex</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI zrangebylex(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.zrangebylex(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/zrangebylex">zrangebylex</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI zrangebylex(java.util.List<java.lang.String> args) {
    return 
zrangebylex(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/zrangebylex">zrangebylex</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxZrangebylex(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      zrangebylex(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/zrangebyscore">zrangebyscore</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI zrangebyscore(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.zrangebyscore(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/zrangebyscore">zrangebyscore</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI zrangebyscore(java.util.List<java.lang.String> args) {
    return 
zrangebyscore(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/zrangebyscore">zrangebyscore</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxZrangebyscore(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      zrangebyscore(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/zrangestore">zrangestore</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI zrangestore(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.zrangestore(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/zrangestore">zrangestore</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI zrangestore(java.util.List<java.lang.String> args) {
    return 
zrangestore(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/zrangestore">zrangestore</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxZrangestore(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      zrangestore(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/zrank">zrank</a>.
   * @param arg0 
   * @param arg1 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI zrank(java.lang.String arg0, java.lang.String arg1, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.zrank(arg0, arg1, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/zrank">zrank</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI zrank(java.lang.String arg0, java.lang.String arg1) {
    return 
zrank(arg0, arg1, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/zrank">zrank</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxZrank(java.lang.String arg0, java.lang.String arg1) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      zrank(arg0, arg1, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/zrem">zrem</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI zrem(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.zrem(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/zrem">zrem</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI zrem(java.util.List<java.lang.String> args) {
    return 
zrem(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/zrem">zrem</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxZrem(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      zrem(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/zremrangebylex">zremrangebylex</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI zremrangebylex(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.zremrangebylex(arg0, arg1, arg2, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/zremrangebylex">zremrangebylex</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI zremrangebylex(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) {
    return 
zremrangebylex(arg0, arg1, arg2, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/zremrangebylex">zremrangebylex</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxZremrangebylex(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      zremrangebylex(arg0, arg1, arg2, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/zremrangebyrank">zremrangebyrank</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI zremrangebyrank(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.zremrangebyrank(arg0, arg1, arg2, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/zremrangebyrank">zremrangebyrank</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI zremrangebyrank(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) {
    return 
zremrangebyrank(arg0, arg1, arg2, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/zremrangebyrank">zremrangebyrank</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxZremrangebyrank(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      zremrangebyrank(arg0, arg1, arg2, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/zremrangebyscore">zremrangebyscore</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI zremrangebyscore(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.zremrangebyscore(arg0, arg1, arg2, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/zremrangebyscore">zremrangebyscore</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI zremrangebyscore(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) {
    return 
zremrangebyscore(arg0, arg1, arg2, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/zremrangebyscore">zremrangebyscore</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxZremrangebyscore(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      zremrangebyscore(arg0, arg1, arg2, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/zrevrange">zrevrange</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI zrevrange(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.zrevrange(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/zrevrange">zrevrange</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI zrevrange(java.util.List<java.lang.String> args) {
    return 
zrevrange(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/zrevrange">zrevrange</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxZrevrange(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      zrevrange(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/zrevrangebylex">zrevrangebylex</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI zrevrangebylex(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.zrevrangebylex(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/zrevrangebylex">zrevrangebylex</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI zrevrangebylex(java.util.List<java.lang.String> args) {
    return 
zrevrangebylex(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/zrevrangebylex">zrevrangebylex</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxZrevrangebylex(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      zrevrangebylex(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/zrevrangebyscore">zrevrangebyscore</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI zrevrangebyscore(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.zrevrangebyscore(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/zrevrangebyscore">zrevrangebyscore</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI zrevrangebyscore(java.util.List<java.lang.String> args) {
    return 
zrevrangebyscore(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/zrevrangebyscore">zrevrangebyscore</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxZrevrangebyscore(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      zrevrangebyscore(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/zrevrank">zrevrank</a>.
   * @param arg0 
   * @param arg1 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI zrevrank(java.lang.String arg0, java.lang.String arg1, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.zrevrank(arg0, arg1, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/zrevrank">zrevrank</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI zrevrank(java.lang.String arg0, java.lang.String arg1) {
    return 
zrevrank(arg0, arg1, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/zrevrank">zrevrank</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxZrevrank(java.lang.String arg0, java.lang.String arg1) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      zrevrank(arg0, arg1, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/zscan">zscan</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI zscan(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.zscan(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/zscan">zscan</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI zscan(java.util.List<java.lang.String> args) {
    return 
zscan(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/zscan">zscan</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxZscan(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      zscan(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/zscore">zscore</a>.
   * @param arg0 
   * @param arg1 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI zscore(java.lang.String arg0, java.lang.String arg1, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.zscore(arg0, arg1, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/zscore">zscore</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI zscore(java.lang.String arg0, java.lang.String arg1) {
    return 
zscore(arg0, arg1, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/zscore">zscore</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxZscore(java.lang.String arg0, java.lang.String arg1) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      zscore(arg0, arg1, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/zunion">zunion</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI zunion(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.zunion(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/zunion">zunion</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI zunion(java.util.List<java.lang.String> args) {
    return 
zunion(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/zunion">zunion</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxZunion(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      zunion(args, fut);
    }));
  }

  /**
   * Redis command <a href="https://redis.io/commands/zunionstore">zunionstore</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI zunionstore(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> handler) { 
    delegate.zunionstore(args, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/zunionstore">zunionstore</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.rxjava.redis.client.RedisAPI zunionstore(java.util.List<java.lang.String> args) {
    return 
zunionstore(args, ar -> { });
  }

    /**
   * Redis command <a href="https://redis.io/commands/zunionstore">zunionstore</a>.
   * @param args 
   * @return fluent self
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxZunionstore(java.util.List<java.lang.String> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      zunionstore(args, fut);
    }));
  }

  public static io.vertx.rxjava.redis.client.RedisAPI api(io.vertx.rxjava.redis.client.Redis client) { 
    io.vertx.rxjava.redis.client.RedisAPI ret = io.vertx.rxjava.redis.client.RedisAPI.newInstance((io.vertx.redis.client.RedisAPI)io.vertx.redis.client.RedisAPI.api(client.getDelegate()));
    return ret;
  }

  public static io.vertx.rxjava.redis.client.RedisAPI api(io.vertx.rxjava.redis.client.RedisConnection connection) { 
    io.vertx.rxjava.redis.client.RedisAPI ret = io.vertx.rxjava.redis.client.RedisAPI.newInstance((io.vertx.redis.client.RedisAPI)io.vertx.redis.client.RedisAPI.api(connection.getDelegate()));
    return ret;
  }

  public static RedisAPI newInstance(io.vertx.redis.client.RedisAPI arg) {
    return arg != null ? new RedisAPI(arg) : null;
  }

}
