/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava.redis.client;

import rx.Observable;
import rx.Single;
import io.vertx.rx.java.RxHelper;
import io.vertx.rx.java.WriteStreamSubscriber;
import io.vertx.rx.java.SingleOnSubscribeAdapter;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * A simple Redis client.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.redis.client.Redis original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.redis.client.Redis.class)
public class Redis {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    Redis that = (Redis) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<Redis> __TYPE_ARG = new TypeArg<>(    obj -> new Redis((io.vertx.redis.client.Redis) obj),
    Redis::getDelegate
  );

  private final io.vertx.redis.client.Redis delegate;
  
  public Redis(io.vertx.redis.client.Redis delegate) {
    this.delegate = delegate;
  }

  public Redis(Object delegate) {
    this.delegate = (io.vertx.redis.client.Redis)delegate;
  }

  public io.vertx.redis.client.Redis getDelegate() {
    return delegate;
  }

  /**
   * Create a new redis client using the default client options.
   * @param vertx the vertx instance
   * @return the client
   */
  public static io.vertx.rxjava.redis.client.Redis createClient(io.vertx.rxjava.core.Vertx vertx) { 
    io.vertx.rxjava.redis.client.Redis ret = io.vertx.rxjava.redis.client.Redis.newInstance((io.vertx.redis.client.Redis)io.vertx.redis.client.Redis.createClient(vertx.getDelegate()));
    return ret;
  }

  /**
   * Create a new redis client using the default client options. Does not support rediss (redis over ssl scheme) for now.
   * @param vertx the vertx instance
   * @param connectionString a string URI following the scheme: redis://[username:password@][host][:port][/database]
   * @return the client
   */
  public static io.vertx.rxjava.redis.client.Redis createClient(io.vertx.rxjava.core.Vertx vertx, java.lang.String connectionString) { 
    io.vertx.rxjava.redis.client.Redis ret = io.vertx.rxjava.redis.client.Redis.newInstance((io.vertx.redis.client.Redis)io.vertx.redis.client.Redis.createClient(vertx.getDelegate(), connectionString));
    return ret;
  }

  /**
   * Create a new redis client using the given client options.
   * @param vertx the vertx instance
   * @param options the user provided options
   * @return the client
   */
  public static io.vertx.rxjava.redis.client.Redis createClient(io.vertx.rxjava.core.Vertx vertx, io.vertx.redis.client.RedisOptions options) { 
    io.vertx.rxjava.redis.client.Redis ret = io.vertx.rxjava.redis.client.Redis.newInstance((io.vertx.redis.client.Redis)io.vertx.redis.client.Redis.createClient(vertx.getDelegate(), options));
    return ret;
  }

  /**
   * Connects to the redis server.
   * @param handler the async result handler
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava.redis.client.Redis connect(io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.RedisConnection>> handler) { 
    delegate.connect(new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.redis.client.RedisConnection.newInstance((io.vertx.redis.client.RedisConnection)event))));
    return this;
  }

  /**
   * Connects to the redis server.
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava.redis.client.Redis connect() {
    return 
connect(ar -> { });
  }

    /**
   * Connects to the redis server.
   * @return a reference to this, so the API can be used fluently
   */
  public rx.Single<io.vertx.rxjava.redis.client.RedisConnection> rxConnect() { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      connect(fut);
    }));
  }

  /**
   * Closes the client and terminates any connection.
   */
  public void close() { 
    delegate.close();
  }

  /**
   * Send the given command to the redis server or cluster.
   * @param command the command to send
   * @param onSend the asynchronous result handler.
   * @return fluent self.
   */
  public io.vertx.rxjava.redis.client.Redis send(io.vertx.rxjava.redis.client.Request command, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> onSend) { 
    delegate.send(command.getDelegate(), new io.vertx.lang.rx.DelegatingHandler<>(onSend, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Send the given command to the redis server or cluster.
   * @param command the command to send
   * @return fluent self.
   */
  public io.vertx.rxjava.redis.client.Redis send(io.vertx.rxjava.redis.client.Request command) {
    return 
send(command, ar -> { });
  }

    /**
   * Send the given command to the redis server or cluster.
   * @param command the command to send
   * @return fluent self.
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxSend(io.vertx.rxjava.redis.client.Request command) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      send(command, fut);
    }));
  }

  /**
   * Sends a list of commands in a single IO operation, this prevents any inter twinning to happen from other
   * client users.
   * @param commands list of command to send
   * @param onSend the asynchronous result handler.
   * @return fluent self.
   */
  public io.vertx.rxjava.redis.client.Redis batch(java.util.List<io.vertx.rxjava.redis.client.Request> commands, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.util.List<io.vertx.rxjava.redis.client.Response>>> onSend) { 
    delegate.batch(commands.stream().map(elt -> elt.getDelegate()).collect(Collectors.toList()), new io.vertx.lang.rx.DelegatingHandler<>(onSend, ar -> ar.map(event -> event.stream().map(elt -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)elt)).collect(Collectors.toList()))));
    return this;
  }

  /**
   * Sends a list of commands in a single IO operation, this prevents any inter twinning to happen from other
   * client users.
   * @param commands list of command to send
   * @return fluent self.
   */
  public io.vertx.rxjava.redis.client.Redis batch(java.util.List<io.vertx.rxjava.redis.client.Request> commands) {
    return 
batch(commands, ar -> { });
  }

    /**
   * Sends a list of commands in a single IO operation, this prevents any inter twinning to happen from other
   * client users.
   * @param commands list of command to send
   * @return fluent self.
   */
  public rx.Single<java.util.List<io.vertx.rxjava.redis.client.Response>> rxBatch(java.util.List<io.vertx.rxjava.redis.client.Request> commands) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      batch(commands, fut);
    }));
  }

  public static Redis newInstance(io.vertx.redis.client.Redis arg) {
    return arg != null ? new Redis(arg) : null;
  }

}
