/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava.rabbitmq;

import rx.Observable;
import rx.Single;
import io.vertx.rx.java.RxHelper;
import io.vertx.rx.java.WriteStreamSubscriber;
import io.vertx.rx.java.SingleOnSubscribeAdapter;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.rabbitmq.RabbitMQClient original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.rabbitmq.RabbitMQClient.class)
public class RabbitMQClient {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    RabbitMQClient that = (RabbitMQClient) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<RabbitMQClient> __TYPE_ARG = new TypeArg<>(    obj -> new RabbitMQClient((io.vertx.rabbitmq.RabbitMQClient) obj),
    RabbitMQClient::getDelegate
  );

  private final io.vertx.rabbitmq.RabbitMQClient delegate;
  
  public RabbitMQClient(io.vertx.rabbitmq.RabbitMQClient delegate) {
    this.delegate = delegate;
  }

  public RabbitMQClient(Object delegate) {
    this.delegate = (io.vertx.rabbitmq.RabbitMQClient)delegate;
  }

  public io.vertx.rabbitmq.RabbitMQClient getDelegate() {
    return delegate;
  }

  /**
   * Create and return a client configured with the default options.
   * @param vertx the vertx instance
   * @return the client
   */
  public static io.vertx.rxjava.rabbitmq.RabbitMQClient create(io.vertx.rxjava.core.Vertx vertx) { 
    io.vertx.rxjava.rabbitmq.RabbitMQClient ret = io.vertx.rxjava.rabbitmq.RabbitMQClient.newInstance((io.vertx.rabbitmq.RabbitMQClient)io.vertx.rabbitmq.RabbitMQClient.create(vertx.getDelegate()));
    return ret;
  }

  /**
   * Create and return a client.
   * @param vertx the vertx instance
   * @param config the client config
   * @return the client
   */
  public static io.vertx.rxjava.rabbitmq.RabbitMQClient create(io.vertx.rxjava.core.Vertx vertx, io.vertx.rabbitmq.RabbitMQOptions config) { 
    io.vertx.rxjava.rabbitmq.RabbitMQClient ret = io.vertx.rxjava.rabbitmq.RabbitMQClient.newInstance((io.vertx.rabbitmq.RabbitMQClient)io.vertx.rabbitmq.RabbitMQClient.create(vertx.getDelegate(), config));
    return ret;
  }

  /**
   * Acknowledge one or several received messages. Supply the deliveryTag from the AMQP.Basic.GetOk or AMQP.Basic.Deliver
   * method containing the received message being acknowledged.
   * @param deliveryTag 
   * @param multiple 
   * @param resultHandler 
   */
  public void basicAck(long deliveryTag, boolean multiple, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.Void>> resultHandler) { 
    delegate.basicAck(deliveryTag, multiple, resultHandler);
  }

  /**
   * Acknowledge one or several received messages. Supply the deliveryTag from the AMQP.Basic.GetOk or AMQP.Basic.Deliver
   * method containing the received message being acknowledged.
   * @param deliveryTag 
   * @param multiple 
   */
  public void basicAck(long deliveryTag, boolean multiple) {
    basicAck(deliveryTag, multiple, ar -> { });
  }

    /**
   * Acknowledge one or several received messages. Supply the deliveryTag from the AMQP.Basic.GetOk or AMQP.Basic.Deliver
   * method containing the received message being acknowledged.
   * @param deliveryTag 
   * @param multiple 
   * @return 
   */
  public rx.Single<java.lang.Void> rxBasicAck(long deliveryTag, boolean multiple) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      basicAck(deliveryTag, multiple, fut);
    }));
  }

  /**
   * Reject one or several received messages.
   * @param deliveryTag 
   * @param multiple 
   * @param requeue 
   * @param resultHandler 
   */
  public void basicNack(long deliveryTag, boolean multiple, boolean requeue, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.Void>> resultHandler) { 
    delegate.basicNack(deliveryTag, multiple, requeue, resultHandler);
  }

  /**
   * Reject one or several received messages.
   * @param deliveryTag 
   * @param multiple 
   * @param requeue 
   */
  public void basicNack(long deliveryTag, boolean multiple, boolean requeue) {
    basicNack(deliveryTag, multiple, requeue, ar -> { });
  }

    /**
   * Reject one or several received messages.
   * @param deliveryTag 
   * @param multiple 
   * @param requeue 
   * @return 
   */
  public rx.Single<java.lang.Void> rxBasicNack(long deliveryTag, boolean multiple, boolean requeue) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      basicNack(deliveryTag, multiple, requeue, fut);
    }));
  }

  /**
   * Retrieve a message from a queue using AMQP.Basic.Get
   * @param queue 
   * @param autoAck 
   * @param resultHandler 
   */
  public void basicGet(java.lang.String queue, boolean autoAck, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.rabbitmq.RabbitMQMessage>> resultHandler) { 
    delegate.basicGet(queue, autoAck, new io.vertx.lang.rx.DelegatingHandler<>(resultHandler, ar -> ar.map(event -> io.vertx.rxjava.rabbitmq.RabbitMQMessage.newInstance((io.vertx.rabbitmq.RabbitMQMessage)event))));
  }

  /**
   * Retrieve a message from a queue using AMQP.Basic.Get
   * @param queue 
   * @param autoAck 
   */
  public void basicGet(java.lang.String queue, boolean autoAck) {
    basicGet(queue, autoAck, ar -> { });
  }

    /**
   * Retrieve a message from a queue using AMQP.Basic.Get
   * @param queue 
   * @param autoAck 
   * @return 
   */
  public rx.Single<io.vertx.rxjava.rabbitmq.RabbitMQMessage> rxBasicGet(java.lang.String queue, boolean autoAck) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      basicGet(queue, autoAck, fut);
    }));
  }

  /**
   * @param queue 
   * @param resultHandler 
   */
  public void basicConsumer(java.lang.String queue, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.rabbitmq.RabbitMQConsumer>> resultHandler) { 
    delegate.basicConsumer(queue, new io.vertx.lang.rx.DelegatingHandler<>(resultHandler, ar -> ar.map(event -> io.vertx.rxjava.rabbitmq.RabbitMQConsumer.newInstance((io.vertx.rabbitmq.RabbitMQConsumer)event))));
  }

  /**
   * @param queue 
   */
  public void basicConsumer(java.lang.String queue) {
    basicConsumer(queue, ar -> { });
  }

    /**
   * @param queue 
   * @return 
   */
  public rx.Single<io.vertx.rxjava.rabbitmq.RabbitMQConsumer> rxBasicConsumer(java.lang.String queue) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      basicConsumer(queue, fut);
    }));
  }

  /**
   * Create a consumer with the given <code>options</code>.
   * @param queue the name of a queue
   * @param options options for queue
   * @param resultHandler a handler through which you can find out the operation status; if the operation succeeds you can begin to receive messages through an instance of {@link io.vertx.rxjava.rabbitmq.RabbitMQConsumer}
   */
  public void basicConsumer(java.lang.String queue, io.vertx.rabbitmq.QueueOptions options, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.rabbitmq.RabbitMQConsumer>> resultHandler) { 
    delegate.basicConsumer(queue, options, new io.vertx.lang.rx.DelegatingHandler<>(resultHandler, ar -> ar.map(event -> io.vertx.rxjava.rabbitmq.RabbitMQConsumer.newInstance((io.vertx.rabbitmq.RabbitMQConsumer)event))));
  }

  /**
   * Create a consumer with the given <code>options</code>.
   * @param queue the name of a queue
   * @param options options for queue
   */
  public void basicConsumer(java.lang.String queue, io.vertx.rabbitmq.QueueOptions options) {
    basicConsumer(queue, options, ar -> { });
  }

    /**
   * Create a consumer with the given <code>options</code>.
   * @param queue the name of a queue
   * @param options options for queue
   * @return 
   */
  public rx.Single<io.vertx.rxjava.rabbitmq.RabbitMQConsumer> rxBasicConsumer(java.lang.String queue, io.vertx.rabbitmq.QueueOptions options) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      basicConsumer(queue, options, fut);
    }));
  }

  /**
   * Publish a message. Publishing to a non-existent exchange will result in a channel-level protocol exception,
   * which closes the channel. Invocations of Channel#basicPublish will eventually block if a resource-driven alarm is in effect.
   * @param exchange 
   * @param routingKey 
   * @param body 
   * @param resultHandler 
   */
  public void basicPublish(java.lang.String exchange, java.lang.String routingKey, io.vertx.rxjava.core.buffer.Buffer body, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.Void>> resultHandler) { 
    delegate.basicPublish(exchange, routingKey, body.getDelegate(), resultHandler);
  }

  /**
   * Publish a message. Publishing to a non-existent exchange will result in a channel-level protocol exception,
   * which closes the channel. Invocations of Channel#basicPublish will eventually block if a resource-driven alarm is in effect.
   * @param exchange 
   * @param routingKey 
   * @param body 
   */
  public void basicPublish(java.lang.String exchange, java.lang.String routingKey, io.vertx.rxjava.core.buffer.Buffer body) {
    basicPublish(exchange, routingKey, body, ar -> { });
  }

    /**
   * Publish a message. Publishing to a non-existent exchange will result in a channel-level protocol exception,
   * which closes the channel. Invocations of Channel#basicPublish will eventually block if a resource-driven alarm is in effect.
   * @param exchange 
   * @param routingKey 
   * @param body 
   * @return 
   */
  public rx.Single<java.lang.Void> rxBasicPublish(java.lang.String exchange, java.lang.String routingKey, io.vertx.rxjava.core.buffer.Buffer body) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      basicPublish(exchange, routingKey, body, fut);
    }));
  }

  /**
   * Add a Confirm Listener to the channel.
   * Note that this will automatically call confirmSelect, it is not necessary to call that too.
   * @param maxQueueSize maximum size of the queue of confirmations
   * @param resultHandler a handler through which you can find out the operation status; if the operation succeeds you can begin to receive confirmations through an instance of 
   */
  public void addConfirmListener(int maxQueueSize, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.core.streams.ReadStream<io.vertx.rabbitmq.RabbitMQConfirmation>>> resultHandler) { 
    delegate.addConfirmListener(maxQueueSize, new io.vertx.lang.rx.DelegatingHandler<>(resultHandler, ar -> ar.map(event -> io.vertx.rxjava.core.streams.ReadStream.newInstance((io.vertx.core.streams.ReadStream)event, TypeArg.unknown()))));
  }

  /**
   * Add a Confirm Listener to the channel.
   * Note that this will automatically call confirmSelect, it is not necessary to call that too.
   * @param maxQueueSize maximum size of the queue of confirmations
   */
  public void addConfirmListener(int maxQueueSize) {
    addConfirmListener(maxQueueSize, ar -> { });
  }

    /**
   * Add a Confirm Listener to the channel.
   * Note that this will automatically call confirmSelect, it is not necessary to call that too.
   * @param maxQueueSize maximum size of the queue of confirmations
   * @return 
   */
  public rx.Single<io.vertx.rxjava.core.streams.ReadStream<io.vertx.rabbitmq.RabbitMQConfirmation>> rxAddConfirmListener(int maxQueueSize) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      addConfirmListener(maxQueueSize, fut);
    }));
  }

  /**
   * Enables publisher acknowledgements on this channel. Can be called once during client initialisation. Calls to basicPublish()
   * will have to be confirmed.
   * @param resultHandler 
   */
  public void confirmSelect(io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.Void>> resultHandler) { 
    delegate.confirmSelect(resultHandler);
  }

  /**
   * Enables publisher acknowledgements on this channel. Can be called once during client initialisation. Calls to basicPublish()
   * will have to be confirmed.
   */
  public void confirmSelect() {
    confirmSelect(ar -> { });
  }

    /**
   * Enables publisher acknowledgements on this channel. Can be called once during client initialisation. Calls to basicPublish()
   * will have to be confirmed.
   * @return 
   */
  public rx.Single<java.lang.Void> rxConfirmSelect() { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      confirmSelect(fut);
    }));
  }

  /**
   * Wait until all messages published since the last call have been either ack'd or nack'd by the broker.
   * This will incur slight performance loss at the expense of higher write consistency.
   * If desired, multiple calls to basicPublish() can be batched before confirming.
   * @param resultHandler 
   */
  public void waitForConfirms(io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.Void>> resultHandler) { 
    delegate.waitForConfirms(resultHandler);
  }

  /**
   * Wait until all messages published since the last call have been either ack'd or nack'd by the broker.
   * This will incur slight performance loss at the expense of higher write consistency.
   * If desired, multiple calls to basicPublish() can be batched before confirming.
   */
  public void waitForConfirms() {
    waitForConfirms(ar -> { });
  }

    /**
   * Wait until all messages published since the last call have been either ack'd or nack'd by the broker.
   * This will incur slight performance loss at the expense of higher write consistency.
   * If desired, multiple calls to basicPublish() can be batched before confirming.
   * @return 
   */
  public rx.Single<java.lang.Void> rxWaitForConfirms() { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      waitForConfirms(fut);
    }));
  }

  /**
   * Wait until all messages published since the last call have been either ack'd or nack'd by the broker; or until timeout elapses. If the timeout expires a TimeoutException is thrown.
   * @param timeout 
   * @param resultHandler 
   */
  public void waitForConfirms(long timeout, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.Void>> resultHandler) { 
    delegate.waitForConfirms(timeout, resultHandler);
  }

  /**
   * Wait until all messages published since the last call have been either ack'd or nack'd by the broker; or until timeout elapses. If the timeout expires a TimeoutException is thrown.
   * @param timeout 
   */
  public void waitForConfirms(long timeout) {
    waitForConfirms(timeout, ar -> { });
  }

    /**
   * Wait until all messages published since the last call have been either ack'd or nack'd by the broker; or until timeout elapses. If the timeout expires a TimeoutException is thrown.
   * @param timeout 
   * @return 
   */
  public rx.Single<java.lang.Void> rxWaitForConfirms(long timeout) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      waitForConfirms(timeout, fut);
    }));
  }

  /**
   * Request a specific prefetchCount "quality of service" settings
   * for this channel.
   * @param prefetchCount maximum number of messages that the server will deliver, 0 if unlimited
   * @param resultHandler handler called when operation is done with a result of the operation
   */
  public void basicQos(int prefetchCount, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.Void>> resultHandler) { 
    delegate.basicQos(prefetchCount, resultHandler);
  }

  /**
   * Request a specific prefetchCount "quality of service" settings
   * for this channel.
   * @param prefetchCount maximum number of messages that the server will deliver, 0 if unlimited
   */
  public void basicQos(int prefetchCount) {
    basicQos(prefetchCount, ar -> { });
  }

    /**
   * Request a specific prefetchCount "quality of service" settings
   * for this channel.
   * @param prefetchCount maximum number of messages that the server will deliver, 0 if unlimited
   * @return 
   */
  public rx.Single<java.lang.Void> rxBasicQos(int prefetchCount) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      basicQos(prefetchCount, fut);
    }));
  }

  /**
   * Request a specific prefetchCount "quality of service" settings
   * for this channel.
   * @param prefetchCount maximum number of messages that the server will deliver, 0 if unlimited
   * @param global true if the settings should be applied to the entire channel rather than each consumer
   * @param resultHandler handler called when operation is done with a result of the operation
   */
  public void basicQos(int prefetchCount, boolean global, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.Void>> resultHandler) { 
    delegate.basicQos(prefetchCount, global, resultHandler);
  }

  /**
   * Request a specific prefetchCount "quality of service" settings
   * for this channel.
   * @param prefetchCount maximum number of messages that the server will deliver, 0 if unlimited
   * @param global true if the settings should be applied to the entire channel rather than each consumer
   */
  public void basicQos(int prefetchCount, boolean global) {
    basicQos(prefetchCount, global, ar -> { });
  }

    /**
   * Request a specific prefetchCount "quality of service" settings
   * for this channel.
   * @param prefetchCount maximum number of messages that the server will deliver, 0 if unlimited
   * @param global true if the settings should be applied to the entire channel rather than each consumer
   * @return 
   */
  public rx.Single<java.lang.Void> rxBasicQos(int prefetchCount, boolean global) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      basicQos(prefetchCount, global, fut);
    }));
  }

  /**
   * Request specific "quality of service" settings.
   *
   * These settings impose limits on the amount of data the server
   * will deliver to consumers before requiring acknowledgements.
   * Thus they provide a means of consumer-initiated flow control.
   * @param prefetchSize maximum amount of content (measured in octets) that the server will deliver, 0 if unlimited
   * @param prefetchCount maximum number of messages that the server will deliver, 0 if unlimited
   * @param global true if the settings should be applied to the entire channel rather than each consumer
   * @param resultHandler handler called when operation is done with a result of the operation
   */
  public void basicQos(int prefetchSize, int prefetchCount, boolean global, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.Void>> resultHandler) { 
    delegate.basicQos(prefetchSize, prefetchCount, global, resultHandler);
  }

  /**
   * Request specific "quality of service" settings.
   *
   * These settings impose limits on the amount of data the server
   * will deliver to consumers before requiring acknowledgements.
   * Thus they provide a means of consumer-initiated flow control.
   * @param prefetchSize maximum amount of content (measured in octets) that the server will deliver, 0 if unlimited
   * @param prefetchCount maximum number of messages that the server will deliver, 0 if unlimited
   * @param global true if the settings should be applied to the entire channel rather than each consumer
   */
  public void basicQos(int prefetchSize, int prefetchCount, boolean global) {
    basicQos(prefetchSize, prefetchCount, global, ar -> { });
  }

    /**
   * Request specific "quality of service" settings.
   *
   * These settings impose limits on the amount of data the server
   * will deliver to consumers before requiring acknowledgements.
   * Thus they provide a means of consumer-initiated flow control.
   * @param prefetchSize maximum amount of content (measured in octets) that the server will deliver, 0 if unlimited
   * @param prefetchCount maximum number of messages that the server will deliver, 0 if unlimited
   * @param global true if the settings should be applied to the entire channel rather than each consumer
   * @return 
   */
  public rx.Single<java.lang.Void> rxBasicQos(int prefetchSize, int prefetchCount, boolean global) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      basicQos(prefetchSize, prefetchCount, global, fut);
    }));
  }

  /**
   * Declare an exchange.
   * @param exchange 
   * @param type 
   * @param durable 
   * @param autoDelete 
   * @param resultHandler 
   */
  public void exchangeDeclare(java.lang.String exchange, java.lang.String type, boolean durable, boolean autoDelete, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.Void>> resultHandler) { 
    delegate.exchangeDeclare(exchange, type, durable, autoDelete, resultHandler);
  }

  /**
   * Declare an exchange.
   * @param exchange 
   * @param type 
   * @param durable 
   * @param autoDelete 
   */
  public void exchangeDeclare(java.lang.String exchange, java.lang.String type, boolean durable, boolean autoDelete) {
    exchangeDeclare(exchange, type, durable, autoDelete, ar -> { });
  }

    /**
   * Declare an exchange.
   * @param exchange 
   * @param type 
   * @param durable 
   * @param autoDelete 
   * @return 
   */
  public rx.Single<java.lang.Void> rxExchangeDeclare(java.lang.String exchange, java.lang.String type, boolean durable, boolean autoDelete) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      exchangeDeclare(exchange, type, durable, autoDelete, fut);
    }));
  }

  /**
   * Declare an exchange with additional parameters such as dead lettering, an alternate exchange or TTL.
   * @param exchange 
   * @param type 
   * @param durable 
   * @param autoDelete 
   * @param config 
   * @param resultHandler 
   */
  public void exchangeDeclare(java.lang.String exchange, java.lang.String type, boolean durable, boolean autoDelete, io.vertx.core.json.JsonObject config, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.Void>> resultHandler) { 
    delegate.exchangeDeclare(exchange, type, durable, autoDelete, config, resultHandler);
  }

  /**
   * Declare an exchange with additional parameters such as dead lettering, an alternate exchange or TTL.
   * @param exchange 
   * @param type 
   * @param durable 
   * @param autoDelete 
   * @param config 
   */
  public void exchangeDeclare(java.lang.String exchange, java.lang.String type, boolean durable, boolean autoDelete, io.vertx.core.json.JsonObject config) {
    exchangeDeclare(exchange, type, durable, autoDelete, config, ar -> { });
  }

    /**
   * Declare an exchange with additional parameters such as dead lettering, an alternate exchange or TTL.
   * @param exchange 
   * @param type 
   * @param durable 
   * @param autoDelete 
   * @param config 
   * @return 
   */
  public rx.Single<java.lang.Void> rxExchangeDeclare(java.lang.String exchange, java.lang.String type, boolean durable, boolean autoDelete, io.vertx.core.json.JsonObject config) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      exchangeDeclare(exchange, type, durable, autoDelete, config, fut);
    }));
  }

  /**
   * Delete an exchange, without regard for whether it is in use or not.
   * @param exchange 
   * @param resultHandler 
   */
  public void exchangeDelete(java.lang.String exchange, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.Void>> resultHandler) { 
    delegate.exchangeDelete(exchange, resultHandler);
  }

  /**
   * Delete an exchange, without regard for whether it is in use or not.
   * @param exchange 
   */
  public void exchangeDelete(java.lang.String exchange) {
    exchangeDelete(exchange, ar -> { });
  }

    /**
   * Delete an exchange, without regard for whether it is in use or not.
   * @param exchange 
   * @return 
   */
  public rx.Single<java.lang.Void> rxExchangeDelete(java.lang.String exchange) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      exchangeDelete(exchange, fut);
    }));
  }

  /**
   * Bind an exchange to an exchange.
   * @param destination 
   * @param source 
   * @param routingKey 
   * @param resultHandler 
   */
  public void exchangeBind(java.lang.String destination, java.lang.String source, java.lang.String routingKey, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.Void>> resultHandler) { 
    delegate.exchangeBind(destination, source, routingKey, resultHandler);
  }

  /**
   * Bind an exchange to an exchange.
   * @param destination 
   * @param source 
   * @param routingKey 
   */
  public void exchangeBind(java.lang.String destination, java.lang.String source, java.lang.String routingKey) {
    exchangeBind(destination, source, routingKey, ar -> { });
  }

    /**
   * Bind an exchange to an exchange.
   * @param destination 
   * @param source 
   * @param routingKey 
   * @return 
   */
  public rx.Single<java.lang.Void> rxExchangeBind(java.lang.String destination, java.lang.String source, java.lang.String routingKey) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      exchangeBind(destination, source, routingKey, fut);
    }));
  }

  /**
   * Bind an exchange to an exchange.
   * @param destination 
   * @param source 
   * @param routingKey 
   * @param arguments 
   * @param resultHandler 
   */
  public void exchangeBind(java.lang.String destination, java.lang.String source, java.lang.String routingKey, java.util.Map<java.lang.String,java.lang.Object> arguments, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.Void>> resultHandler) { 
    delegate.exchangeBind(destination, source, routingKey, arguments, resultHandler);
  }

  /**
   * Bind an exchange to an exchange.
   * @param destination 
   * @param source 
   * @param routingKey 
   * @param arguments 
   */
  public void exchangeBind(java.lang.String destination, java.lang.String source, java.lang.String routingKey, java.util.Map<java.lang.String,java.lang.Object> arguments) {
    exchangeBind(destination, source, routingKey, arguments, ar -> { });
  }

    /**
   * Bind an exchange to an exchange.
   * @param destination 
   * @param source 
   * @param routingKey 
   * @param arguments 
   * @return 
   */
  public rx.Single<java.lang.Void> rxExchangeBind(java.lang.String destination, java.lang.String source, java.lang.String routingKey, java.util.Map<java.lang.String,java.lang.Object> arguments) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      exchangeBind(destination, source, routingKey, arguments, fut);
    }));
  }

  /**
   * Unbind an exchange from an exchange.
   * @param destination 
   * @param source 
   * @param routingKey 
   * @param resultHandler 
   */
  public void exchangeUnbind(java.lang.String destination, java.lang.String source, java.lang.String routingKey, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.Void>> resultHandler) { 
    delegate.exchangeUnbind(destination, source, routingKey, resultHandler);
  }

  /**
   * Unbind an exchange from an exchange.
   * @param destination 
   * @param source 
   * @param routingKey 
   */
  public void exchangeUnbind(java.lang.String destination, java.lang.String source, java.lang.String routingKey) {
    exchangeUnbind(destination, source, routingKey, ar -> { });
  }

    /**
   * Unbind an exchange from an exchange.
   * @param destination 
   * @param source 
   * @param routingKey 
   * @return 
   */
  public rx.Single<java.lang.Void> rxExchangeUnbind(java.lang.String destination, java.lang.String source, java.lang.String routingKey) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      exchangeUnbind(destination, source, routingKey, fut);
    }));
  }

  /**
   * Unbind an exchange from an exchange.
   * @param destination 
   * @param source 
   * @param routingKey 
   * @param arguments 
   * @param resultHandler 
   */
  public void exchangeUnbind(java.lang.String destination, java.lang.String source, java.lang.String routingKey, java.util.Map<java.lang.String,java.lang.Object> arguments, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.Void>> resultHandler) { 
    delegate.exchangeUnbind(destination, source, routingKey, arguments, resultHandler);
  }

  /**
   * Unbind an exchange from an exchange.
   * @param destination 
   * @param source 
   * @param routingKey 
   * @param arguments 
   */
  public void exchangeUnbind(java.lang.String destination, java.lang.String source, java.lang.String routingKey, java.util.Map<java.lang.String,java.lang.Object> arguments) {
    exchangeUnbind(destination, source, routingKey, arguments, ar -> { });
  }

    /**
   * Unbind an exchange from an exchange.
   * @param destination 
   * @param source 
   * @param routingKey 
   * @param arguments 
   * @return 
   */
  public rx.Single<java.lang.Void> rxExchangeUnbind(java.lang.String destination, java.lang.String source, java.lang.String routingKey, java.util.Map<java.lang.String,java.lang.Object> arguments) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      exchangeUnbind(destination, source, routingKey, arguments, fut);
    }));
  }

  /**
   * Actively declare a server-named exclusive, autodelete, non-durable queue.
   * @param resultHandler 
   */
  public void queueDeclareAuto(io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.core.json.JsonObject>> resultHandler) { 
    delegate.queueDeclareAuto(resultHandler);
  }

  /**
   * Actively declare a server-named exclusive, autodelete, non-durable queue.
   */
  public void queueDeclareAuto() {
    queueDeclareAuto(ar -> { });
  }

    /**
   * Actively declare a server-named exclusive, autodelete, non-durable queue.
   * @return 
   */
  public rx.Single<io.vertx.core.json.JsonObject> rxQueueDeclareAuto() { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      queueDeclareAuto(fut);
    }));
  }

  /**
   * Bind a queue to an exchange
   * @param queue 
   * @param exchange 
   * @param routingKey 
   * @param resultHandler 
   */
  public void queueBind(java.lang.String queue, java.lang.String exchange, java.lang.String routingKey, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.Void>> resultHandler) { 
    delegate.queueBind(queue, exchange, routingKey, resultHandler);
  }

  /**
   * Bind a queue to an exchange
   * @param queue 
   * @param exchange 
   * @param routingKey 
   */
  public void queueBind(java.lang.String queue, java.lang.String exchange, java.lang.String routingKey) {
    queueBind(queue, exchange, routingKey, ar -> { });
  }

    /**
   * Bind a queue to an exchange
   * @param queue 
   * @param exchange 
   * @param routingKey 
   * @return 
   */
  public rx.Single<java.lang.Void> rxQueueBind(java.lang.String queue, java.lang.String exchange, java.lang.String routingKey) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      queueBind(queue, exchange, routingKey, fut);
    }));
  }

  /**
   * Bind a queue to an exchange
   * @param queue 
   * @param exchange 
   * @param routingKey 
   * @param arguments 
   * @param resultHandler 
   */
  public void queueBind(java.lang.String queue, java.lang.String exchange, java.lang.String routingKey, java.util.Map<java.lang.String,java.lang.Object> arguments, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.Void>> resultHandler) { 
    delegate.queueBind(queue, exchange, routingKey, arguments, resultHandler);
  }

  /**
   * Bind a queue to an exchange
   * @param queue 
   * @param exchange 
   * @param routingKey 
   * @param arguments 
   */
  public void queueBind(java.lang.String queue, java.lang.String exchange, java.lang.String routingKey, java.util.Map<java.lang.String,java.lang.Object> arguments) {
    queueBind(queue, exchange, routingKey, arguments, ar -> { });
  }

    /**
   * Bind a queue to an exchange
   * @param queue 
   * @param exchange 
   * @param routingKey 
   * @param arguments 
   * @return 
   */
  public rx.Single<java.lang.Void> rxQueueBind(java.lang.String queue, java.lang.String exchange, java.lang.String routingKey, java.util.Map<java.lang.String,java.lang.Object> arguments) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      queueBind(queue, exchange, routingKey, arguments, fut);
    }));
  }

  /**
   * Unbind a queue from an exchange
   * @param queue 
   * @param exchange 
   * @param routingKey 
   * @param resultHandler 
   */
  public void queueUnbind(java.lang.String queue, java.lang.String exchange, java.lang.String routingKey, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.Void>> resultHandler) { 
    delegate.queueUnbind(queue, exchange, routingKey, resultHandler);
  }

  /**
   * Unbind a queue from an exchange
   * @param queue 
   * @param exchange 
   * @param routingKey 
   */
  public void queueUnbind(java.lang.String queue, java.lang.String exchange, java.lang.String routingKey) {
    queueUnbind(queue, exchange, routingKey, ar -> { });
  }

    /**
   * Unbind a queue from an exchange
   * @param queue 
   * @param exchange 
   * @param routingKey 
   * @return 
   */
  public rx.Single<java.lang.Void> rxQueueUnbind(java.lang.String queue, java.lang.String exchange, java.lang.String routingKey) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      queueUnbind(queue, exchange, routingKey, fut);
    }));
  }

  /**
   * Unbind a queue from an exchange
   * @param queue 
   * @param exchange 
   * @param routingKey 
   * @param arguments 
   * @param resultHandler 
   */
  public void queueUnbind(java.lang.String queue, java.lang.String exchange, java.lang.String routingKey, java.util.Map<java.lang.String,java.lang.Object> arguments, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.Void>> resultHandler) { 
    delegate.queueUnbind(queue, exchange, routingKey, arguments, resultHandler);
  }

  /**
   * Unbind a queue from an exchange
   * @param queue 
   * @param exchange 
   * @param routingKey 
   * @param arguments 
   */
  public void queueUnbind(java.lang.String queue, java.lang.String exchange, java.lang.String routingKey, java.util.Map<java.lang.String,java.lang.Object> arguments) {
    queueUnbind(queue, exchange, routingKey, arguments, ar -> { });
  }

    /**
   * Unbind a queue from an exchange
   * @param queue 
   * @param exchange 
   * @param routingKey 
   * @param arguments 
   * @return 
   */
  public rx.Single<java.lang.Void> rxQueueUnbind(java.lang.String queue, java.lang.String exchange, java.lang.String routingKey, java.util.Map<java.lang.String,java.lang.Object> arguments) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      queueUnbind(queue, exchange, routingKey, arguments, fut);
    }));
  }

  /**
   * Returns the number of messages in a queue ready to be delivered.
   * @param queue 
   * @param resultHandler 
   */
  public void messageCount(java.lang.String queue, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.Long>> resultHandler) { 
    delegate.messageCount(queue, resultHandler);
  }

  /**
   * Returns the number of messages in a queue ready to be delivered.
   * @param queue 
   */
  public void messageCount(java.lang.String queue) {
    messageCount(queue, ar -> { });
  }

    /**
   * Returns the number of messages in a queue ready to be delivered.
   * @param queue 
   * @return 
   */
  public rx.Single<java.lang.Long> rxMessageCount(java.lang.String queue) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      messageCount(queue, fut);
    }));
  }

  /**
   * Start the rabbitMQ client. Create the connection and the channel.
   * @param resultHandler 
   */
  public void start(io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.Void>> resultHandler) { 
    delegate.start(resultHandler);
  }

  /**
   * Start the rabbitMQ client. Create the connection and the channel.
   */
  public void start() {
    start(ar -> { });
  }

    /**
   * Start the rabbitMQ client. Create the connection and the channel.
   * @return 
   */
  public rx.Single<java.lang.Void> rxStart() { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      start(fut);
    }));
  }

  /**
   * Stop the rabbitMQ client. Close the connection and its channel.
   * @param resultHandler 
   */
  public void stop(io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.Void>> resultHandler) { 
    delegate.stop(resultHandler);
  }

  /**
   * Stop the rabbitMQ client. Close the connection and its channel.
   */
  public void stop() {
    stop(ar -> { });
  }

    /**
   * Stop the rabbitMQ client. Close the connection and its channel.
   * @return 
   */
  public rx.Single<java.lang.Void> rxStop() { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      stop(fut);
    }));
  }

  /**
   * Check if a connection is open
   * @return true when the connection is open, false otherwise
   */
  public boolean isConnected() { 
    boolean ret = delegate.isConnected();
    return ret;
  }

  /**
   * restart the rabbitMQ connect.
   * @param attempts number of attempts
   * @param resultHandler handler called when operation is done with a result of the operation
   */
  public void restartConnect(int attempts, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.Void>> resultHandler) { 
    delegate.restartConnect(attempts, resultHandler);
  }

  /**
   * restart the rabbitMQ connect.
   * @param attempts number of attempts
   */
  public void restartConnect(int attempts) {
    restartConnect(attempts, ar -> { });
  }

    /**
   * restart the rabbitMQ connect.
   * @param attempts number of attempts
   * @return 
   */
  public rx.Single<java.lang.Void> rxRestartConnect(int attempts) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      restartConnect(attempts, fut);
    }));
  }

  /**
   * Check if a channel is open
   * @return true when the connection is open, false otherwise
   */
  public boolean isOpenChannel() { 
    boolean ret = delegate.isOpenChannel();
    return ret;
  }

  /**
   * Publish a message. Publishing to a non-existent exchange will result in a channel-level protocol exception,
   * which closes the channel. Invocations of Channel#basicPublish will eventually block if a resource-driven alarm is in effect.
   * @param exchange 
   * @param routingKey 
   * @param properties 
   * @param body 
   * @param resultHandler 
   */
  public void basicPublish(java.lang.String exchange, java.lang.String routingKey, com.rabbitmq.client.BasicProperties properties, io.vertx.rxjava.core.buffer.Buffer body, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.Void>> resultHandler) { 
    delegate.basicPublish(exchange, routingKey, properties, body.getDelegate(), resultHandler);
  }

  /**
   * Publish a message. Publishing to a non-existent exchange will result in a channel-level protocol exception,
   * which closes the channel. Invocations of Channel#basicPublish will eventually block if a resource-driven alarm is in effect.
   * @param exchange 
   * @param routingKey 
   * @param properties 
   * @param body 
   */
  public void basicPublish(java.lang.String exchange, java.lang.String routingKey, com.rabbitmq.client.BasicProperties properties, io.vertx.rxjava.core.buffer.Buffer body) {
    basicPublish(exchange, routingKey, properties, body, ar -> { });
  }

    /**
   * Publish a message. Publishing to a non-existent exchange will result in a channel-level protocol exception,
   * which closes the channel. Invocations of Channel#basicPublish will eventually block if a resource-driven alarm is in effect.
   * @param exchange 
   * @param routingKey 
   * @param properties 
   * @param body 
   * @return 
   */
  public rx.Single<java.lang.Void> rxBasicPublish(java.lang.String exchange, java.lang.String routingKey, com.rabbitmq.client.BasicProperties properties, io.vertx.rxjava.core.buffer.Buffer body) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      basicPublish(exchange, routingKey, properties, body, fut);
    }));
  }

  /**
   * Publish a message. Publishing to a non-existent exchange will result in a channel-level protocol exception,
   * which closes the channel. Invocations of Channel#basicPublish will eventually block if a resource-driven alarm is in effect.
   *
   * The deliveryTagHandler will be called before the message is sent, which is necessary because the confirmation may arrive
   * asynchronously before the resultHandler is called.
   * @param exchange 
   * @param routingKey 
   * @param properties 
   * @param body 
   * @param deliveryTagHandler callback to capture the deliveryTag for this message. Note that this will be called synchronously in the context of the client before the result is known.
   * @param resultHandler 
   */
  public void basicPublishWithDeliveryTag(java.lang.String exchange, java.lang.String routingKey, com.rabbitmq.client.BasicProperties properties, io.vertx.rxjava.core.buffer.Buffer body, io.vertx.core.Handler<java.lang.Long> deliveryTagHandler, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.Void>> resultHandler) { 
    delegate.basicPublishWithDeliveryTag(exchange, routingKey, properties, body.getDelegate(), deliveryTagHandler, resultHandler);
  }

  /**
   * Publish a message. Publishing to a non-existent exchange will result in a channel-level protocol exception,
   * which closes the channel. Invocations of Channel#basicPublish will eventually block if a resource-driven alarm is in effect.
   *
   * The deliveryTagHandler will be called before the message is sent, which is necessary because the confirmation may arrive
   * asynchronously before the resultHandler is called.
   * @param exchange 
   * @param routingKey 
   * @param properties 
   * @param body 
   * @param deliveryTagHandler callback to capture the deliveryTag for this message. Note that this will be called synchronously in the context of the client before the result is known.
   */
  public void basicPublishWithDeliveryTag(java.lang.String exchange, java.lang.String routingKey, com.rabbitmq.client.BasicProperties properties, io.vertx.rxjava.core.buffer.Buffer body, io.vertx.core.Handler<java.lang.Long> deliveryTagHandler) {
    basicPublishWithDeliveryTag(exchange, routingKey, properties, body, deliveryTagHandler, ar -> { });
  }

    /**
   * Publish a message. Publishing to a non-existent exchange will result in a channel-level protocol exception,
   * which closes the channel. Invocations of Channel#basicPublish will eventually block if a resource-driven alarm is in effect.
   *
   * The deliveryTagHandler will be called before the message is sent, which is necessary because the confirmation may arrive
   * asynchronously before the resultHandler is called.
   * @param exchange 
   * @param routingKey 
   * @param properties 
   * @param body 
   * @param deliveryTagHandler callback to capture the deliveryTag for this message. Note that this will be called synchronously in the context of the client before the result is known.
   * @return 
   */
  public rx.Single<java.lang.Void> rxBasicPublishWithDeliveryTag(java.lang.String exchange, java.lang.String routingKey, com.rabbitmq.client.BasicProperties properties, io.vertx.rxjava.core.buffer.Buffer body, io.vertx.core.Handler<java.lang.Long> deliveryTagHandler) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      basicPublishWithDeliveryTag(exchange, routingKey, properties, body, deliveryTagHandler, fut);
    }));
  }

  /**
   * Declare a queue
   * @param queue 
   * @param durable 
   * @param exclusive 
   * @param autoDelete 
   * @param resultHandler 
   */
  public void queueDeclare(java.lang.String queue, boolean durable, boolean exclusive, boolean autoDelete, io.vertx.core.Handler<io.vertx.core.AsyncResult<com.rabbitmq.client.AMQP.Queue.DeclareOk>> resultHandler) { 
    delegate.queueDeclare(queue, durable, exclusive, autoDelete, resultHandler);
  }

  /**
   * Declare a queue
   * @param queue 
   * @param durable 
   * @param exclusive 
   * @param autoDelete 
   */
  public void queueDeclare(java.lang.String queue, boolean durable, boolean exclusive, boolean autoDelete) {
    queueDeclare(queue, durable, exclusive, autoDelete, ar -> { });
  }

    /**
   * Declare a queue
   * @param queue 
   * @param durable 
   * @param exclusive 
   * @param autoDelete 
   * @return 
   */
  public rx.Single<com.rabbitmq.client.AMQP.Queue.DeclareOk> rxQueueDeclare(java.lang.String queue, boolean durable, boolean exclusive, boolean autoDelete) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      queueDeclare(queue, durable, exclusive, autoDelete, fut);
    }));
  }

  /**
   * Declare a queue with config options
   * @param queue 
   * @param durable 
   * @param exclusive 
   * @param autoDelete 
   * @param config 
   * @param resultHandler 
   */
  public void queueDeclare(java.lang.String queue, boolean durable, boolean exclusive, boolean autoDelete, io.vertx.core.json.JsonObject config, io.vertx.core.Handler<io.vertx.core.AsyncResult<com.rabbitmq.client.AMQP.Queue.DeclareOk>> resultHandler) { 
    delegate.queueDeclare(queue, durable, exclusive, autoDelete, config, resultHandler);
  }

  /**
   * Declare a queue with config options
   * @param queue 
   * @param durable 
   * @param exclusive 
   * @param autoDelete 
   * @param config 
   */
  public void queueDeclare(java.lang.String queue, boolean durable, boolean exclusive, boolean autoDelete, io.vertx.core.json.JsonObject config) {
    queueDeclare(queue, durable, exclusive, autoDelete, config, ar -> { });
  }

    /**
   * Declare a queue with config options
   * @param queue 
   * @param durable 
   * @param exclusive 
   * @param autoDelete 
   * @param config 
   * @return 
   */
  public rx.Single<com.rabbitmq.client.AMQP.Queue.DeclareOk> rxQueueDeclare(java.lang.String queue, boolean durable, boolean exclusive, boolean autoDelete, io.vertx.core.json.JsonObject config) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      queueDeclare(queue, durable, exclusive, autoDelete, config, fut);
    }));
  }

  /**
   * Delete a queue, without regard for whether it is in use or has messages on it
   * @param queue 
   * @param resultHandler 
   */
  public void queueDelete(java.lang.String queue, io.vertx.core.Handler<io.vertx.core.AsyncResult<com.rabbitmq.client.AMQP.Queue.DeleteOk>> resultHandler) { 
    delegate.queueDelete(queue, resultHandler);
  }

  /**
   * Delete a queue, without regard for whether it is in use or has messages on it
   * @param queue 
   */
  public void queueDelete(java.lang.String queue) {
    queueDelete(queue, ar -> { });
  }

    /**
   * Delete a queue, without regard for whether it is in use or has messages on it
   * @param queue 
   * @return 
   */
  public rx.Single<com.rabbitmq.client.AMQP.Queue.DeleteOk> rxQueueDelete(java.lang.String queue) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      queueDelete(queue, fut);
    }));
  }

  /**
   * Delete a queue
   * @param queue 
   * @param ifUnused 
   * @param ifEmpty 
   * @param resultHandler 
   */
  public void queueDeleteIf(java.lang.String queue, boolean ifUnused, boolean ifEmpty, io.vertx.core.Handler<io.vertx.core.AsyncResult<com.rabbitmq.client.AMQP.Queue.DeleteOk>> resultHandler) { 
    delegate.queueDeleteIf(queue, ifUnused, ifEmpty, resultHandler);
  }

  /**
   * Delete a queue
   * @param queue 
   * @param ifUnused 
   * @param ifEmpty 
   */
  public void queueDeleteIf(java.lang.String queue, boolean ifUnused, boolean ifEmpty) {
    queueDeleteIf(queue, ifUnused, ifEmpty, ar -> { });
  }

    /**
   * Delete a queue
   * @param queue 
   * @param ifUnused 
   * @param ifEmpty 
   * @return 
   */
  public rx.Single<com.rabbitmq.client.AMQP.Queue.DeleteOk> rxQueueDeleteIf(java.lang.String queue, boolean ifUnused, boolean ifEmpty) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      queueDeleteIf(queue, ifUnused, ifEmpty, fut);
    }));
  }

  public static RabbitMQClient newInstance(io.vertx.rabbitmq.RabbitMQClient arg) {
    return arg != null ? new RabbitMQClient(arg) : null;
  }

}
