/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava.pgclient.pubsub;

import rx.Observable;
import rx.Single;
import io.vertx.rx.java.RxHelper;
import io.vertx.rx.java.WriteStreamSubscriber;
import io.vertx.rx.java.SingleOnSubscribeAdapter;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * A channel to Postgres that tracks the subscription to a given Postgres channel using the <code>LISTEN/UNLISTEN</code> commands.
 * <p/>
 * When paused the channel discards the messages.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.pgclient.pubsub.PgChannel original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.pgclient.pubsub.PgChannel.class)
public class PgChannel implements io.vertx.rxjava.core.streams.ReadStream<java.lang.String> {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    PgChannel that = (PgChannel) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<PgChannel> __TYPE_ARG = new TypeArg<>(    obj -> new PgChannel((io.vertx.pgclient.pubsub.PgChannel) obj),
    PgChannel::getDelegate
  );

  private final io.vertx.pgclient.pubsub.PgChannel delegate;
  
  public PgChannel(io.vertx.pgclient.pubsub.PgChannel delegate) {
    this.delegate = delegate;
  }

  public PgChannel(Object delegate) {
    this.delegate = (io.vertx.pgclient.pubsub.PgChannel)delegate;
  }

  public io.vertx.pgclient.pubsub.PgChannel getDelegate() {
    return delegate;
  }

  private Observable<java.lang.String> observable;

  public synchronized Observable<java.lang.String> toObservable() {
    if (observable == null) {
      observable = RxHelper.toObservable(this.getDelegate());
    }
    return observable;
  }


  /**
   * Fetch the specified <code>amount</code> of elements. If the <code>ReadStream</code> has been paused, reading will
   * recommence with the specified <code>amount</code> of items, otherwise the specified <code>amount</code> will
   * be added to the current stream demand.
   * @param amount 
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava.core.streams.ReadStream<java.lang.String> fetch(long amount) { 
    delegate.fetch(amount);
    return this;
  }

  /**
   * Pause this stream and return a  to transfer the elements of this stream to a destination .
   * <p/>
   * The stream will be resumed when the pipe will be wired to a <code>WriteStream</code>.
   * @return a pipe
   */
  public io.vertx.rxjava.core.streams.Pipe<java.lang.String> pipe() { 
    io.vertx.rxjava.core.streams.Pipe<java.lang.String> ret = io.vertx.rxjava.core.streams.Pipe.newInstance((io.vertx.core.streams.Pipe)delegate.pipe(), TypeArg.unknown());
    return ret;
  }

  /**
   * Pipe this <code>ReadStream</code> to the <code>WriteStream</code>.
   * <p>
   * Elements emitted by this stream will be written to the write stream until this stream ends or fails.
   * <p>
   * Once this stream has ended or failed, the write stream will be ended and the <code>handler</code> will be
   * called with the result.
   * @param dst the destination write stream
   * @param handler 
   */
  public void pipeTo(io.vertx.rxjava.core.streams.WriteStream<java.lang.String> dst, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.Void>> handler) { 
    delegate.pipeTo(dst.getDelegate(), handler);
  }

  /**
   * Pipe this <code>ReadStream</code> to the <code>WriteStream</code>.
   * <p>
   * Elements emitted by this stream will be written to the write stream until this stream ends or fails.
   * <p>
   * Once this stream has ended or failed, the write stream will be ended and the <code>handler</code> will be
   * called with the result.
   * @param dst the destination write stream
   */
  public void pipeTo(io.vertx.rxjava.core.streams.WriteStream<java.lang.String> dst) {
    pipeTo(dst, ar -> { });
  }

    /**
   * Pipe this <code>ReadStream</code> to the <code>WriteStream</code>.
   * <p>
   * Elements emitted by this stream will be written to the write stream until this stream ends or fails.
   * <p>
   * Once this stream has ended or failed, the write stream will be ended and the <code>handler</code> will be
   * called with the result.
   * @param dst the destination write stream
   * @return 
   */
  public rx.Single<java.lang.Void> rxPipeTo(io.vertx.rxjava.core.streams.WriteStream<java.lang.String> dst) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      pipeTo(dst, fut);
    }));
  }

  /**
   * Set an handler called when the the channel get subscribed.
   * @param handler the handler
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava.pgclient.pubsub.PgChannel subscribeHandler(io.vertx.core.Handler<java.lang.Void> handler) { 
    delegate.subscribeHandler(handler);
    return this;
  }

  /**
   * Set or unset an handler to be called when a the channel is notified by Postgres.
   * <p/>
   * <ul>
   *   <li>when the handler is set, the subscriber sends a <code>LISTEN</code> command if needed</li>
   *   <li>when the handler is unset, the subscriber sends a <code>UNLISTEN</code> command if needed</li>
   * </ul>
   * @param handler the handler
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava.pgclient.pubsub.PgChannel handler(io.vertx.core.Handler<java.lang.String> handler) { 
    delegate.handler(handler);
    return this;
  }

  /**
   * Pause the channel, all notifications are discarded.
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava.pgclient.pubsub.PgChannel pause() { 
    delegate.pause();
    return this;
  }

  /**
   * Resume the channel.
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava.pgclient.pubsub.PgChannel resume() { 
    delegate.resume();
    return this;
  }

  /**
   * Set an handler to be called when no more notifications will be received.
   * @param endHandler the handler
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava.pgclient.pubsub.PgChannel endHandler(io.vertx.core.Handler<java.lang.Void> endHandler) { 
    delegate.endHandler(endHandler);
    return this;
  }

  public io.vertx.rxjava.pgclient.pubsub.PgChannel exceptionHandler(io.vertx.core.Handler<java.lang.Throwable> handler) { 
    delegate.exceptionHandler(handler);
    return this;
  }

  public static PgChannel newInstance(io.vertx.pgclient.pubsub.PgChannel arg) {
    return arg != null ? new PgChannel(arg) : null;
  }

}
