/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava.mysqlclient;

import rx.Observable;
import rx.Single;
import io.vertx.rx.java.RxHelper;
import io.vertx.rx.java.WriteStreamSubscriber;
import io.vertx.rx.java.SingleOnSubscribeAdapter;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * An interface which represents a connection to MySQL server.
 * <P>
 *   The connection object supports all the operations defined in the  interface,
 *   in addition it provides MySQL utility command support:
 *   <ul>
 *     <li>COM_PING</li>
 *     <li>COM_CHANGE_USER</li>
 *     <li>COM_RESET_CONNECTION</li>
 *     <li>COM_DEBUG</li>
 *     <li>COM_INIT_DB</li>
 *     <li>COM_STATISTICS</li>
 *     <li>COM_SET_OPTION</li>
 *   </ul>
 * </P>
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.mysqlclient.MySQLConnection original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.mysqlclient.MySQLConnection.class)
public class MySQLConnection extends io.vertx.rxjava.sqlclient.SqlConnection {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    MySQLConnection that = (MySQLConnection) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<MySQLConnection> __TYPE_ARG = new TypeArg<>(    obj -> new MySQLConnection((io.vertx.mysqlclient.MySQLConnection) obj),
    MySQLConnection::getDelegate
  );

  private final io.vertx.mysqlclient.MySQLConnection delegate;
  
  public MySQLConnection(io.vertx.mysqlclient.MySQLConnection delegate) {
    super(delegate);
    this.delegate = delegate;
  }

  public MySQLConnection(Object delegate) {
    super((io.vertx.mysqlclient.MySQLConnection)delegate);
    this.delegate = (io.vertx.mysqlclient.MySQLConnection)delegate;
  }

  public io.vertx.mysqlclient.MySQLConnection getDelegate() {
    return delegate;
  }

  /**
   * Create a connection to MySQL server with the given <code>connectOptions</code>.
   * @param vertx the vertx instance
   * @param connectOptions the options for the connection
   * @param handler the handler called with the connection or the failure
   */
  public static void connect(io.vertx.rxjava.core.Vertx vertx, io.vertx.mysqlclient.MySQLConnectOptions connectOptions, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.mysqlclient.MySQLConnection>> handler) { 
    io.vertx.mysqlclient.MySQLConnection.connect(vertx.getDelegate(), connectOptions, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.mysqlclient.MySQLConnection.newInstance((io.vertx.mysqlclient.MySQLConnection)event))));
  }

  /**
   * Create a connection to MySQL server with the given <code>connectOptions</code>.
   * @param vertx the vertx instance
   * @param connectOptions the options for the connection
   */
  public static void connect(io.vertx.rxjava.core.Vertx vertx, io.vertx.mysqlclient.MySQLConnectOptions connectOptions) {
    connect(vertx, connectOptions, ar -> { });
  }

    /**
   * Create a connection to MySQL server with the given <code>connectOptions</code>.
   * @param vertx the vertx instance
   * @param connectOptions the options for the connection
   * @return 
   */
  public static rx.Single<io.vertx.rxjava.mysqlclient.MySQLConnection> rxConnect(io.vertx.rxjava.core.Vertx vertx, io.vertx.mysqlclient.MySQLConnectOptions connectOptions) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      connect(vertx, connectOptions, fut);
    }));
  }

  /**
   * Like {@link io.vertx.rxjava.mysqlclient.MySQLConnection#connect} with options built from <code>connectionUri</code>.
   * @param vertx 
   * @param connectionUri 
   * @param handler 
   */
  public static void connect(io.vertx.rxjava.core.Vertx vertx, java.lang.String connectionUri, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.mysqlclient.MySQLConnection>> handler) { 
    io.vertx.mysqlclient.MySQLConnection.connect(vertx.getDelegate(), connectionUri, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.mysqlclient.MySQLConnection.newInstance((io.vertx.mysqlclient.MySQLConnection)event))));
  }

  /**
   * Like {@link io.vertx.rxjava.mysqlclient.MySQLConnection#connect} with options built from <code>connectionUri</code>.
   * @param vertx 
   * @param connectionUri 
   */
  public static void connect(io.vertx.rxjava.core.Vertx vertx, java.lang.String connectionUri) {
    connect(vertx, connectionUri, ar -> { });
  }

    /**
   * Like {@link io.vertx.rxjava.mysqlclient.MySQLConnection#connect} with options built from <code>connectionUri</code>.
   * @param vertx 
   * @param connectionUri 
   * @return 
   */
  public static rx.Single<io.vertx.rxjava.mysqlclient.MySQLConnection> rxConnect(io.vertx.rxjava.core.Vertx vertx, java.lang.String connectionUri) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      connect(vertx, connectionUri, fut);
    }));
  }

  /**
   * 
   * @param sql 
   * @param handler 
   * @return 
   */
  public io.vertx.rxjava.mysqlclient.MySQLConnection prepare(java.lang.String sql, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.sqlclient.PreparedStatement>> handler) { 
    delegate.prepare(sql, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.sqlclient.PreparedStatement.newInstance((io.vertx.sqlclient.PreparedStatement)event))));
    return this;
  }

  /**
   * 
   * @param sql 
   * @return 
   */
  public io.vertx.rxjava.mysqlclient.MySQLConnection prepare(java.lang.String sql) {
    return 
prepare(sql, ar -> { });
  }

    /**
   * 
   * @param sql 
   * @return 
   */
  public rx.Single<io.vertx.rxjava.sqlclient.PreparedStatement> rxPrepare(java.lang.String sql) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      prepare(sql, fut);
    }));
  }

  /**
   * 
   * @param handler 
   * @return 
   */
  public io.vertx.rxjava.mysqlclient.MySQLConnection exceptionHandler(io.vertx.core.Handler<java.lang.Throwable> handler) { 
    delegate.exceptionHandler(handler);
    return this;
  }

  /**
   * 
   * @param handler 
   * @return 
   */
  public io.vertx.rxjava.mysqlclient.MySQLConnection closeHandler(io.vertx.core.Handler<java.lang.Void> handler) { 
    delegate.closeHandler(handler);
    return this;
  }

  /**
   * Send a PING command to check if the server is alive.
   * @param handler the handler notified when the server responses to client
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava.mysqlclient.MySQLConnection ping(io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.Void>> handler) { 
    delegate.ping(handler);
    return this;
  }

  /**
   * Send a PING command to check if the server is alive.
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava.mysqlclient.MySQLConnection ping() {
    return 
ping(ar -> { });
  }

    /**
   * Send a PING command to check if the server is alive.
   * @return a reference to this, so the API can be used fluently
   */
  public rx.Single<java.lang.Void> rxPing() { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      ping(fut);
    }));
  }

  /**
   * Send a INIT_DB command to change the default schema of the connection.
   * @param schemaName name of the schema to change to
   * @param handler the handler notified with the execution result
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava.mysqlclient.MySQLConnection specifySchema(java.lang.String schemaName, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.Void>> handler) { 
    delegate.specifySchema(schemaName, handler);
    return this;
  }

  /**
   * Send a INIT_DB command to change the default schema of the connection.
   * @param schemaName name of the schema to change to
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava.mysqlclient.MySQLConnection specifySchema(java.lang.String schemaName) {
    return 
specifySchema(schemaName, ar -> { });
  }

    /**
   * Send a INIT_DB command to change the default schema of the connection.
   * @param schemaName name of the schema to change to
   * @return a reference to this, so the API can be used fluently
   */
  public rx.Single<java.lang.Void> rxSpecifySchema(java.lang.String schemaName) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      specifySchema(schemaName, fut);
    }));
  }

  /**
   * Send a STATISTICS command to get a human readable string of the server internal status.
   * @param handler the handler notified with the execution result
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava.mysqlclient.MySQLConnection getInternalStatistics(io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.String>> handler) { 
    delegate.getInternalStatistics(handler);
    return this;
  }

  /**
   * Send a STATISTICS command to get a human readable string of the server internal status.
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava.mysqlclient.MySQLConnection getInternalStatistics() {
    return 
getInternalStatistics(ar -> { });
  }

    /**
   * Send a STATISTICS command to get a human readable string of the server internal status.
   * @return a reference to this, so the API can be used fluently
   */
  public rx.Single<java.lang.String> rxGetInternalStatistics() { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      getInternalStatistics(fut);
    }));
  }

  /**
   * Send a SET_OPTION command to set options for the current connection.
   * @param option the options to set
   * @param handler the handler notified with the execution result
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava.mysqlclient.MySQLConnection setOption(io.vertx.mysqlclient.MySQLSetOption option, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.Void>> handler) { 
    delegate.setOption(option, handler);
    return this;
  }

  /**
   * Send a SET_OPTION command to set options for the current connection.
   * @param option the options to set
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava.mysqlclient.MySQLConnection setOption(io.vertx.mysqlclient.MySQLSetOption option) {
    return 
setOption(option, ar -> { });
  }

    /**
   * Send a SET_OPTION command to set options for the current connection.
   * @param option the options to set
   * @return a reference to this, so the API can be used fluently
   */
  public rx.Single<java.lang.Void> rxSetOption(io.vertx.mysqlclient.MySQLSetOption option) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      setOption(option, fut);
    }));
  }

  /**
   * Send a RESET_CONNECTION command to reset the session state.
   * @param handler the handler notified with the execution result
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava.mysqlclient.MySQLConnection resetConnection(io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.Void>> handler) { 
    delegate.resetConnection(handler);
    return this;
  }

  /**
   * Send a RESET_CONNECTION command to reset the session state.
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava.mysqlclient.MySQLConnection resetConnection() {
    return 
resetConnection(ar -> { });
  }

    /**
   * Send a RESET_CONNECTION command to reset the session state.
   * @return a reference to this, so the API can be used fluently
   */
  public rx.Single<java.lang.Void> rxResetConnection() { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      resetConnection(fut);
    }));
  }

  /**
   * Send a DEBUG command to dump debug information to the server's stdout.
   * @param handler the handler notified with the execution result
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava.mysqlclient.MySQLConnection debug(io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.Void>> handler) { 
    delegate.debug(handler);
    return this;
  }

  /**
   * Send a DEBUG command to dump debug information to the server's stdout.
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava.mysqlclient.MySQLConnection debug() {
    return 
debug(ar -> { });
  }

    /**
   * Send a DEBUG command to dump debug information to the server's stdout.
   * @return a reference to this, so the API can be used fluently
   */
  public rx.Single<java.lang.Void> rxDebug() { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      debug(fut);
    }));
  }

  /**
   * Send a CHANGE_USER command to change the user of the current connection, this operation will also reset connection state.
   * @param options authentication options
   * @param handler the handler
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava.mysqlclient.MySQLConnection changeUser(io.vertx.mysqlclient.MySQLAuthOptions options, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.Void>> handler) { 
    delegate.changeUser(options, handler);
    return this;
  }

  /**
   * Send a CHANGE_USER command to change the user of the current connection, this operation will also reset connection state.
   * @param options authentication options
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava.mysqlclient.MySQLConnection changeUser(io.vertx.mysqlclient.MySQLAuthOptions options) {
    return 
changeUser(options, ar -> { });
  }

    /**
   * Send a CHANGE_USER command to change the user of the current connection, this operation will also reset connection state.
   * @param options authentication options
   * @return a reference to this, so the API can be used fluently
   */
  public rx.Single<java.lang.Void> rxChangeUser(io.vertx.mysqlclient.MySQLAuthOptions options) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      changeUser(options, fut);
    }));
  }

  /**
   * Cast a  to {@link io.vertx.rxjava.mysqlclient.MySQLConnection}.
   *
   * This is mostly useful for Vert.x generated APIs like RxJava/Mutiny.
   * @param sqlConnection the connection to cast
   * @return a {@link io.vertx.rxjava.mysqlclient.MySQLConnection instance}
   */
  public static io.vertx.rxjava.mysqlclient.MySQLConnection cast(io.vertx.rxjava.sqlclient.SqlConnection sqlConnection) { 
    io.vertx.rxjava.mysqlclient.MySQLConnection ret = io.vertx.rxjava.mysqlclient.MySQLConnection.newInstance((io.vertx.mysqlclient.MySQLConnection)io.vertx.mysqlclient.MySQLConnection.cast(sqlConnection.getDelegate()));
    return ret;
  }

  public static MySQLConnection newInstance(io.vertx.mysqlclient.MySQLConnection arg) {
    return arg != null ? new MySQLConnection(arg) : null;
  }

}
