/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava.mssqlclient;

import rx.Observable;
import rx.Single;
import io.vertx.rx.java.RxHelper;
import io.vertx.rx.java.WriteStreamSubscriber;
import io.vertx.rx.java.SingleOnSubscribeAdapter;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * A connection to Microsoft SQL Server.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.mssqlclient.MSSQLConnection original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.mssqlclient.MSSQLConnection.class)
public class MSSQLConnection extends io.vertx.rxjava.sqlclient.SqlConnection {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    MSSQLConnection that = (MSSQLConnection) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<MSSQLConnection> __TYPE_ARG = new TypeArg<>(    obj -> new MSSQLConnection((io.vertx.mssqlclient.MSSQLConnection) obj),
    MSSQLConnection::getDelegate
  );

  private final io.vertx.mssqlclient.MSSQLConnection delegate;
  
  public MSSQLConnection(io.vertx.mssqlclient.MSSQLConnection delegate) {
    super(delegate);
    this.delegate = delegate;
  }

  public MSSQLConnection(Object delegate) {
    super((io.vertx.mssqlclient.MSSQLConnection)delegate);
    this.delegate = (io.vertx.mssqlclient.MSSQLConnection)delegate;
  }

  public io.vertx.mssqlclient.MSSQLConnection getDelegate() {
    return delegate;
  }

  /**
   * Create a connection to SQL Server with the given <code>connectOptions</code>.
   * @param vertx the vertx instance
   * @param connectOptions the options for the connection
   * @param handler the handler called with the connection or the failure
   */
  public static void connect(io.vertx.rxjava.core.Vertx vertx, io.vertx.mssqlclient.MSSQLConnectOptions connectOptions, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.mssqlclient.MSSQLConnection>> handler) { 
    io.vertx.mssqlclient.MSSQLConnection.connect(vertx.getDelegate(), connectOptions, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.mssqlclient.MSSQLConnection.newInstance((io.vertx.mssqlclient.MSSQLConnection)event))));
  }

  /**
   * Create a connection to SQL Server with the given <code>connectOptions</code>.
   * @param vertx the vertx instance
   * @param connectOptions the options for the connection
   */
  public static void connect(io.vertx.rxjava.core.Vertx vertx, io.vertx.mssqlclient.MSSQLConnectOptions connectOptions) {
    connect(vertx, connectOptions, ar -> { });
  }

    /**
   * Create a connection to SQL Server with the given <code>connectOptions</code>.
   * @param vertx the vertx instance
   * @param connectOptions the options for the connection
   * @return 
   */
  public static rx.Single<io.vertx.rxjava.mssqlclient.MSSQLConnection> rxConnect(io.vertx.rxjava.core.Vertx vertx, io.vertx.mssqlclient.MSSQLConnectOptions connectOptions) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      connect(vertx, connectOptions, fut);
    }));
  }

  /**
   * Like {@link io.vertx.rxjava.mssqlclient.MSSQLConnection#connect} with options built from <code>connectionUri</code>.
   * @param vertx 
   * @param connectionUri 
   * @param handler 
   */
  public static void connect(io.vertx.rxjava.core.Vertx vertx, java.lang.String connectionUri, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.mssqlclient.MSSQLConnection>> handler) { 
    io.vertx.mssqlclient.MSSQLConnection.connect(vertx.getDelegate(), connectionUri, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.mssqlclient.MSSQLConnection.newInstance((io.vertx.mssqlclient.MSSQLConnection)event))));
  }

  /**
   * Like {@link io.vertx.rxjava.mssqlclient.MSSQLConnection#connect} with options built from <code>connectionUri</code>.
   * @param vertx 
   * @param connectionUri 
   */
  public static void connect(io.vertx.rxjava.core.Vertx vertx, java.lang.String connectionUri) {
    connect(vertx, connectionUri, ar -> { });
  }

    /**
   * Like {@link io.vertx.rxjava.mssqlclient.MSSQLConnection#connect} with options built from <code>connectionUri</code>.
   * @param vertx 
   * @param connectionUri 
   * @return 
   */
  public static rx.Single<io.vertx.rxjava.mssqlclient.MSSQLConnection> rxConnect(io.vertx.rxjava.core.Vertx vertx, java.lang.String connectionUri) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      connect(vertx, connectionUri, fut);
    }));
  }

  /**
   * 
   * @param s 
   * @param handler 
   * @return 
   */
  public io.vertx.rxjava.mssqlclient.MSSQLConnection prepare(java.lang.String s, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.sqlclient.PreparedStatement>> handler) { 
    delegate.prepare(s, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.sqlclient.PreparedStatement.newInstance((io.vertx.sqlclient.PreparedStatement)event))));
    return this;
  }

  /**
   * 
   * @param s 
   * @return 
   */
  public io.vertx.rxjava.mssqlclient.MSSQLConnection prepare(java.lang.String s) {
    return 
prepare(s, ar -> { });
  }

    /**
   * 
   * @param s 
   * @return 
   */
  public rx.Single<io.vertx.rxjava.sqlclient.PreparedStatement> rxPrepare(java.lang.String s) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      prepare(s, fut);
    }));
  }

  /**
   * 
   * @param handler 
   * @return 
   */
  public io.vertx.rxjava.mssqlclient.MSSQLConnection exceptionHandler(io.vertx.core.Handler<java.lang.Throwable> handler) { 
    delegate.exceptionHandler(handler);
    return this;
  }

  /**
   * 
   * @param handler 
   * @return 
   */
  public io.vertx.rxjava.mssqlclient.MSSQLConnection closeHandler(io.vertx.core.Handler<java.lang.Void> handler) { 
    delegate.closeHandler(handler);
    return this;
  }

  /**
   * Set a handler called when the connection receives an informational message from the server.
   * @param handler the handler
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava.mssqlclient.MSSQLConnection infoHandler(io.vertx.core.Handler<io.vertx.mssqlclient.MSSQLInfo> handler) { 
    delegate.infoHandler(handler);
    return this;
  }

  /**
   * Cast a  to {@link io.vertx.rxjava.mssqlclient.MSSQLConnection}.
   *
   * This is mostly useful for Vert.x generated APIs like RxJava/Mutiny.
   * @param sqlConnection the connection to cast
   * @return a {@link io.vertx.rxjava.mssqlclient.MSSQLConnection instance}
   */
  public static io.vertx.rxjava.mssqlclient.MSSQLConnection cast(io.vertx.rxjava.sqlclient.SqlConnection sqlConnection) { 
    io.vertx.rxjava.mssqlclient.MSSQLConnection ret = io.vertx.rxjava.mssqlclient.MSSQLConnection.newInstance((io.vertx.mssqlclient.MSSQLConnection)io.vertx.mssqlclient.MSSQLConnection.cast(sqlConnection.getDelegate()));
    return ret;
  }

  public static MSSQLConnection newInstance(io.vertx.mssqlclient.MSSQLConnection arg) {
    return arg != null ? new MSSQLConnection(arg) : null;
  }

}
