/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava.mqtt.messages;

import rx.Observable;
import rx.Single;
import io.vertx.rx.java.RxHelper;
import io.vertx.rx.java.WriteStreamSubscriber;
import io.vertx.rx.java.SingleOnSubscribeAdapter;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * Represents an MQTT SUBSCRIBE message
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.mqtt.messages.MqttSubscribeMessage original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.mqtt.messages.MqttSubscribeMessage.class)
public class MqttSubscribeMessage implements io.vertx.rxjava.mqtt.messages.MqttMessage {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    MqttSubscribeMessage that = (MqttSubscribeMessage) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<MqttSubscribeMessage> __TYPE_ARG = new TypeArg<>(    obj -> new MqttSubscribeMessage((io.vertx.mqtt.messages.MqttSubscribeMessage) obj),
    MqttSubscribeMessage::getDelegate
  );

  private final io.vertx.mqtt.messages.MqttSubscribeMessage delegate;
  
  public MqttSubscribeMessage(io.vertx.mqtt.messages.MqttSubscribeMessage delegate) {
    this.delegate = delegate;
  }

  public MqttSubscribeMessage(Object delegate) {
    this.delegate = (io.vertx.mqtt.messages.MqttSubscribeMessage)delegate;
  }

  public io.vertx.mqtt.messages.MqttSubscribeMessage getDelegate() {
    return delegate;
  }

  private static final TypeArg<io.vertx.rxjava.mqtt.MqttTopicSubscription> TYPE_ARG_0 = new TypeArg<io.vertx.rxjava.mqtt.MqttTopicSubscription>(o1 -> io.vertx.rxjava.mqtt.MqttTopicSubscription.newInstance((io.vertx.mqtt.MqttTopicSubscription)o1), o1 -> o1.getDelegate());

  /**
   * @return Message identifier
   */
  public int messageId() { 
    if (cached_0 != null) {
      return cached_0;
    }
    int ret = delegate.messageId();
    cached_0 = ret;
    return ret;
  }

  /**
   * @return List with topics and related quolity of service levels
   */
  public java.util.List<io.vertx.rxjava.mqtt.MqttTopicSubscription> topicSubscriptions() { 
    if (cached_1 != null) {
      return cached_1;
    }
    java.util.List<io.vertx.rxjava.mqtt.MqttTopicSubscription> ret = delegate.topicSubscriptions().stream().map(elt -> io.vertx.rxjava.mqtt.MqttTopicSubscription.newInstance((io.vertx.mqtt.MqttTopicSubscription)elt)).collect(Collectors.toList());
    cached_1 = ret;
    return ret;
  }

  /**
   * Create a concrete instance of a Vert.x subscribe message
   * @param messageId message identifier
   * @param topicSubscriptions list with topics and related quality of service levels (from Netty)
   * @param properties MQTT message properties
   * @return Vert.x subscribe message
   */
  public static io.vertx.rxjava.mqtt.messages.MqttSubscribeMessage create(int messageId, java.util.List<io.netty.handler.codec.mqtt.MqttTopicSubscription> topicSubscriptions, io.netty.handler.codec.mqtt.MqttProperties properties) { 
    io.vertx.rxjava.mqtt.messages.MqttSubscribeMessage ret = io.vertx.rxjava.mqtt.messages.MqttSubscribeMessage.newInstance((io.vertx.mqtt.messages.MqttSubscribeMessage)io.vertx.mqtt.messages.MqttSubscribeMessage.create(messageId, topicSubscriptions, properties));
    return ret;
  }

  /**
   * @return MQTT properties
   */
  public io.netty.handler.codec.mqtt.MqttProperties properties() { 
    if (cached_2 != null) {
      return cached_2;
    }
    io.netty.handler.codec.mqtt.MqttProperties ret = delegate.properties();
    cached_2 = ret;
    return ret;
  }

  private java.lang.Integer cached_0;
  private java.util.List<io.vertx.rxjava.mqtt.MqttTopicSubscription> cached_1;
  private io.netty.handler.codec.mqtt.MqttProperties cached_2;
  public static MqttSubscribeMessage newInstance(io.vertx.mqtt.messages.MqttSubscribeMessage arg) {
    return arg != null ? new MqttSubscribeMessage(arg) : null;
  }

}
