/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava.mqtt.messages;

import rx.Observable;
import rx.Single;
import io.vertx.rx.java.RxHelper;
import io.vertx.rx.java.WriteStreamSubscriber;
import io.vertx.rx.java.SingleOnSubscribeAdapter;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * Represents an MQTT PUBREL message
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.mqtt.messages.MqttPubRelMessage original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.mqtt.messages.MqttPubRelMessage.class)
public class MqttPubRelMessage {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    MqttPubRelMessage that = (MqttPubRelMessage) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<MqttPubRelMessage> __TYPE_ARG = new TypeArg<>(    obj -> new MqttPubRelMessage((io.vertx.mqtt.messages.MqttPubRelMessage) obj),
    MqttPubRelMessage::getDelegate
  );

  private final io.vertx.mqtt.messages.MqttPubRelMessage delegate;
  
  public MqttPubRelMessage(io.vertx.mqtt.messages.MqttPubRelMessage delegate) {
    this.delegate = delegate;
  }

  public MqttPubRelMessage(Object delegate) {
    this.delegate = (io.vertx.mqtt.messages.MqttPubRelMessage)delegate;
  }

  public io.vertx.mqtt.messages.MqttPubRelMessage getDelegate() {
    return delegate;
  }

  public int messageId() { 
    if (cached_0 != null) {
      return cached_0;
    }
    int ret = delegate.messageId();
    cached_0 = ret;
    return ret;
  }

  /**
   * @return reason code from the pubrel request
   */
  public io.vertx.mqtt.messages.codes.MqttPubRelReasonCode code() { 
    if (cached_1 != null) {
      return cached_1;
    }
    io.vertx.mqtt.messages.codes.MqttPubRelReasonCode ret = delegate.code();
    cached_1 = ret;
    return ret;
  }

  /**
   * Create a concrete instance of a Vert.x pubrel message
   * @param messageId message Id
   * @param code return code from the pubrel
   * @param properties MQTT properties of the pubrel message
   * @return 
   */
  public static io.vertx.rxjava.mqtt.messages.MqttPubRelMessage create(int messageId, io.vertx.mqtt.messages.codes.MqttPubRelReasonCode code, io.netty.handler.codec.mqtt.MqttProperties properties) { 
    io.vertx.rxjava.mqtt.messages.MqttPubRelMessage ret = io.vertx.rxjava.mqtt.messages.MqttPubRelMessage.newInstance((io.vertx.mqtt.messages.MqttPubRelMessage)io.vertx.mqtt.messages.MqttPubRelMessage.create(messageId, code, properties));
    return ret;
  }

  /**
   * @return MQTT properties
   */
  public io.netty.handler.codec.mqtt.MqttProperties properties() { 
    if (cached_2 != null) {
      return cached_2;
    }
    io.netty.handler.codec.mqtt.MqttProperties ret = delegate.properties();
    cached_2 = ret;
    return ret;
  }

  private java.lang.Integer cached_0;
  private io.vertx.mqtt.messages.codes.MqttPubRelReasonCode cached_1;
  private io.netty.handler.codec.mqtt.MqttProperties cached_2;
  public static MqttPubRelMessage newInstance(io.vertx.mqtt.messages.MqttPubRelMessage arg) {
    return arg != null ? new MqttPubRelMessage(arg) : null;
  }

}
