/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava.mqtt;

import rx.Observable;
import rx.Single;
import io.vertx.rx.java.RxHelper;
import io.vertx.rx.java.WriteStreamSubscriber;
import io.vertx.rx.java.SingleOnSubscribeAdapter;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * Represents a subscription to a topic
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.mqtt.MqttTopicSubscription original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.mqtt.MqttTopicSubscription.class)
public class MqttTopicSubscription {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    MqttTopicSubscription that = (MqttTopicSubscription) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<MqttTopicSubscription> __TYPE_ARG = new TypeArg<>(    obj -> new MqttTopicSubscription((io.vertx.mqtt.MqttTopicSubscription) obj),
    MqttTopicSubscription::getDelegate
  );

  private final io.vertx.mqtt.MqttTopicSubscription delegate;
  
  public MqttTopicSubscription(io.vertx.mqtt.MqttTopicSubscription delegate) {
    this.delegate = delegate;
  }

  public MqttTopicSubscription(Object delegate) {
    this.delegate = (io.vertx.mqtt.MqttTopicSubscription)delegate;
  }

  public io.vertx.mqtt.MqttTopicSubscription getDelegate() {
    return delegate;
  }

  /**
   * @return Subscription topic name
   */
  public java.lang.String topicName() { 
    if (cached_0 != null) {
      return cached_0;
    }
    java.lang.String ret = delegate.topicName();
    cached_0 = ret;
    return ret;
  }

  /**
   * @return Quality of Service level for the subscription
   */
  public io.netty.handler.codec.mqtt.MqttQoS qualityOfService() { 
    if (cached_1 != null) {
      return cached_1;
    }
    io.netty.handler.codec.mqtt.MqttQoS ret = delegate.qualityOfService();
    cached_1 = ret;
    return ret;
  }

  /**
   * Subscription option
   * @return Subscription options
   */
  public io.netty.handler.codec.mqtt.MqttSubscriptionOption subscriptionOption() { 
    if (cached_2 != null) {
      return cached_2;
    }
    io.netty.handler.codec.mqtt.MqttSubscriptionOption ret = delegate.subscriptionOption();
    cached_2 = ret;
    return ret;
  }

  private java.lang.String cached_0;
  private io.netty.handler.codec.mqtt.MqttQoS cached_1;
  private io.netty.handler.codec.mqtt.MqttSubscriptionOption cached_2;
  public static MqttTopicSubscription newInstance(io.vertx.mqtt.MqttTopicSubscription arg) {
    return arg != null ? new MqttTopicSubscription(arg) : null;
  }

}
