/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava.kafka.client.producer;

import rx.Observable;
import rx.Single;
import io.vertx.rx.java.RxHelper;
import io.vertx.rx.java.WriteStreamSubscriber;
import io.vertx.rx.java.SingleOnSubscribeAdapter;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * Vert.x Kafka producer.
 * <p>
 * The {@link io.vertx.rxjava.core.streams.WriteStream#write} provides global control over writing a record.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.kafka.client.producer.KafkaProducer original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.kafka.client.producer.KafkaProducer.class)
public class KafkaProducer<K,V> implements io.vertx.rxjava.core.streams.WriteStream<io.vertx.rxjava.kafka.client.producer.KafkaProducerRecord<K,V>> {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    KafkaProducer that = (KafkaProducer) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<KafkaProducer> __TYPE_ARG = new TypeArg<>(    obj -> new KafkaProducer((io.vertx.kafka.client.producer.KafkaProducer) obj),
    KafkaProducer::getDelegate
  );

  private final io.vertx.kafka.client.producer.KafkaProducer<K,V> delegate;
  public final TypeArg<K> __typeArg_0;
  public final TypeArg<V> __typeArg_1;
  
  public KafkaProducer(io.vertx.kafka.client.producer.KafkaProducer delegate) {
    this.delegate = delegate;
    this.__typeArg_0 = TypeArg.unknown();    this.__typeArg_1 = TypeArg.unknown();  }

  public KafkaProducer(Object delegate, TypeArg<K> typeArg_0, TypeArg<V> typeArg_1) {
    this.delegate = (io.vertx.kafka.client.producer.KafkaProducer)delegate;
    this.__typeArg_0 = typeArg_0;
    this.__typeArg_1 = typeArg_1;
  }

  public io.vertx.kafka.client.producer.KafkaProducer getDelegate() {
    return delegate;
  }

  private WriteStreamSubscriber<io.vertx.rxjava.kafka.client.producer.KafkaProducerRecord<K,V>> subscriber;

  public synchronized WriteStreamSubscriber<io.vertx.rxjava.kafka.client.producer.KafkaProducerRecord<K,V>> toSubscriber() {
    if (subscriber == null) {
      Function<io.vertx.rxjava.kafka.client.producer.KafkaProducerRecord, io.vertx.kafka.client.producer.KafkaProducerRecord<K,V>> conv = io.vertx.rxjava.kafka.client.producer.KafkaProducerRecord<K,V>::getDelegate;
      subscriber = RxHelper.toSubscriber(getDelegate(), conv);
    }
    return subscriber;
  }


  /**
   * Same as  but with an <code>handler</code> called when the operation completes
   * @param data 
   * @param handler 
   */
  public void write(io.vertx.rxjava.kafka.client.producer.KafkaProducerRecord<K,V> data, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.Void>> handler) { 
    delegate.write(data.getDelegate(), handler);
  }

  /**
   * Same as  but with an <code>handler</code> called when the operation completes
   * @param data 
   */
  public void write(io.vertx.rxjava.kafka.client.producer.KafkaProducerRecord<K,V> data) {
    write(data, ar -> { });
  }

    /**
   * Same as  but with an <code>handler</code> called when the operation completes
   * @param data 
   * @return 
   */
  public rx.Single<java.lang.Void> rxWrite(io.vertx.rxjava.kafka.client.producer.KafkaProducerRecord<K,V> data) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      write(data, fut);
    }));
  }

  /**
   * Same as {@link io.vertx.rxjava.core.streams.WriteStream#end} but with an <code>handler</code> called when the operation completes
   * @param handler 
   */
  public void end(io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.Void>> handler) { 
    delegate.end(handler);
  }

  /**
   * Same as {@link io.vertx.rxjava.core.streams.WriteStream#end} but with an <code>handler</code> called when the operation completes
   */
  public void end() {
    end(ar -> { });
  }

    /**
   * Same as {@link io.vertx.rxjava.core.streams.WriteStream#end} but with an <code>handler</code> called when the operation completes
   * @return 
   */
  public rx.Single<java.lang.Void> rxEnd() { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      end(fut);
    }));
  }

  /**
   * Same as  but with an <code>handler</code> called when the operation completes
   * @param data 
   * @param handler 
   */
  public void end(io.vertx.rxjava.kafka.client.producer.KafkaProducerRecord<K,V> data, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.Void>> handler) { 
    delegate.end(data.getDelegate(), handler);
  }

  /**
   * Same as  but with an <code>handler</code> called when the operation completes
   * @param data 
   */
  public void end(io.vertx.rxjava.kafka.client.producer.KafkaProducerRecord<K,V> data) {
    end(data, ar -> { });
  }

    /**
   * Same as  but with an <code>handler</code> called when the operation completes
   * @param data 
   * @return 
   */
  public rx.Single<java.lang.Void> rxEnd(io.vertx.rxjava.kafka.client.producer.KafkaProducerRecord<K,V> data) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      end(data, fut);
    }));
  }

  /**
   * This will return <code>true</code> if there are more bytes in the write queue than the value set using {@link io.vertx.rxjava.kafka.client.producer.KafkaProducer#setWriteQueueMaxSize}
   * @return <code>true</code> if write queue is full
   */
  public boolean writeQueueFull() { 
    boolean ret = delegate.writeQueueFull();
    return ret;
  }

  /**
   * Get or create a KafkaProducer instance which shares its stream with any other KafkaProducer created with the same <code>name</code>
   * <p>
   * When <code>close</code> has been called for each shared producer the resources will be released.
   * Calling <code>end</code> closes all shared producers.
   * @param vertx Vert.x instance to use
   * @param name the producer name to identify it
   * @param config Kafka producer configuration
   * @return an instance of the KafkaProducer
   */
  public static <K, V> io.vertx.rxjava.kafka.client.producer.KafkaProducer<K,V> createShared(io.vertx.rxjava.core.Vertx vertx, java.lang.String name, java.util.Map<java.lang.String,java.lang.String> config) { 
    io.vertx.rxjava.kafka.client.producer.KafkaProducer<K,V> ret = io.vertx.rxjava.kafka.client.producer.KafkaProducer.newInstance((io.vertx.kafka.client.producer.KafkaProducer)io.vertx.kafka.client.producer.KafkaProducer.createShared(vertx.getDelegate(), name, config), TypeArg.unknown(), TypeArg.unknown());
    return ret;
  }

  /**
   * Get or create a KafkaProducer instance which shares its stream with any other KafkaProducer created with the same <code>name</code>
   * <p>
   * When <code>close</code> has been called for each shared producer the resources will be released.
   * Calling <code>end</code> closes all shared producers.
   * @param vertx Vert.x instance to use
   * @param name the producer name to identify it
   * @param options Kafka producer options
   * @return an instance of the KafkaProducer
   */
  public static <K, V> io.vertx.rxjava.kafka.client.producer.KafkaProducer<K,V> createShared(io.vertx.rxjava.core.Vertx vertx, java.lang.String name, io.vertx.kafka.client.common.KafkaClientOptions options) { 
    io.vertx.rxjava.kafka.client.producer.KafkaProducer<K,V> ret = io.vertx.rxjava.kafka.client.producer.KafkaProducer.newInstance((io.vertx.kafka.client.producer.KafkaProducer)io.vertx.kafka.client.producer.KafkaProducer.createShared(vertx.getDelegate(), name, options), TypeArg.unknown(), TypeArg.unknown());
    return ret;
  }

  /**
   * Get or create a KafkaProducer instance which shares its stream with any other KafkaProducer created with the same <code>name</code>
   * <p>
   * When <code>close</code> has been called for each shared producer the resources will be released.
   * Calling <code>end</code> closes all shared producers.
   * @param vertx Vert.x instance to use
   * @param name the producer name to identify it
   * @param config Kafka producer configuration
   * @param keyType class type for the key serialization
   * @param valueType class type for the value serialization
   * @return an instance of the KafkaProducer
   */
  public static <K, V> io.vertx.rxjava.kafka.client.producer.KafkaProducer<K,V> createShared(io.vertx.rxjava.core.Vertx vertx, java.lang.String name, java.util.Map<java.lang.String,java.lang.String> config, java.lang.Class<K> keyType, java.lang.Class<V> valueType) { 
    io.vertx.rxjava.kafka.client.producer.KafkaProducer<K,V> ret = io.vertx.rxjava.kafka.client.producer.KafkaProducer.newInstance((io.vertx.kafka.client.producer.KafkaProducer)io.vertx.kafka.client.producer.KafkaProducer.createShared(vertx.getDelegate(), name, config, io.vertx.lang.rxjava.Helper.unwrap(keyType), io.vertx.lang.rxjava.Helper.unwrap(valueType)), TypeArg.of(keyType), TypeArg.of(valueType));
    return ret;
  }

  /**
   * Get or create a KafkaProducer instance which shares its stream with any other KafkaProducer created with the same <code>name</code>
   * <p>
   * When <code>close</code> has been called for each shared producer the resources will be released.
   * Calling <code>end</code> closes all shared producers.
   * @param vertx Vert.x instance to use
   * @param name the producer name to identify it
   * @param options Kafka producer options
   * @param keyType class type for the key serialization
   * @param valueType class type for the value serialization
   * @return an instance of the KafkaProducer
   */
  public static <K, V> io.vertx.rxjava.kafka.client.producer.KafkaProducer<K,V> createShared(io.vertx.rxjava.core.Vertx vertx, java.lang.String name, io.vertx.kafka.client.common.KafkaClientOptions options, java.lang.Class<K> keyType, java.lang.Class<V> valueType) { 
    io.vertx.rxjava.kafka.client.producer.KafkaProducer<K,V> ret = io.vertx.rxjava.kafka.client.producer.KafkaProducer.newInstance((io.vertx.kafka.client.producer.KafkaProducer)io.vertx.kafka.client.producer.KafkaProducer.createShared(vertx.getDelegate(), name, options, io.vertx.lang.rxjava.Helper.unwrap(keyType), io.vertx.lang.rxjava.Helper.unwrap(valueType)), TypeArg.of(keyType), TypeArg.of(valueType));
    return ret;
  }

  /**
   * Create a new KafkaProducer instance
   * @param vertx Vert.x instance to use
   * @param config Kafka producer configuration
   * @return an instance of the KafkaProducer
   */
  public static <K, V> io.vertx.rxjava.kafka.client.producer.KafkaProducer<K,V> create(io.vertx.rxjava.core.Vertx vertx, java.util.Map<java.lang.String,java.lang.String> config) { 
    io.vertx.rxjava.kafka.client.producer.KafkaProducer<K,V> ret = io.vertx.rxjava.kafka.client.producer.KafkaProducer.newInstance((io.vertx.kafka.client.producer.KafkaProducer)io.vertx.kafka.client.producer.KafkaProducer.create(vertx.getDelegate(), config), TypeArg.unknown(), TypeArg.unknown());
    return ret;
  }

  /**
   * Create a new KafkaProducer instance
   * @param vertx Vert.x instance to use
   * @param config Kafka producer configuration
   * @param keyType class type for the key serialization
   * @param valueType class type for the value serialization
   * @return an instance of the KafkaProducer
   */
  public static <K, V> io.vertx.rxjava.kafka.client.producer.KafkaProducer<K,V> create(io.vertx.rxjava.core.Vertx vertx, java.util.Map<java.lang.String,java.lang.String> config, java.lang.Class<K> keyType, java.lang.Class<V> valueType) { 
    io.vertx.rxjava.kafka.client.producer.KafkaProducer<K,V> ret = io.vertx.rxjava.kafka.client.producer.KafkaProducer.newInstance((io.vertx.kafka.client.producer.KafkaProducer)io.vertx.kafka.client.producer.KafkaProducer.create(vertx.getDelegate(), config, io.vertx.lang.rxjava.Helper.unwrap(keyType), io.vertx.lang.rxjava.Helper.unwrap(valueType)), TypeArg.of(keyType), TypeArg.of(valueType));
    return ret;
  }

  /**
   * Initializes the underlying kafka transactional producer. See {@link io.vertx.rxjava.kafka.client.producer.KafkaProducer#initTransactions} ()}
   * @param handler handler called on operation completed
   * @return current KafkaWriteStream instance
   */
  public io.vertx.rxjava.kafka.client.producer.KafkaProducer<K,V> initTransactions(io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.Void>> handler) { 
    delegate.initTransactions(handler);
    return this;
  }

  /**
   * Initializes the underlying kafka transactional producer. See {@link io.vertx.rxjava.kafka.client.producer.KafkaProducer#initTransactions} ()}
   * @return current KafkaWriteStream instance
   */
  public io.vertx.rxjava.kafka.client.producer.KafkaProducer<K,V> initTransactions() {
    return 
initTransactions(ar -> { });
  }

    /**
   * Initializes the underlying kafka transactional producer. See {@link io.vertx.rxjava.kafka.client.producer.KafkaProducer#initTransactions} ()}
   * @return current KafkaWriteStream instance
   */
  public rx.Single<java.lang.Void> rxInitTransactions() { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      initTransactions(fut);
    }));
  }

  /**
   * Starts a new kafka transaction. See {@link io.vertx.rxjava.kafka.client.producer.KafkaProducer#beginTransaction}
   * @param handler handler called on operation completed
   * @return current KafkaWriteStream instance
   */
  public io.vertx.rxjava.kafka.client.producer.KafkaProducer<K,V> beginTransaction(io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.Void>> handler) { 
    delegate.beginTransaction(handler);
    return this;
  }

  /**
   * Starts a new kafka transaction. See {@link io.vertx.rxjava.kafka.client.producer.KafkaProducer#beginTransaction}
   * @return current KafkaWriteStream instance
   */
  public io.vertx.rxjava.kafka.client.producer.KafkaProducer<K,V> beginTransaction() {
    return 
beginTransaction(ar -> { });
  }

    /**
   * Starts a new kafka transaction. See {@link io.vertx.rxjava.kafka.client.producer.KafkaProducer#beginTransaction}
   * @return current KafkaWriteStream instance
   */
  public rx.Single<java.lang.Void> rxBeginTransaction() { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      beginTransaction(fut);
    }));
  }

  /**
   * Commits the ongoing transaction. See {@link io.vertx.rxjava.kafka.client.producer.KafkaProducer#commitTransaction}
   * @param handler handler called on operation completed
   * @return current KafkaWriteStream instance
   */
  public io.vertx.rxjava.kafka.client.producer.KafkaProducer<K,V> commitTransaction(io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.Void>> handler) { 
    delegate.commitTransaction(handler);
    return this;
  }

  /**
   * Commits the ongoing transaction. See {@link io.vertx.rxjava.kafka.client.producer.KafkaProducer#commitTransaction}
   * @return current KafkaWriteStream instance
   */
  public io.vertx.rxjava.kafka.client.producer.KafkaProducer<K,V> commitTransaction() {
    return 
commitTransaction(ar -> { });
  }

    /**
   * Commits the ongoing transaction. See {@link io.vertx.rxjava.kafka.client.producer.KafkaProducer#commitTransaction}
   * @return current KafkaWriteStream instance
   */
  public rx.Single<java.lang.Void> rxCommitTransaction() { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      commitTransaction(fut);
    }));
  }

  /**
   * Aborts the ongoing transaction. See {@link org.apache.kafka.clients.producer.KafkaProducer}
   * @param handler handler called on operation completed
   * @return current KafkaWriteStream instance
   */
  public io.vertx.rxjava.kafka.client.producer.KafkaProducer<K,V> abortTransaction(io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.Void>> handler) { 
    delegate.abortTransaction(handler);
    return this;
  }

  /**
   * Aborts the ongoing transaction. See {@link org.apache.kafka.clients.producer.KafkaProducer}
   * @return current KafkaWriteStream instance
   */
  public io.vertx.rxjava.kafka.client.producer.KafkaProducer<K,V> abortTransaction() {
    return 
abortTransaction(ar -> { });
  }

    /**
   * Aborts the ongoing transaction. See {@link org.apache.kafka.clients.producer.KafkaProducer}
   * @return current KafkaWriteStream instance
   */
  public rx.Single<java.lang.Void> rxAbortTransaction() { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      abortTransaction(fut);
    }));
  }

  public io.vertx.rxjava.kafka.client.producer.KafkaProducer<K,V> exceptionHandler(io.vertx.core.Handler<java.lang.Throwable> handler) { 
    delegate.exceptionHandler(handler);
    return this;
  }

  public io.vertx.rxjava.kafka.client.producer.KafkaProducer<K,V> setWriteQueueMaxSize(int i) { 
    delegate.setWriteQueueMaxSize(i);
    return this;
  }

  public io.vertx.rxjava.kafka.client.producer.KafkaProducer<K,V> drainHandler(io.vertx.core.Handler<java.lang.Void> handler) { 
    delegate.drainHandler(handler);
    return this;
  }

  /**
   * Asynchronously write a record to a topic
   * @param record record to write
   * @param handler handler called on operation completed
   * @return current KafkaWriteStream instance
   */
  public io.vertx.rxjava.kafka.client.producer.KafkaProducer<K,V> send(io.vertx.rxjava.kafka.client.producer.KafkaProducerRecord<K,V> record, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.kafka.client.producer.RecordMetadata>> handler) { 
    delegate.send(record.getDelegate(), handler);
    return this;
  }

  /**
   * Asynchronously write a record to a topic
   * @param record record to write
   * @return current KafkaWriteStream instance
   */
  public io.vertx.rxjava.kafka.client.producer.KafkaProducer<K,V> send(io.vertx.rxjava.kafka.client.producer.KafkaProducerRecord<K,V> record) {
    return 
send(record, ar -> { });
  }

    /**
   * Asynchronously write a record to a topic
   * @param record record to write
   * @return current KafkaWriteStream instance
   */
  public rx.Single<io.vertx.kafka.client.producer.RecordMetadata> rxSend(io.vertx.rxjava.kafka.client.producer.KafkaProducerRecord<K,V> record) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      send(record, fut);
    }));
  }

  /**
   * Get the partition metadata for the give topic.
   * @param topic topic partition for which getting partitions info
   * @param handler handler called on operation completed
   * @return current KafkaProducer instance
   */
  public io.vertx.rxjava.kafka.client.producer.KafkaProducer<K,V> partitionsFor(java.lang.String topic, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.util.List<io.vertx.kafka.client.common.PartitionInfo>>> handler) { 
    delegate.partitionsFor(topic, handler);
    return this;
  }

  /**
   * Get the partition metadata for the give topic.
   * @param topic topic partition for which getting partitions info
   * @return current KafkaProducer instance
   */
  public io.vertx.rxjava.kafka.client.producer.KafkaProducer<K,V> partitionsFor(java.lang.String topic) {
    return 
partitionsFor(topic, ar -> { });
  }

    /**
   * Get the partition metadata for the give topic.
   * @param topic topic partition for which getting partitions info
   * @return current KafkaProducer instance
   */
  public rx.Single<java.util.List<io.vertx.kafka.client.common.PartitionInfo>> rxPartitionsFor(java.lang.String topic) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      partitionsFor(topic, fut);
    }));
  }

  /**
   * Invoking this method makes all buffered records immediately available to write
   * @param completionHandler handler called on operation completed
   * @return current KafkaProducer instance
   */
  public io.vertx.rxjava.kafka.client.producer.KafkaProducer<K,V> flush(io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.Void>> completionHandler) { 
    delegate.flush(completionHandler);
    return this;
  }

  /**
   * Invoking this method makes all buffered records immediately available to write
   * @return current KafkaProducer instance
   */
  public io.vertx.rxjava.kafka.client.producer.KafkaProducer<K,V> flush() {
    return 
flush(ar -> { });
  }

    /**
   * Invoking this method makes all buffered records immediately available to write
   * @return current KafkaProducer instance
   */
  public rx.Single<java.lang.Void> rxFlush() { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      flush(fut);
    }));
  }

  /**
   * Close the producer
   * @param completionHandler handler called on operation completed
   */
  public void close(io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.Void>> completionHandler) { 
    delegate.close(completionHandler);
  }

  /**
   * Close the producer
   */
  public void close() {
    close(ar -> { });
  }

    /**
   * Close the producer
   * @return 
   */
  public rx.Single<java.lang.Void> rxClose() { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      close(fut);
    }));
  }

  /**
   * Close the producer
   * @param timeout timeout to wait for closing
   * @param completionHandler handler called on operation completed
   */
  public void close(long timeout, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.Void>> completionHandler) { 
    delegate.close(timeout, completionHandler);
  }

  /**
   * Close the producer
   * @param timeout timeout to wait for closing
   */
  public void close(long timeout) {
    close(timeout, ar -> { });
  }

    /**
   * Close the producer
   * @param timeout timeout to wait for closing
   * @return 
   */
  public rx.Single<java.lang.Void> rxClose(long timeout) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      close(timeout, fut);
    }));
  }

  public static <K,V> KafkaProducer<K,V> newInstance(io.vertx.kafka.client.producer.KafkaProducer arg) {
    return arg != null ? new KafkaProducer<K,V>(arg) : null;
  }

  public static <K,V> KafkaProducer<K,V> newInstance(io.vertx.kafka.client.producer.KafkaProducer arg, TypeArg<K> __typeArg_K, TypeArg<V> __typeArg_V) {
    return arg != null ? new KafkaProducer<K,V>(arg, __typeArg_K, __typeArg_V) : null;
  }

}
