/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava.json.schema;

import rx.Observable;
import rx.Single;
import io.vertx.rx.java.RxHelper;
import io.vertx.rx.java.WriteStreamSubscriber;
import io.vertx.rx.java.SingleOnSubscribeAdapter;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * Represents a pool where parsed schemas are addressed and cached. <br/>
 * <p>
 * It also contains a cache of  including on top or inner level some json schemas that could eventually parsed later.<br/>
 * <p>
 * You should not share this object between different threads
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.json.schema.SchemaRouter original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.json.schema.SchemaRouter.class)
public class SchemaRouter {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SchemaRouter that = (SchemaRouter) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<SchemaRouter> __TYPE_ARG = new TypeArg<>(    obj -> new SchemaRouter((io.vertx.json.schema.SchemaRouter) obj),
    SchemaRouter::getDelegate
  );

  private final io.vertx.json.schema.SchemaRouter delegate;
  
  public SchemaRouter(io.vertx.json.schema.SchemaRouter delegate) {
    this.delegate = delegate;
  }

  public SchemaRouter(Object delegate) {
    this.delegate = (io.vertx.json.schema.SchemaRouter)delegate;
  }

  public io.vertx.json.schema.SchemaRouter getDelegate() {
    return delegate;
  }

  private static final TypeArg<io.vertx.rxjava.json.schema.Schema> TYPE_ARG_0 = new TypeArg<io.vertx.rxjava.json.schema.Schema>(o1 -> io.vertx.rxjava.json.schema.Schema.newInstance((io.vertx.json.schema.Schema)o1), o1 -> o1.getDelegate());

  /**
   * Resolve cached schema based on refPointer. If a schema isn't cached, it returns null
   * @param refPointer 
   * @param schemaScope 
   * @param parser 
   * @return the resolved schema, or null if no schema was found
   */
  @Deprecated()
  public io.vertx.rxjava.json.schema.Schema resolveCachedSchema(io.vertx.rxjava.core.json.pointer.JsonPointer refPointer, io.vertx.rxjava.core.json.pointer.JsonPointer schemaScope, io.vertx.rxjava.json.schema.SchemaParser parser) { 
    io.vertx.rxjava.json.schema.Schema ret = io.vertx.rxjava.json.schema.Schema.newInstance((io.vertx.json.schema.Schema)delegate.resolveCachedSchema(refPointer.getDelegate(), schemaScope.getDelegate(), parser.getDelegate()));
    return ret;
  }

  /**
   * Like {@link io.vertx.rxjava.json.schema.SchemaRouter#resolveRef} but with a direct callback.
   * @param pointer 
   * @param scope 
   * @param schemaParser 
   * @param handler 
   */
  @Deprecated()
  public void resolveRef(io.vertx.rxjava.core.json.pointer.JsonPointer pointer, io.vertx.rxjava.core.json.pointer.JsonPointer scope, io.vertx.rxjava.json.schema.SchemaParser schemaParser, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.json.schema.Schema>> handler) { 
    delegate.resolveRef(pointer.getDelegate(), scope.getDelegate(), schemaParser.getDelegate(), new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.json.schema.Schema.newInstance((io.vertx.json.schema.Schema)event))));
  }

  /**
   * Like {@link io.vertx.rxjava.json.schema.SchemaRouter#resolveRef} but with a direct callback.
   * @param pointer 
   * @param scope 
   * @param schemaParser 
   */
  @Deprecated()
  public void resolveRef(io.vertx.rxjava.core.json.pointer.JsonPointer pointer, io.vertx.rxjava.core.json.pointer.JsonPointer scope, io.vertx.rxjava.json.schema.SchemaParser schemaParser) {
    resolveRef(pointer, scope, schemaParser, ar -> { });
  }

    /**
   * Like {@link io.vertx.rxjava.json.schema.SchemaRouter#resolveRef} but with a direct callback.
   * @param pointer 
   * @param scope 
   * @param schemaParser 
   * @return 
   */
  @Deprecated()
  public rx.Single<io.vertx.rxjava.json.schema.Schema> rxResolveRef(io.vertx.rxjava.core.json.pointer.JsonPointer pointer, io.vertx.rxjava.core.json.pointer.JsonPointer scope, io.vertx.rxjava.json.schema.SchemaParser schemaParser) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      resolveRef(pointer, scope, schemaParser, fut);
    }));
  }

  /**
   * Add a parsed schema to this router. When a schema is added to the cache, a new entry is created for the provided scope,
   * but NOT for {@link io.vertx.rxjava.json.schema.Schema#getScope}. This may be useful to register links to singleton schemas.
   * This method is automatically called by {@link io.vertx.rxjava.json.schema.SchemaParser} when a new schema is parsed
   * @param schema schema to add
   * @param scope 
   * @return a reference to this
   */
  @Deprecated()
  public io.vertx.rxjava.json.schema.SchemaRouter addSchemaWithScope(io.vertx.rxjava.json.schema.Schema schema, io.vertx.rxjava.core.json.pointer.JsonPointer scope) { 
    delegate.addSchemaWithScope(schema.getDelegate(), scope.getDelegate());
    return this;
  }

  /**
   * Add an alias to a schema already registered in this router (this alias can be solved only from schema scope).
   * @param schema schema to add
   * @param alias the schema alias
   * @return a reference to this
   */
  @Deprecated()
  public io.vertx.rxjava.json.schema.SchemaRouter addSchemaAlias(io.vertx.rxjava.json.schema.Schema schema, java.lang.String alias) { 
    delegate.addSchemaAlias(schema.getDelegate(), alias);
    return this;
  }

  /**
   * Add one or more json documents including schemas on top or inner levels. This method doesn't trigger the schema parsing<br/>
   * <p>
   * You can use this schema if you have externally loaded some json document and you want to register to the schema router.
   * You can later parse and retrieve a schema from this json structure using ,
   * providing the correct <code>refPointer</code>
   * @param uri 
   * @param object 
   * @return a reference to this
   */
  @Deprecated()
  public io.vertx.rxjava.json.schema.SchemaRouter addJson(java.lang.String uri, io.vertx.core.json.JsonObject object) { 
    delegate.addJson(uri, object);
    return this;
  }

  /**
   * @return a list of all registered schemas
   */
  @Deprecated()
  public java.util.List<io.vertx.rxjava.json.schema.Schema> registeredSchemas() { 
    java.util.List<io.vertx.rxjava.json.schema.Schema> ret = delegate.registeredSchemas().stream().map(elt -> io.vertx.rxjava.json.schema.Schema.newInstance((io.vertx.json.schema.Schema)elt)).collect(Collectors.toList());
    return ret;
  }

  /**
   * Create a new {@link io.vertx.rxjava.json.schema.SchemaRouter}
   * @param vertx 
   * @param schemaRouterOptions 
   * @return 
   */
  @Deprecated()
  public static io.vertx.rxjava.json.schema.SchemaRouter create(io.vertx.rxjava.core.Vertx vertx, io.vertx.json.schema.SchemaRouterOptions schemaRouterOptions) { 
    io.vertx.rxjava.json.schema.SchemaRouter ret = io.vertx.rxjava.json.schema.SchemaRouter.newInstance((io.vertx.json.schema.SchemaRouter)io.vertx.json.schema.SchemaRouter.create(vertx.getDelegate(), schemaRouterOptions));
    return ret;
  }

  /**
   * Create a new {@link io.vertx.rxjava.json.schema.SchemaRouter}
   * @param vertx 
   * @param client 
   * @param fs 
   * @param schemaRouterOptions 
   * @return 
   */
  @Deprecated()
  public static io.vertx.rxjava.json.schema.SchemaRouter create(io.vertx.rxjava.core.Vertx vertx, io.vertx.rxjava.core.http.HttpClient client, io.vertx.rxjava.core.file.FileSystem fs, io.vertx.json.schema.SchemaRouterOptions schemaRouterOptions) { 
    io.vertx.rxjava.json.schema.SchemaRouter ret = io.vertx.rxjava.json.schema.SchemaRouter.newInstance((io.vertx.json.schema.SchemaRouter)io.vertx.json.schema.SchemaRouter.create(vertx.getDelegate(), client.getDelegate(), fs.getDelegate(), schemaRouterOptions));
    return ret;
  }

  /**
   * Add a parsed schema to this router. When a schema is added to the cache, a new entry is created for {@link io.vertx.rxjava.json.schema.Schema#getScope} and,
   * if you provide additional aliasScopes, this method register links to this schema with these scopes.
   * This method is automatically called by {@link io.vertx.rxjava.json.schema.SchemaParser} when a new schema is parsed
   * @param schema schema to add
   * @param aliasScopes 
   * @return a reference to this
   */
  @Deprecated()
  public io.vertx.rxjava.json.schema.SchemaRouter addSchema(io.vertx.rxjava.json.schema.Schema schema, io.vertx.core.json.pointer.JsonPointer[] aliasScopes) { 
    delegate.addSchema(schema.getDelegate(), aliasScopes);
    return this;
  }

  /**
   * Add one or more json documents including schemas on top or inner levels. This method doesn't trigger the schema parsing<br/>
   * <p>
   * You can use this schema if you have externally loaded some json document and you want to register to the schema router.
   * You can later parse and retrieve a schema from this json structure using ,
   * providing the correct <code>refPointer</code>
   * @param uri 
   * @param object 
   * @return a reference to this
   */
  @Deprecated()
  public io.vertx.rxjava.json.schema.SchemaRouter addJson(java.net.URI uri, io.vertx.core.json.JsonObject object) { 
    delegate.addJson(uri, object);
    return this;
  }

  public static SchemaRouter newInstance(io.vertx.json.schema.SchemaRouter arg) {
    return arg != null ? new SchemaRouter(arg) : null;
  }

}
