/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava.json.schema;

import rx.Observable;
import rx.Single;
import io.vertx.rx.java.RxHelper;
import io.vertx.rx.java.WriteStreamSubscriber;
import io.vertx.rx.java.SingleOnSubscribeAdapter;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * JsonObject <code>$ref</code> resolver. This interface is used to resolve <code>$ref</code> in a . The result
 * is a new  with all the <code>$ref</code> replaced by actual object references.
 *
 * This new object allows navigation and queries using {@link io.vertx.rxjava.core.json.pointer.JsonPointer} but will not be
 * able to be encoded back to JSON when circular dependencies are present.
 *
 * The resolver will only resolve local references as defined in RFC3986. A local reference is a reference that starts
 * with <code>#</code> and is followed by a valid JSON Pointer.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.json.schema.Ref original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.json.schema.Ref.class)
public class Ref {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    Ref that = (Ref) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<Ref> __TYPE_ARG = new TypeArg<>(    obj -> new Ref((io.vertx.json.schema.Ref) obj),
    Ref::getDelegate
  );

  private final io.vertx.json.schema.Ref delegate;
  
  public Ref(io.vertx.json.schema.Ref delegate) {
    this.delegate = delegate;
  }

  public Ref(Object delegate) {
    this.delegate = (io.vertx.json.schema.Ref)delegate;
  }

  public io.vertx.json.schema.Ref getDelegate() {
    return delegate;
  }

  /**
   * Resolve all <code>$ref</code> in the given . The resolution algorithm is not aware of other
   * specifications. When resolving OpenAPI documents (which only allow <code>$ref</code> at specific locations) you
   * should validate if the document is valid before performing a resolution.
   *
   * It is important to note that any sibling elements of a <code>$ref</code> is ignored. This is because <code>$ref</code>
   * works by replacing itself and everything on its level with the definition it is pointing at.
   * @param json the JSON object to resolve.
   * @return a new JSON object with all the <code>$ref</code> replaced by actual object references.
   */
  public static io.vertx.core.json.JsonObject resolve(io.vertx.core.json.JsonObject json) { 
    io.vertx.core.json.JsonObject ret = io.vertx.json.schema.Ref.resolve(json);
    return ret;
  }

  public static Ref newInstance(io.vertx.json.schema.Ref arg) {
    return arg != null ? new Ref(arg) : null;
  }

}
