/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava.jdbcclient;

import rx.Observable;
import rx.Single;
import io.vertx.rx.java.RxHelper;
import io.vertx.rx.java.WriteStreamSubscriber;
import io.vertx.rx.java.SingleOnSubscribeAdapter;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * Tag if a parameter is of type OUT or INOUT.
 *
 * By default parameters are of type IN as they are provided by the user to the RDBMs engine. There are however cases
 * where these must be tagged as OUT/INOUT when dealing with stored procedures/functions or complex statements.
 *
 * This interface allows marking the type of the param as required by the JDBC API.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.jdbcclient.SqlOutParam original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.jdbcclient.SqlOutParam.class)
public class SqlOutParam {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SqlOutParam that = (SqlOutParam) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<SqlOutParam> __TYPE_ARG = new TypeArg<>(    obj -> new SqlOutParam((io.vertx.jdbcclient.SqlOutParam) obj),
    SqlOutParam::getDelegate
  );

  private final io.vertx.jdbcclient.SqlOutParam delegate;
  
  public SqlOutParam(io.vertx.jdbcclient.SqlOutParam delegate) {
    this.delegate = delegate;
  }

  public SqlOutParam(Object delegate) {
    this.delegate = (io.vertx.jdbcclient.SqlOutParam)delegate;
  }

  public io.vertx.jdbcclient.SqlOutParam getDelegate() {
    return delegate;
  }

  /**
   * Factory for a OUT parameter of type <code>out</code>.
   * @param out the kind of the type according to JDBC types.
   * @return new marker
   */
  public static io.vertx.rxjava.jdbcclient.SqlOutParam OUT(int out) { 
    io.vertx.rxjava.jdbcclient.SqlOutParam ret = io.vertx.rxjava.jdbcclient.SqlOutParam.newInstance((io.vertx.jdbcclient.SqlOutParam)io.vertx.jdbcclient.SqlOutParam.OUT(out));
    return ret;
  }

  /**
   * Factory for a OUT parameter of type <code>out</code>.
   * @param out the kind of the type according to JDBC types.
   * @return new marker
   */
  public static io.vertx.rxjava.jdbcclient.SqlOutParam OUT(java.lang.String out) { 
    io.vertx.rxjava.jdbcclient.SqlOutParam ret = io.vertx.rxjava.jdbcclient.SqlOutParam.newInstance((io.vertx.jdbcclient.SqlOutParam)io.vertx.jdbcclient.SqlOutParam.OUT(out));
    return ret;
  }

  /**
   * Factory for a OUT parameter of type <code>out</code>.
   * @param out the kind of the type according to JDBC types.
   * @return new marker
   */
  public static io.vertx.rxjava.jdbcclient.SqlOutParam OUT(java.sql.JDBCType out) { 
    io.vertx.rxjava.jdbcclient.SqlOutParam ret = io.vertx.rxjava.jdbcclient.SqlOutParam.newInstance((io.vertx.jdbcclient.SqlOutParam)io.vertx.jdbcclient.SqlOutParam.OUT(out));
    return ret;
  }

  /**
   * Factory for a INOUT parameter of type <code>out</code>.
   * @param in the value to be passed as input.
   * @param out the kind of the type according to JDBC types.
   * @return new marker
   */
  public static io.vertx.rxjava.jdbcclient.SqlOutParam INOUT(java.lang.Object in, int out) { 
    io.vertx.rxjava.jdbcclient.SqlOutParam ret = io.vertx.rxjava.jdbcclient.SqlOutParam.newInstance((io.vertx.jdbcclient.SqlOutParam)io.vertx.jdbcclient.SqlOutParam.INOUT(in, out));
    return ret;
  }

  /**
   * Factory for a INOUT parameter of type <code>out</code>.
   * @param in the value to be passed as input.
   * @param out the kind of the type according to JDBC types.
   * @return new marker
   */
  public static io.vertx.rxjava.jdbcclient.SqlOutParam INOUT(java.lang.Object in, java.lang.String out) { 
    io.vertx.rxjava.jdbcclient.SqlOutParam ret = io.vertx.rxjava.jdbcclient.SqlOutParam.newInstance((io.vertx.jdbcclient.SqlOutParam)io.vertx.jdbcclient.SqlOutParam.INOUT(in, out));
    return ret;
  }

  /**
   * Factory for a INOUT parameter of type <code>out</code>.
   * @param in the value to be passed as input.
   * @param out the kind of the type according to JDBC types.
   * @return new marker
   */
  public static io.vertx.rxjava.jdbcclient.SqlOutParam INOUT(java.lang.Object in, java.sql.JDBCType out) { 
    io.vertx.rxjava.jdbcclient.SqlOutParam ret = io.vertx.rxjava.jdbcclient.SqlOutParam.newInstance((io.vertx.jdbcclient.SqlOutParam)io.vertx.jdbcclient.SqlOutParam.INOUT(in, out));
    return ret;
  }

  /**
   * Is this marker <code>IN</code>?
   * @return true if <code>INOUT</code>
   */
  public boolean in() { 
    boolean ret = delegate.in();
    return ret;
  }

  /**
   * Get the output type
   * @return type
   */
  public int type() { 
    int ret = delegate.type();
    return ret;
  }

  /**
   * Get the input value
   * @return input
   */
  public java.lang.Object value() { 
    java.lang.Object ret = (Object) delegate.value();
    return ret;
  }

  public static SqlOutParam newInstance(io.vertx.jdbcclient.SqlOutParam arg) {
    return arg != null ? new SqlOutParam(arg) : null;
  }

}
