/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava.grpc.server;

import rx.Observable;
import rx.Single;
import io.vertx.rx.java.RxHelper;
import io.vertx.rx.java.WriteStreamSubscriber;
import io.vertx.rx.java.SingleOnSubscribeAdapter;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;


@RxGen(io.vertx.grpc.server.GrpcServerRequest.class)
public class GrpcServerRequest<Req,Resp> extends io.vertx.rxjava.grpc.common.GrpcReadStream<Req> {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    GrpcServerRequest that = (GrpcServerRequest) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<GrpcServerRequest> __TYPE_ARG = new TypeArg<>(    obj -> new GrpcServerRequest((io.vertx.grpc.server.GrpcServerRequest) obj),
    GrpcServerRequest::getDelegate
  );

  private final io.vertx.grpc.server.GrpcServerRequest<Req,Resp> delegate;
  public final TypeArg<Req> __typeArg_0;
  public final TypeArg<Resp> __typeArg_1;
  
  public GrpcServerRequest(io.vertx.grpc.server.GrpcServerRequest delegate) {
    super(delegate);
    this.delegate = delegate;
    this.__typeArg_0 = TypeArg.unknown();    this.__typeArg_1 = TypeArg.unknown();  }

  public GrpcServerRequest(Object delegate, TypeArg<Req> typeArg_0, TypeArg<Resp> typeArg_1) {
    super((io.vertx.grpc.server.GrpcServerRequest)delegate);
    this.delegate = (io.vertx.grpc.server.GrpcServerRequest)delegate;
    this.__typeArg_0 = typeArg_0;
    this.__typeArg_1 = typeArg_1;
  }

  public io.vertx.grpc.server.GrpcServerRequest getDelegate() {
    return delegate;
  }

  private Observable<Req> observable;

  public synchronized Observable<Req> toObservable() {
    if (observable == null) {
      Function<Req, Req> conv = (Function<Req, Req>) __typeArg_0.wrap;
      observable = RxHelper.toObservable(delegate, conv);
    }
    return observable;
  }


  /**
   * Pause this stream and return a  to transfer the elements of this stream to a destination .
   * <p/>
   * The stream will be resumed when the pipe will be wired to a <code>WriteStream</code>.
   * @return a pipe
   */
  public io.vertx.rxjava.core.streams.Pipe<Req> pipe() { 
    io.vertx.rxjava.core.streams.Pipe<Req> ret = io.vertx.rxjava.core.streams.Pipe.newInstance((io.vertx.core.streams.Pipe)delegate.pipe(), __typeArg_0);
    return ret;
  }

  /**
   * Pipe this <code>ReadStream</code> to the <code>WriteStream</code>.
   * <p>
   * Elements emitted by this stream will be written to the write stream until this stream ends or fails.
   * <p>
   * Once this stream has ended or failed, the write stream will be ended and the <code>handler</code> will be
   * called with the result.
   * @param dst the destination write stream
   * @param handler 
   */
  public void pipeTo(io.vertx.rxjava.core.streams.WriteStream<Req> dst, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.Void>> handler) { 
    delegate.pipeTo(dst.getDelegate(), handler);
  }

  /**
   * Pipe this <code>ReadStream</code> to the <code>WriteStream</code>.
   * <p>
   * Elements emitted by this stream will be written to the write stream until this stream ends or fails.
   * <p>
   * Once this stream has ended or failed, the write stream will be ended and the <code>handler</code> will be
   * called with the result.
   * @param dst the destination write stream
   */
  public void pipeTo(io.vertx.rxjava.core.streams.WriteStream<Req> dst) {
    pipeTo(dst, ar -> { });
  }

    /**
   * Pipe this <code>ReadStream</code> to the <code>WriteStream</code>.
   * <p>
   * Elements emitted by this stream will be written to the write stream until this stream ends or fails.
   * <p>
   * Once this stream has ended or failed, the write stream will be ended and the <code>handler</code> will be
   * called with the result.
   * @param dst the destination write stream
   * @return 
   */
  public rx.Single<java.lang.Void> rxPipeTo(io.vertx.rxjava.core.streams.WriteStream<Req> dst) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      pipeTo(dst, fut);
    }));
  }

  /**
   * @return the last element of the stream
   */
  public io.vertx.core.Future<Req> last() { 
    io.vertx.core.Future<Req> ret = delegate.last().map(val -> (Req)__typeArg_0.wrap(val));
    return ret;
  }

    /**
   * @return the last element of the stream
   */
  public rx.Single<Req> rxLast() { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      last().onComplete(fut);
    }));
  }

  /**
   * @return the service name
   */
  public io.vertx.rxjava.grpc.common.ServiceName serviceName() { 
    if (cached_0 != null) {
      return cached_0;
    }
    io.vertx.rxjava.grpc.common.ServiceName ret = io.vertx.rxjava.grpc.common.ServiceName.newInstance((io.vertx.grpc.common.ServiceName)delegate.serviceName());
    cached_0 = ret;
    return ret;
  }

  /**
   * @return the method name
   */
  public java.lang.String methodName() { 
    if (cached_1 != null) {
      return cached_1;
    }
    java.lang.String ret = delegate.methodName();
    cached_1 = ret;
    return ret;
  }

  /**
   * @return the full method name sent by the client
   */
  public java.lang.String fullMethodName() { 
    if (cached_2 != null) {
      return cached_2;
    }
    java.lang.String ret = delegate.fullMethodName();
    cached_2 = ret;
    return ret;
  }

  /**
   * @return the response
   */
  public io.vertx.rxjava.grpc.server.GrpcServerResponse<Req,Resp> response() { 
    if (cached_3 != null) {
      return cached_3;
    }
    io.vertx.rxjava.grpc.server.GrpcServerResponse<Req,Resp> ret = io.vertx.rxjava.grpc.server.GrpcServerResponse.newInstance((io.vertx.grpc.server.GrpcServerResponse)delegate.response(), __typeArg_0, __typeArg_1);
    cached_3 = ret;
    return ret;
  }

  public io.vertx.rxjava.grpc.server.GrpcServerRequest<Req,Resp> messageHandler(io.vertx.core.Handler<io.vertx.rxjava.grpc.common.GrpcMessage> handler) { 
    delegate.messageHandler(new io.vertx.lang.rx.DelegatingHandler<>(handler, event -> io.vertx.rxjava.grpc.common.GrpcMessage.newInstance((io.vertx.grpc.common.GrpcMessage)event)));
    return this;
  }

  public io.vertx.rxjava.grpc.server.GrpcServerRequest<Req,Resp> errorHandler(io.vertx.core.Handler<io.vertx.grpc.common.GrpcError> handler) { 
    delegate.errorHandler(handler);
    return this;
  }

  public io.vertx.rxjava.grpc.server.GrpcServerRequest<Req,Resp> exceptionHandler(io.vertx.core.Handler<java.lang.Throwable> handler) { 
    delegate.exceptionHandler(handler);
    return this;
  }

  public io.vertx.rxjava.grpc.server.GrpcServerRequest<Req,Resp> handler(io.vertx.core.Handler<Req> handler) { 
    delegate.handler(new io.vertx.lang.rx.DelegatingHandler<>(handler, event -> (Req)__typeArg_0.wrap(event)));
    return this;
  }

  public io.vertx.rxjava.grpc.server.GrpcServerRequest<Req,Resp> pause() { 
    delegate.pause();
    return this;
  }

  public io.vertx.rxjava.grpc.server.GrpcServerRequest<Req,Resp> resume() { 
    delegate.resume();
    return this;
  }

  public io.vertx.rxjava.grpc.server.GrpcServerRequest<Req,Resp> fetch(long amount) { 
    delegate.fetch(amount);
    return this;
  }

  public io.vertx.rxjava.grpc.server.GrpcServerRequest<Req,Resp> endHandler(io.vertx.core.Handler<java.lang.Void> endHandler) { 
    delegate.endHandler(endHandler);
    return this;
  }

  /**
   * @return the underlying HTTP connection
   */
  public io.vertx.rxjava.core.http.HttpConnection connection() { 
    io.vertx.rxjava.core.http.HttpConnection ret = io.vertx.rxjava.core.http.HttpConnection.newInstance((io.vertx.core.http.HttpConnection)delegate.connection());
    return ret;
  }

  /**
   * @param collector 
   * @return the result of applying a collector on the stream
   */
  public <R, A> io.vertx.core.Future<R> collecting(java.util.stream.Collector<Req,A,R> collector) { 
    io.vertx.core.Future<R> ret = delegate.collecting(collector).map(val -> (R) val);
    return ret;
  }

    /**
   * @param collector 
   * @return the result of applying a collector on the stream
   */
  public <R, A> rx.Single<R> rxCollecting(java.util.stream.Collector<Req,A,R> collector) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      collecting(collector).onComplete(fut);
    }));
  }

  private io.vertx.rxjava.grpc.common.ServiceName cached_0;
  private java.lang.String cached_1;
  private java.lang.String cached_2;
  private io.vertx.rxjava.grpc.server.GrpcServerResponse<Req,Resp> cached_3;
  public static <Req,Resp> GrpcServerRequest<Req,Resp> newInstance(io.vertx.grpc.server.GrpcServerRequest arg) {
    return arg != null ? new GrpcServerRequest<Req,Resp>(arg) : null;
  }

  public static <Req,Resp> GrpcServerRequest<Req,Resp> newInstance(io.vertx.grpc.server.GrpcServerRequest arg, TypeArg<Req> __typeArg_Req, TypeArg<Resp> __typeArg_Resp) {
    return arg != null ? new GrpcServerRequest<Req,Resp>(arg, __typeArg_Req, __typeArg_Resp) : null;
  }

}
