/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava.grpc.common;

import rx.Observable;
import rx.Single;
import io.vertx.rx.java.RxHelper;
import io.vertx.rx.java.WriteStreamSubscriber;
import io.vertx.rx.java.SingleOnSubscribeAdapter;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * A gRPC service name.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.grpc.common.ServiceName original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.grpc.common.ServiceName.class)
public class ServiceName {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ServiceName that = (ServiceName) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<ServiceName> __TYPE_ARG = new TypeArg<>(    obj -> new ServiceName((io.vertx.grpc.common.ServiceName) obj),
    ServiceName::getDelegate
  );

  private final io.vertx.grpc.common.ServiceName delegate;
  
  public ServiceName(io.vertx.grpc.common.ServiceName delegate) {
    this.delegate = delegate;
  }

  public ServiceName(Object delegate) {
    this.delegate = (io.vertx.grpc.common.ServiceName)delegate;
  }

  public io.vertx.grpc.common.ServiceName getDelegate() {
    return delegate;
  }

  /**
   * Create a service name from its fully qualified name, e.g <code>com.examples.MyService</code>
   * @param fqn the fully qualified service name
   * @return the service name
   */
  public static io.vertx.rxjava.grpc.common.ServiceName create(java.lang.String fqn) { 
    io.vertx.rxjava.grpc.common.ServiceName ret = io.vertx.rxjava.grpc.common.ServiceName.newInstance((io.vertx.grpc.common.ServiceName)io.vertx.grpc.common.ServiceName.create(fqn));
    return ret;
  }

  /**
   * Create a service name from its package name and name
   * @param packageName the package name
   * @param name the name
   * @return the service name
   */
  public static io.vertx.rxjava.grpc.common.ServiceName create(java.lang.String packageName, java.lang.String name) { 
    io.vertx.rxjava.grpc.common.ServiceName ret = io.vertx.rxjava.grpc.common.ServiceName.newInstance((io.vertx.grpc.common.ServiceName)io.vertx.grpc.common.ServiceName.create(packageName, name));
    return ret;
  }

  /**
   * @return the name
   */
  public java.lang.String name() { 
    if (cached_0 != null) {
      return cached_0;
    }
    java.lang.String ret = delegate.name();
    cached_0 = ret;
    return ret;
  }

  /**
   * @return the package name
   */
  public java.lang.String packageName() { 
    if (cached_1 != null) {
      return cached_1;
    }
    java.lang.String ret = delegate.packageName();
    cached_1 = ret;
    return ret;
  }

  /**
   * @return the fully qualified name
   */
  public java.lang.String fullyQualifiedName() { 
    if (cached_2 != null) {
      return cached_2;
    }
    java.lang.String ret = delegate.fullyQualifiedName();
    cached_2 = ret;
    return ret;
  }

  /**
   * Create the path of a given <code>method</code> to call.
   * @param method the method
   * @return the path, e.g <code>/com.examples.MyService/MyMethod</code>
   */
  public java.lang.String pathOf(java.lang.String method) { 
    java.lang.String ret = delegate.pathOf(method);
    return ret;
  }

  private java.lang.String cached_0;
  private java.lang.String cached_1;
  private java.lang.String cached_2;
  public static ServiceName newInstance(io.vertx.grpc.common.ServiceName arg) {
    return arg != null ? new ServiceName(arg) : null;
  }

}
