/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava.grpc.common;

import rx.Observable;
import rx.Single;
import io.vertx.rx.java.RxHelper;
import io.vertx.rx.java.WriteStreamSubscriber;
import io.vertx.rx.java.SingleOnSubscribeAdapter;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;


@RxGen(io.vertx.grpc.common.GrpcWriteStream.class)
public class GrpcWriteStream<T> implements io.vertx.rxjava.core.streams.WriteStream<T> {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    GrpcWriteStream that = (GrpcWriteStream) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<GrpcWriteStream> __TYPE_ARG = new TypeArg<>(    obj -> new GrpcWriteStream((io.vertx.grpc.common.GrpcWriteStream) obj),
    GrpcWriteStream::getDelegate
  );

  private final io.vertx.grpc.common.GrpcWriteStream<T> delegate;
  public final TypeArg<T> __typeArg_0;
  
  public GrpcWriteStream(io.vertx.grpc.common.GrpcWriteStream delegate) {
    this.delegate = delegate;
    this.__typeArg_0 = TypeArg.unknown();  }

  public GrpcWriteStream(Object delegate, TypeArg<T> typeArg_0) {
    this.delegate = (io.vertx.grpc.common.GrpcWriteStream)delegate;
    this.__typeArg_0 = typeArg_0;
  }

  public io.vertx.grpc.common.GrpcWriteStream getDelegate() {
    return delegate;
  }

  private WriteStreamSubscriber<T> subscriber;

  public synchronized WriteStreamSubscriber<T> toSubscriber() {
    if (subscriber == null) {
      Function<T, T> conv = (Function<T, T>) __typeArg_0.unwrap;
      subscriber = RxHelper.toSubscriber(getDelegate(), conv);
    }
    return subscriber;
  }


  /**
   * Same as  but with an <code>handler</code> called when the operation completes
   * @param data 
   * @param handler 
   */
  public void write(T data, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.Void>> handler) { 
    delegate.write(__typeArg_0.<T>unwrap(data), handler);
  }

  /**
   * Same as  but with an <code>handler</code> called when the operation completes
   * @param data 
   */
  public void write(T data) {
    write(data, ar -> { });
  }

    /**
   * Same as  but with an <code>handler</code> called when the operation completes
   * @param data 
   * @return 
   */
  public rx.Single<java.lang.Void> rxWrite(T data) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      write(data, fut);
    }));
  }

  /**
   * Same as {@link io.vertx.rxjava.core.streams.WriteStream#end} but with an <code>handler</code> called when the operation completes
   * @param handler 
   */
  public void end(io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.Void>> handler) { 
    delegate.end(handler);
  }

  /**
   * Same as {@link io.vertx.rxjava.core.streams.WriteStream#end} but with an <code>handler</code> called when the operation completes
   */
  public void end() {
    end(ar -> { });
  }

    /**
   * Same as {@link io.vertx.rxjava.core.streams.WriteStream#end} but with an <code>handler</code> called when the operation completes
   * @return 
   */
  public rx.Single<java.lang.Void> rxEnd() { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      end(fut);
    }));
  }

  /**
   * Same as  but with an <code>handler</code> called when the operation completes
   * @param data 
   * @param handler 
   */
  public void end(T data, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.Void>> handler) { 
    delegate.end(__typeArg_0.<T>unwrap(data), handler);
  }

  /**
   * Same as  but with an <code>handler</code> called when the operation completes
   * @param data 
   */
  public void end(T data) {
    end(data, ar -> { });
  }

    /**
   * Same as  but with an <code>handler</code> called when the operation completes
   * @param data 
   * @return 
   */
  public rx.Single<java.lang.Void> rxEnd(T data) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      end(data, fut);
    }));
  }

  /**
   * This will return <code>true</code> if there are more bytes in the write queue than the value set using {@link io.vertx.rxjava.grpc.common.GrpcWriteStream#setWriteQueueMaxSize}
   * @return <code>true</code> if write queue is full
   */
  public boolean writeQueueFull() { 
    boolean ret = delegate.writeQueueFull();
    return ret;
  }

  /**
   * @return the  to reader metadata headers
   */
  public io.vertx.rxjava.core.MultiMap headers() { 
    io.vertx.rxjava.core.MultiMap ret = io.vertx.rxjava.core.MultiMap.newInstance((io.vertx.core.MultiMap)delegate.headers());
    return ret;
  }

  /**
   * Set the stream encoding, e.g <code>identity</code> or <code>gzip</code>.
   *
   * It must be called before sending any message, otherwise {@code identity will be used.
   * @param encoding the target message encoding
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava.grpc.common.GrpcWriteStream<T> encoding(java.lang.String encoding) { 
    delegate.encoding(encoding);
    return this;
  }

  public io.vertx.rxjava.grpc.common.GrpcWriteStream<T> exceptionHandler(io.vertx.core.Handler<java.lang.Throwable> handler) { 
    delegate.exceptionHandler(handler);
    return this;
  }

  public io.vertx.rxjava.grpc.common.GrpcWriteStream<T> setWriteQueueMaxSize(int i) { 
    delegate.setWriteQueueMaxSize(i);
    return this;
  }

  public io.vertx.rxjava.grpc.common.GrpcWriteStream<T> drainHandler(io.vertx.core.Handler<java.lang.Void> handler) { 
    delegate.drainHandler(handler);
    return this;
  }

  /**
   * Write an encoded gRPC message.
   * @param message the message
   * @return a future completed with the result
   */
  public io.vertx.core.Future<java.lang.Void> writeMessage(io.vertx.rxjava.grpc.common.GrpcMessage message) { 
    io.vertx.core.Future<java.lang.Void> ret = delegate.writeMessage(message.getDelegate()).map(val -> val);
    return ret;
  }

    /**
   * Write an encoded gRPC message.
   * @param message the message
   * @return a future completed with the result
   */
  public rx.Single<java.lang.Void> rxWriteMessage(io.vertx.rxjava.grpc.common.GrpcMessage message) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      writeMessage(message).onComplete(fut);
    }));
  }

  /**
   * End the stream with an encoded gRPC message.
   * @param message the message
   * @return a future completed with the result
   */
  public io.vertx.core.Future<java.lang.Void> endMessage(io.vertx.rxjava.grpc.common.GrpcMessage message) { 
    io.vertx.core.Future<java.lang.Void> ret = delegate.endMessage(message.getDelegate()).map(val -> val);
    return ret;
  }

    /**
   * End the stream with an encoded gRPC message.
   * @param message the message
   * @return a future completed with the result
   */
  public rx.Single<java.lang.Void> rxEndMessage(io.vertx.rxjava.grpc.common.GrpcMessage message) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      endMessage(message).onComplete(fut);
    }));
  }

  /**
   * Cancel the stream.
   */
  public void cancel() { 
    delegate.cancel();
  }

  public static <T> GrpcWriteStream<T> newInstance(io.vertx.grpc.common.GrpcWriteStream arg) {
    return arg != null ? new GrpcWriteStream<T>(arg) : null;
  }

  public static <T> GrpcWriteStream<T> newInstance(io.vertx.grpc.common.GrpcWriteStream arg, TypeArg<T> __typeArg_T) {
    return arg != null ? new GrpcWriteStream<T>(arg, __typeArg_T) : null;
  }

}
