/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava.grpc.common;

import rx.Observable;
import rx.Single;
import io.vertx.rx.java.RxHelper;
import io.vertx.rx.java.WriteStreamSubscriber;
import io.vertx.rx.java.SingleOnSubscribeAdapter;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;


@RxGen(io.vertx.grpc.common.GrpcReadStream.class)
public class GrpcReadStream<T> implements io.vertx.rxjava.core.streams.ReadStream<T> {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    GrpcReadStream that = (GrpcReadStream) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<GrpcReadStream> __TYPE_ARG = new TypeArg<>(    obj -> new GrpcReadStream((io.vertx.grpc.common.GrpcReadStream) obj),
    GrpcReadStream::getDelegate
  );

  private final io.vertx.grpc.common.GrpcReadStream<T> delegate;
  public final TypeArg<T> __typeArg_0;
  
  public GrpcReadStream(io.vertx.grpc.common.GrpcReadStream delegate) {
    this.delegate = delegate;
    this.__typeArg_0 = TypeArg.unknown();  }

  public GrpcReadStream(Object delegate, TypeArg<T> typeArg_0) {
    this.delegate = (io.vertx.grpc.common.GrpcReadStream)delegate;
    this.__typeArg_0 = typeArg_0;
  }

  public io.vertx.grpc.common.GrpcReadStream getDelegate() {
    return delegate;
  }

  private Observable<T> observable;

  public synchronized Observable<T> toObservable() {
    if (observable == null) {
      Function<T, T> conv = (Function<T, T>) __typeArg_0.wrap;
      observable = RxHelper.toObservable(delegate, conv);
    }
    return observable;
  }


  /**
   * Pause this stream and return a  to transfer the elements of this stream to a destination .
   * <p/>
   * The stream will be resumed when the pipe will be wired to a <code>WriteStream</code>.
   * @return a pipe
   */
  public io.vertx.rxjava.core.streams.Pipe<T> pipe() { 
    io.vertx.rxjava.core.streams.Pipe<T> ret = io.vertx.rxjava.core.streams.Pipe.newInstance((io.vertx.core.streams.Pipe)delegate.pipe(), __typeArg_0);
    return ret;
  }

  /**
   * Pipe this <code>ReadStream</code> to the <code>WriteStream</code>.
   * <p>
   * Elements emitted by this stream will be written to the write stream until this stream ends or fails.
   * <p>
   * Once this stream has ended or failed, the write stream will be ended and the <code>handler</code> will be
   * called with the result.
   * @param dst the destination write stream
   * @param handler 
   */
  public void pipeTo(io.vertx.rxjava.core.streams.WriteStream<T> dst, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.Void>> handler) { 
    delegate.pipeTo(dst.getDelegate(), handler);
  }

  /**
   * Pipe this <code>ReadStream</code> to the <code>WriteStream</code>.
   * <p>
   * Elements emitted by this stream will be written to the write stream until this stream ends or fails.
   * <p>
   * Once this stream has ended or failed, the write stream will be ended and the <code>handler</code> will be
   * called with the result.
   * @param dst the destination write stream
   */
  public void pipeTo(io.vertx.rxjava.core.streams.WriteStream<T> dst) {
    pipeTo(dst, ar -> { });
  }

    /**
   * Pipe this <code>ReadStream</code> to the <code>WriteStream</code>.
   * <p>
   * Elements emitted by this stream will be written to the write stream until this stream ends or fails.
   * <p>
   * Once this stream has ended or failed, the write stream will be ended and the <code>handler</code> will be
   * called with the result.
   * @param dst the destination write stream
   * @return 
   */
  public rx.Single<java.lang.Void> rxPipeTo(io.vertx.rxjava.core.streams.WriteStream<T> dst) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      pipeTo(dst, fut);
    }));
  }

  /**
   * @return the  to read metadata headers
   */
  public io.vertx.rxjava.core.MultiMap headers() { 
    io.vertx.rxjava.core.MultiMap ret = io.vertx.rxjava.core.MultiMap.newInstance((io.vertx.core.MultiMap)delegate.headers());
    return ret;
  }

  /**
   * @return the stream encoding, e.g <code>identity</code> or <code>gzip</code>
   */
  public java.lang.String encoding() { 
    java.lang.String ret = delegate.encoding();
    return ret;
  }

  /**
   * Set a handler to be notified with incoming encoded messages. The <code>handler</code> is
   * responsible for fully decoding incoming messages, including compression.
   * @param handler the message handler
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava.grpc.common.GrpcReadStream<T> messageHandler(io.vertx.core.Handler<io.vertx.rxjava.grpc.common.GrpcMessage> handler) { 
    delegate.messageHandler(new io.vertx.lang.rx.DelegatingHandler<>(handler, event -> io.vertx.rxjava.grpc.common.GrpcMessage.newInstance((io.vertx.grpc.common.GrpcMessage)event)));
    return this;
  }

  /**
   * Set a handler to be notified with gRPC errors.
   * @param handler the error handler
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava.grpc.common.GrpcReadStream<T> errorHandler(io.vertx.core.Handler<io.vertx.grpc.common.GrpcError> handler) { 
    delegate.errorHandler(handler);
    return this;
  }

  public io.vertx.rxjava.grpc.common.GrpcReadStream<T> exceptionHandler(io.vertx.core.Handler<java.lang.Throwable> handler) { 
    delegate.exceptionHandler(handler);
    return this;
  }

  public io.vertx.rxjava.grpc.common.GrpcReadStream<T> handler(io.vertx.core.Handler<T> handler) { 
    delegate.handler(new io.vertx.lang.rx.DelegatingHandler<>(handler, event -> (T)__typeArg_0.wrap(event)));
    return this;
  }

  public io.vertx.rxjava.grpc.common.GrpcReadStream<T> pause() { 
    delegate.pause();
    return this;
  }

  public io.vertx.rxjava.grpc.common.GrpcReadStream<T> resume() { 
    delegate.resume();
    return this;
  }

  public io.vertx.rxjava.grpc.common.GrpcReadStream<T> fetch(long l) { 
    delegate.fetch(l);
    return this;
  }

  public io.vertx.rxjava.grpc.common.GrpcReadStream<T> endHandler(io.vertx.core.Handler<java.lang.Void> handler) { 
    delegate.endHandler(handler);
    return this;
  }

  /**
   * @return the last element of the stream
   */
  public io.vertx.core.Future<T> last() { 
    io.vertx.core.Future<T> ret = delegate.last().map(val -> (T)__typeArg_0.wrap(val));
    return ret;
  }

    /**
   * @return the last element of the stream
   */
  public rx.Single<T> rxLast() { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      last().onComplete(fut);
    }));
  }

  /**
   * @return a future signaling when the response has been fully received successfully or failed
   */
  public io.vertx.core.Future<java.lang.Void> end() { 
    io.vertx.core.Future<java.lang.Void> ret = delegate.end().map(val -> val);
    return ret;
  }

    /**
   * @return a future signaling when the response has been fully received successfully or failed
   */
  public rx.Single<java.lang.Void> rxEnd() { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      end().onComplete(fut);
    }));
  }

  /**
   * @param collector 
   * @return the result of applying a collector on the stream
   */
  public <R, A> io.vertx.core.Future<R> collecting(java.util.stream.Collector<T,A,R> collector) { 
    io.vertx.core.Future<R> ret = delegate.collecting(collector).map(val -> (R) val);
    return ret;
  }

    /**
   * @param collector 
   * @return the result of applying a collector on the stream
   */
  public <R, A> rx.Single<R> rxCollecting(java.util.stream.Collector<T,A,R> collector) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      collecting(collector).onComplete(fut);
    }));
  }

  public static <T> GrpcReadStream<T> newInstance(io.vertx.grpc.common.GrpcReadStream arg) {
    return arg != null ? new GrpcReadStream<T>(arg) : null;
  }

  public static <T> GrpcReadStream<T> newInstance(io.vertx.grpc.common.GrpcReadStream arg, TypeArg<T> __typeArg_T) {
    return arg != null ? new GrpcReadStream<T>(arg, __typeArg_T) : null;
  }

}
