/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava.grpc.common;

import rx.Observable;
import rx.Single;
import io.vertx.rx.java.RxHelper;
import io.vertx.rx.java.WriteStreamSubscriber;
import io.vertx.rx.java.SingleOnSubscribeAdapter;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;


@RxGen(io.vertx.grpc.common.GrpcMessageEncoder.class)
public class GrpcMessageEncoder<T> {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    GrpcMessageEncoder that = (GrpcMessageEncoder) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<GrpcMessageEncoder> __TYPE_ARG = new TypeArg<>(    obj -> new GrpcMessageEncoder((io.vertx.grpc.common.GrpcMessageEncoder) obj),
    GrpcMessageEncoder::getDelegate
  );

  private final io.vertx.grpc.common.GrpcMessageEncoder<T> delegate;
  public final TypeArg<T> __typeArg_0;
  
  public GrpcMessageEncoder(io.vertx.grpc.common.GrpcMessageEncoder delegate) {
    this.delegate = delegate;
    this.__typeArg_0 = TypeArg.unknown();  }

  public GrpcMessageEncoder(Object delegate, TypeArg<T> typeArg_0) {
    this.delegate = (io.vertx.grpc.common.GrpcMessageEncoder)delegate;
    this.__typeArg_0 = typeArg_0;
  }

  public io.vertx.grpc.common.GrpcMessageEncoder getDelegate() {
    return delegate;
  }


  public io.vertx.rxjava.grpc.common.GrpcMessage encode(T msg) { 
    io.vertx.rxjava.grpc.common.GrpcMessage ret = io.vertx.rxjava.grpc.common.GrpcMessage.newInstance((io.vertx.grpc.common.GrpcMessage)delegate.encode(__typeArg_0.<T>unwrap(msg)));
    return ret;
  }

  public static <T> io.vertx.rxjava.grpc.common.GrpcMessageEncoder<T> marshaller(io.grpc.MethodDescriptor.Marshaller<T> desc) { 
    io.vertx.rxjava.grpc.common.GrpcMessageEncoder<T> ret = io.vertx.rxjava.grpc.common.GrpcMessageEncoder.newInstance((io.vertx.grpc.common.GrpcMessageEncoder)io.vertx.grpc.common.GrpcMessageEncoder.marshaller(desc), TypeArg.unknown());
    return ret;
  }

  public static final io.vertx.rxjava.grpc.common.GrpcMessageEncoder<io.vertx.rxjava.core.buffer.Buffer> IDENTITY = io.vertx.rxjava.grpc.common.GrpcMessageEncoder.newInstance((io.vertx.grpc.common.GrpcMessageEncoder)io.vertx.grpc.common.GrpcMessageEncoder.IDENTITY, new TypeArg<io.vertx.rxjava.core.buffer.Buffer>(o0 -> io.vertx.rxjava.core.buffer.Buffer.newInstance((io.vertx.core.buffer.Buffer)o0), o0 -> o0.getDelegate()));
  public static final io.vertx.rxjava.grpc.common.GrpcMessageEncoder<io.vertx.rxjava.core.buffer.Buffer> GZIP = io.vertx.rxjava.grpc.common.GrpcMessageEncoder.newInstance((io.vertx.grpc.common.GrpcMessageEncoder)io.vertx.grpc.common.GrpcMessageEncoder.GZIP, new TypeArg<io.vertx.rxjava.core.buffer.Buffer>(o0 -> io.vertx.rxjava.core.buffer.Buffer.newInstance((io.vertx.core.buffer.Buffer)o0), o0 -> o0.getDelegate()));
  public static <T> GrpcMessageEncoder<T> newInstance(io.vertx.grpc.common.GrpcMessageEncoder arg) {
    return arg != null ? new GrpcMessageEncoder<T>(arg) : null;
  }

  public static <T> GrpcMessageEncoder<T> newInstance(io.vertx.grpc.common.GrpcMessageEncoder arg, TypeArg<T> __typeArg_T) {
    return arg != null ? new GrpcMessageEncoder<T>(arg, __typeArg_T) : null;
  }

}
