/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava.ext.web.validation.builder;

import rx.Observable;
import rx.Single;
import io.vertx.rx.java.RxHelper;
import io.vertx.rx.java.WriteStreamSubscriber;
import io.vertx.rx.java.SingleOnSubscribeAdapter;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * In this interface you can find all available {@link io.vertx.rxjava.ext.web.validation.builder.BodyProcessorFactory} to use in {@link io.vertx.rxjava.ext.web.validation.builder.ValidationHandlerBuilder}. <br/>
 *
 * To create new schemas using , look at the <a href="https://vertx.io/docs/vertx-json-schema/java/">docs of vertx-json-schema</a>
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.web.validation.builder.Bodies original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.ext.web.validation.builder.Bodies.class)
public class Bodies {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    Bodies that = (Bodies) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<Bodies> __TYPE_ARG = new TypeArg<>(    obj -> new Bodies((io.vertx.ext.web.validation.builder.Bodies) obj),
    Bodies::getDelegate
  );

  private final io.vertx.ext.web.validation.builder.Bodies delegate;
  
  public Bodies(io.vertx.ext.web.validation.builder.Bodies delegate) {
    this.delegate = delegate;
  }

  public Bodies(Object delegate) {
    this.delegate = (io.vertx.ext.web.validation.builder.Bodies)delegate;
  }

  public io.vertx.ext.web.validation.builder.Bodies getDelegate() {
    return delegate;
  }

  /**
   * Create a json body processor
   * @param schemaBuilder 
   * @return 
   */
  public static io.vertx.rxjava.ext.web.validation.builder.BodyProcessorFactory json(io.vertx.json.schema.common.dsl.SchemaBuilder schemaBuilder) { 
    io.vertx.rxjava.ext.web.validation.builder.BodyProcessorFactory ret = io.vertx.rxjava.ext.web.validation.builder.BodyProcessorFactory.newInstance((io.vertx.ext.web.validation.builder.BodyProcessorFactory)io.vertx.ext.web.validation.builder.Bodies.json(schemaBuilder));
    return ret;
  }

  /**
   * Create a <code>text/plain</code> body processor
   * @param schemaBuilder 
   * @return 
   */
  public static io.vertx.rxjava.ext.web.validation.builder.BodyProcessorFactory textPlain(io.vertx.json.schema.common.dsl.StringSchemaBuilder schemaBuilder) { 
    io.vertx.rxjava.ext.web.validation.builder.BodyProcessorFactory ret = io.vertx.rxjava.ext.web.validation.builder.BodyProcessorFactory.newInstance((io.vertx.ext.web.validation.builder.BodyProcessorFactory)io.vertx.ext.web.validation.builder.Bodies.textPlain(schemaBuilder));
    return ret;
  }

  /**
   * Create a form <code>application/x-www-form-urlencoded</code> processor
   * @param schemaBuilder 
   * @return 
   */
  public static io.vertx.rxjava.ext.web.validation.builder.BodyProcessorFactory formUrlEncoded(io.vertx.json.schema.common.dsl.ObjectSchemaBuilder schemaBuilder) { 
    io.vertx.rxjava.ext.web.validation.builder.BodyProcessorFactory ret = io.vertx.rxjava.ext.web.validation.builder.BodyProcessorFactory.newInstance((io.vertx.ext.web.validation.builder.BodyProcessorFactory)io.vertx.ext.web.validation.builder.Bodies.formUrlEncoded(schemaBuilder));
    return ret;
  }

  /**
   * Create a form <code>multipart/form-data</code> processor
   * @param schemaBuilder 
   * @return 
   */
  public static io.vertx.rxjava.ext.web.validation.builder.BodyProcessorFactory multipartFormData(io.vertx.json.schema.common.dsl.ObjectSchemaBuilder schemaBuilder) { 
    io.vertx.rxjava.ext.web.validation.builder.BodyProcessorFactory ret = io.vertx.rxjava.ext.web.validation.builder.BodyProcessorFactory.newInstance((io.vertx.ext.web.validation.builder.BodyProcessorFactory)io.vertx.ext.web.validation.builder.Bodies.multipartFormData(schemaBuilder));
    return ret;
  }

  public static Bodies newInstance(io.vertx.ext.web.validation.builder.Bodies arg) {
    return arg != null ? new Bodies(arg) : null;
  }

}
