/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava.ext.web.validation;

import rx.Observable;
import rx.Single;
import io.vertx.rx.java.RxHelper;
import io.vertx.rx.java.WriteStreamSubscriber;
import io.vertx.rx.java.SingleOnSubscribeAdapter;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * Request parameter holder
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.web.validation.RequestParameter original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.ext.web.validation.RequestParameter.class)
public class RequestParameter {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    RequestParameter that = (RequestParameter) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<RequestParameter> __TYPE_ARG = new TypeArg<>(    obj -> new RequestParameter((io.vertx.ext.web.validation.RequestParameter) obj),
    RequestParameter::getDelegate
  );

  private final io.vertx.ext.web.validation.RequestParameter delegate;
  
  public RequestParameter(io.vertx.ext.web.validation.RequestParameter delegate) {
    this.delegate = delegate;
  }

  public RequestParameter(Object delegate) {
    this.delegate = (io.vertx.ext.web.validation.RequestParameter)delegate;
  }

  public io.vertx.ext.web.validation.RequestParameter getDelegate() {
    return delegate;
  }

  /**
   * @return null if value is not a {@link java.lang.String}, otherwise it returns value
   */
  public java.lang.String getString() { 
    java.lang.String ret = delegate.getString();
    return ret;
  }

  /**
   * @return true if value of this instance is a {@link java.lang.String} instance
   */
  public boolean isString() { 
    boolean ret = delegate.isString();
    return ret;
  }

  /**
   * @return null if value is not a {@link java.lang.Number}, otherwise it returns value as {@link java.lang.Integer}
   */
  public java.lang.Integer getInteger() { 
    java.lang.Integer ret = delegate.getInteger();
    return ret;
  }

  /**
   * @return null if value is not a {@link java.lang.Number}, otherwise it returns value as {@link java.lang.Long}
   */
  public java.lang.Long getLong() { 
    java.lang.Long ret = delegate.getLong();
    return ret;
  }

  /**
   * @return null if value is not a {@link java.lang.Number}, otherwise it returns value as {@link java.lang.Float}
   */
  public java.lang.Float getFloat() { 
    java.lang.Float ret = delegate.getFloat();
    return ret;
  }

  /**
   * @return null if value is not a {@link java.lang.Number}, otherwise it returns value as {@link java.lang.Double}
   */
  public java.lang.Double getDouble() { 
    java.lang.Double ret = delegate.getDouble();
    return ret;
  }

  /**
   * @return true if value of this instance is a {@link java.lang.Number} instance
   */
  public boolean isNumber() { 
    boolean ret = delegate.isNumber();
    return ret;
  }

  /**
   * @return null if value is not a {@link java.lang.Boolean}, otherwise it returns value
   */
  public java.lang.Boolean getBoolean() { 
    java.lang.Boolean ret = delegate.getBoolean();
    return ret;
  }

  /**
   * @return true if value of this instance is a {@link java.lang.Boolean} instance
   */
  public boolean isBoolean() { 
    boolean ret = delegate.isBoolean();
    return ret;
  }

  /**
   * Returns null if value is not a , otherwise it returns value
   * @return 
   */
  public io.vertx.core.json.JsonObject getJsonObject() { 
    io.vertx.core.json.JsonObject ret = delegate.getJsonObject();
    return ret;
  }

  /**
   * @return true if value of this instance is a  instance
   */
  public boolean isJsonObject() { 
    boolean ret = delegate.isJsonObject();
    return ret;
  }

  /**
   * @return null if value is not a , otherwise it returns value
   */
  public io.vertx.core.json.JsonArray getJsonArray() { 
    io.vertx.core.json.JsonArray ret = delegate.getJsonArray();
    return ret;
  }

  /**
   * @return true if value of this instance is a  instance
   */
  public boolean isJsonArray() { 
    boolean ret = delegate.isJsonArray();
    return ret;
  }

  /**
   * @return null if value is not a , otherwise it returns value
   */
  public io.vertx.rxjava.core.buffer.Buffer getBuffer() { 
    io.vertx.rxjava.core.buffer.Buffer ret = io.vertx.rxjava.core.buffer.Buffer.newInstance((io.vertx.core.buffer.Buffer)delegate.getBuffer());
    return ret;
  }

  /**
   * @return true if value of this instance is a  instance
   */
  public boolean isBuffer() { 
    boolean ret = delegate.isBuffer();
    return ret;
  }

  /**
   * @return true if value is null
   */
  public boolean isNull() { 
    boolean ret = delegate.isNull();
    return ret;
  }

  /**
   * @return True if it's an empty string, an empty json object/array, an empty buffer or it's null
   */
  public boolean isEmpty() { 
    boolean ret = delegate.isEmpty();
    return ret;
  }

  /**
   * @return the internal value. The internal value is always a valid Vert.x JSON type
   */
  public java.lang.Object get() { 
    if (cached_0 != null) {
      return cached_0;
    }
    java.lang.Object ret = (Object) delegate.get();
    cached_0 = ret;
    return ret;
  }

  public static io.vertx.rxjava.ext.web.validation.RequestParameter create(java.lang.Object value) { 
    io.vertx.rxjava.ext.web.validation.RequestParameter ret = io.vertx.rxjava.ext.web.validation.RequestParameter.newInstance((io.vertx.ext.web.validation.RequestParameter)io.vertx.ext.web.validation.RequestParameter.create(value));
    return ret;
  }

  private java.lang.Object cached_0;
  public static RequestParameter newInstance(io.vertx.ext.web.validation.RequestParameter arg) {
    return arg != null ? new RequestParameter(arg) : null;
  }

}
