/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava.ext.web.templ.thymeleaf;

import rx.Observable;
import rx.Single;
import io.vertx.rx.java.RxHelper;
import io.vertx.rx.java.WriteStreamSubscriber;
import io.vertx.rx.java.SingleOnSubscribeAdapter;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * A template engine that uses the Thymeleaf library.
 * The {@link io.vertx.rxjava.ext.web.common.template.TemplateEngine#unwrap} shall return an object of class {@link org.thymeleaf.TemplateEngine}
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.web.templ.thymeleaf.ThymeleafTemplateEngine original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.ext.web.templ.thymeleaf.ThymeleafTemplateEngine.class)
public class ThymeleafTemplateEngine extends io.vertx.rxjava.ext.web.common.template.TemplateEngine {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ThymeleafTemplateEngine that = (ThymeleafTemplateEngine) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<ThymeleafTemplateEngine> __TYPE_ARG = new TypeArg<>(    obj -> new ThymeleafTemplateEngine((io.vertx.ext.web.templ.thymeleaf.ThymeleafTemplateEngine) obj),
    ThymeleafTemplateEngine::getDelegate
  );

  private final io.vertx.ext.web.templ.thymeleaf.ThymeleafTemplateEngine delegate;
  
  public ThymeleafTemplateEngine(io.vertx.ext.web.templ.thymeleaf.ThymeleafTemplateEngine delegate) {
    super(delegate);
    this.delegate = delegate;
  }

  public ThymeleafTemplateEngine(Object delegate) {
    super((io.vertx.ext.web.templ.thymeleaf.ThymeleafTemplateEngine)delegate);
    this.delegate = (io.vertx.ext.web.templ.thymeleaf.ThymeleafTemplateEngine)delegate;
  }

  public io.vertx.ext.web.templ.thymeleaf.ThymeleafTemplateEngine getDelegate() {
    return delegate;
  }

  /**
   * Create a template engine using defaults
   * @param vertx 
   * @return the engine
   */
  public static io.vertx.rxjava.ext.web.templ.thymeleaf.ThymeleafTemplateEngine create(io.vertx.rxjava.core.Vertx vertx) { 
    io.vertx.rxjava.ext.web.templ.thymeleaf.ThymeleafTemplateEngine ret = io.vertx.rxjava.ext.web.templ.thymeleaf.ThymeleafTemplateEngine.newInstance((io.vertx.ext.web.templ.thymeleaf.ThymeleafTemplateEngine)io.vertx.ext.web.templ.thymeleaf.ThymeleafTemplateEngine.create(vertx.getDelegate()));
    return ret;
  }

  /**
   * @param mode the mode
   * @return a reference to this for fluency
   */
  @Deprecated()
  public io.vertx.rxjava.ext.web.templ.thymeleaf.ThymeleafTemplateEngine setMode(org.thymeleaf.templatemode.TemplateMode mode) { 
    delegate.setMode(mode);
    return this;
  }

  public static final org.thymeleaf.templatemode.TemplateMode DEFAULT_TEMPLATE_MODE = io.vertx.ext.web.templ.thymeleaf.ThymeleafTemplateEngine.DEFAULT_TEMPLATE_MODE;
  public static ThymeleafTemplateEngine newInstance(io.vertx.ext.web.templ.thymeleaf.ThymeleafTemplateEngine arg) {
    return arg != null ? new ThymeleafTemplateEngine(arg) : null;
  }

}
