/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava.ext.web.handler.sockjs;

import rx.Observable;
import rx.Single;
import io.vertx.rx.java.RxHelper;
import io.vertx.rx.java.WriteStreamSubscriber;
import io.vertx.rx.java.SingleOnSubscribeAdapter;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 *
 * You interact with SockJS clients through instances of SockJS socket.
 * <p>
 * The API is very similar to {@link io.vertx.rxjava.core.http.WebSocket}.
 * It implements both  and 
 * so it can be used with
 * {@link io.vertx.rxjava.core.streams.Pump} to pump data with flow control.<p>
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.web.handler.sockjs.SockJSSocket original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.ext.web.handler.sockjs.SockJSSocket.class)
public class SockJSSocket implements io.vertx.rxjava.core.streams.ReadStream<io.vertx.rxjava.core.buffer.Buffer>, io.vertx.rxjava.core.streams.WriteStream<io.vertx.rxjava.core.buffer.Buffer> {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SockJSSocket that = (SockJSSocket) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<SockJSSocket> __TYPE_ARG = new TypeArg<>(    obj -> new SockJSSocket((io.vertx.ext.web.handler.sockjs.SockJSSocket) obj),
    SockJSSocket::getDelegate
  );

  private final io.vertx.ext.web.handler.sockjs.SockJSSocket delegate;
  
  public SockJSSocket(io.vertx.ext.web.handler.sockjs.SockJSSocket delegate) {
    this.delegate = delegate;
  }

  public SockJSSocket(Object delegate) {
    this.delegate = (io.vertx.ext.web.handler.sockjs.SockJSSocket)delegate;
  }

  public io.vertx.ext.web.handler.sockjs.SockJSSocket getDelegate() {
    return delegate;
  }

  private Observable<io.vertx.rxjava.core.buffer.Buffer> observable;

  public synchronized Observable<io.vertx.rxjava.core.buffer.Buffer> toObservable() {
    if (observable == null) {
      Function<io.vertx.core.buffer.Buffer, io.vertx.rxjava.core.buffer.Buffer> conv = io.vertx.rxjava.core.buffer.Buffer::newInstance;
      observable = RxHelper.toObservable(delegate, conv);
    }
    return observable;
  }

  private WriteStreamSubscriber<io.vertx.rxjava.core.buffer.Buffer> subscriber;

  public synchronized WriteStreamSubscriber<io.vertx.rxjava.core.buffer.Buffer> toSubscriber() {
    if (subscriber == null) {
      Function<io.vertx.rxjava.core.buffer.Buffer, io.vertx.core.buffer.Buffer> conv = io.vertx.rxjava.core.buffer.Buffer::getDelegate;
      subscriber = RxHelper.toSubscriber(getDelegate(), conv);
    }
    return subscriber;
  }

  private static final TypeArg<io.vertx.rxjava.core.buffer.Buffer> TYPE_ARG_0 = new TypeArg<io.vertx.rxjava.core.buffer.Buffer>(o1 -> io.vertx.rxjava.core.buffer.Buffer.newInstance((io.vertx.core.buffer.Buffer)o1), o1 -> o1.getDelegate());

  /**
   * Pause this stream and return a  to transfer the elements of this stream to a destination .
   * <p/>
   * The stream will be resumed when the pipe will be wired to a <code>WriteStream</code>.
   * @return a pipe
   */
  public io.vertx.rxjava.core.streams.Pipe<io.vertx.rxjava.core.buffer.Buffer> pipe() { 
    io.vertx.rxjava.core.streams.Pipe<io.vertx.rxjava.core.buffer.Buffer> ret = io.vertx.rxjava.core.streams.Pipe.newInstance((io.vertx.core.streams.Pipe)delegate.pipe(), TYPE_ARG_0);
    return ret;
  }

  /**
   * Pipe this <code>ReadStream</code> to the <code>WriteStream</code>.
   * <p>
   * Elements emitted by this stream will be written to the write stream until this stream ends or fails.
   * <p>
   * Once this stream has ended or failed, the write stream will be ended and the <code>handler</code> will be
   * called with the result.
   * @param dst the destination write stream
   * @param handler 
   */
  public void pipeTo(io.vertx.rxjava.core.streams.WriteStream<io.vertx.rxjava.core.buffer.Buffer> dst, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.Void>> handler) { 
    delegate.pipeTo(dst.getDelegate(), handler);
  }

  /**
   * Pipe this <code>ReadStream</code> to the <code>WriteStream</code>.
   * <p>
   * Elements emitted by this stream will be written to the write stream until this stream ends or fails.
   * <p>
   * Once this stream has ended or failed, the write stream will be ended and the <code>handler</code> will be
   * called with the result.
   * @param dst the destination write stream
   */
  public void pipeTo(io.vertx.rxjava.core.streams.WriteStream<io.vertx.rxjava.core.buffer.Buffer> dst) {
    pipeTo(dst, ar -> { });
  }

    /**
   * Pipe this <code>ReadStream</code> to the <code>WriteStream</code>.
   * <p>
   * Elements emitted by this stream will be written to the write stream until this stream ends or fails.
   * <p>
   * Once this stream has ended or failed, the write stream will be ended and the <code>handler</code> will be
   * called with the result.
   * @param dst the destination write stream
   * @return 
   */
  public rx.Single<java.lang.Void> rxPipeTo(io.vertx.rxjava.core.streams.WriteStream<io.vertx.rxjava.core.buffer.Buffer> dst) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      pipeTo(dst, fut);
    }));
  }

  /**
   * Same as {@link io.vertx.rxjava.ext.web.handler.sockjs.SockJSSocket#end} but with an <code>handler</code> called when the operation completes
   * @param handler 
   */
  public void end(io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.Void>> handler) { 
    delegate.end(handler);
  }

  /**
   * Same as {@link io.vertx.rxjava.ext.web.handler.sockjs.SockJSSocket#end} but with an <code>handler</code> called when the operation completes
   */
  public void end() {
    end(ar -> { });
  }

    /**
   * Same as {@link io.vertx.rxjava.ext.web.handler.sockjs.SockJSSocket#end} but with an <code>handler</code> called when the operation completes
   * @return 
   */
  public rx.Single<java.lang.Void> rxEnd() { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      end(fut);
    }));
  }

  /**
   * Same as  but with an <code>handler</code> called when the operation completes
   * @param data 
   * @param handler 
   */
  public void end(io.vertx.rxjava.core.buffer.Buffer data, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.Void>> handler) { 
    delegate.end(data.getDelegate(), handler);
  }

  /**
   * Same as  but with an <code>handler</code> called when the operation completes
   * @param data 
   */
  public void end(io.vertx.rxjava.core.buffer.Buffer data) {
    end(data, ar -> { });
  }

    /**
   * Same as  but with an <code>handler</code> called when the operation completes
   * @param data 
   * @return 
   */
  public rx.Single<java.lang.Void> rxEnd(io.vertx.rxjava.core.buffer.Buffer data) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      end(data, fut);
    }));
  }

  /**
   * This will return <code>true</code> if there are more bytes in the write queue than the value set using {@link io.vertx.rxjava.ext.web.handler.sockjs.SockJSSocket#setWriteQueueMaxSize}
   * @return <code>true</code> if write queue is full
   */
  public boolean writeQueueFull() { 
    boolean ret = delegate.writeQueueFull();
    return ret;
  }

  public io.vertx.rxjava.ext.web.handler.sockjs.SockJSSocket exceptionHandler(io.vertx.core.Handler<java.lang.Throwable> handler) { 
    delegate.exceptionHandler(handler);
    return this;
  }

  public io.vertx.rxjava.ext.web.handler.sockjs.SockJSSocket handler(io.vertx.core.Handler<io.vertx.rxjava.core.buffer.Buffer> handler) { 
    delegate.handler(new io.vertx.lang.rx.DelegatingHandler<>(handler, event -> io.vertx.rxjava.core.buffer.Buffer.newInstance((io.vertx.core.buffer.Buffer)event)));
    return this;
  }

  public io.vertx.rxjava.ext.web.handler.sockjs.SockJSSocket pause() { 
    delegate.pause();
    return this;
  }

  public io.vertx.rxjava.ext.web.handler.sockjs.SockJSSocket resume() { 
    delegate.resume();
    return this;
  }

  public io.vertx.rxjava.ext.web.handler.sockjs.SockJSSocket fetch(long amount) { 
    delegate.fetch(amount);
    return this;
  }

  public io.vertx.rxjava.ext.web.handler.sockjs.SockJSSocket endHandler(io.vertx.core.Handler<java.lang.Void> endHandler) { 
    delegate.endHandler(endHandler);
    return this;
  }

  public io.vertx.rxjava.ext.web.handler.sockjs.SockJSSocket closeHandler(io.vertx.core.Handler<java.lang.Void> closeHandler) { 
    io.vertx.rxjava.ext.web.handler.sockjs.SockJSSocket ret = io.vertx.rxjava.ext.web.handler.sockjs.SockJSSocket.newInstance((io.vertx.ext.web.handler.sockjs.SockJSSocket)delegate.closeHandler(closeHandler));
    return ret;
  }

  public void write(java.lang.String data, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.Void>> handler) { 
    delegate.write(data, handler);
  }

  public void write(java.lang.String data) {
    write(data, ar -> { });
  }

    public rx.Single<java.lang.Void> rxWrite(java.lang.String data) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      write(data, fut);
    }));
  }

  public void write(io.vertx.rxjava.core.buffer.Buffer data, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.Void>> handler) { 
    delegate.write(data.getDelegate(), handler);
  }

  public void write(io.vertx.rxjava.core.buffer.Buffer data) {
    write(data, ar -> { });
  }

    public rx.Single<java.lang.Void> rxWrite(io.vertx.rxjava.core.buffer.Buffer data) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      write(data, fut);
    }));
  }

  public io.vertx.rxjava.ext.web.handler.sockjs.SockJSSocket setWriteQueueMaxSize(int maxSize) { 
    delegate.setWriteQueueMaxSize(maxSize);
    return this;
  }

  public io.vertx.rxjava.ext.web.handler.sockjs.SockJSSocket drainHandler(io.vertx.core.Handler<java.lang.Void> handler) { 
    delegate.drainHandler(handler);
    return this;
  }

  /**
   * When a <code>SockJSSocket</code> is created it can register an event handler with the event bus, the ID of that
   * handler is given by <code>writeHandlerID</code>.
   * <p>
   * Given this ID, a different event loop can send a buffer to that event handler using the event bus and
   * that buffer will be received by this instance in its own event loop and written to the underlying socket. This
   * allows you to write data to other sockets which are owned by different event loops.
   * @return the <code>writeHandlerID</code> or <code>null</code> if <code>writeHandler</code> registration is disabled in {@link io.vertx.ext.web.handler.sockjs.SockJSHandlerOptions}
   */
  public java.lang.String writeHandlerID() { 
    java.lang.String ret = delegate.writeHandlerID();
    return ret;
  }

  /**
   * Close it
   */
  public void close() { 
    delegate.close();
  }

  /**
   * Close it giving a status code and reason. Only Applicable to RawWebSocket will downgrade to plain close for
   * other transports.
   * @param statusCode 
   * @param reason 
   */
  public void close(int statusCode, java.lang.String reason) { 
    delegate.close(statusCode, reason);
  }

  /**
   * Return the remote address for this socket
   * @return 
   */
  public io.vertx.rxjava.core.net.SocketAddress remoteAddress() { 
    io.vertx.rxjava.core.net.SocketAddress ret = io.vertx.rxjava.core.net.SocketAddress.newInstance((io.vertx.core.net.SocketAddress)delegate.remoteAddress());
    return ret;
  }

  /**
   * Return the local address for this socket
   * @return 
   */
  public io.vertx.rxjava.core.net.SocketAddress localAddress() { 
    io.vertx.rxjava.core.net.SocketAddress ret = io.vertx.rxjava.core.net.SocketAddress.newInstance((io.vertx.core.net.SocketAddress)delegate.localAddress());
    return ret;
  }

  /**
   * Return the headers corresponding to the last request for this socket or the websocket handshake
   * Any cookie headers will be removed for security reasons
   * @return 
   */
  public io.vertx.rxjava.core.MultiMap headers() { 
    io.vertx.rxjava.core.MultiMap ret = io.vertx.rxjava.core.MultiMap.newInstance((io.vertx.core.MultiMap)delegate.headers());
    return ret;
  }

  /**
   * Return the URI corresponding to the last request for this socket or the websocket handshake
   * @return 
   */
  public java.lang.String uri() { 
    java.lang.String ret = delegate.uri();
    return ret;
  }

  /**
   * @return the Vert.x-Web RoutingContext corresponding to this socket
   */
  public io.vertx.rxjava.ext.web.RoutingContext routingContext() { 
    io.vertx.rxjava.ext.web.RoutingContext ret = io.vertx.rxjava.ext.web.RoutingContext.newInstance((io.vertx.ext.web.RoutingContext)delegate.routingContext());
    return ret;
  }

  /**
   * @return the Vert.x-Web session corresponding to this socket
   */
  public io.vertx.rxjava.ext.web.Session webSession() { 
    io.vertx.rxjava.ext.web.Session ret = io.vertx.rxjava.ext.web.Session.newInstance((io.vertx.ext.web.Session)delegate.webSession());
    return ret;
  }

  /**
   * @return the Vert.x-Web user corresponding to this socket
   */
  public io.vertx.rxjava.ext.auth.User webUser() { 
    io.vertx.rxjava.ext.auth.User ret = io.vertx.rxjava.ext.auth.User.newInstance((io.vertx.ext.auth.User)delegate.webUser());
    return ret;
  }

  public static SockJSSocket newInstance(io.vertx.ext.web.handler.sockjs.SockJSSocket arg) {
    return arg != null ? new SockJSSocket(arg) : null;
  }

}
