/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava.ext.web.handler.graphql.ws;

import rx.Observable;
import rx.Single;
import io.vertx.rx.java.RxHelper;
import io.vertx.rx.java.WriteStreamSubscriber;
import io.vertx.rx.java.SingleOnSubscribeAdapter;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * A <a href="https://github.com/enisdenjo/graphql-ws/blob/master/PROTOCOL.md">GraphQL over WebSocket Protocol</a> message.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.web.handler.graphql.ws.Message original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.ext.web.handler.graphql.ws.Message.class)
public class Message {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    Message that = (Message) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<Message> __TYPE_ARG = new TypeArg<>(    obj -> new Message((io.vertx.ext.web.handler.graphql.ws.Message) obj),
    Message::getDelegate
  );

  private final io.vertx.ext.web.handler.graphql.ws.Message delegate;
  
  public Message(io.vertx.ext.web.handler.graphql.ws.Message delegate) {
    this.delegate = delegate;
  }

  public Message(Object delegate) {
    this.delegate = (io.vertx.ext.web.handler.graphql.ws.Message)delegate;
  }

  public io.vertx.ext.web.handler.graphql.ws.Message getDelegate() {
    return delegate;
  }

  /**
   * @return the websocket that received the message
   */
  public io.vertx.rxjava.core.http.ServerWebSocket socket() { 
    io.vertx.rxjava.core.http.ServerWebSocket ret = io.vertx.rxjava.core.http.ServerWebSocket.newInstance((io.vertx.core.http.ServerWebSocket)delegate.socket());
    return ret;
  }

  /**
   * @return the message type
   */
  public io.vertx.ext.web.handler.graphql.ws.MessageType type() { 
    io.vertx.ext.web.handler.graphql.ws.MessageType ret = delegate.type();
    return ret;
  }

  /**
   * @return the message content
   */
  public io.vertx.core.json.JsonObject message() { 
    io.vertx.core.json.JsonObject ret = delegate.message();
    return ret;
  }

  /**
   * @return the connection params
   */
  public java.lang.Object connectionParams() { 
    java.lang.Object ret = (Object) delegate.connectionParams();
    return ret;
  }

  public static Message newInstance(io.vertx.ext.web.handler.graphql.ws.Message arg) {
    return arg != null ? new Message(arg) : null;
  }

}
