/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava.ext.web.handler;

import rx.Observable;
import rx.Single;
import io.vertx.rx.java.RxHelper;
import io.vertx.rx.java.WriteStreamSubscriber;
import io.vertx.rx.java.SingleOnSubscribeAdapter;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * Base platform interface for handlers that provide functionality to the application platform.
 *
 * Two examples are:
 *
 * <ul>
 *   <li>{@link io.vertx.rxjava.ext.web.handler.BodyHandler}</li>
 *   <li>{@link io.vertx.rxjava.ext.web.handler.SessionHandler}</li>
 * </ul>
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.web.handler.PlatformHandler original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.ext.web.handler.PlatformHandler.class)
public interface PlatformHandler extends Handler<io.vertx.rxjava.ext.web.RoutingContext> {

  io.vertx.ext.web.handler.PlatformHandler getDelegate();

  /**
   * Something has happened, so handle it.
   * @param event the event to handle
   */
  public void handle(io.vertx.rxjava.ext.web.RoutingContext event);

  public static PlatformHandler newInstance(io.vertx.ext.web.handler.PlatformHandler arg) {
    return arg != null ? new PlatformHandlerImpl(arg) : null;
  }

}

class PlatformHandlerImpl implements PlatformHandler {
  private final io.vertx.ext.web.handler.PlatformHandler delegate;
  
  public PlatformHandlerImpl(io.vertx.ext.web.handler.PlatformHandler delegate) {
    this.delegate = delegate;
  }

  public PlatformHandlerImpl(Object delegate) {
    this.delegate = (io.vertx.ext.web.handler.PlatformHandler)delegate;
  }

  public io.vertx.ext.web.handler.PlatformHandler getDelegate() {
    return delegate;
  }

  /**
   * Something has happened, so handle it.
   * @param event the event to handle
   */
  public void handle(io.vertx.rxjava.ext.web.RoutingContext event) { 
    delegate.handle(event.getDelegate());
  }

}
