/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava.ext.web.handler;

import rx.Observable;
import rx.Single;
import io.vertx.rx.java.RxHelper;
import io.vertx.rx.java.WriteStreamSubscriber;
import io.vertx.rx.java.SingleOnSubscribeAdapter;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * An auth handler that provides One Time Password (Multi-Factor) Authentication support.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.web.handler.OtpAuthHandler original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.ext.web.handler.OtpAuthHandler.class)
public class OtpAuthHandler implements io.vertx.rxjava.ext.web.handler.AuthenticationHandler, Handler<io.vertx.rxjava.ext.web.RoutingContext> {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    OtpAuthHandler that = (OtpAuthHandler) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<OtpAuthHandler> __TYPE_ARG = new TypeArg<>(    obj -> new OtpAuthHandler((io.vertx.ext.web.handler.OtpAuthHandler) obj),
    OtpAuthHandler::getDelegate
  );

  private final io.vertx.ext.web.handler.OtpAuthHandler delegate;
  
  public OtpAuthHandler(io.vertx.ext.web.handler.OtpAuthHandler delegate) {
    this.delegate = delegate;
  }

  public OtpAuthHandler(Object delegate) {
    this.delegate = (io.vertx.ext.web.handler.OtpAuthHandler)delegate;
  }

  public io.vertx.ext.web.handler.OtpAuthHandler getDelegate() {
    return delegate;
  }

  /**
   * Something has happened, so handle it.
   * @param event the event to handle
   */
  public void handle(io.vertx.rxjava.ext.web.RoutingContext event) { 
    delegate.handle(event.getDelegate());
  }

  /**
   * Create a new instance of this handler using a time based one time password authentication provider.
   * @param totpAuth the time based OTP provider.
   * @return new instance of the handler.
   */
  public static io.vertx.rxjava.ext.web.handler.OtpAuthHandler create(io.vertx.rxjava.ext.auth.otp.totp.TotpAuth totpAuth) { 
    io.vertx.rxjava.ext.web.handler.OtpAuthHandler ret = io.vertx.rxjava.ext.web.handler.OtpAuthHandler.newInstance((io.vertx.ext.web.handler.OtpAuthHandler)io.vertx.ext.web.handler.OtpAuthHandler.create(totpAuth.getDelegate()));
    return ret;
  }

  /**
   * Create a new instance of this handler using a hash based one time password authentication provider.
   * @param hotpAuth the hash based OTP provider.
   * @return new instance of the handler.
   */
  public static io.vertx.rxjava.ext.web.handler.OtpAuthHandler create(io.vertx.rxjava.ext.auth.otp.hotp.HotpAuth hotpAuth) { 
    io.vertx.rxjava.ext.web.handler.OtpAuthHandler ret = io.vertx.rxjava.ext.web.handler.OtpAuthHandler.newInstance((io.vertx.ext.web.handler.OtpAuthHandler)io.vertx.ext.web.handler.OtpAuthHandler.create(hotpAuth.getDelegate()));
    return ret;
  }

  /**
   * Specify the URL where requests are to be redirected when a user is already known in the request.
   *
   * A user is already known when the  is not <code>null</code>.
   *
   * If no redirect is provided, requests are terminated immediately with status code <code>401</code>.
   * @param url the location where users are to be asked for the OTP code.
   * @return fluent self.
   */
  public io.vertx.rxjava.ext.web.handler.OtpAuthHandler verifyUrl(java.lang.String url) { 
    delegate.verifyUrl(url);
    return this;
  }

  /**
   * Setup the optional route where authenticators are allowed to register. Registration is only allowed on requests with
   * a valid user.
   *
   * A user is valid when the  is not <code>null</code>.
   * @param route the location where users are to register new authenticator devices/apps.
   * @return fluent self.
   */
  public io.vertx.rxjava.ext.web.handler.OtpAuthHandler setupRegisterCallback(io.vertx.rxjava.ext.web.Route route) { 
    delegate.setupRegisterCallback(route.getDelegate());
    return this;
  }

  /**
   * Setup the required route where authenticators to submit the challenge response. Challenges
   * are only allowed on requests with a valid user.
   *
   * A user is valid when the  is not <code>null</code>.
   * @param route the location where users are to submit challenge responses from authenticator devices/apps.
   * @return fluent self.
   */
  public io.vertx.rxjava.ext.web.handler.OtpAuthHandler setupCallback(io.vertx.rxjava.ext.web.Route route) { 
    delegate.setupCallback(route.getDelegate());
    return this;
  }

  /**
   * Configure the <code>issuer</code> value to be shown in the authenticator URL.
   * @param issuer a <code>String</code> for example <code>Vert.x OTP</code>
   * @return fluent self.
   */
  public io.vertx.rxjava.ext.web.handler.OtpAuthHandler issuer(java.lang.String issuer) { 
    delegate.issuer(issuer);
    return this;
  }

  /**
   * Configure the <code>label</code> value to be shown in the authenticator URL. When this value is provided it will
   * overwrite the default label which is composed of the <code>issuer</code> and the current <code>user</code> id.
   * @param label a <code>String</code> for example <code>Vert.x OTP</code>
   * @return fluent self.
   */
  public io.vertx.rxjava.ext.web.handler.OtpAuthHandler label(java.lang.String label) { 
    delegate.label(label);
    return this;
  }

  public static OtpAuthHandler newInstance(io.vertx.ext.web.handler.OtpAuthHandler arg) {
    return arg != null ? new OtpAuthHandler(arg) : null;
  }

}
