/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava.ext.web.handler;

import rx.Observable;
import rx.Single;
import io.vertx.rx.java.RxHelper;
import io.vertx.rx.java.WriteStreamSubscriber;
import io.vertx.rx.java.SingleOnSubscribeAdapter;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * A handler which logs request information to the Vert.x logger.
 * You should mount this handler before any handler that could fail the routing context
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.web.handler.LoggerHandler original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.ext.web.handler.LoggerHandler.class)
public class LoggerHandler implements io.vertx.rxjava.ext.web.handler.PlatformHandler, Handler<io.vertx.rxjava.ext.web.RoutingContext> {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    LoggerHandler that = (LoggerHandler) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<LoggerHandler> __TYPE_ARG = new TypeArg<>(    obj -> new LoggerHandler((io.vertx.ext.web.handler.LoggerHandler) obj),
    LoggerHandler::getDelegate
  );

  private final io.vertx.ext.web.handler.LoggerHandler delegate;
  
  public LoggerHandler(io.vertx.ext.web.handler.LoggerHandler delegate) {
    this.delegate = delegate;
  }

  public LoggerHandler(Object delegate) {
    this.delegate = (io.vertx.ext.web.handler.LoggerHandler)delegate;
  }

  public io.vertx.ext.web.handler.LoggerHandler getDelegate() {
    return delegate;
  }

  /**
   * Something has happened, so handle it.
   * @param event the event to handle
   */
  public void handle(io.vertx.rxjava.ext.web.RoutingContext event) { 
    delegate.handle(event.getDelegate());
  }

  /**
   * Create a handler with default format
   * @return the handler
   */
  public static io.vertx.rxjava.ext.web.handler.LoggerHandler create() { 
    io.vertx.rxjava.ext.web.handler.LoggerHandler ret = io.vertx.rxjava.ext.web.handler.LoggerHandler.newInstance((io.vertx.ext.web.handler.LoggerHandler)io.vertx.ext.web.handler.LoggerHandler.create());
    return ret;
  }

  /**
   * Create a handler with he specified format
   * @param format the format
   * @return the handler
   */
  public static io.vertx.rxjava.ext.web.handler.LoggerHandler create(io.vertx.ext.web.handler.LoggerFormat format) { 
    io.vertx.rxjava.ext.web.handler.LoggerHandler ret = io.vertx.rxjava.ext.web.handler.LoggerHandler.newInstance((io.vertx.ext.web.handler.LoggerHandler)io.vertx.ext.web.handler.LoggerHandler.create(format));
    return ret;
  }

  /**
   * Create a handler with he specified format
   * @param immediate true if logging should occur as soon as request arrives
   * @param format the format
   * @return the handler
   */
  public static io.vertx.rxjava.ext.web.handler.LoggerHandler create(boolean immediate, io.vertx.ext.web.handler.LoggerFormat format) { 
    io.vertx.rxjava.ext.web.handler.LoggerHandler ret = io.vertx.rxjava.ext.web.handler.LoggerHandler.newInstance((io.vertx.ext.web.handler.LoggerHandler)io.vertx.ext.web.handler.LoggerHandler.create(immediate, format));
    return ret;
  }

  /**
   * Set the custom formatter to be used by the handler.
   * @param formatter the formatting function
   * @return the formatted log string
   */
  @Deprecated()
  public io.vertx.rxjava.ext.web.handler.LoggerHandler customFormatter(java.util.function.Function<io.vertx.rxjava.core.http.HttpServerRequest,java.lang.String> formatter) { 
    delegate.customFormatter(new Function<io.vertx.core.http.HttpServerRequest,java.lang.String>() {
      public java.lang.String apply(io.vertx.core.http.HttpServerRequest arg) {
        java.lang.String ret = formatter.apply(io.vertx.rxjava.core.http.HttpServerRequest.newInstance((io.vertx.core.http.HttpServerRequest)arg));
        return ret;
      }
    });
    return this;
  }

  /**
   * Set the custom formatter to be used by the handler.
   * @param formatter the formatter
   * @return the formatted log string
   */
  public io.vertx.rxjava.ext.web.handler.LoggerHandler customFormatter(io.vertx.rxjava.ext.web.handler.LoggerFormatter formatter) { 
    delegate.customFormatter(formatter.getDelegate());
    return this;
  }

  public static final io.vertx.ext.web.handler.LoggerFormat DEFAULT_FORMAT = io.vertx.ext.web.handler.LoggerHandler.DEFAULT_FORMAT;
  public static LoggerHandler newInstance(io.vertx.ext.web.handler.LoggerHandler arg) {
    return arg != null ? new LoggerHandler(arg) : null;
  }

}
