/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava.ext.web.handler;

import rx.Observable;
import rx.Single;
import io.vertx.rx.java.RxHelper;
import io.vertx.rx.java.WriteStreamSubscriber;
import io.vertx.rx.java.SingleOnSubscribeAdapter;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * An auth handler that provides JWT Authentication support.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.web.handler.JWTAuthHandler original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.ext.web.handler.JWTAuthHandler.class)
public class JWTAuthHandler implements io.vertx.rxjava.ext.web.handler.AuthenticationHandler, Handler<io.vertx.rxjava.ext.web.RoutingContext> {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    JWTAuthHandler that = (JWTAuthHandler) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<JWTAuthHandler> __TYPE_ARG = new TypeArg<>(    obj -> new JWTAuthHandler((io.vertx.ext.web.handler.JWTAuthHandler) obj),
    JWTAuthHandler::getDelegate
  );

  private final io.vertx.ext.web.handler.JWTAuthHandler delegate;
  
  public JWTAuthHandler(io.vertx.ext.web.handler.JWTAuthHandler delegate) {
    this.delegate = delegate;
  }

  public JWTAuthHandler(Object delegate) {
    this.delegate = (io.vertx.ext.web.handler.JWTAuthHandler)delegate;
  }

  public io.vertx.ext.web.handler.JWTAuthHandler getDelegate() {
    return delegate;
  }

  /**
   * Something has happened, so handle it.
   * @param event the event to handle
   */
  public void handle(io.vertx.rxjava.ext.web.RoutingContext event) { 
    delegate.handle(event.getDelegate());
  }

  /**
   * Create a JWT auth handler
   * @param authProvider the auth provider to use
   * @return the auth handler
   */
  public static io.vertx.rxjava.ext.web.handler.JWTAuthHandler create(io.vertx.rxjava.ext.auth.jwt.JWTAuth authProvider) { 
    io.vertx.rxjava.ext.web.handler.JWTAuthHandler ret = io.vertx.rxjava.ext.web.handler.JWTAuthHandler.newInstance((io.vertx.ext.web.handler.JWTAuthHandler)io.vertx.ext.web.handler.JWTAuthHandler.create(authProvider.getDelegate()));
    return ret;
  }

  /**
   * Create a JWT auth handler
   * @param authProvider the auth provider to use
   * @param realm 
   * @return the auth handler
   */
  public static io.vertx.rxjava.ext.web.handler.JWTAuthHandler create(io.vertx.rxjava.ext.auth.jwt.JWTAuth authProvider, java.lang.String realm) { 
    io.vertx.rxjava.ext.web.handler.JWTAuthHandler ret = io.vertx.rxjava.ext.web.handler.JWTAuthHandler.newInstance((io.vertx.ext.web.handler.JWTAuthHandler)io.vertx.ext.web.handler.JWTAuthHandler.create(authProvider.getDelegate(), realm));
    return ret;
  }

  /**
   * Return a new instance with the internal state copied from the caller but the scopes delimiter set
   * to be unique to the instance.
   * @param delimiter scope delimiter.
   * @return new instance of this interface.
   */
  public io.vertx.rxjava.ext.web.handler.JWTAuthHandler scopeDelimiter(java.lang.String delimiter) { 
    delegate.scopeDelimiter(delimiter);
    return this;
  }

  /**
   * Return a new instance with the internal state copied from the caller but the scopes to be requested during a token
   * request are unique to the instance.
   * @param scope scope.
   * @return new instance of this interface.
   */
  public io.vertx.rxjava.ext.web.handler.JWTAuthHandler withScope(java.lang.String scope) { 
    delegate.withScope(scope);
    return this;
  }

  /**
   * Return a new instance with the internal state copied from the caller but the scopes to be requested during a token
   * request are unique to the instance.
   * @param scopes scopes.
   * @return new instance of this interface.
   */
  public io.vertx.rxjava.ext.web.handler.JWTAuthHandler withScopes(java.util.List<java.lang.String> scopes) { 
    delegate.withScopes(scopes);
    return this;
  }

  public static JWTAuthHandler newInstance(io.vertx.ext.web.handler.JWTAuthHandler arg) {
    return arg != null ? new JWTAuthHandler(arg) : null;
  }

}
