/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava.ext.web.handler;

import rx.Observable;
import rx.Single;
import io.vertx.rx.java.RxHelper;
import io.vertx.rx.java.WriteStreamSubscriber;
import io.vertx.rx.java.SingleOnSubscribeAdapter;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * Base interface for authorization handlers that provide authorization support.
 * <p>
 * AuthorizationHandlerImpl usually requires a {@link io.vertx.rxjava.ext.web.handler.AuthenticationHandler} to be on the routing chain before it
 * or a custom handler that has previously set a {@link io.vertx.rxjava.ext.auth.User} in the {@link io.vertx.rxjava.ext.web.RoutingContext}
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.web.handler.AuthorizationHandler original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.ext.web.handler.AuthorizationHandler.class)
public class AuthorizationHandler implements Handler<io.vertx.rxjava.ext.web.RoutingContext> {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    AuthorizationHandler that = (AuthorizationHandler) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<AuthorizationHandler> __TYPE_ARG = new TypeArg<>(    obj -> new AuthorizationHandler((io.vertx.ext.web.handler.AuthorizationHandler) obj),
    AuthorizationHandler::getDelegate
  );

  private final io.vertx.ext.web.handler.AuthorizationHandler delegate;
  
  public AuthorizationHandler(io.vertx.ext.web.handler.AuthorizationHandler delegate) {
    this.delegate = delegate;
  }

  public AuthorizationHandler(Object delegate) {
    this.delegate = (io.vertx.ext.web.handler.AuthorizationHandler)delegate;
  }

  public io.vertx.ext.web.handler.AuthorizationHandler getDelegate() {
    return delegate;
  }

  /**
   * Something has happened, so handle it.
   * @param event the event to handle
   */
  public void handle(io.vertx.rxjava.ext.web.RoutingContext event) { 
    delegate.handle(event.getDelegate());
  }

  /**
   * create the the handler that will check the specified authorization
   * Note that to check several authorizations, you can specify a sub-interface such as {@link io.vertx.rxjava.ext.auth.authorization.AndAuthorization} or {@link io.vertx.rxjava.ext.auth.authorization.OrAuthorization}
   * @param authorization the authorization to attest.
   * @return fluent self.
   */
  public static io.vertx.rxjava.ext.web.handler.AuthorizationHandler create(io.vertx.rxjava.ext.auth.authorization.Authorization authorization) { 
    io.vertx.rxjava.ext.web.handler.AuthorizationHandler ret = io.vertx.rxjava.ext.web.handler.AuthorizationHandler.newInstance((io.vertx.ext.web.handler.AuthorizationHandler)io.vertx.ext.web.handler.AuthorizationHandler.create(authorization.getDelegate()));
    return ret;
  }

  /**
   * Adds a provider that shall be used to retrieve the required authorizations for the user to attest.
   * Multiple calls are allowed to retrieve authorizations from many sources.
   * @param authorizationProvider a provider.
   * @return fluent self.
   */
  public io.vertx.rxjava.ext.web.handler.AuthorizationHandler addAuthorizationProvider(io.vertx.rxjava.ext.auth.authorization.AuthorizationProvider authorizationProvider) { 
    delegate.addAuthorizationProvider(authorizationProvider.getDelegate());
    return this;
  }

  public static AuthorizationHandler newInstance(io.vertx.ext.web.handler.AuthorizationHandler arg) {
    return arg != null ? new AuthorizationHandler(arg) : null;
  }

}
