/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava.ext.web.client.predicate;

import rx.Observable;
import rx.Single;
import io.vertx.rx.java.RxHelper;
import io.vertx.rx.java.WriteStreamSubscriber;
import io.vertx.rx.java.SingleOnSubscribeAdapter;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * Represents the outcome of a {@link io.vertx.rxjava.ext.web.client.predicate.ResponsePredicate} applied to an .
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.web.client.predicate.ResponsePredicateResult original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.ext.web.client.predicate.ResponsePredicateResult.class)
public class ResponsePredicateResult {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ResponsePredicateResult that = (ResponsePredicateResult) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<ResponsePredicateResult> __TYPE_ARG = new TypeArg<>(    obj -> new ResponsePredicateResult((io.vertx.ext.web.client.predicate.ResponsePredicateResult) obj),
    ResponsePredicateResult::getDelegate
  );

  private final io.vertx.ext.web.client.predicate.ResponsePredicateResult delegate;
  
  public ResponsePredicateResult(io.vertx.ext.web.client.predicate.ResponsePredicateResult delegate) {
    this.delegate = delegate;
  }

  public ResponsePredicateResult(Object delegate) {
    this.delegate = (io.vertx.ext.web.client.predicate.ResponsePredicateResult)delegate;
  }

  public io.vertx.ext.web.client.predicate.ResponsePredicateResult getDelegate() {
    return delegate;
  }

  private static final TypeArg<io.vertx.rxjava.core.buffer.Buffer> TYPE_ARG_0 = new TypeArg<io.vertx.rxjava.core.buffer.Buffer>(o1 -> io.vertx.rxjava.core.buffer.Buffer.newInstance((io.vertx.core.buffer.Buffer)o1), o1 -> o1.getDelegate());

  /**
   * @return a successful result
   */
  public static io.vertx.rxjava.ext.web.client.predicate.ResponsePredicateResult success() { 
    io.vertx.rxjava.ext.web.client.predicate.ResponsePredicateResult ret = io.vertx.rxjava.ext.web.client.predicate.ResponsePredicateResult.newInstance((io.vertx.ext.web.client.predicate.ResponsePredicateResult)io.vertx.ext.web.client.predicate.ResponsePredicateResult.success());
    return ret;
  }

  /**
   * Creates a failed result.
   * @param message the failure description
   * @return 
   */
  public static io.vertx.rxjava.ext.web.client.predicate.ResponsePredicateResult failure(java.lang.String message) { 
    io.vertx.rxjava.ext.web.client.predicate.ResponsePredicateResult ret = io.vertx.rxjava.ext.web.client.predicate.ResponsePredicateResult.newInstance((io.vertx.ext.web.client.predicate.ResponsePredicateResult)io.vertx.ext.web.client.predicate.ResponsePredicateResult.failure(message));
    return ret;
  }

  /**
   * Whether the result is a success or failure.
   * @return <code>true</code> if the {@link io.vertx.rxjava.ext.web.client.predicate.ResponsePredicate} was applied successfully, false otherwise
   */
  public boolean succeeded() { 
    boolean ret = delegate.succeeded();
    return ret;
  }

  /**
   * The failure message. May be <code>null</code>.
   * @return 
   */
  public java.lang.String message() { 
    java.lang.String ret = delegate.message();
    return ret;
  }

  /**
   * The  which has been tested.
   * @return <code>null</code> after the result has been created, or the tested response for converters created with {@link io.vertx.rxjava.ext.web.client.predicate.ErrorConverter#createFullBody}
   */
  public io.vertx.rxjava.ext.web.client.HttpResponse<io.vertx.rxjava.core.buffer.Buffer> response() { 
    io.vertx.rxjava.ext.web.client.HttpResponse<io.vertx.rxjava.core.buffer.Buffer> ret = io.vertx.rxjava.ext.web.client.HttpResponse.newInstance((io.vertx.ext.web.client.HttpResponse)delegate.response(), TYPE_ARG_0);
    return ret;
  }

  public static ResponsePredicateResult newInstance(io.vertx.ext.web.client.predicate.ResponsePredicateResult arg) {
    return arg != null ? new ResponsePredicateResult(arg) : null;
  }

}
