/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava.ext.web.client;

import rx.Observable;
import rx.Single;
import io.vertx.rx.java.RxHelper;
import io.vertx.rx.java.WriteStreamSubscriber;
import io.vertx.rx.java.SingleOnSubscribeAdapter;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * An asynchronous cache aware HTTP / HTTP/2 client called <code>CachingWebClient</code>.
 * <p>
 * This client wraps a {@link io.vertx.rxjava.ext.web.client.WebClient} and makes it cache aware by adding features to it:
 * <ul>
 *   <li>Cache-Control header parsing</li>
 *   <li>Freshness checking</li>
 * </ul>
 * <p>
 * The client honors the following cache headers:
 * <ul>
 *  <li>Cache-Control with the following properties understood:
 *    <ul>
 *      <li>public</li>
 *      <li>private</li>
 *      <li>no-cache</li>
 *      <li>no-store</li>
 *      <li>max-age</li>
 *      <li>s-maxage</li>
 *      <li>stale-if-error</li>
 *      <li>staile-while-revalidate</li>
 *      <li>must-revalidate</li>
 *    </ul>
 *  </li>
 *  <li>Expires</li>
 *  <li>ETag</li>
 *  <li>Vary</li>
 * </ul>
 * <p/>
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.web.client.CachingWebClient original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.ext.web.client.CachingWebClient.class)
public class CachingWebClient {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    CachingWebClient that = (CachingWebClient) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<CachingWebClient> __TYPE_ARG = new TypeArg<>(    obj -> new CachingWebClient((io.vertx.ext.web.client.CachingWebClient) obj),
    CachingWebClient::getDelegate
  );

  private final io.vertx.ext.web.client.CachingWebClient delegate;
  
  public CachingWebClient(io.vertx.ext.web.client.CachingWebClient delegate) {
    this.delegate = delegate;
  }

  public CachingWebClient(Object delegate) {
    this.delegate = (io.vertx.ext.web.client.CachingWebClient)delegate;
  }

  public io.vertx.ext.web.client.CachingWebClient getDelegate() {
    return delegate;
  }

  /**
   * Create a cache aware web client using the provided {@link io.vertx.rxjava.ext.web.client.WebClient}.
   * @param webClient the web client instance
   * @return the created web client
   */
  public static io.vertx.rxjava.ext.web.client.WebClient create(io.vertx.rxjava.ext.web.client.WebClient webClient) { 
    io.vertx.rxjava.ext.web.client.WebClient ret = io.vertx.rxjava.ext.web.client.WebClient.newInstance((io.vertx.ext.web.client.WebClient)io.vertx.ext.web.client.CachingWebClient.create(webClient.getDelegate()));
    return ret;
  }

  /**
   * Create a cache aware web client using the provided {@link io.vertx.rxjava.ext.web.client.WebClient}.
   * @param webClient the web client instance
   * @param cacheStore the cache adapter
   * @return the created web client
   */
  public static io.vertx.rxjava.ext.web.client.WebClient create(io.vertx.rxjava.ext.web.client.WebClient webClient, io.vertx.ext.web.client.spi.CacheStore cacheStore) { 
    io.vertx.rxjava.ext.web.client.WebClient ret = io.vertx.rxjava.ext.web.client.WebClient.newInstance((io.vertx.ext.web.client.WebClient)io.vertx.ext.web.client.CachingWebClient.create(webClient.getDelegate(), cacheStore));
    return ret;
  }

  /**
   * Create a cache aware web client using the provided {@link io.vertx.rxjava.ext.web.client.WebClient}.
   * @param webClient the web client instance
   * @param options the caching web client options
   * @return the created web client
   */
  public static io.vertx.rxjava.ext.web.client.WebClient create(io.vertx.rxjava.ext.web.client.WebClient webClient, io.vertx.ext.web.client.CachingWebClientOptions options) { 
    io.vertx.rxjava.ext.web.client.WebClient ret = io.vertx.rxjava.ext.web.client.WebClient.newInstance((io.vertx.ext.web.client.WebClient)io.vertx.ext.web.client.CachingWebClient.create(webClient.getDelegate(), options));
    return ret;
  }

  /**
   * Create a cache aware web client using the provided {@link io.vertx.rxjava.ext.web.client.WebClient}.
   * @param webClient the web client instance
   * @param cacheStore the cache adapter
   * @param options the caching web client options
   * @return the created web client
   */
  public static io.vertx.rxjava.ext.web.client.WebClient create(io.vertx.rxjava.ext.web.client.WebClient webClient, io.vertx.ext.web.client.spi.CacheStore cacheStore, io.vertx.ext.web.client.CachingWebClientOptions options) { 
    io.vertx.rxjava.ext.web.client.WebClient ret = io.vertx.rxjava.ext.web.client.WebClient.newInstance((io.vertx.ext.web.client.WebClient)io.vertx.ext.web.client.CachingWebClient.create(webClient.getDelegate(), cacheStore, options));
    return ret;
  }

  public static CachingWebClient newInstance(io.vertx.ext.web.client.CachingWebClient arg) {
    return arg != null ? new CachingWebClient(arg) : null;
  }

}
