/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava.ext.unit.report;

import rx.Observable;
import rx.Single;
import io.vertx.rx.java.RxHelper;
import io.vertx.rx.java.WriteStreamSubscriber;
import io.vertx.rx.java.SingleOnSubscribeAdapter;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * The test suite reports is basically a stream of events reporting the test suite execution.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.unit.report.TestSuiteReport original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.ext.unit.report.TestSuiteReport.class)
public class TestSuiteReport implements io.vertx.rxjava.core.streams.ReadStream<io.vertx.rxjava.ext.unit.report.TestCaseReport> {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    TestSuiteReport that = (TestSuiteReport) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<TestSuiteReport> __TYPE_ARG = new TypeArg<>(    obj -> new TestSuiteReport((io.vertx.ext.unit.report.TestSuiteReport) obj),
    TestSuiteReport::getDelegate
  );

  private final io.vertx.ext.unit.report.TestSuiteReport delegate;
  
  public TestSuiteReport(io.vertx.ext.unit.report.TestSuiteReport delegate) {
    this.delegate = delegate;
  }

  public TestSuiteReport(Object delegate) {
    this.delegate = (io.vertx.ext.unit.report.TestSuiteReport)delegate;
  }

  public io.vertx.ext.unit.report.TestSuiteReport getDelegate() {
    return delegate;
  }

  private Observable<io.vertx.rxjava.ext.unit.report.TestCaseReport> observable;

  public synchronized Observable<io.vertx.rxjava.ext.unit.report.TestCaseReport> toObservable() {
    if (observable == null) {
      Function<io.vertx.ext.unit.report.TestCaseReport, io.vertx.rxjava.ext.unit.report.TestCaseReport> conv = io.vertx.rxjava.ext.unit.report.TestCaseReport::newInstance;
      observable = RxHelper.toObservable(delegate, conv);
    }
    return observable;
  }

  private static final TypeArg<io.vertx.rxjava.ext.unit.report.TestCaseReport> TYPE_ARG_0 = new TypeArg<io.vertx.rxjava.ext.unit.report.TestCaseReport>(o1 -> io.vertx.rxjava.ext.unit.report.TestCaseReport.newInstance((io.vertx.ext.unit.report.TestCaseReport)o1), o1 -> o1.getDelegate());
  private static final TypeArg<io.vertx.rxjava.ext.unit.report.TestCaseReport> TYPE_ARG_1 = new TypeArg<io.vertx.rxjava.ext.unit.report.TestCaseReport>(o1 -> io.vertx.rxjava.ext.unit.report.TestCaseReport.newInstance((io.vertx.ext.unit.report.TestCaseReport)o1), o1 -> o1.getDelegate());

  /**
   * Fetch the specified <code>amount</code> of elements. If the <code>ReadStream</code> has been paused, reading will
   * recommence with the specified <code>amount</code> of items, otherwise the specified <code>amount</code> will
   * be added to the current stream demand.
   * @param amount 
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava.core.streams.ReadStream<io.vertx.rxjava.ext.unit.report.TestCaseReport> fetch(long amount) { 
    delegate.fetch(amount);
    return this;
  }

  /**
   * Pause this stream and return a  to transfer the elements of this stream to a destination .
   * <p/>
   * The stream will be resumed when the pipe will be wired to a <code>WriteStream</code>.
   * @return a pipe
   */
  public io.vertx.rxjava.core.streams.Pipe<io.vertx.rxjava.ext.unit.report.TestCaseReport> pipe() { 
    io.vertx.rxjava.core.streams.Pipe<io.vertx.rxjava.ext.unit.report.TestCaseReport> ret = io.vertx.rxjava.core.streams.Pipe.newInstance((io.vertx.core.streams.Pipe)delegate.pipe(), TYPE_ARG_1);
    return ret;
  }

  /**
   * Pipe this <code>ReadStream</code> to the <code>WriteStream</code>.
   * <p>
   * Elements emitted by this stream will be written to the write stream until this stream ends or fails.
   * <p>
   * Once this stream has ended or failed, the write stream will be ended and the <code>handler</code> will be
   * called with the result.
   * @param dst the destination write stream
   * @param handler 
   */
  public void pipeTo(io.vertx.rxjava.core.streams.WriteStream<io.vertx.rxjava.ext.unit.report.TestCaseReport> dst, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.Void>> handler) { 
    delegate.pipeTo(dst.getDelegate(), handler);
  }

  /**
   * Pipe this <code>ReadStream</code> to the <code>WriteStream</code>.
   * <p>
   * Elements emitted by this stream will be written to the write stream until this stream ends or fails.
   * <p>
   * Once this stream has ended or failed, the write stream will be ended and the <code>handler</code> will be
   * called with the result.
   * @param dst the destination write stream
   */
  public void pipeTo(io.vertx.rxjava.core.streams.WriteStream<io.vertx.rxjava.ext.unit.report.TestCaseReport> dst) {
    pipeTo(dst, ar -> { });
  }

    /**
   * Pipe this <code>ReadStream</code> to the <code>WriteStream</code>.
   * <p>
   * Elements emitted by this stream will be written to the write stream until this stream ends or fails.
   * <p>
   * Once this stream has ended or failed, the write stream will be ended and the <code>handler</code> will be
   * called with the result.
   * @param dst the destination write stream
   * @return 
   */
  public rx.Single<java.lang.Void> rxPipeTo(io.vertx.rxjava.core.streams.WriteStream<io.vertx.rxjava.ext.unit.report.TestCaseReport> dst) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      pipeTo(dst, fut);
    }));
  }

  /**
   * @return the test suite name
   */
  public java.lang.String name() { 
    if (cached_0 != null) {
      return cached_0;
    }
    java.lang.String ret = delegate.name();
    cached_0 = ret;
    return ret;
  }

  /**
   * Set an exception handler, the exception handler reports the test suite errors, it can be called mulitple
   * times before the test ends.
   * @param handler the exception handler
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava.ext.unit.report.TestSuiteReport exceptionHandler(io.vertx.core.Handler<java.lang.Throwable> handler) { 
    delegate.exceptionHandler(handler);
    return this;
  }

  public io.vertx.rxjava.ext.unit.report.TestSuiteReport handler(io.vertx.core.Handler<io.vertx.rxjava.ext.unit.report.TestCaseReport> handler) { 
    delegate.handler(new io.vertx.lang.rx.DelegatingHandler<>(handler, event -> io.vertx.rxjava.ext.unit.report.TestCaseReport.newInstance((io.vertx.ext.unit.report.TestCaseReport)event)));
    return this;
  }

  public io.vertx.rxjava.ext.unit.report.TestSuiteReport pause() { 
    delegate.pause();
    return this;
  }

  public io.vertx.rxjava.ext.unit.report.TestSuiteReport resume() { 
    delegate.resume();
    return this;
  }

  public io.vertx.rxjava.ext.unit.report.TestSuiteReport endHandler(io.vertx.core.Handler<java.lang.Void> endHandler) { 
    delegate.endHandler(endHandler);
    return this;
  }

  private java.lang.String cached_0;
  public static TestSuiteReport newInstance(io.vertx.ext.unit.report.TestSuiteReport arg) {
    return arg != null ? new TestSuiteReport(arg) : null;
  }

}
