/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava.ext.stomp;

import rx.Observable;
import rx.Single;
import io.vertx.rx.java.RxHelper;
import io.vertx.rx.java.WriteStreamSubscriber;
import io.vertx.rx.java.SingleOnSubscribeAdapter;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * Defines a STOMP client.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.stomp.StompClient original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.ext.stomp.StompClient.class)
public class StompClient {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    StompClient that = (StompClient) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<StompClient> __TYPE_ARG = new TypeArg<>(    obj -> new StompClient((io.vertx.ext.stomp.StompClient) obj),
    StompClient::getDelegate
  );

  private final io.vertx.ext.stomp.StompClient delegate;
  
  public StompClient(io.vertx.ext.stomp.StompClient delegate) {
    this.delegate = delegate;
  }

  public StompClient(Object delegate) {
    this.delegate = (io.vertx.ext.stomp.StompClient)delegate;
  }

  public io.vertx.ext.stomp.StompClient getDelegate() {
    return delegate;
  }

  /**
   * Creates a {@link io.vertx.rxjava.ext.stomp.StompClient} using the default implementation.
   * @param vertx the vert.x instance to use
   * @return the created {@link io.vertx.rxjava.ext.stomp.StompClient}
   */
  public static io.vertx.rxjava.ext.stomp.StompClient create(io.vertx.rxjava.core.Vertx vertx) { 
    io.vertx.rxjava.ext.stomp.StompClient ret = io.vertx.rxjava.ext.stomp.StompClient.newInstance((io.vertx.ext.stomp.StompClient)io.vertx.ext.stomp.StompClient.create(vertx.getDelegate()));
    return ret;
  }

  /**
   * Creates a {@link io.vertx.rxjava.ext.stomp.StompClient} using the default implementation.
   * @param vertx the vert.x instance to use
   * @param options the options
   * @return the created {@link io.vertx.rxjava.ext.stomp.StompClient}
   */
  public static io.vertx.rxjava.ext.stomp.StompClient create(io.vertx.rxjava.core.Vertx vertx, io.vertx.ext.stomp.StompClientOptions options) { 
    io.vertx.rxjava.ext.stomp.StompClient ret = io.vertx.rxjava.ext.stomp.StompClient.newInstance((io.vertx.ext.stomp.StompClient)io.vertx.ext.stomp.StompClient.create(vertx.getDelegate(), options));
    return ret;
  }

  /**
   * Connects to the server.
   * @param port the server port
   * @param host the server host
   * @param resultHandler handler called with the connection result
   * @return the current {@link io.vertx.rxjava.ext.stomp.StompClient}
   */
  public io.vertx.rxjava.ext.stomp.StompClient connect(int port, java.lang.String host, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.ext.stomp.StompClientConnection>> resultHandler) { 
    delegate.connect(port, host, new io.vertx.lang.rx.DelegatingHandler<>(resultHandler, ar -> ar.map(event -> io.vertx.rxjava.ext.stomp.StompClientConnection.newInstance((io.vertx.ext.stomp.StompClientConnection)event))));
    return this;
  }

  /**
   * Connects to the server.
   * @param port the server port
   * @param host the server host
   * @return the current {@link io.vertx.rxjava.ext.stomp.StompClient}
   */
  public io.vertx.rxjava.ext.stomp.StompClient connect(int port, java.lang.String host) {
    return 
connect(port, host, ar -> { });
  }

    /**
   * Connects to the server.
   * @param port the server port
   * @param host the server host
   * @return the current {@link io.vertx.rxjava.ext.stomp.StompClient}
   */
  public rx.Single<io.vertx.rxjava.ext.stomp.StompClientConnection> rxConnect(int port, java.lang.String host) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      connect(port, host, fut);
    }));
  }

  /**
   * Connects to the server.
   * @param net the NET client to use
   * @param resultHandler handler called with the connection result
   * @return the current {@link io.vertx.rxjava.ext.stomp.StompClient}
   */
  public io.vertx.rxjava.ext.stomp.StompClient connect(io.vertx.rxjava.core.net.NetClient net, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.ext.stomp.StompClientConnection>> resultHandler) { 
    delegate.connect(net.getDelegate(), new io.vertx.lang.rx.DelegatingHandler<>(resultHandler, ar -> ar.map(event -> io.vertx.rxjava.ext.stomp.StompClientConnection.newInstance((io.vertx.ext.stomp.StompClientConnection)event))));
    return this;
  }

  /**
   * Connects to the server.
   * @param net the NET client to use
   * @return the current {@link io.vertx.rxjava.ext.stomp.StompClient}
   */
  public io.vertx.rxjava.ext.stomp.StompClient connect(io.vertx.rxjava.core.net.NetClient net) {
    return 
connect(net, ar -> { });
  }

    /**
   * Connects to the server.
   * @param net the NET client to use
   * @return the current {@link io.vertx.rxjava.ext.stomp.StompClient}
   */
  public rx.Single<io.vertx.rxjava.ext.stomp.StompClientConnection> rxConnect(io.vertx.rxjava.core.net.NetClient net) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      connect(net, fut);
    }));
  }

  /**
   * Connects to the server.
   * @param port the server port
   * @param host the server host
   * @param net the NET client to use
   * @param resultHandler handler called with the connection result
   * @return the current {@link io.vertx.rxjava.ext.stomp.StompClient}
   */
  public io.vertx.rxjava.ext.stomp.StompClient connect(int port, java.lang.String host, io.vertx.rxjava.core.net.NetClient net, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.ext.stomp.StompClientConnection>> resultHandler) { 
    delegate.connect(port, host, net.getDelegate(), new io.vertx.lang.rx.DelegatingHandler<>(resultHandler, ar -> ar.map(event -> io.vertx.rxjava.ext.stomp.StompClientConnection.newInstance((io.vertx.ext.stomp.StompClientConnection)event))));
    return this;
  }

  /**
   * Connects to the server.
   * @param port the server port
   * @param host the server host
   * @param net the NET client to use
   * @return the current {@link io.vertx.rxjava.ext.stomp.StompClient}
   */
  public io.vertx.rxjava.ext.stomp.StompClient connect(int port, java.lang.String host, io.vertx.rxjava.core.net.NetClient net) {
    return 
connect(port, host, net, ar -> { });
  }

    /**
   * Connects to the server.
   * @param port the server port
   * @param host the server host
   * @param net the NET client to use
   * @return the current {@link io.vertx.rxjava.ext.stomp.StompClient}
   */
  public rx.Single<io.vertx.rxjava.ext.stomp.StompClientConnection> rxConnect(int port, java.lang.String host, io.vertx.rxjava.core.net.NetClient net) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      connect(port, host, net, fut);
    }));
  }

  /**
   * Connects to the server using the host and port configured in the client's options.
   * @param resultHandler handler called with the connection result. A failure will be sent to the handler if a TCP level issue happen before the `CONNECTED` frame is received. Afterwards, the {@link io.vertx.rxjava.ext.stomp.StompClient#exceptionHandler} is called.
   * @return the current {@link io.vertx.rxjava.ext.stomp.StompClient}
   */
  public io.vertx.rxjava.ext.stomp.StompClient connect(io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.ext.stomp.StompClientConnection>> resultHandler) { 
    delegate.connect(new io.vertx.lang.rx.DelegatingHandler<>(resultHandler, ar -> ar.map(event -> io.vertx.rxjava.ext.stomp.StompClientConnection.newInstance((io.vertx.ext.stomp.StompClientConnection)event))));
    return this;
  }

  /**
   * Connects to the server using the host and port configured in the client's options.
   * @return the current {@link io.vertx.rxjava.ext.stomp.StompClient}
   */
  public io.vertx.rxjava.ext.stomp.StompClient connect() {
    return 
connect(ar -> { });
  }

    /**
   * Connects to the server using the host and port configured in the client's options.
   * @return the current {@link io.vertx.rxjava.ext.stomp.StompClient}
   */
  public rx.Single<io.vertx.rxjava.ext.stomp.StompClientConnection> rxConnect() { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      connect(fut);
    }));
  }

  /**
   * Configures a received handler that gets notified when a STOMP frame is received by the client.
   * This handler can be used for logging, debugging or ad-hoc behavior. The frame can still be modified at the time.
   * <p>
   * When a connection is created, the handler is used as
   * {@link io.vertx.rxjava.ext.stomp.StompClientConnection#receivedFrameHandler}.
   * @param handler the handler
   * @return the current {@link io.vertx.rxjava.ext.stomp.StompClient}
   */
  public io.vertx.rxjava.ext.stomp.StompClient receivedFrameHandler(io.vertx.core.Handler<io.vertx.ext.stomp.Frame> handler) { 
    delegate.receivedFrameHandler(handler);
    return this;
  }

  /**
   * Configures a writing handler that gets notified when a STOMP frame is written on the wire.
   * This handler can be used for logging, debugging or ad-hoc behavior. The frame can still be modified at the time.
   * <p>
   * When a connection is created, the handler is used as
   * {@link io.vertx.rxjava.ext.stomp.StompClientConnection#writingFrameHandler}.
   * @param handler the handler
   * @return the current {@link io.vertx.rxjava.ext.stomp.StompClient}
   */
  public io.vertx.rxjava.ext.stomp.StompClient writingFrameHandler(io.vertx.core.Handler<io.vertx.ext.stomp.Frame> handler) { 
    delegate.writingFrameHandler(handler);
    return this;
  }

  /**
   * A general error frame handler. It can be used to catch <code>ERROR</code> frame emitted during the connection process
   * (wrong authentication). This error handler will be pass to all {@link io.vertx.rxjava.ext.stomp.StompClientConnection} created from this
   * client. Obviously, the client can override it when the connection is established.
   * @param handler the handler
   * @return the current {@link io.vertx.rxjava.ext.stomp.StompClient}
   */
  public io.vertx.rxjava.ext.stomp.StompClient errorFrameHandler(io.vertx.core.Handler<io.vertx.ext.stomp.Frame> handler) { 
    delegate.errorFrameHandler(handler);
    return this;
  }

  /**
   * Sets an exception handler notified for TCP-level errors.
   * @param handler the handler
   * @return the current {@link io.vertx.rxjava.ext.stomp.StompClient}
   */
  public io.vertx.rxjava.ext.stomp.StompClient exceptionHandler(io.vertx.core.Handler<java.lang.Throwable> handler) { 
    delegate.exceptionHandler(handler);
    return this;
  }

  /**
   * Closes the client.
   */
  public void close() { 
    delegate.close();
  }

  /**
   * @return the client's options.
   */
  public io.vertx.ext.stomp.StompClientOptions options() { 
    io.vertx.ext.stomp.StompClientOptions ret = delegate.options();
    return ret;
  }

  /**
   * @return the vert.x instance used by the client.
   */
  public io.vertx.rxjava.core.Vertx vertx() { 
    io.vertx.rxjava.core.Vertx ret = io.vertx.rxjava.core.Vertx.newInstance((io.vertx.core.Vertx)delegate.vertx());
    return ret;
  }

  /**
   * @return whether or not the client is connected to the server.
   */
  public boolean isClosed() { 
    boolean ret = delegate.isClosed();
    return ret;
  }

  public static StompClient newInstance(io.vertx.ext.stomp.StompClient arg) {
    return arg != null ? new StompClient(arg) : null;
  }

}
