/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava.ext.stomp;

import rx.Observable;
import rx.Single;
import io.vertx.rx.java.RxHelper;
import io.vertx.rx.java.WriteStreamSubscriber;
import io.vertx.rx.java.SingleOnSubscribeAdapter;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * Structure passed to server handler when receiving a frame. It provides a reference on the received {@link io.vertx.ext.stomp.Frame}
 * but also on the {@link io.vertx.rxjava.ext.stomp.StompServerConnection}.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.stomp.ServerFrame original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.ext.stomp.ServerFrame.class)
public class ServerFrame {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ServerFrame that = (ServerFrame) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<ServerFrame> __TYPE_ARG = new TypeArg<>(    obj -> new ServerFrame((io.vertx.ext.stomp.ServerFrame) obj),
    ServerFrame::getDelegate
  );

  private final io.vertx.ext.stomp.ServerFrame delegate;
  
  public ServerFrame(io.vertx.ext.stomp.ServerFrame delegate) {
    this.delegate = delegate;
  }

  public ServerFrame(Object delegate) {
    this.delegate = (io.vertx.ext.stomp.ServerFrame)delegate;
  }

  public io.vertx.ext.stomp.ServerFrame getDelegate() {
    return delegate;
  }

  /**
   * @return the received frame
   */
  public io.vertx.ext.stomp.Frame frame() { 
    io.vertx.ext.stomp.Frame ret = delegate.frame();
    return ret;
  }

  /**
   * @return the connection
   */
  public io.vertx.rxjava.ext.stomp.StompServerConnection connection() { 
    io.vertx.rxjava.ext.stomp.StompServerConnection ret = io.vertx.rxjava.ext.stomp.StompServerConnection.newInstance((io.vertx.ext.stomp.StompServerConnection)delegate.connection());
    return ret;
  }

  public static ServerFrame newInstance(io.vertx.ext.stomp.ServerFrame arg) {
    return arg != null ? new ServerFrame(arg) : null;
  }

}
