/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava.ext.sql;

import rx.Observable;
import rx.Single;
import io.vertx.rx.java.RxHelper;
import io.vertx.rx.java.WriteStreamSubscriber;
import io.vertx.rx.java.SingleOnSubscribeAdapter;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * A ReadStream of Rows from the underlying RDBMS. This class follows the ReadStream semantics and will automatically
 * close the underlying resources if all returned rows are returned. For cases where the results are ignored before the
 * full processing of the returned rows is complete the close method **MUST** be called in order to release underlying
 * resources.
 *
 * The interface is minimal in order to support all SQL clients not just JDBC.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.sql.SQLRowStream original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.ext.sql.SQLRowStream.class)
public class SQLRowStream implements io.vertx.rxjava.core.streams.ReadStream<io.vertx.core.json.JsonArray> {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SQLRowStream that = (SQLRowStream) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<SQLRowStream> __TYPE_ARG = new TypeArg<>(    obj -> new SQLRowStream((io.vertx.ext.sql.SQLRowStream) obj),
    SQLRowStream::getDelegate
  );

  private final io.vertx.ext.sql.SQLRowStream delegate;
  
  public SQLRowStream(io.vertx.ext.sql.SQLRowStream delegate) {
    this.delegate = delegate;
  }

  public SQLRowStream(Object delegate) {
    this.delegate = (io.vertx.ext.sql.SQLRowStream)delegate;
  }

  public io.vertx.ext.sql.SQLRowStream getDelegate() {
    return delegate;
  }

  private Observable<io.vertx.core.json.JsonArray> observable;

  public synchronized Observable<io.vertx.core.json.JsonArray> toObservable() {
    if (observable == null) {
      observable = RxHelper.toObservable(this.getDelegate());
    }
    return observable;
  }


  /**
   * Fetch the specified <code>amount</code> of elements. If the <code>ReadStream</code> has been paused, reading will
   * recommence with the specified <code>amount</code> of items, otherwise the specified <code>amount</code> will
   * be added to the current stream demand.
   * @param amount 
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava.core.streams.ReadStream<io.vertx.core.json.JsonArray> fetch(long amount) { 
    delegate.fetch(amount);
    return this;
  }

  /**
   * Pause this stream and return a  to transfer the elements of this stream to a destination .
   * <p/>
   * The stream will be resumed when the pipe will be wired to a <code>WriteStream</code>.
   * @return a pipe
   */
  public io.vertx.rxjava.core.streams.Pipe<io.vertx.core.json.JsonArray> pipe() { 
    io.vertx.rxjava.core.streams.Pipe<io.vertx.core.json.JsonArray> ret = io.vertx.rxjava.core.streams.Pipe.newInstance((io.vertx.core.streams.Pipe)delegate.pipe(), TypeArg.unknown());
    return ret;
  }

  /**
   * Pipe this <code>ReadStream</code> to the <code>WriteStream</code>.
   * <p>
   * Elements emitted by this stream will be written to the write stream until this stream ends or fails.
   * <p>
   * Once this stream has ended or failed, the write stream will be ended and the <code>handler</code> will be
   * called with the result.
   * @param dst the destination write stream
   * @param handler 
   */
  public void pipeTo(io.vertx.rxjava.core.streams.WriteStream<io.vertx.core.json.JsonArray> dst, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.Void>> handler) { 
    delegate.pipeTo(dst.getDelegate(), handler);
  }

  /**
   * Pipe this <code>ReadStream</code> to the <code>WriteStream</code>.
   * <p>
   * Elements emitted by this stream will be written to the write stream until this stream ends or fails.
   * <p>
   * Once this stream has ended or failed, the write stream will be ended and the <code>handler</code> will be
   * called with the result.
   * @param dst the destination write stream
   */
  public void pipeTo(io.vertx.rxjava.core.streams.WriteStream<io.vertx.core.json.JsonArray> dst) {
    pipeTo(dst, ar -> { });
  }

    /**
   * Pipe this <code>ReadStream</code> to the <code>WriteStream</code>.
   * <p>
   * Elements emitted by this stream will be written to the write stream until this stream ends or fails.
   * <p>
   * Once this stream has ended or failed, the write stream will be ended and the <code>handler</code> will be
   * called with the result.
   * @param dst the destination write stream
   * @return 
   */
  public rx.Single<java.lang.Void> rxPipeTo(io.vertx.rxjava.core.streams.WriteStream<io.vertx.core.json.JsonArray> dst) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      pipeTo(dst, fut);
    }));
  }

  public io.vertx.rxjava.ext.sql.SQLRowStream exceptionHandler(io.vertx.core.Handler<java.lang.Throwable> handler) { 
    delegate.exceptionHandler(handler);
    return this;
  }

  public io.vertx.rxjava.ext.sql.SQLRowStream handler(io.vertx.core.Handler<io.vertx.core.json.JsonArray> handler) { 
    delegate.handler(handler);
    return this;
  }

  public io.vertx.rxjava.ext.sql.SQLRowStream pause() { 
    delegate.pause();
    return this;
  }

  public io.vertx.rxjava.ext.sql.SQLRowStream resume() { 
    delegate.resume();
    return this;
  }

  public io.vertx.rxjava.ext.sql.SQLRowStream endHandler(io.vertx.core.Handler<java.lang.Void> endHandler) { 
    delegate.endHandler(endHandler);
    return this;
  }

  /**
   * Will convert the column name to the json array index.
   * @param name the column name
   * @return the json array index
   */
  public int column(java.lang.String name) { 
    int ret = delegate.column(name);
    return ret;
  }

  /**
   * Returns all column names available in the underlying resultset. One needs to carefully use this method since in
   * contrast to the singular version it does not perform case insensitive lookups or takes alias in consideration on
   * the column names.
   * @return the list of columns names returned by the query
   */
  public java.util.List<java.lang.String> columns() { 
    java.util.List<java.lang.String> ret = delegate.columns();
    return ret;
  }

  /**
   * Event handler when a resultset is closed. This is useful to request for more results.
   * @param handler called when the current result set is closed
   * @return 
   */
  public io.vertx.rxjava.ext.sql.SQLRowStream resultSetClosedHandler(io.vertx.core.Handler<java.lang.Void> handler) { 
    delegate.resultSetClosedHandler(handler);
    return this;
  }

  /**
   * Request for more results if available
   */
  public void moreResults() { 
    delegate.moreResults();
  }

  /**
   * Closes the stream/underlying cursor(s). The actual close happens asynchronously.
   */
  public void close() { 
    delegate.close();
  }

  /**
   * Closes the stream/underlying cursor(s). The actual close happens asynchronously.
   * @param handler called when the stream/underlying cursor(s) is(are) closed
   */
  public void close(io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.Void>> handler) { 
    delegate.close(handler);
  }

    /**
   * Closes the stream/underlying cursor(s). The actual close happens asynchronously.
   * @return 
   */
  public rx.Single<java.lang.Void> rxClose() { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      close(fut);
    }));
  }

  public static SQLRowStream newInstance(io.vertx.ext.sql.SQLRowStream arg) {
    return arg != null ? new SQLRowStream(arg) : null;
  }

}
