/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava.ext.sql;

import rx.Observable;
import rx.Single;
import io.vertx.rx.java.RxHelper;
import io.vertx.rx.java.WriteStreamSubscriber;
import io.vertx.rx.java.SingleOnSubscribeAdapter;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * Represents a connection to a SQL database
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.sql.SQLConnection original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.ext.sql.SQLConnection.class)
public class SQLConnection implements io.vertx.rxjava.ext.sql.SQLOperations {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SQLConnection that = (SQLConnection) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<SQLConnection> __TYPE_ARG = new TypeArg<>(    obj -> new SQLConnection((io.vertx.ext.sql.SQLConnection) obj),
    SQLConnection::getDelegate
  );

  private final io.vertx.ext.sql.SQLConnection delegate;
  
  public SQLConnection(io.vertx.ext.sql.SQLConnection delegate) {
    this.delegate = delegate;
  }

  public SQLConnection(Object delegate) {
    this.delegate = (io.vertx.ext.sql.SQLConnection)delegate;
  }

  public io.vertx.ext.sql.SQLConnection getDelegate() {
    return delegate;
  }

  /**
   * Execute a one shot SQL statement that returns a single SQL row. This method will reduce the boilerplate code by
   * getting a connection from the pool (this object) and return it back after the execution. Only the first result
   * from the result set is returned.
   * @param sql the statement to execute
   * @param handler the result handler
   * @return self
   */
  public io.vertx.rxjava.ext.sql.SQLOperations querySingle(java.lang.String sql, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.core.json.JsonArray>> handler) { 
    delegate.querySingle(sql, handler);
    return this;
  }

  /**
   * Execute a one shot SQL statement that returns a single SQL row. This method will reduce the boilerplate code by
   * getting a connection from the pool (this object) and return it back after the execution. Only the first result
   * from the result set is returned.
   * @param sql the statement to execute
   * @return self
   */
  public io.vertx.rxjava.ext.sql.SQLOperations querySingle(java.lang.String sql) {
    return 
querySingle(sql, ar -> { });
  }

    /**
   * Execute a one shot SQL statement that returns a single SQL row. This method will reduce the boilerplate code by
   * getting a connection from the pool (this object) and return it back after the execution. Only the first result
   * from the result set is returned.
   * @param sql the statement to execute
   * @return self
   */
  public rx.Single<io.vertx.core.json.JsonArray> rxQuerySingle(java.lang.String sql) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      querySingle(sql, fut);
    }));
  }

  /**
   * Execute a one shot SQL statement with arguments that returns a single SQL row. This method will reduce the
   * boilerplate code by getting a connection from the pool (this object) and return it back after the execution.
   * Only the first result from the result set is returned.
   * @param sql the statement to execute
   * @param arguments the arguments
   * @param handler the result handler
   * @return self
   */
  public io.vertx.rxjava.ext.sql.SQLOperations querySingleWithParams(java.lang.String sql, io.vertx.core.json.JsonArray arguments, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.core.json.JsonArray>> handler) { 
    delegate.querySingleWithParams(sql, arguments, handler);
    return this;
  }

  /**
   * Execute a one shot SQL statement with arguments that returns a single SQL row. This method will reduce the
   * boilerplate code by getting a connection from the pool (this object) and return it back after the execution.
   * Only the first result from the result set is returned.
   * @param sql the statement to execute
   * @param arguments the arguments
   * @return self
   */
  public io.vertx.rxjava.ext.sql.SQLOperations querySingleWithParams(java.lang.String sql, io.vertx.core.json.JsonArray arguments) {
    return 
querySingleWithParams(sql, arguments, ar -> { });
  }

    /**
   * Execute a one shot SQL statement with arguments that returns a single SQL row. This method will reduce the
   * boilerplate code by getting a connection from the pool (this object) and return it back after the execution.
   * Only the first result from the result set is returned.
   * @param sql the statement to execute
   * @param arguments the arguments
   * @return self
   */
  public rx.Single<io.vertx.core.json.JsonArray> rxQuerySingleWithParams(java.lang.String sql, io.vertx.core.json.JsonArray arguments) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      querySingleWithParams(sql, arguments, fut);
    }));
  }

  /**
   * Sets the desired options to be applied to the current connection when statements are executed.
   *
   * The options are not applied globally but applicable to the current connection. For example changing the transaction
   * isolation level will only affect statements run on this connection and not future or current connections acquired
   * from the connection pool.
   *
   * This method is not async in nature since the apply will only happen at the moment a query is run.
   * @param options the options to modify the unwrapped connection.
   * @return 
   */
  public io.vertx.rxjava.ext.sql.SQLConnection setOptions(io.vertx.ext.sql.SQLOptions options) { 
    delegate.setOptions(options);
    return this;
  }

  /**
   * Sets the auto commit flag for this connection. True by default.
   * @param autoCommit the autoCommit flag, true by default.
   * @param resultHandler the handler which is called once this operation completes.
   * @return 
   */
  public io.vertx.rxjava.ext.sql.SQLConnection setAutoCommit(boolean autoCommit, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.Void>> resultHandler) { 
    delegate.setAutoCommit(autoCommit, resultHandler);
    return this;
  }

  /**
   * Sets the auto commit flag for this connection. True by default.
   * @param autoCommit the autoCommit flag, true by default.
   * @return 
   */
  public io.vertx.rxjava.ext.sql.SQLConnection setAutoCommit(boolean autoCommit) {
    return 
setAutoCommit(autoCommit, ar -> { });
  }

    /**
   * Sets the auto commit flag for this connection. True by default.
   * @param autoCommit the autoCommit flag, true by default.
   * @return 
   */
  public rx.Single<java.lang.Void> rxSetAutoCommit(boolean autoCommit) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      setAutoCommit(autoCommit, fut);
    }));
  }

  /**
   * Executes the given SQL statement
   * @param sql the SQL to execute. For example <code>CREATE TABLE IF EXISTS table ...</code>
   * @param resultHandler the handler which is called once this operation completes.
   * @return 
   */
  public io.vertx.rxjava.ext.sql.SQLConnection execute(java.lang.String sql, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.Void>> resultHandler) { 
    delegate.execute(sql, resultHandler);
    return this;
  }

  /**
   * Executes the given SQL statement
   * @param sql the SQL to execute. For example <code>CREATE TABLE IF EXISTS table ...</code>
   * @return 
   */
  public io.vertx.rxjava.ext.sql.SQLConnection execute(java.lang.String sql) {
    return 
execute(sql, ar -> { });
  }

    /**
   * Executes the given SQL statement
   * @param sql the SQL to execute. For example <code>CREATE TABLE IF EXISTS table ...</code>
   * @return 
   */
  public rx.Single<java.lang.Void> rxExecute(java.lang.String sql) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      execute(sql, fut);
    }));
  }

  /**
   * Executes the given SQL <code>SELECT</code> statement which returns the results of the query.
   * @param sql the SQL to execute. For example <code>SELECT * FROM table ...</code>.
   * @param resultHandler the handler which is called once the operation completes. It will return a <code>ResultSet</code>.
   * @return 
   */
  public io.vertx.rxjava.ext.sql.SQLConnection query(java.lang.String sql, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.ext.sql.ResultSet>> resultHandler) { 
    delegate.query(sql, resultHandler);
    return this;
  }

  /**
   * Executes the given SQL <code>SELECT</code> statement which returns the results of the query.
   * @param sql the SQL to execute. For example <code>SELECT * FROM table ...</code>.
   * @return 
   */
  public io.vertx.rxjava.ext.sql.SQLConnection query(java.lang.String sql) {
    return 
query(sql, ar -> { });
  }

    /**
   * Executes the given SQL <code>SELECT</code> statement which returns the results of the query.
   * @param sql the SQL to execute. For example <code>SELECT * FROM table ...</code>.
   * @return 
   */
  public rx.Single<io.vertx.ext.sql.ResultSet> rxQuery(java.lang.String sql) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      query(sql, fut);
    }));
  }

  /**
   * Executes the given SQL <code>SELECT</code> statement which returns the results of the query as a read stream.
   * @param sql the SQL to execute. For example <code>SELECT * FROM table ...</code>.
   * @param handler the handler which is called once the operation completes. It will return a <code>SQLRowStream</code>.
   * @return 
   */
  public io.vertx.rxjava.ext.sql.SQLConnection queryStream(java.lang.String sql, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.ext.sql.SQLRowStream>> handler) { 
    delegate.queryStream(sql, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.ext.sql.SQLRowStream.newInstance((io.vertx.ext.sql.SQLRowStream)event))));
    return this;
  }

  /**
   * Executes the given SQL <code>SELECT</code> statement which returns the results of the query as a read stream.
   * @param sql the SQL to execute. For example <code>SELECT * FROM table ...</code>.
   * @return 
   */
  public io.vertx.rxjava.ext.sql.SQLConnection queryStream(java.lang.String sql) {
    return 
queryStream(sql, ar -> { });
  }

    /**
   * Executes the given SQL <code>SELECT</code> statement which returns the results of the query as a read stream.
   * @param sql the SQL to execute. For example <code>SELECT * FROM table ...</code>.
   * @return 
   */
  public rx.Single<io.vertx.rxjava.ext.sql.SQLRowStream> rxQueryStream(java.lang.String sql) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      queryStream(sql, fut);
    }));
  }

  /**
   * Executes the given SQL <code>SELECT</code> prepared statement which returns the results of the query.
   * @param sql the SQL to execute. For example <code>SELECT * FROM table ...</code>.
   * @param params these are the parameters to fill the statement.
   * @param resultHandler the handler which is called once the operation completes. It will return a <code>ResultSet</code>.
   * @return 
   */
  public io.vertx.rxjava.ext.sql.SQLConnection queryWithParams(java.lang.String sql, io.vertx.core.json.JsonArray params, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.ext.sql.ResultSet>> resultHandler) { 
    delegate.queryWithParams(sql, params, resultHandler);
    return this;
  }

  /**
   * Executes the given SQL <code>SELECT</code> prepared statement which returns the results of the query.
   * @param sql the SQL to execute. For example <code>SELECT * FROM table ...</code>.
   * @param params these are the parameters to fill the statement.
   * @return 
   */
  public io.vertx.rxjava.ext.sql.SQLConnection queryWithParams(java.lang.String sql, io.vertx.core.json.JsonArray params) {
    return 
queryWithParams(sql, params, ar -> { });
  }

    /**
   * Executes the given SQL <code>SELECT</code> prepared statement which returns the results of the query.
   * @param sql the SQL to execute. For example <code>SELECT * FROM table ...</code>.
   * @param params these are the parameters to fill the statement.
   * @return 
   */
  public rx.Single<io.vertx.ext.sql.ResultSet> rxQueryWithParams(java.lang.String sql, io.vertx.core.json.JsonArray params) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      queryWithParams(sql, params, fut);
    }));
  }

  /**
   * Executes the given SQL <code>SELECT</code> statement which returns the results of the query as a read stream.
   * @param sql the SQL to execute. For example <code>SELECT * FROM table ...</code>.
   * @param params these are the parameters to fill the statement.
   * @param handler the handler which is called once the operation completes. It will return a <code>SQLRowStream</code>.
   * @return 
   */
  public io.vertx.rxjava.ext.sql.SQLConnection queryStreamWithParams(java.lang.String sql, io.vertx.core.json.JsonArray params, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.ext.sql.SQLRowStream>> handler) { 
    delegate.queryStreamWithParams(sql, params, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.ext.sql.SQLRowStream.newInstance((io.vertx.ext.sql.SQLRowStream)event))));
    return this;
  }

  /**
   * Executes the given SQL <code>SELECT</code> statement which returns the results of the query as a read stream.
   * @param sql the SQL to execute. For example <code>SELECT * FROM table ...</code>.
   * @param params these are the parameters to fill the statement.
   * @return 
   */
  public io.vertx.rxjava.ext.sql.SQLConnection queryStreamWithParams(java.lang.String sql, io.vertx.core.json.JsonArray params) {
    return 
queryStreamWithParams(sql, params, ar -> { });
  }

    /**
   * Executes the given SQL <code>SELECT</code> statement which returns the results of the query as a read stream.
   * @param sql the SQL to execute. For example <code>SELECT * FROM table ...</code>.
   * @param params these are the parameters to fill the statement.
   * @return 
   */
  public rx.Single<io.vertx.rxjava.ext.sql.SQLRowStream> rxQueryStreamWithParams(java.lang.String sql, io.vertx.core.json.JsonArray params) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      queryStreamWithParams(sql, params, fut);
    }));
  }

  /**
   * Executes the given SQL statement which may be an <code>INSERT</code>, <code>UPDATE</code>, or <code>DELETE</code>
   * statement.
   * @param sql the SQL to execute. For example <code>INSERT INTO table ...</code>
   * @param resultHandler the handler which is called once the operation completes.
   * @return 
   */
  public io.vertx.rxjava.ext.sql.SQLConnection update(java.lang.String sql, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.ext.sql.UpdateResult>> resultHandler) { 
    delegate.update(sql, resultHandler);
    return this;
  }

  /**
   * Executes the given SQL statement which may be an <code>INSERT</code>, <code>UPDATE</code>, or <code>DELETE</code>
   * statement.
   * @param sql the SQL to execute. For example <code>INSERT INTO table ...</code>
   * @return 
   */
  public io.vertx.rxjava.ext.sql.SQLConnection update(java.lang.String sql) {
    return 
update(sql, ar -> { });
  }

    /**
   * Executes the given SQL statement which may be an <code>INSERT</code>, <code>UPDATE</code>, or <code>DELETE</code>
   * statement.
   * @param sql the SQL to execute. For example <code>INSERT INTO table ...</code>
   * @return 
   */
  public rx.Single<io.vertx.ext.sql.UpdateResult> rxUpdate(java.lang.String sql) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      update(sql, fut);
    }));
  }

  /**
   * Executes the given prepared statement which may be an <code>INSERT</code>, <code>UPDATE</code>, or <code>DELETE</code>
   * statement with the given parameters
   * @param sql the SQL to execute. For example <code>INSERT INTO table ...</code>
   * @param params these are the parameters to fill the statement.
   * @param resultHandler the handler which is called once the operation completes.
   * @return 
   */
  public io.vertx.rxjava.ext.sql.SQLConnection updateWithParams(java.lang.String sql, io.vertx.core.json.JsonArray params, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.ext.sql.UpdateResult>> resultHandler) { 
    delegate.updateWithParams(sql, params, resultHandler);
    return this;
  }

  /**
   * Executes the given prepared statement which may be an <code>INSERT</code>, <code>UPDATE</code>, or <code>DELETE</code>
   * statement with the given parameters
   * @param sql the SQL to execute. For example <code>INSERT INTO table ...</code>
   * @param params these are the parameters to fill the statement.
   * @return 
   */
  public io.vertx.rxjava.ext.sql.SQLConnection updateWithParams(java.lang.String sql, io.vertx.core.json.JsonArray params) {
    return 
updateWithParams(sql, params, ar -> { });
  }

    /**
   * Executes the given prepared statement which may be an <code>INSERT</code>, <code>UPDATE</code>, or <code>DELETE</code>
   * statement with the given parameters
   * @param sql the SQL to execute. For example <code>INSERT INTO table ...</code>
   * @param params these are the parameters to fill the statement.
   * @return 
   */
  public rx.Single<io.vertx.ext.sql.UpdateResult> rxUpdateWithParams(java.lang.String sql, io.vertx.core.json.JsonArray params) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      updateWithParams(sql, params, fut);
    }));
  }

  /**
   * Calls the given SQL <code>PROCEDURE</code> which returns the result from the procedure.
   * @param sql the SQL to execute. For example <code>{call getEmpName}</code>.
   * @param resultHandler the handler which is called once the operation completes. It will return a <code>ResultSet</code>.
   * @return 
   */
  public io.vertx.rxjava.ext.sql.SQLConnection call(java.lang.String sql, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.ext.sql.ResultSet>> resultHandler) { 
    delegate.call(sql, resultHandler);
    return this;
  }

  /**
   * Calls the given SQL <code>PROCEDURE</code> which returns the result from the procedure.
   * @param sql the SQL to execute. For example <code>{call getEmpName}</code>.
   * @return 
   */
  public io.vertx.rxjava.ext.sql.SQLConnection call(java.lang.String sql) {
    return 
call(sql, ar -> { });
  }

    /**
   * Calls the given SQL <code>PROCEDURE</code> which returns the result from the procedure.
   * @param sql the SQL to execute. For example <code>{call getEmpName}</code>.
   * @return 
   */
  public rx.Single<io.vertx.ext.sql.ResultSet> rxCall(java.lang.String sql) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      call(sql, fut);
    }));
  }

  /**
   * Calls the given SQL <code>PROCEDURE</code> which returns the result from the procedure.
   *
   * The index of params and outputs are important for both arrays, for example when dealing with a prodecure that
   * takes the first 2 arguments as input values and the 3 arg as an output then the arrays should be like:
   *
   * <pre>
   *   params = [VALUE1, VALUE2, null]
   *   outputs = [null, null, "VARCHAR"]
   * </pre>
   * @param sql the SQL to execute. For example <code>{call getEmpName (?, ?)}</code>.
   * @param params these are the parameters to fill the statement.
   * @param outputs these are the outputs to fill the statement.
   * @param resultHandler the handler which is called once the operation completes. It will return a <code>ResultSet</code>.
   * @return 
   */
  public io.vertx.rxjava.ext.sql.SQLConnection callWithParams(java.lang.String sql, io.vertx.core.json.JsonArray params, io.vertx.core.json.JsonArray outputs, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.ext.sql.ResultSet>> resultHandler) { 
    delegate.callWithParams(sql, params, outputs, resultHandler);
    return this;
  }

  /**
   * Calls the given SQL <code>PROCEDURE</code> which returns the result from the procedure.
   *
   * The index of params and outputs are important for both arrays, for example when dealing with a prodecure that
   * takes the first 2 arguments as input values and the 3 arg as an output then the arrays should be like:
   *
   * <pre>
   *   params = [VALUE1, VALUE2, null]
   *   outputs = [null, null, "VARCHAR"]
   * </pre>
   * @param sql the SQL to execute. For example <code>{call getEmpName (?, ?)}</code>.
   * @param params these are the parameters to fill the statement.
   * @param outputs these are the outputs to fill the statement.
   * @return 
   */
  public io.vertx.rxjava.ext.sql.SQLConnection callWithParams(java.lang.String sql, io.vertx.core.json.JsonArray params, io.vertx.core.json.JsonArray outputs) {
    return 
callWithParams(sql, params, outputs, ar -> { });
  }

    /**
   * Calls the given SQL <code>PROCEDURE</code> which returns the result from the procedure.
   *
   * The index of params and outputs are important for both arrays, for example when dealing with a prodecure that
   * takes the first 2 arguments as input values and the 3 arg as an output then the arrays should be like:
   *
   * <pre>
   *   params = [VALUE1, VALUE2, null]
   *   outputs = [null, null, "VARCHAR"]
   * </pre>
   * @param sql the SQL to execute. For example <code>{call getEmpName (?, ?)}</code>.
   * @param params these are the parameters to fill the statement.
   * @param outputs these are the outputs to fill the statement.
   * @return 
   */
  public rx.Single<io.vertx.ext.sql.ResultSet> rxCallWithParams(java.lang.String sql, io.vertx.core.json.JsonArray params, io.vertx.core.json.JsonArray outputs) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      callWithParams(sql, params, outputs, fut);
    }));
  }

  /**
   * Closes the connection. Important to always close the connection when you are done so it's returned to the pool.
   * @param handler the handler called when this operation completes.
   */
  public void close(io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.Void>> handler) { 
    delegate.close(handler);
  }

    /**
   * Closes the connection. Important to always close the connection when you are done so it's returned to the pool.
   * @return 
   */
  public rx.Single<java.lang.Void> rxClose() { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      close(fut);
    }));
  }

  /**
   * Closes the connection. Important to always close the connection when you are done so it's returned to the pool.
   */
  public void close() { 
    delegate.close();
  }

  /**
   * Commits all changes made since the previous commit/rollback.
   * @param handler the handler called when this operation completes.
   * @return 
   */
  public io.vertx.rxjava.ext.sql.SQLConnection commit(io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.Void>> handler) { 
    delegate.commit(handler);
    return this;
  }

  /**
   * Commits all changes made since the previous commit/rollback.
   * @return 
   */
  public io.vertx.rxjava.ext.sql.SQLConnection commit() {
    return 
commit(ar -> { });
  }

    /**
   * Commits all changes made since the previous commit/rollback.
   * @return 
   */
  public rx.Single<java.lang.Void> rxCommit() { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      commit(fut);
    }));
  }

  /**
   * Rolls back all changes made since the previous commit/rollback.
   * @param handler the handler called when this operation completes.
   * @return 
   */
  public io.vertx.rxjava.ext.sql.SQLConnection rollback(io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.Void>> handler) { 
    delegate.rollback(handler);
    return this;
  }

  /**
   * Rolls back all changes made since the previous commit/rollback.
   * @return 
   */
  public io.vertx.rxjava.ext.sql.SQLConnection rollback() {
    return 
rollback(ar -> { });
  }

    /**
   * Rolls back all changes made since the previous commit/rollback.
   * @return 
   */
  public rx.Single<java.lang.Void> rxRollback() { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      rollback(fut);
    }));
  }

  /**
   * Sets a connection wide query timeout.
   *
   * It can be over written at any time and becomes active on the next query call.
   * @param timeoutInSeconds the max amount of seconds the query can take to execute.
   * @return 
   */
  @Deprecated()
  public io.vertx.rxjava.ext.sql.SQLConnection setQueryTimeout(int timeoutInSeconds) { 
    delegate.setQueryTimeout(timeoutInSeconds);
    return this;
  }

  /**
   * Batch simple SQL strings and execute the batch where the async result contains a array of Integers.
   * @param sqlStatements sql statement
   * @param handler the result handler
   * @return 
   */
  public io.vertx.rxjava.ext.sql.SQLConnection batch(java.util.List<java.lang.String> sqlStatements, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.util.List<java.lang.Integer>>> handler) { 
    delegate.batch(sqlStatements, handler);
    return this;
  }

  /**
   * Batch simple SQL strings and execute the batch where the async result contains a array of Integers.
   * @param sqlStatements sql statement
   * @return 
   */
  public io.vertx.rxjava.ext.sql.SQLConnection batch(java.util.List<java.lang.String> sqlStatements) {
    return 
batch(sqlStatements, ar -> { });
  }

    /**
   * Batch simple SQL strings and execute the batch where the async result contains a array of Integers.
   * @param sqlStatements sql statement
   * @return 
   */
  public rx.Single<java.util.List<java.lang.Integer>> rxBatch(java.util.List<java.lang.String> sqlStatements) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      batch(sqlStatements, fut);
    }));
  }

  /**
   * Batch a prepared statement with all entries from the args list. Each entry is a batch.
   * The operation completes with the execution of the batch where the async result contains a array of Integers.
   * @param sqlStatement sql statement
   * @param args the prepared statement arguments
   * @param handler the result handler
   * @return 
   */
  public io.vertx.rxjava.ext.sql.SQLConnection batchWithParams(java.lang.String sqlStatement, java.util.List<io.vertx.core.json.JsonArray> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.util.List<java.lang.Integer>>> handler) { 
    delegate.batchWithParams(sqlStatement, args, handler);
    return this;
  }

  /**
   * Batch a prepared statement with all entries from the args list. Each entry is a batch.
   * The operation completes with the execution of the batch where the async result contains a array of Integers.
   * @param sqlStatement sql statement
   * @param args the prepared statement arguments
   * @return 
   */
  public io.vertx.rxjava.ext.sql.SQLConnection batchWithParams(java.lang.String sqlStatement, java.util.List<io.vertx.core.json.JsonArray> args) {
    return 
batchWithParams(sqlStatement, args, ar -> { });
  }

    /**
   * Batch a prepared statement with all entries from the args list. Each entry is a batch.
   * The operation completes with the execution of the batch where the async result contains a array of Integers.
   * @param sqlStatement sql statement
   * @param args the prepared statement arguments
   * @return 
   */
  public rx.Single<java.util.List<java.lang.Integer>> rxBatchWithParams(java.lang.String sqlStatement, java.util.List<io.vertx.core.json.JsonArray> args) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      batchWithParams(sqlStatement, args, fut);
    }));
  }

  /**
   * Batch a callable statement with all entries from the args list. Each entry is a batch.
   * The size of the lists inArgs and outArgs MUST be the equal.
   * The operation completes with the execution of the batch where the async result contains a array of Integers.
   * @param sqlStatement sql statement
   * @param inArgs the callable statement input arguments
   * @param outArgs the callable statement output arguments
   * @param handler the result handler
   * @return 
   */
  public io.vertx.rxjava.ext.sql.SQLConnection batchCallableWithParams(java.lang.String sqlStatement, java.util.List<io.vertx.core.json.JsonArray> inArgs, java.util.List<io.vertx.core.json.JsonArray> outArgs, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.util.List<java.lang.Integer>>> handler) { 
    delegate.batchCallableWithParams(sqlStatement, inArgs, outArgs, handler);
    return this;
  }

  /**
   * Batch a callable statement with all entries from the args list. Each entry is a batch.
   * The size of the lists inArgs and outArgs MUST be the equal.
   * The operation completes with the execution of the batch where the async result contains a array of Integers.
   * @param sqlStatement sql statement
   * @param inArgs the callable statement input arguments
   * @param outArgs the callable statement output arguments
   * @return 
   */
  public io.vertx.rxjava.ext.sql.SQLConnection batchCallableWithParams(java.lang.String sqlStatement, java.util.List<io.vertx.core.json.JsonArray> inArgs, java.util.List<io.vertx.core.json.JsonArray> outArgs) {
    return 
batchCallableWithParams(sqlStatement, inArgs, outArgs, ar -> { });
  }

    /**
   * Batch a callable statement with all entries from the args list. Each entry is a batch.
   * The size of the lists inArgs and outArgs MUST be the equal.
   * The operation completes with the execution of the batch where the async result contains a array of Integers.
   * @param sqlStatement sql statement
   * @param inArgs the callable statement input arguments
   * @param outArgs the callable statement output arguments
   * @return 
   */
  public rx.Single<java.util.List<java.lang.Integer>> rxBatchCallableWithParams(java.lang.String sqlStatement, java.util.List<io.vertx.core.json.JsonArray> inArgs, java.util.List<io.vertx.core.json.JsonArray> outArgs) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      batchCallableWithParams(sqlStatement, inArgs, outArgs, fut);
    }));
  }

  /**
   * Attempts to change the transaction isolation level for this Connection object to the one given.
   *
   * The constants defined in the interface Connection are the possible transaction isolation levels.
   * @param isolation the level of isolation
   * @param handler the handler called when this operation completes.
   * @return 
   */
  public io.vertx.rxjava.ext.sql.SQLConnection setTransactionIsolation(io.vertx.ext.sql.TransactionIsolation isolation, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.Void>> handler) { 
    delegate.setTransactionIsolation(isolation, handler);
    return this;
  }

  /**
   * Attempts to change the transaction isolation level for this Connection object to the one given.
   *
   * The constants defined in the interface Connection are the possible transaction isolation levels.
   * @param isolation the level of isolation
   * @return 
   */
  public io.vertx.rxjava.ext.sql.SQLConnection setTransactionIsolation(io.vertx.ext.sql.TransactionIsolation isolation) {
    return 
setTransactionIsolation(isolation, ar -> { });
  }

    /**
   * Attempts to change the transaction isolation level for this Connection object to the one given.
   *
   * The constants defined in the interface Connection are the possible transaction isolation levels.
   * @param isolation the level of isolation
   * @return 
   */
  public rx.Single<java.lang.Void> rxSetTransactionIsolation(io.vertx.ext.sql.TransactionIsolation isolation) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      setTransactionIsolation(isolation, fut);
    }));
  }

  /**
   * Attempts to return the transaction isolation level for this Connection object to the one given.
   * @param handler the handler called when this operation completes.
   * @return 
   */
  public io.vertx.rxjava.ext.sql.SQLConnection getTransactionIsolation(io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.ext.sql.TransactionIsolation>> handler) { 
    delegate.getTransactionIsolation(handler);
    return this;
  }

  /**
   * Attempts to return the transaction isolation level for this Connection object to the one given.
   * @return 
   */
  public io.vertx.rxjava.ext.sql.SQLConnection getTransactionIsolation() {
    return 
getTransactionIsolation(ar -> { });
  }

    /**
   * Attempts to return the transaction isolation level for this Connection object to the one given.
   * @return 
   */
  public rx.Single<io.vertx.ext.sql.TransactionIsolation> rxGetTransactionIsolation() { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      getTransactionIsolation(fut);
    }));
  }

  public static SQLConnection newInstance(io.vertx.ext.sql.SQLConnection arg) {
    return arg != null ? new SQLConnection(arg) : null;
  }

}
