/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava.ext.shell.command;

import rx.Observable;
import rx.Single;
import io.vertx.rx.java.RxHelper;
import io.vertx.rx.java.WriteStreamSubscriber;
import io.vertx.rx.java.SingleOnSubscribeAdapter;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * A registry that contains the commands known by a shell.<p/>
 *
 * It is a mutable command resolver.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.shell.command.CommandRegistry original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.ext.shell.command.CommandRegistry.class)
public class CommandRegistry extends io.vertx.rxjava.ext.shell.command.CommandResolver {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    CommandRegistry that = (CommandRegistry) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<CommandRegistry> __TYPE_ARG = new TypeArg<>(    obj -> new CommandRegistry((io.vertx.ext.shell.command.CommandRegistry) obj),
    CommandRegistry::getDelegate
  );

  private final io.vertx.ext.shell.command.CommandRegistry delegate;
  
  public CommandRegistry(io.vertx.ext.shell.command.CommandRegistry delegate) {
    super(delegate);
    this.delegate = delegate;
  }

  public CommandRegistry(Object delegate) {
    super((io.vertx.ext.shell.command.CommandRegistry)delegate);
    this.delegate = (io.vertx.ext.shell.command.CommandRegistry)delegate;
  }

  public io.vertx.ext.shell.command.CommandRegistry getDelegate() {
    return delegate;
  }

  /**
   * Get the shared registry for the Vert.x instance.
   * @param vertx the vertx instance
   * @return the shared registry
   */
  public static io.vertx.rxjava.ext.shell.command.CommandRegistry getShared(io.vertx.rxjava.core.Vertx vertx) { 
    io.vertx.rxjava.ext.shell.command.CommandRegistry ret = io.vertx.rxjava.ext.shell.command.CommandRegistry.newInstance((io.vertx.ext.shell.command.CommandRegistry)io.vertx.ext.shell.command.CommandRegistry.getShared(vertx.getDelegate()));
    return ret;
  }

  /**
   * Create a new registry.
   * @param vertx the vertx instance
   * @return the created registry
   */
  public static io.vertx.rxjava.ext.shell.command.CommandRegistry create(io.vertx.rxjava.core.Vertx vertx) { 
    io.vertx.rxjava.ext.shell.command.CommandRegistry ret = io.vertx.rxjava.ext.shell.command.CommandRegistry.newInstance((io.vertx.ext.shell.command.CommandRegistry)io.vertx.ext.shell.command.CommandRegistry.create(vertx.getDelegate()));
    return ret;
  }

  /**
   * Register a command
   * @param command the command to register
   * @param completionHandler notified when the command is registered
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava.ext.shell.command.CommandRegistry registerCommand(io.vertx.rxjava.ext.shell.command.Command command, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.ext.shell.command.Command>> completionHandler) { 
    delegate.registerCommand(command.getDelegate(), new io.vertx.lang.rx.DelegatingHandler<>(completionHandler, ar -> ar.map(event -> io.vertx.rxjava.ext.shell.command.Command.newInstance((io.vertx.ext.shell.command.Command)event))));
    return this;
  }

  /**
   * Register a command
   * @param command the command to register
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava.ext.shell.command.CommandRegistry registerCommand(io.vertx.rxjava.ext.shell.command.Command command) {
    return 
registerCommand(command, ar -> { });
  }

    /**
   * Register a command
   * @param command the command to register
   * @return a reference to this, so the API can be used fluently
   */
  public rx.Single<io.vertx.rxjava.ext.shell.command.Command> rxRegisterCommand(io.vertx.rxjava.ext.shell.command.Command command) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      registerCommand(command, fut);
    }));
  }

  /**
   * Register a list of commands.
   * @param commands the commands to register
   * @param completionHandler notified when the command is registered
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava.ext.shell.command.CommandRegistry registerCommands(java.util.List<io.vertx.rxjava.ext.shell.command.Command> commands, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.util.List<io.vertx.rxjava.ext.shell.command.Command>>> completionHandler) { 
    delegate.registerCommands(commands.stream().map(elt -> elt.getDelegate()).collect(Collectors.toList()), new io.vertx.lang.rx.DelegatingHandler<>(completionHandler, ar -> ar.map(event -> event.stream().map(elt -> io.vertx.rxjava.ext.shell.command.Command.newInstance((io.vertx.ext.shell.command.Command)elt)).collect(Collectors.toList()))));
    return this;
  }

  /**
   * Register a list of commands.
   * @param commands the commands to register
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava.ext.shell.command.CommandRegistry registerCommands(java.util.List<io.vertx.rxjava.ext.shell.command.Command> commands) {
    return 
registerCommands(commands, ar -> { });
  }

    /**
   * Register a list of commands.
   * @param commands the commands to register
   * @return a reference to this, so the API can be used fluently
   */
  public rx.Single<java.util.List<io.vertx.rxjava.ext.shell.command.Command>> rxRegisterCommands(java.util.List<io.vertx.rxjava.ext.shell.command.Command> commands) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      registerCommands(commands, fut);
    }));
  }

  /**
   * Unregister a command.
   * @param commandName the command name
   * @param completionHandler notified when the command is unregistered
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava.ext.shell.command.CommandRegistry unregisterCommand(java.lang.String commandName, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.Void>> completionHandler) { 
    delegate.unregisterCommand(commandName, completionHandler);
    return this;
  }

  /**
   * Unregister a command.
   * @param commandName the command name
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava.ext.shell.command.CommandRegistry unregisterCommand(java.lang.String commandName) {
    return 
unregisterCommand(commandName, ar -> { });
  }

    /**
   * Unregister a command.
   * @param commandName the command name
   * @return a reference to this, so the API can be used fluently
   */
  public rx.Single<java.lang.Void> rxUnregisterCommand(java.lang.String commandName) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      unregisterCommand(commandName, fut);
    }));
  }

  public static CommandRegistry newInstance(io.vertx.ext.shell.command.CommandRegistry arg) {
    return arg != null ? new CommandRegistry(arg) : null;
  }

}
