/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava.ext.shell.command;

import rx.Observable;
import rx.Single;
import io.vertx.rx.java.RxHelper;
import io.vertx.rx.java.WriteStreamSubscriber;
import io.vertx.rx.java.SingleOnSubscribeAdapter;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * The command process provides interaction with the process of the command provided by Vert.x Shell.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.shell.command.CommandProcess original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.ext.shell.command.CommandProcess.class)
public class CommandProcess extends io.vertx.rxjava.ext.shell.term.Tty {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    CommandProcess that = (CommandProcess) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<CommandProcess> __TYPE_ARG = new TypeArg<>(    obj -> new CommandProcess((io.vertx.ext.shell.command.CommandProcess) obj),
    CommandProcess::getDelegate
  );

  private final io.vertx.ext.shell.command.CommandProcess delegate;
  
  public CommandProcess(io.vertx.ext.shell.command.CommandProcess delegate) {
    super(delegate);
    this.delegate = delegate;
  }

  public CommandProcess(Object delegate) {
    super((io.vertx.ext.shell.command.CommandProcess)delegate);
    this.delegate = (io.vertx.ext.shell.command.CommandProcess)delegate;
  }

  public io.vertx.ext.shell.command.CommandProcess getDelegate() {
    return delegate;
  }

  private static final TypeArg<io.vertx.rxjava.ext.shell.cli.CliToken> TYPE_ARG_0 = new TypeArg<io.vertx.rxjava.ext.shell.cli.CliToken>(o1 -> io.vertx.rxjava.ext.shell.cli.CliToken.newInstance((io.vertx.ext.shell.cli.CliToken)o1), o1 -> o1.getDelegate());

  /**
   * @return the current Vert.x instance
   */
  public io.vertx.rxjava.core.Vertx vertx() { 
    io.vertx.rxjava.core.Vertx ret = io.vertx.rxjava.core.Vertx.newInstance((io.vertx.core.Vertx)delegate.vertx());
    return ret;
  }

  /**
   * @return the unparsed arguments tokens
   */
  public java.util.List<io.vertx.rxjava.ext.shell.cli.CliToken> argsTokens() { 
    java.util.List<io.vertx.rxjava.ext.shell.cli.CliToken> ret = delegate.argsTokens().stream().map(elt -> io.vertx.rxjava.ext.shell.cli.CliToken.newInstance((io.vertx.ext.shell.cli.CliToken)elt)).collect(Collectors.toList());
    return ret;
  }

  /**
   * @return the actual string arguments of the command
   */
  public java.util.List<java.lang.String> args() { 
    java.util.List<java.lang.String> ret = delegate.args();
    return ret;
  }

  /**
   * @return the command line object or null
   */
  public io.vertx.rxjava.core.cli.CommandLine commandLine() { 
    io.vertx.rxjava.core.cli.CommandLine ret = io.vertx.rxjava.core.cli.CommandLine.newInstance((io.vertx.core.cli.CommandLine)delegate.commandLine());
    return ret;
  }

  /**
   * @return the shell session
   */
  public io.vertx.rxjava.ext.shell.session.Session session() { 
    io.vertx.rxjava.ext.shell.session.Session ret = io.vertx.rxjava.ext.shell.session.Session.newInstance((io.vertx.ext.shell.session.Session)delegate.session());
    return ret;
  }

  /**
   * @return true if the command is running in foreground
   */
  public boolean isForeground() { 
    boolean ret = delegate.isForeground();
    return ret;
  }

  public io.vertx.rxjava.ext.shell.command.CommandProcess stdinHandler(io.vertx.core.Handler<java.lang.String> handler) { 
    delegate.stdinHandler(handler);
    return this;
  }

  /**
   * Set an interrupt handler, this handler is called when the command is interrupted, for instance user
   * press <code>Ctrl-C</code>.
   * @param handler the interrupt handler
   * @return this command
   */
  public io.vertx.rxjava.ext.shell.command.CommandProcess interruptHandler(io.vertx.core.Handler<java.lang.Void> handler) { 
    delegate.interruptHandler(handler);
    return this;
  }

  /**
   * Set a suspend handler, this handler is called when the command is suspended, for instance user
   * press <code>Ctrl-Z</code>.
   * @param handler the interrupt handler
   * @return this command
   */
  public io.vertx.rxjava.ext.shell.command.CommandProcess suspendHandler(io.vertx.core.Handler<java.lang.Void> handler) { 
    delegate.suspendHandler(handler);
    return this;
  }

  /**
   * Set a resume handler, this handler is called when the command is resumed, for instance user
   * types <code>bg</code> or <code>fg</code> to resume the command.
   * @param handler the interrupt handler
   * @return this command
   */
  public io.vertx.rxjava.ext.shell.command.CommandProcess resumeHandler(io.vertx.core.Handler<java.lang.Void> handler) { 
    delegate.resumeHandler(handler);
    return this;
  }

  /**
   * Set an end handler, this handler is called when the command is ended, for instance the command is running
   * and the shell closes.
   * @param handler the end handler
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava.ext.shell.command.CommandProcess endHandler(io.vertx.core.Handler<java.lang.Void> handler) { 
    delegate.endHandler(handler);
    return this;
  }

  /**
   * Write some text to the standard output.
   * @param data the text
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava.ext.shell.command.CommandProcess write(java.lang.String data) { 
    delegate.write(data);
    return this;
  }

  /**
   * Set a background handler, this handler is called when the command is running and put to background.
   * @param handler the background handler
   * @return this command
   */
  public io.vertx.rxjava.ext.shell.command.CommandProcess backgroundHandler(io.vertx.core.Handler<java.lang.Void> handler) { 
    delegate.backgroundHandler(handler);
    return this;
  }

  /**
   * Set a foreground handler, this handler is called when the command is running and put to foreground.
   * @param handler the foreground handler
   * @return this command
   */
  public io.vertx.rxjava.ext.shell.command.CommandProcess foregroundHandler(io.vertx.core.Handler<java.lang.Void> handler) { 
    delegate.foregroundHandler(handler);
    return this;
  }

  public io.vertx.rxjava.ext.shell.command.CommandProcess resizehandler(io.vertx.core.Handler<java.lang.Void> handler) { 
    delegate.resizehandler(handler);
    return this;
  }

  /**
   * End the process with the exit status 
   */
  public void end() { 
    delegate.end();
  }

  /**
   * End the process.
   * @param status the exit status.
   */
  public void end(int status) { 
    delegate.end(status);
  }

  public static CommandProcess newInstance(io.vertx.ext.shell.command.CommandProcess arg) {
    return arg != null ? new CommandProcess(arg) : null;
  }

}
