/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava.ext.shell.command;

import rx.Observable;
import rx.Single;
import io.vertx.rx.java.RxHelper;
import io.vertx.rx.java.WriteStreamSubscriber;
import io.vertx.rx.java.SingleOnSubscribeAdapter;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * A Vert.x Shell command, it can be created from any language using the {@link io.vertx.rxjava.ext.shell.command.CommandBuilder#command} or from a
 * Java class using {@link io.vertx.rxjava.ext.shell.command.Command#create}
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.shell.command.Command original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.ext.shell.command.Command.class)
public class Command {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    Command that = (Command) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<Command> __TYPE_ARG = new TypeArg<>(    obj -> new Command((io.vertx.ext.shell.command.Command) obj),
    Command::getDelegate
  );

  private final io.vertx.ext.shell.command.Command delegate;
  
  public Command(io.vertx.ext.shell.command.Command delegate) {
    this.delegate = delegate;
  }

  public Command(Object delegate) {
    this.delegate = (io.vertx.ext.shell.command.Command)delegate;
  }

  public io.vertx.ext.shell.command.Command getDelegate() {
    return delegate;
  }

  /**
   * @return the command name
   */
  public java.lang.String name() { 
    java.lang.String ret = delegate.name();
    return ret;
  }

  /**
   * @return the command line interface, can be null
   */
  public io.vertx.rxjava.core.cli.CLI cli() { 
    io.vertx.rxjava.core.cli.CLI ret = io.vertx.rxjava.core.cli.CLI.newInstance((io.vertx.core.cli.CLI)delegate.cli());
    return ret;
  }

  /**
   * Create a new process with empty arguments.
   * @return the process
   */
  public io.vertx.rxjava.ext.shell.system.Process createProcess() { 
    io.vertx.rxjava.ext.shell.system.Process ret = io.vertx.rxjava.ext.shell.system.Process.newInstance((io.vertx.ext.shell.system.Process)delegate.createProcess());
    return ret;
  }

  /**
   * Create a new process with the passed arguments.
   * @param args the process arguments
   * @return the process
   */
  public io.vertx.rxjava.ext.shell.system.Process createProcess(java.util.List<io.vertx.rxjava.ext.shell.cli.CliToken> args) { 
    io.vertx.rxjava.ext.shell.system.Process ret = io.vertx.rxjava.ext.shell.system.Process.newInstance((io.vertx.ext.shell.system.Process)delegate.createProcess(args.stream().map(elt -> elt.getDelegate()).collect(Collectors.toList())));
    return ret;
  }

  /**
   * Perform command completion, when the command is done completing it should call 
   * or  )} method to signal completion is done.
   * @param completion the completion object
   */
  public void complete(io.vertx.rxjava.ext.shell.cli.Completion completion) { 
    delegate.complete(completion.getDelegate());
  }

  public static Command newInstance(io.vertx.ext.shell.command.Command arg) {
    return arg != null ? new Command(arg) : null;
  }

}
