/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava.ext.shell.cli;

import rx.Observable;
import rx.Single;
import io.vertx.rx.java.RxHelper;
import io.vertx.rx.java.WriteStreamSubscriber;
import io.vertx.rx.java.SingleOnSubscribeAdapter;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * A parsed token in the command line interface.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.shell.cli.CliToken original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.ext.shell.cli.CliToken.class)
public class CliToken {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    CliToken that = (CliToken) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<CliToken> __TYPE_ARG = new TypeArg<>(    obj -> new CliToken((io.vertx.ext.shell.cli.CliToken) obj),
    CliToken::getDelegate
  );

  private final io.vertx.ext.shell.cli.CliToken delegate;
  
  public CliToken(io.vertx.ext.shell.cli.CliToken delegate) {
    this.delegate = delegate;
  }

  public CliToken(Object delegate) {
    this.delegate = (io.vertx.ext.shell.cli.CliToken)delegate;
  }

  public io.vertx.ext.shell.cli.CliToken getDelegate() {
    return delegate;
  }

  private static final TypeArg<io.vertx.rxjava.ext.shell.cli.CliToken> TYPE_ARG_0 = new TypeArg<io.vertx.rxjava.ext.shell.cli.CliToken>(o1 -> io.vertx.rxjava.ext.shell.cli.CliToken.newInstance((io.vertx.ext.shell.cli.CliToken)o1), o1 -> o1.getDelegate());

  /**
   * Create a text token.
   * @param text the text
   * @return the token
   */
  public static io.vertx.rxjava.ext.shell.cli.CliToken createText(java.lang.String text) { 
    io.vertx.rxjava.ext.shell.cli.CliToken ret = io.vertx.rxjava.ext.shell.cli.CliToken.newInstance((io.vertx.ext.shell.cli.CliToken)io.vertx.ext.shell.cli.CliToken.createText(text));
    return ret;
  }

  /**
   * Create a new blank token.
   * @param blank the blank value
   * @return the token
   */
  public static io.vertx.rxjava.ext.shell.cli.CliToken createBlank(java.lang.String blank) { 
    io.vertx.rxjava.ext.shell.cli.CliToken ret = io.vertx.rxjava.ext.shell.cli.CliToken.newInstance((io.vertx.ext.shell.cli.CliToken)io.vertx.ext.shell.cli.CliToken.createBlank(blank));
    return ret;
  }

  /**
   * @return the token value
   */
  public java.lang.String value() { 
    java.lang.String ret = delegate.value();
    return ret;
  }

  /**
   * @return the raw token value, that may contain unescaped chars, for instance 
   */
  public java.lang.String raw() { 
    java.lang.String ret = delegate.raw();
    return ret;
  }

  /**
   * @return true when it's a text token
   */
  public boolean isText() { 
    boolean ret = delegate.isText();
    return ret;
  }

  /**
   * @return true when it's a blank token
   */
  public boolean isBlank() { 
    boolean ret = delegate.isBlank();
    return ret;
  }

  /**
   * Tokenize the string argument and return a list of tokens.
   * @param s the tokenized string
   * @return the tokens
   */
  public static java.util.List<io.vertx.rxjava.ext.shell.cli.CliToken> tokenize(java.lang.String s) { 
    java.util.List<io.vertx.rxjava.ext.shell.cli.CliToken> ret = io.vertx.ext.shell.cli.CliToken.tokenize(s).stream().map(elt -> io.vertx.rxjava.ext.shell.cli.CliToken.newInstance((io.vertx.ext.shell.cli.CliToken)elt)).collect(Collectors.toList());
    return ret;
  }

  public static CliToken newInstance(io.vertx.ext.shell.cli.CliToken arg) {
    return arg != null ? new CliToken(arg) : null;
  }

}
