/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava.ext.shell;

import rx.Observable;
import rx.Single;
import io.vertx.rx.java.RxHelper;
import io.vertx.rx.java.WriteStreamSubscriber;
import io.vertx.rx.java.SingleOnSubscribeAdapter;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * The shell service, provides a remotely accessible shell available via Telnet or SSH according to the
 * {@link io.vertx.ext.shell.ShellServiceOptions} configuration.<p/>
 *
 * The shell service will expose commands using {@link io.vertx.rxjava.ext.shell.command.CommandResolver} on the classpath and
 * the shared command registry for the Vert.x instance.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.shell.ShellService original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.ext.shell.ShellService.class)
public class ShellService {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ShellService that = (ShellService) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<ShellService> __TYPE_ARG = new TypeArg<>(    obj -> new ShellService((io.vertx.ext.shell.ShellService) obj),
    ShellService::getDelegate
  );

  private final io.vertx.ext.shell.ShellService delegate;
  
  public ShellService(io.vertx.ext.shell.ShellService delegate) {
    this.delegate = delegate;
  }

  public ShellService(Object delegate) {
    this.delegate = (io.vertx.ext.shell.ShellService)delegate;
  }

  public io.vertx.ext.shell.ShellService getDelegate() {
    return delegate;
  }

  /**
   * Like {@link io.vertx.rxjava.ext.shell.ShellService#create}, with default options.
   * @param vertx 
   * @return 
   */
  public static io.vertx.rxjava.ext.shell.ShellService create(io.vertx.rxjava.core.Vertx vertx) { 
    io.vertx.rxjava.ext.shell.ShellService ret = io.vertx.rxjava.ext.shell.ShellService.newInstance((io.vertx.ext.shell.ShellService)io.vertx.ext.shell.ShellService.create(vertx.getDelegate()));
    return ret;
  }

  /**
   * Create a new shell service.
   * @param vertx the Vert.x instance
   * @param options the service config options
   * @return the shell service
   */
  public static io.vertx.rxjava.ext.shell.ShellService create(io.vertx.rxjava.core.Vertx vertx, io.vertx.ext.shell.ShellServiceOptions options) { 
    io.vertx.rxjava.ext.shell.ShellService ret = io.vertx.rxjava.ext.shell.ShellService.newInstance((io.vertx.ext.shell.ShellService)io.vertx.ext.shell.ShellService.create(vertx.getDelegate(), options));
    return ret;
  }

  /**
   * Start the shell service, this is an asynchronous start.
   * @param startHandler handler for getting notified when service is started
   */
  public void start(io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.Void>> startHandler) { 
    delegate.start(startHandler);
  }

  /**
   * Start the shell service, this is an asynchronous start.
   */
  public void start() {
    start(ar -> { });
  }

    /**
   * Start the shell service, this is an asynchronous start.
   * @return 
   */
  public rx.Single<java.lang.Void> rxStart() { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      start(fut);
    }));
  }

  /**
   * @return the shell server
   */
  public io.vertx.rxjava.ext.shell.ShellServer server() { 
    io.vertx.rxjava.ext.shell.ShellServer ret = io.vertx.rxjava.ext.shell.ShellServer.newInstance((io.vertx.ext.shell.ShellServer)delegate.server());
    return ret;
  }

  /**
   * Stop the shell service, this is an asynchronous start.
   * @param stopHandler handler for getting notified when service is stopped
   */
  public void stop(io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.Void>> stopHandler) { 
    delegate.stop(stopHandler);
  }

  /**
   * Stop the shell service, this is an asynchronous start.
   */
  public void stop() {
    stop(ar -> { });
  }

    /**
   * Stop the shell service, this is an asynchronous start.
   * @return 
   */
  public rx.Single<java.lang.Void> rxStop() { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      stop(fut);
    }));
  }

  public static ShellService newInstance(io.vertx.ext.shell.ShellService arg) {
    return arg != null ? new ShellService(arg) : null;
  }

}
