/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava.ext.mongo;

import rx.Observable;
import rx.Single;
import io.vertx.rx.java.RxHelper;
import io.vertx.rx.java.WriteStreamSubscriber;
import io.vertx.rx.java.SingleOnSubscribeAdapter;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * A Vert.x service used to interact with MongoDB server instances.
 * <p>
 * Some of the operations might change <i>_id</i> field of passed  document.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.mongo.MongoClient original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.ext.mongo.MongoClient.class)
public class MongoClient {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    MongoClient that = (MongoClient) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<MongoClient> __TYPE_ARG = new TypeArg<>(    obj -> new MongoClient((io.vertx.ext.mongo.MongoClient) obj),
    MongoClient::getDelegate
  );

  private final io.vertx.ext.mongo.MongoClient delegate;
  
  public MongoClient(io.vertx.ext.mongo.MongoClient delegate) {
    this.delegate = delegate;
  }

  public MongoClient(Object delegate) {
    this.delegate = (io.vertx.ext.mongo.MongoClient)delegate;
  }

  public io.vertx.ext.mongo.MongoClient getDelegate() {
    return delegate;
  }


  /**
   * Create a Mongo client which maintains its own data source.
   * @param vertx the Vert.x instance
   * @param config the configuration
   * @return the client
   */
  public static io.vertx.rxjava.ext.mongo.MongoClient create(io.vertx.rxjava.core.Vertx vertx, io.vertx.core.json.JsonObject config) { 
    io.vertx.rxjava.ext.mongo.MongoClient ret = io.vertx.rxjava.ext.mongo.MongoClient.newInstance((io.vertx.ext.mongo.MongoClient)io.vertx.ext.mongo.MongoClient.create(vertx.getDelegate(), config));
    return ret;
  }

  /**
   * Create a Mongo client which shares its data source with any other Mongo clients created with the same
   * data source name
   * @param vertx the Vert.x instance
   * @param config the configuration
   * @param dataSourceName the data source name
   * @return the client
   */
  public static io.vertx.rxjava.ext.mongo.MongoClient createShared(io.vertx.rxjava.core.Vertx vertx, io.vertx.core.json.JsonObject config, java.lang.String dataSourceName) { 
    io.vertx.rxjava.ext.mongo.MongoClient ret = io.vertx.rxjava.ext.mongo.MongoClient.newInstance((io.vertx.ext.mongo.MongoClient)io.vertx.ext.mongo.MongoClient.createShared(vertx.getDelegate(), config, dataSourceName));
    return ret;
  }

  /**
   * Like {@link io.vertx.rxjava.ext.mongo.MongoClient#createShared} but with the default data source name
   * @param vertx the Vert.x instance
   * @param config the configuration
   * @return the client
   */
  public static io.vertx.rxjava.ext.mongo.MongoClient createShared(io.vertx.rxjava.core.Vertx vertx, io.vertx.core.json.JsonObject config) { 
    io.vertx.rxjava.ext.mongo.MongoClient ret = io.vertx.rxjava.ext.mongo.MongoClient.newInstance((io.vertx.ext.mongo.MongoClient)io.vertx.ext.mongo.MongoClient.createShared(vertx.getDelegate(), config));
    return ret;
  }

  /**
   * Save a document in the specified collection
   * <p>
   * This operation might change <i>_id</i> field of <i>document</i> parameter
   * @param collection the collection
   * @param document the document
   * @param resultHandler result handler will be provided with the id if document didn't already have one
   * @return 
   */
  public io.vertx.rxjava.ext.mongo.MongoClient save(java.lang.String collection, io.vertx.core.json.JsonObject document, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.String>> resultHandler) { 
    delegate.save(collection, document, resultHandler);
    return this;
  }

  /**
   * Save a document in the specified collection
   * <p>
   * This operation might change <i>_id</i> field of <i>document</i> parameter
   * @param collection the collection
   * @param document the document
   * @return 
   */
  public io.vertx.rxjava.ext.mongo.MongoClient save(java.lang.String collection, io.vertx.core.json.JsonObject document) {
    return 
save(collection, document, ar -> { });
  }

    /**
   * Save a document in the specified collection
   * <p>
   * This operation might change <i>_id</i> field of <i>document</i> parameter
   * @param collection the collection
   * @param document the document
   * @return 
   */
  public rx.Single<java.lang.String> rxSave(java.lang.String collection, io.vertx.core.json.JsonObject document) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      save(collection, document, fut);
    }));
  }

  /**
   * Save a document in the specified collection with the specified write option
   * <p>
   * This operation might change <i>_id</i> field of <i>document</i> parameter
   * @param collection the collection
   * @param document the document
   * @param writeOption the write option to use
   * @param resultHandler result handler will be provided with the id if document didn't already have one
   * @return 
   */
  public io.vertx.rxjava.ext.mongo.MongoClient saveWithOptions(java.lang.String collection, io.vertx.core.json.JsonObject document, io.vertx.ext.mongo.WriteOption writeOption, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.String>> resultHandler) { 
    delegate.saveWithOptions(collection, document, writeOption, resultHandler);
    return this;
  }

  /**
   * Save a document in the specified collection with the specified write option
   * <p>
   * This operation might change <i>_id</i> field of <i>document</i> parameter
   * @param collection the collection
   * @param document the document
   * @param writeOption the write option to use
   * @return 
   */
  public io.vertx.rxjava.ext.mongo.MongoClient saveWithOptions(java.lang.String collection, io.vertx.core.json.JsonObject document, io.vertx.ext.mongo.WriteOption writeOption) {
    return 
saveWithOptions(collection, document, writeOption, ar -> { });
  }

    /**
   * Save a document in the specified collection with the specified write option
   * <p>
   * This operation might change <i>_id</i> field of <i>document</i> parameter
   * @param collection the collection
   * @param document the document
   * @param writeOption the write option to use
   * @return 
   */
  public rx.Single<java.lang.String> rxSaveWithOptions(java.lang.String collection, io.vertx.core.json.JsonObject document, io.vertx.ext.mongo.WriteOption writeOption) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      saveWithOptions(collection, document, writeOption, fut);
    }));
  }

  /**
   * Insert a document in the specified collection
   * <p>
   * This operation might change <i>_id</i> field of <i>document</i> parameter
   * @param collection the collection
   * @param document the document
   * @param resultHandler result handler will be provided with the id if document didn't already have one
   * @return 
   */
  public io.vertx.rxjava.ext.mongo.MongoClient insert(java.lang.String collection, io.vertx.core.json.JsonObject document, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.String>> resultHandler) { 
    delegate.insert(collection, document, resultHandler);
    return this;
  }

  /**
   * Insert a document in the specified collection
   * <p>
   * This operation might change <i>_id</i> field of <i>document</i> parameter
   * @param collection the collection
   * @param document the document
   * @return 
   */
  public io.vertx.rxjava.ext.mongo.MongoClient insert(java.lang.String collection, io.vertx.core.json.JsonObject document) {
    return 
insert(collection, document, ar -> { });
  }

    /**
   * Insert a document in the specified collection
   * <p>
   * This operation might change <i>_id</i> field of <i>document</i> parameter
   * @param collection the collection
   * @param document the document
   * @return 
   */
  public rx.Single<java.lang.String> rxInsert(java.lang.String collection, io.vertx.core.json.JsonObject document) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      insert(collection, document, fut);
    }));
  }

  /**
   * Insert a document in the specified collection with the specified write option
   * <p>
   * This operation might change <i>_id</i> field of <i>document</i> parameter
   * @param collection the collection
   * @param document the document
   * @param writeOption the write option to use
   * @param resultHandler result handler will be provided with the id if document didn't already have one
   * @return 
   */
  public io.vertx.rxjava.ext.mongo.MongoClient insertWithOptions(java.lang.String collection, io.vertx.core.json.JsonObject document, io.vertx.ext.mongo.WriteOption writeOption, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.String>> resultHandler) { 
    delegate.insertWithOptions(collection, document, writeOption, resultHandler);
    return this;
  }

  /**
   * Insert a document in the specified collection with the specified write option
   * <p>
   * This operation might change <i>_id</i> field of <i>document</i> parameter
   * @param collection the collection
   * @param document the document
   * @param writeOption the write option to use
   * @return 
   */
  public io.vertx.rxjava.ext.mongo.MongoClient insertWithOptions(java.lang.String collection, io.vertx.core.json.JsonObject document, io.vertx.ext.mongo.WriteOption writeOption) {
    return 
insertWithOptions(collection, document, writeOption, ar -> { });
  }

    /**
   * Insert a document in the specified collection with the specified write option
   * <p>
   * This operation might change <i>_id</i> field of <i>document</i> parameter
   * @param collection the collection
   * @param document the document
   * @param writeOption the write option to use
   * @return 
   */
  public rx.Single<java.lang.String> rxInsertWithOptions(java.lang.String collection, io.vertx.core.json.JsonObject document, io.vertx.ext.mongo.WriteOption writeOption) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      insertWithOptions(collection, document, writeOption, fut);
    }));
  }

  /**
   * Update matching documents in the specified collection and return the handler with <code>MongoClientUpdateResult</code> result
   * @param collection the collection
   * @param query query used to match the documents
   * @param update used to describe how the documents will be updated
   * @param resultHandler will be called with a {@link io.vertx.ext.mongo.MongoClientUpdateResult} when complete
   * @return 
   */
  public io.vertx.rxjava.ext.mongo.MongoClient updateCollection(java.lang.String collection, io.vertx.core.json.JsonObject query, io.vertx.core.json.JsonObject update, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.ext.mongo.MongoClientUpdateResult>> resultHandler) { 
    delegate.updateCollection(collection, query, update, resultHandler);
    return this;
  }

  /**
   * Update matching documents in the specified collection and return the handler with <code>MongoClientUpdateResult</code> result
   * @param collection the collection
   * @param query query used to match the documents
   * @param update used to describe how the documents will be updated
   * @return 
   */
  public io.vertx.rxjava.ext.mongo.MongoClient updateCollection(java.lang.String collection, io.vertx.core.json.JsonObject query, io.vertx.core.json.JsonObject update) {
    return 
updateCollection(collection, query, update, ar -> { });
  }

    /**
   * Update matching documents in the specified collection and return the handler with <code>MongoClientUpdateResult</code> result
   * @param collection the collection
   * @param query query used to match the documents
   * @param update used to describe how the documents will be updated
   * @return 
   */
  public rx.Single<io.vertx.ext.mongo.MongoClientUpdateResult> rxUpdateCollection(java.lang.String collection, io.vertx.core.json.JsonObject query, io.vertx.core.json.JsonObject update) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      updateCollection(collection, query, update, fut);
    }));
  }

  /**
   * Use an aggregation pipeline to update documents in the specified collection and return the handler with <code>MongoClientUpdateResult</code> result
   * @param collection the collection
   * @param query query used to match the documents
   * @param update used to describe how the documents will be updated
   * @param resultHandler will be called with a {@link io.vertx.ext.mongo.MongoClientUpdateResult} when complete
   * @return 
   */
  public io.vertx.rxjava.ext.mongo.MongoClient updateCollection(java.lang.String collection, io.vertx.core.json.JsonObject query, io.vertx.core.json.JsonArray update, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.ext.mongo.MongoClientUpdateResult>> resultHandler) { 
    delegate.updateCollection(collection, query, update, resultHandler);
    return this;
  }

  /**
   * Use an aggregation pipeline to update documents in the specified collection and return the handler with <code>MongoClientUpdateResult</code> result
   * @param collection the collection
   * @param query query used to match the documents
   * @param update used to describe how the documents will be updated
   * @return 
   */
  public io.vertx.rxjava.ext.mongo.MongoClient updateCollection(java.lang.String collection, io.vertx.core.json.JsonObject query, io.vertx.core.json.JsonArray update) {
    return 
updateCollection(collection, query, update, ar -> { });
  }

    /**
   * Use an aggregation pipeline to update documents in the specified collection and return the handler with <code>MongoClientUpdateResult</code> result
   * @param collection the collection
   * @param query query used to match the documents
   * @param update used to describe how the documents will be updated
   * @return 
   */
  public rx.Single<io.vertx.ext.mongo.MongoClientUpdateResult> rxUpdateCollection(java.lang.String collection, io.vertx.core.json.JsonObject query, io.vertx.core.json.JsonArray update) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      updateCollection(collection, query, update, fut);
    }));
  }

  /**
   * Update matching documents in the specified collection, specifying options and return the handler with <code>MongoClientUpdateResult</code> result
   * @param collection the collection
   * @param query query used to match the documents
   * @param update used to describe how the documents will be updated
   * @param options options to configure the update
   * @param resultHandler will be called with a {@link io.vertx.ext.mongo.MongoClientUpdateResult} when complete
   * @return 
   */
  public io.vertx.rxjava.ext.mongo.MongoClient updateCollectionWithOptions(java.lang.String collection, io.vertx.core.json.JsonObject query, io.vertx.core.json.JsonObject update, io.vertx.ext.mongo.UpdateOptions options, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.ext.mongo.MongoClientUpdateResult>> resultHandler) { 
    delegate.updateCollectionWithOptions(collection, query, update, options, resultHandler);
    return this;
  }

  /**
   * Update matching documents in the specified collection, specifying options and return the handler with <code>MongoClientUpdateResult</code> result
   * @param collection the collection
   * @param query query used to match the documents
   * @param update used to describe how the documents will be updated
   * @param options options to configure the update
   * @return 
   */
  public io.vertx.rxjava.ext.mongo.MongoClient updateCollectionWithOptions(java.lang.String collection, io.vertx.core.json.JsonObject query, io.vertx.core.json.JsonObject update, io.vertx.ext.mongo.UpdateOptions options) {
    return 
updateCollectionWithOptions(collection, query, update, options, ar -> { });
  }

    /**
   * Update matching documents in the specified collection, specifying options and return the handler with <code>MongoClientUpdateResult</code> result
   * @param collection the collection
   * @param query query used to match the documents
   * @param update used to describe how the documents will be updated
   * @param options options to configure the update
   * @return 
   */
  public rx.Single<io.vertx.ext.mongo.MongoClientUpdateResult> rxUpdateCollectionWithOptions(java.lang.String collection, io.vertx.core.json.JsonObject query, io.vertx.core.json.JsonObject update, io.vertx.ext.mongo.UpdateOptions options) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      updateCollectionWithOptions(collection, query, update, options, fut);
    }));
  }

  /**
   * Use an aggregation pipeline to update documents in the specified collection, specifying options and return the handler with <code>MongoClientUpdateResult</code> result
   * @param collection the collection
   * @param query query used to match the documents
   * @param update aggregation pipeline used to describe how documents will be updated
   * @param options options to configure the update
   * @param resultHandler will be called with a {@link io.vertx.ext.mongo.MongoClientUpdateResult} when complete
   * @return 
   */
  public io.vertx.rxjava.ext.mongo.MongoClient updateCollectionWithOptions(java.lang.String collection, io.vertx.core.json.JsonObject query, io.vertx.core.json.JsonArray update, io.vertx.ext.mongo.UpdateOptions options, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.ext.mongo.MongoClientUpdateResult>> resultHandler) { 
    delegate.updateCollectionWithOptions(collection, query, update, options, resultHandler);
    return this;
  }

  /**
   * Use an aggregation pipeline to update documents in the specified collection, specifying options and return the handler with <code>MongoClientUpdateResult</code> result
   * @param collection the collection
   * @param query query used to match the documents
   * @param update aggregation pipeline used to describe how documents will be updated
   * @param options options to configure the update
   * @return 
   */
  public io.vertx.rxjava.ext.mongo.MongoClient updateCollectionWithOptions(java.lang.String collection, io.vertx.core.json.JsonObject query, io.vertx.core.json.JsonArray update, io.vertx.ext.mongo.UpdateOptions options) {
    return 
updateCollectionWithOptions(collection, query, update, options, ar -> { });
  }

    /**
   * Use an aggregation pipeline to update documents in the specified collection, specifying options and return the handler with <code>MongoClientUpdateResult</code> result
   * @param collection the collection
   * @param query query used to match the documents
   * @param update aggregation pipeline used to describe how documents will be updated
   * @param options options to configure the update
   * @return 
   */
  public rx.Single<io.vertx.ext.mongo.MongoClientUpdateResult> rxUpdateCollectionWithOptions(java.lang.String collection, io.vertx.core.json.JsonObject query, io.vertx.core.json.JsonArray update, io.vertx.ext.mongo.UpdateOptions options) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      updateCollectionWithOptions(collection, query, update, options, fut);
    }));
  }

  /**
   * Replace matching documents in the specified collection and return the handler with <code>MongoClientUpdateResult</code> result
   * @param collection the collection
   * @param query query used to match the documents
   * @param replace all matching documents will be replaced with this
   * @param resultHandler will be called with a {@link io.vertx.ext.mongo.MongoClientUpdateResult} when complete
   * @return 
   */
  public io.vertx.rxjava.ext.mongo.MongoClient replaceDocuments(java.lang.String collection, io.vertx.core.json.JsonObject query, io.vertx.core.json.JsonObject replace, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.ext.mongo.MongoClientUpdateResult>> resultHandler) { 
    delegate.replaceDocuments(collection, query, replace, resultHandler);
    return this;
  }

  /**
   * Replace matching documents in the specified collection and return the handler with <code>MongoClientUpdateResult</code> result
   * @param collection the collection
   * @param query query used to match the documents
   * @param replace all matching documents will be replaced with this
   * @return 
   */
  public io.vertx.rxjava.ext.mongo.MongoClient replaceDocuments(java.lang.String collection, io.vertx.core.json.JsonObject query, io.vertx.core.json.JsonObject replace) {
    return 
replaceDocuments(collection, query, replace, ar -> { });
  }

    /**
   * Replace matching documents in the specified collection and return the handler with <code>MongoClientUpdateResult</code> result
   * @param collection the collection
   * @param query query used to match the documents
   * @param replace all matching documents will be replaced with this
   * @return 
   */
  public rx.Single<io.vertx.ext.mongo.MongoClientUpdateResult> rxReplaceDocuments(java.lang.String collection, io.vertx.core.json.JsonObject query, io.vertx.core.json.JsonObject replace) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      replaceDocuments(collection, query, replace, fut);
    }));
  }

  /**
   * Replace matching documents in the specified collection, specifying options and return the handler with <code>MongoClientUpdateResult</code> result
   * @param collection the collection
   * @param query query used to match the documents
   * @param replace all matching documents will be replaced with this
   * @param options options to configure the replace
   * @param resultHandler will be called with a {@link io.vertx.ext.mongo.MongoClientUpdateResult} when complete
   * @return 
   */
  public io.vertx.rxjava.ext.mongo.MongoClient replaceDocumentsWithOptions(java.lang.String collection, io.vertx.core.json.JsonObject query, io.vertx.core.json.JsonObject replace, io.vertx.ext.mongo.UpdateOptions options, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.ext.mongo.MongoClientUpdateResult>> resultHandler) { 
    delegate.replaceDocumentsWithOptions(collection, query, replace, options, resultHandler);
    return this;
  }

  /**
   * Replace matching documents in the specified collection, specifying options and return the handler with <code>MongoClientUpdateResult</code> result
   * @param collection the collection
   * @param query query used to match the documents
   * @param replace all matching documents will be replaced with this
   * @param options options to configure the replace
   * @return 
   */
  public io.vertx.rxjava.ext.mongo.MongoClient replaceDocumentsWithOptions(java.lang.String collection, io.vertx.core.json.JsonObject query, io.vertx.core.json.JsonObject replace, io.vertx.ext.mongo.UpdateOptions options) {
    return 
replaceDocumentsWithOptions(collection, query, replace, options, ar -> { });
  }

    /**
   * Replace matching documents in the specified collection, specifying options and return the handler with <code>MongoClientUpdateResult</code> result
   * @param collection the collection
   * @param query query used to match the documents
   * @param replace all matching documents will be replaced with this
   * @param options options to configure the replace
   * @return 
   */
  public rx.Single<io.vertx.ext.mongo.MongoClientUpdateResult> rxReplaceDocumentsWithOptions(java.lang.String collection, io.vertx.core.json.JsonObject query, io.vertx.core.json.JsonObject replace, io.vertx.ext.mongo.UpdateOptions options) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      replaceDocumentsWithOptions(collection, query, replace, options, fut);
    }));
  }

  /**
   * Execute a bulk operation. Can insert, update, replace, and/or delete multiple documents with one request.
   * @param collection the collection
   * @param operations the operations to execute
   * @param resultHandler will be called with a {@link io.vertx.ext.mongo.MongoClientBulkWriteResult} when complete
   * @return 
   */
  public io.vertx.rxjava.ext.mongo.MongoClient bulkWrite(java.lang.String collection, java.util.List<io.vertx.ext.mongo.BulkOperation> operations, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.ext.mongo.MongoClientBulkWriteResult>> resultHandler) { 
    delegate.bulkWrite(collection, operations, resultHandler);
    return this;
  }

  /**
   * Execute a bulk operation. Can insert, update, replace, and/or delete multiple documents with one request.
   * @param collection the collection
   * @param operations the operations to execute
   * @return 
   */
  public io.vertx.rxjava.ext.mongo.MongoClient bulkWrite(java.lang.String collection, java.util.List<io.vertx.ext.mongo.BulkOperation> operations) {
    return 
bulkWrite(collection, operations, ar -> { });
  }

    /**
   * Execute a bulk operation. Can insert, update, replace, and/or delete multiple documents with one request.
   * @param collection the collection
   * @param operations the operations to execute
   * @return 
   */
  public rx.Single<io.vertx.ext.mongo.MongoClientBulkWriteResult> rxBulkWrite(java.lang.String collection, java.util.List<io.vertx.ext.mongo.BulkOperation> operations) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      bulkWrite(collection, operations, fut);
    }));
  }

  /**
   * Execute a bulk operation with the specified write options. Can insert, update, replace, and/or delete multiple
   * documents with one request.
   * @param collection the collection
   * @param operations the operations to execute
   * @param bulkWriteOptions the write options
   * @param resultHandler will be called with a {@link io.vertx.ext.mongo.MongoClientBulkWriteResult} when complete
   * @return 
   */
  public io.vertx.rxjava.ext.mongo.MongoClient bulkWriteWithOptions(java.lang.String collection, java.util.List<io.vertx.ext.mongo.BulkOperation> operations, io.vertx.ext.mongo.BulkWriteOptions bulkWriteOptions, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.ext.mongo.MongoClientBulkWriteResult>> resultHandler) { 
    delegate.bulkWriteWithOptions(collection, operations, bulkWriteOptions, resultHandler);
    return this;
  }

  /**
   * Execute a bulk operation with the specified write options. Can insert, update, replace, and/or delete multiple
   * documents with one request.
   * @param collection the collection
   * @param operations the operations to execute
   * @param bulkWriteOptions the write options
   * @return 
   */
  public io.vertx.rxjava.ext.mongo.MongoClient bulkWriteWithOptions(java.lang.String collection, java.util.List<io.vertx.ext.mongo.BulkOperation> operations, io.vertx.ext.mongo.BulkWriteOptions bulkWriteOptions) {
    return 
bulkWriteWithOptions(collection, operations, bulkWriteOptions, ar -> { });
  }

    /**
   * Execute a bulk operation with the specified write options. Can insert, update, replace, and/or delete multiple
   * documents with one request.
   * @param collection the collection
   * @param operations the operations to execute
   * @param bulkWriteOptions the write options
   * @return 
   */
  public rx.Single<io.vertx.ext.mongo.MongoClientBulkWriteResult> rxBulkWriteWithOptions(java.lang.String collection, java.util.List<io.vertx.ext.mongo.BulkOperation> operations, io.vertx.ext.mongo.BulkWriteOptions bulkWriteOptions) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      bulkWriteWithOptions(collection, operations, bulkWriteOptions, fut);
    }));
  }

  /**
   * Find matching documents in the specified collection
   * @param collection the collection
   * @param query query used to match documents
   * @param resultHandler will be provided with list of documents
   * @return 
   */
  public io.vertx.rxjava.ext.mongo.MongoClient find(java.lang.String collection, io.vertx.core.json.JsonObject query, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.util.List<io.vertx.core.json.JsonObject>>> resultHandler) { 
    delegate.find(collection, query, resultHandler);
    return this;
  }

  /**
   * Find matching documents in the specified collection
   * @param collection the collection
   * @param query query used to match documents
   * @return 
   */
  public io.vertx.rxjava.ext.mongo.MongoClient find(java.lang.String collection, io.vertx.core.json.JsonObject query) {
    return 
find(collection, query, ar -> { });
  }

    /**
   * Find matching documents in the specified collection
   * @param collection the collection
   * @param query query used to match documents
   * @return 
   */
  public rx.Single<java.util.List<io.vertx.core.json.JsonObject>> rxFind(java.lang.String collection, io.vertx.core.json.JsonObject query) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      find(collection, query, fut);
    }));
  }

  /**
   * Find matching documents in the specified collection.
   * This method use batchCursor for returning each found document.
   * @param collection the collection
   * @param query query used to match documents
   * @return a  emitting found documents
   */
  public io.vertx.rxjava.core.streams.ReadStream<io.vertx.core.json.JsonObject> findBatch(java.lang.String collection, io.vertx.core.json.JsonObject query) { 
    io.vertx.rxjava.core.streams.ReadStream<io.vertx.core.json.JsonObject> ret = io.vertx.rxjava.core.streams.ReadStream.newInstance((io.vertx.core.streams.ReadStream)delegate.findBatch(collection, query), TypeArg.unknown());
    return ret;
  }

  /**
   * Find matching documents in the specified collection, specifying options
   * @param collection the collection
   * @param query query used to match documents
   * @param options options to configure the find
   * @param resultHandler will be provided with list of documents
   * @return 
   */
  public io.vertx.rxjava.ext.mongo.MongoClient findWithOptions(java.lang.String collection, io.vertx.core.json.JsonObject query, io.vertx.ext.mongo.FindOptions options, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.util.List<io.vertx.core.json.JsonObject>>> resultHandler) { 
    delegate.findWithOptions(collection, query, options, resultHandler);
    return this;
  }

  /**
   * Find matching documents in the specified collection, specifying options
   * @param collection the collection
   * @param query query used to match documents
   * @param options options to configure the find
   * @return 
   */
  public io.vertx.rxjava.ext.mongo.MongoClient findWithOptions(java.lang.String collection, io.vertx.core.json.JsonObject query, io.vertx.ext.mongo.FindOptions options) {
    return 
findWithOptions(collection, query, options, ar -> { });
  }

    /**
   * Find matching documents in the specified collection, specifying options
   * @param collection the collection
   * @param query query used to match documents
   * @param options options to configure the find
   * @return 
   */
  public rx.Single<java.util.List<io.vertx.core.json.JsonObject>> rxFindWithOptions(java.lang.String collection, io.vertx.core.json.JsonObject query, io.vertx.ext.mongo.FindOptions options) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      findWithOptions(collection, query, options, fut);
    }));
  }

  /**
   * Find matching documents in the specified collection, specifying options.
   * This method use batchCursor for returning each found document.
   * @param collection the collection
   * @param query query used to match documents
   * @param options options to configure the find
   * @return a  emitting found documents
   */
  public io.vertx.rxjava.core.streams.ReadStream<io.vertx.core.json.JsonObject> findBatchWithOptions(java.lang.String collection, io.vertx.core.json.JsonObject query, io.vertx.ext.mongo.FindOptions options) { 
    io.vertx.rxjava.core.streams.ReadStream<io.vertx.core.json.JsonObject> ret = io.vertx.rxjava.core.streams.ReadStream.newInstance((io.vertx.core.streams.ReadStream)delegate.findBatchWithOptions(collection, query, options), TypeArg.unknown());
    return ret;
  }

  /**
   * Find a single matching document in the specified collection
   * <p>
   * This operation might change <i>_id</i> field of <i>query</i> parameter
   * @param collection the collection
   * @param query the query used to match the document
   * @param fields the fields
   * @param resultHandler will be provided with the document, if any
   * @return 
   */
  public io.vertx.rxjava.ext.mongo.MongoClient findOne(java.lang.String collection, io.vertx.core.json.JsonObject query, io.vertx.core.json.JsonObject fields, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.core.json.JsonObject>> resultHandler) { 
    delegate.findOne(collection, query, fields, resultHandler);
    return this;
  }

  /**
   * Find a single matching document in the specified collection
   * <p>
   * This operation might change <i>_id</i> field of <i>query</i> parameter
   * @param collection the collection
   * @param query the query used to match the document
   * @param fields the fields
   * @return 
   */
  public io.vertx.rxjava.ext.mongo.MongoClient findOne(java.lang.String collection, io.vertx.core.json.JsonObject query, io.vertx.core.json.JsonObject fields) {
    return 
findOne(collection, query, fields, ar -> { });
  }

    /**
   * Find a single matching document in the specified collection
   * <p>
   * This operation might change <i>_id</i> field of <i>query</i> parameter
   * @param collection the collection
   * @param query the query used to match the document
   * @param fields the fields
   * @return 
   */
  public rx.Single<io.vertx.core.json.JsonObject> rxFindOne(java.lang.String collection, io.vertx.core.json.JsonObject query, io.vertx.core.json.JsonObject fields) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      findOne(collection, query, fields, fut);
    }));
  }

  /**
   * Find a single matching document in the specified collection and update it.
   * <p>
   * This operation might change <i>_id</i> field of <i>query</i> parameter
   * @param collection the collection
   * @param query the query used to match the document
   * @param update used to describe how the documents will be updated
   * @param resultHandler will be provided with the document, if any
   * @return 
   */
  public io.vertx.rxjava.ext.mongo.MongoClient findOneAndUpdate(java.lang.String collection, io.vertx.core.json.JsonObject query, io.vertx.core.json.JsonObject update, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.core.json.JsonObject>> resultHandler) { 
    delegate.findOneAndUpdate(collection, query, update, resultHandler);
    return this;
  }

  /**
   * Find a single matching document in the specified collection and update it.
   * <p>
   * This operation might change <i>_id</i> field of <i>query</i> parameter
   * @param collection the collection
   * @param query the query used to match the document
   * @param update used to describe how the documents will be updated
   * @return 
   */
  public io.vertx.rxjava.ext.mongo.MongoClient findOneAndUpdate(java.lang.String collection, io.vertx.core.json.JsonObject query, io.vertx.core.json.JsonObject update) {
    return 
findOneAndUpdate(collection, query, update, ar -> { });
  }

    /**
   * Find a single matching document in the specified collection and update it.
   * <p>
   * This operation might change <i>_id</i> field of <i>query</i> parameter
   * @param collection the collection
   * @param query the query used to match the document
   * @param update used to describe how the documents will be updated
   * @return 
   */
  public rx.Single<io.vertx.core.json.JsonObject> rxFindOneAndUpdate(java.lang.String collection, io.vertx.core.json.JsonObject query, io.vertx.core.json.JsonObject update) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      findOneAndUpdate(collection, query, update, fut);
    }));
  }

  /**
   * Find a single matching document in the specified collection and update it.
   * <p>
   * This operation might change <i>_id</i> field of <i>query</i> parameter
   * @param collection the collection
   * @param query the query used to match the document
   * @param update used to describe how the documents will be updated
   * @param findOptions options to configure the find
   * @param updateOptions options to configure the update
   * @param resultHandler will be provided with the document, if any
   * @return 
   */
  public io.vertx.rxjava.ext.mongo.MongoClient findOneAndUpdateWithOptions(java.lang.String collection, io.vertx.core.json.JsonObject query, io.vertx.core.json.JsonObject update, io.vertx.ext.mongo.FindOptions findOptions, io.vertx.ext.mongo.UpdateOptions updateOptions, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.core.json.JsonObject>> resultHandler) { 
    delegate.findOneAndUpdateWithOptions(collection, query, update, findOptions, updateOptions, resultHandler);
    return this;
  }

  /**
   * Find a single matching document in the specified collection and update it.
   * <p>
   * This operation might change <i>_id</i> field of <i>query</i> parameter
   * @param collection the collection
   * @param query the query used to match the document
   * @param update used to describe how the documents will be updated
   * @param findOptions options to configure the find
   * @param updateOptions options to configure the update
   * @return 
   */
  public io.vertx.rxjava.ext.mongo.MongoClient findOneAndUpdateWithOptions(java.lang.String collection, io.vertx.core.json.JsonObject query, io.vertx.core.json.JsonObject update, io.vertx.ext.mongo.FindOptions findOptions, io.vertx.ext.mongo.UpdateOptions updateOptions) {
    return 
findOneAndUpdateWithOptions(collection, query, update, findOptions, updateOptions, ar -> { });
  }

    /**
   * Find a single matching document in the specified collection and update it.
   * <p>
   * This operation might change <i>_id</i> field of <i>query</i> parameter
   * @param collection the collection
   * @param query the query used to match the document
   * @param update used to describe how the documents will be updated
   * @param findOptions options to configure the find
   * @param updateOptions options to configure the update
   * @return 
   */
  public rx.Single<io.vertx.core.json.JsonObject> rxFindOneAndUpdateWithOptions(java.lang.String collection, io.vertx.core.json.JsonObject query, io.vertx.core.json.JsonObject update, io.vertx.ext.mongo.FindOptions findOptions, io.vertx.ext.mongo.UpdateOptions updateOptions) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      findOneAndUpdateWithOptions(collection, query, update, findOptions, updateOptions, fut);
    }));
  }

  /**
   * Find a single matching document in the specified collection and replace it.
   * <p>
   * This operation might change <i>_id</i> field of <i>query</i> parameter
   * @param collection the collection
   * @param query the query used to match the document
   * @param replace the replacement document
   * @param resultHandler will be provided with the document, if any
   * @return 
   */
  public io.vertx.rxjava.ext.mongo.MongoClient findOneAndReplace(java.lang.String collection, io.vertx.core.json.JsonObject query, io.vertx.core.json.JsonObject replace, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.core.json.JsonObject>> resultHandler) { 
    delegate.findOneAndReplace(collection, query, replace, resultHandler);
    return this;
  }

  /**
   * Find a single matching document in the specified collection and replace it.
   * <p>
   * This operation might change <i>_id</i> field of <i>query</i> parameter
   * @param collection the collection
   * @param query the query used to match the document
   * @param replace the replacement document
   * @return 
   */
  public io.vertx.rxjava.ext.mongo.MongoClient findOneAndReplace(java.lang.String collection, io.vertx.core.json.JsonObject query, io.vertx.core.json.JsonObject replace) {
    return 
findOneAndReplace(collection, query, replace, ar -> { });
  }

    /**
   * Find a single matching document in the specified collection and replace it.
   * <p>
   * This operation might change <i>_id</i> field of <i>query</i> parameter
   * @param collection the collection
   * @param query the query used to match the document
   * @param replace the replacement document
   * @return 
   */
  public rx.Single<io.vertx.core.json.JsonObject> rxFindOneAndReplace(java.lang.String collection, io.vertx.core.json.JsonObject query, io.vertx.core.json.JsonObject replace) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      findOneAndReplace(collection, query, replace, fut);
    }));
  }

  /**
   * Find a single matching document in the specified collection and replace it.
   * <p>
   * This operation might change <i>_id</i> field of <i>query</i> parameter
   * @param collection the collection
   * @param query the query used to match the document
   * @param replace the replacement document
   * @param findOptions options to configure the find
   * @param updateOptions options to configure the update
   * @param resultHandler will be provided with the document, if any
   * @return 
   */
  public io.vertx.rxjava.ext.mongo.MongoClient findOneAndReplaceWithOptions(java.lang.String collection, io.vertx.core.json.JsonObject query, io.vertx.core.json.JsonObject replace, io.vertx.ext.mongo.FindOptions findOptions, io.vertx.ext.mongo.UpdateOptions updateOptions, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.core.json.JsonObject>> resultHandler) { 
    delegate.findOneAndReplaceWithOptions(collection, query, replace, findOptions, updateOptions, resultHandler);
    return this;
  }

  /**
   * Find a single matching document in the specified collection and replace it.
   * <p>
   * This operation might change <i>_id</i> field of <i>query</i> parameter
   * @param collection the collection
   * @param query the query used to match the document
   * @param replace the replacement document
   * @param findOptions options to configure the find
   * @param updateOptions options to configure the update
   * @return 
   */
  public io.vertx.rxjava.ext.mongo.MongoClient findOneAndReplaceWithOptions(java.lang.String collection, io.vertx.core.json.JsonObject query, io.vertx.core.json.JsonObject replace, io.vertx.ext.mongo.FindOptions findOptions, io.vertx.ext.mongo.UpdateOptions updateOptions) {
    return 
findOneAndReplaceWithOptions(collection, query, replace, findOptions, updateOptions, ar -> { });
  }

    /**
   * Find a single matching document in the specified collection and replace it.
   * <p>
   * This operation might change <i>_id</i> field of <i>query</i> parameter
   * @param collection the collection
   * @param query the query used to match the document
   * @param replace the replacement document
   * @param findOptions options to configure the find
   * @param updateOptions options to configure the update
   * @return 
   */
  public rx.Single<io.vertx.core.json.JsonObject> rxFindOneAndReplaceWithOptions(java.lang.String collection, io.vertx.core.json.JsonObject query, io.vertx.core.json.JsonObject replace, io.vertx.ext.mongo.FindOptions findOptions, io.vertx.ext.mongo.UpdateOptions updateOptions) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      findOneAndReplaceWithOptions(collection, query, replace, findOptions, updateOptions, fut);
    }));
  }

  /**
   * Find a single matching document in the specified collection and delete it.
   * <p>
   * This operation might change <i>_id</i> field of <i>query</i> parameter
   * @param collection the collection
   * @param query the query used to match the document
   * @param resultHandler will be provided with the deleted document, if any
   * @return 
   */
  public io.vertx.rxjava.ext.mongo.MongoClient findOneAndDelete(java.lang.String collection, io.vertx.core.json.JsonObject query, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.core.json.JsonObject>> resultHandler) { 
    delegate.findOneAndDelete(collection, query, resultHandler);
    return this;
  }

  /**
   * Find a single matching document in the specified collection and delete it.
   * <p>
   * This operation might change <i>_id</i> field of <i>query</i> parameter
   * @param collection the collection
   * @param query the query used to match the document
   * @return 
   */
  public io.vertx.rxjava.ext.mongo.MongoClient findOneAndDelete(java.lang.String collection, io.vertx.core.json.JsonObject query) {
    return 
findOneAndDelete(collection, query, ar -> { });
  }

    /**
   * Find a single matching document in the specified collection and delete it.
   * <p>
   * This operation might change <i>_id</i> field of <i>query</i> parameter
   * @param collection the collection
   * @param query the query used to match the document
   * @return 
   */
  public rx.Single<io.vertx.core.json.JsonObject> rxFindOneAndDelete(java.lang.String collection, io.vertx.core.json.JsonObject query) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      findOneAndDelete(collection, query, fut);
    }));
  }

  /**
   * Find a single matching document in the specified collection and delete it.
   * <p>
   * This operation might change <i>_id</i> field of <i>query</i> parameter
   * @param collection the collection
   * @param query the query used to match the document
   * @param findOptions options to configure the find
   * @param resultHandler will be provided with the deleted document, if any
   * @return 
   */
  public io.vertx.rxjava.ext.mongo.MongoClient findOneAndDeleteWithOptions(java.lang.String collection, io.vertx.core.json.JsonObject query, io.vertx.ext.mongo.FindOptions findOptions, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.core.json.JsonObject>> resultHandler) { 
    delegate.findOneAndDeleteWithOptions(collection, query, findOptions, resultHandler);
    return this;
  }

  /**
   * Find a single matching document in the specified collection and delete it.
   * <p>
   * This operation might change <i>_id</i> field of <i>query</i> parameter
   * @param collection the collection
   * @param query the query used to match the document
   * @param findOptions options to configure the find
   * @return 
   */
  public io.vertx.rxjava.ext.mongo.MongoClient findOneAndDeleteWithOptions(java.lang.String collection, io.vertx.core.json.JsonObject query, io.vertx.ext.mongo.FindOptions findOptions) {
    return 
findOneAndDeleteWithOptions(collection, query, findOptions, ar -> { });
  }

    /**
   * Find a single matching document in the specified collection and delete it.
   * <p>
   * This operation might change <i>_id</i> field of <i>query</i> parameter
   * @param collection the collection
   * @param query the query used to match the document
   * @param findOptions options to configure the find
   * @return 
   */
  public rx.Single<io.vertx.core.json.JsonObject> rxFindOneAndDeleteWithOptions(java.lang.String collection, io.vertx.core.json.JsonObject query, io.vertx.ext.mongo.FindOptions findOptions) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      findOneAndDeleteWithOptions(collection, query, findOptions, fut);
    }));
  }

  /**
   * Count matching documents in a collection.
   * @param collection the collection
   * @param query query used to match documents
   * @param resultHandler will be provided with the number of matching documents
   * @return 
   */
  public io.vertx.rxjava.ext.mongo.MongoClient count(java.lang.String collection, io.vertx.core.json.JsonObject query, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.Long>> resultHandler) { 
    delegate.count(collection, query, resultHandler);
    return this;
  }

  /**
   * Count matching documents in a collection.
   * @param collection the collection
   * @param query query used to match documents
   * @return 
   */
  public io.vertx.rxjava.ext.mongo.MongoClient count(java.lang.String collection, io.vertx.core.json.JsonObject query) {
    return 
count(collection, query, ar -> { });
  }

    /**
   * Count matching documents in a collection.
   * @param collection the collection
   * @param query query used to match documents
   * @return 
   */
  public rx.Single<java.lang.Long> rxCount(java.lang.String collection, io.vertx.core.json.JsonObject query) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      count(collection, query, fut);
    }));
  }

  /**
   * Count matching documents in a collection.
   * @param collection the collection
   * @param query query used to match documents
   * @param countOptions 
   * @param resultHandler will be provided with the number of matching documents
   * @return 
   */
  public io.vertx.rxjava.ext.mongo.MongoClient countWithOptions(java.lang.String collection, io.vertx.core.json.JsonObject query, io.vertx.ext.mongo.CountOptions countOptions, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.Long>> resultHandler) { 
    delegate.countWithOptions(collection, query, countOptions, resultHandler);
    return this;
  }

  /**
   * Count matching documents in a collection.
   * @param collection the collection
   * @param query query used to match documents
   * @param countOptions 
   * @return 
   */
  public io.vertx.rxjava.ext.mongo.MongoClient countWithOptions(java.lang.String collection, io.vertx.core.json.JsonObject query, io.vertx.ext.mongo.CountOptions countOptions) {
    return 
countWithOptions(collection, query, countOptions, ar -> { });
  }

    /**
   * Count matching documents in a collection.
   * @param collection the collection
   * @param query query used to match documents
   * @param countOptions 
   * @return 
   */
  public rx.Single<java.lang.Long> rxCountWithOptions(java.lang.String collection, io.vertx.core.json.JsonObject query, io.vertx.ext.mongo.CountOptions countOptions) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      countWithOptions(collection, query, countOptions, fut);
    }));
  }

  /**
   * Remove matching documents from a collection and return the handler with <code>MongoClientDeleteResult</code> result
   * @param collection the collection
   * @param query query used to match documents
   * @param resultHandler will be called with a {@link io.vertx.ext.mongo.MongoClientDeleteResult} when complete
   * @return 
   */
  public io.vertx.rxjava.ext.mongo.MongoClient removeDocuments(java.lang.String collection, io.vertx.core.json.JsonObject query, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.ext.mongo.MongoClientDeleteResult>> resultHandler) { 
    delegate.removeDocuments(collection, query, resultHandler);
    return this;
  }

  /**
   * Remove matching documents from a collection and return the handler with <code>MongoClientDeleteResult</code> result
   * @param collection the collection
   * @param query query used to match documents
   * @return 
   */
  public io.vertx.rxjava.ext.mongo.MongoClient removeDocuments(java.lang.String collection, io.vertx.core.json.JsonObject query) {
    return 
removeDocuments(collection, query, ar -> { });
  }

    /**
   * Remove matching documents from a collection and return the handler with <code>MongoClientDeleteResult</code> result
   * @param collection the collection
   * @param query query used to match documents
   * @return 
   */
  public rx.Single<io.vertx.ext.mongo.MongoClientDeleteResult> rxRemoveDocuments(java.lang.String collection, io.vertx.core.json.JsonObject query) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      removeDocuments(collection, query, fut);
    }));
  }

  /**
   * Remove matching documents from a collection with the specified write option and return the handler with <code>MongoClientDeleteResult</code> result
   * @param collection the collection
   * @param query query used to match documents
   * @param writeOption the write option to use
   * @param resultHandler will be called with a {@link io.vertx.ext.mongo.MongoClientDeleteResult} when complete
   * @return 
   */
  public io.vertx.rxjava.ext.mongo.MongoClient removeDocumentsWithOptions(java.lang.String collection, io.vertx.core.json.JsonObject query, io.vertx.ext.mongo.WriteOption writeOption, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.ext.mongo.MongoClientDeleteResult>> resultHandler) { 
    delegate.removeDocumentsWithOptions(collection, query, writeOption, resultHandler);
    return this;
  }

  /**
   * Remove matching documents from a collection with the specified write option and return the handler with <code>MongoClientDeleteResult</code> result
   * @param collection the collection
   * @param query query used to match documents
   * @param writeOption the write option to use
   * @return 
   */
  public io.vertx.rxjava.ext.mongo.MongoClient removeDocumentsWithOptions(java.lang.String collection, io.vertx.core.json.JsonObject query, io.vertx.ext.mongo.WriteOption writeOption) {
    return 
removeDocumentsWithOptions(collection, query, writeOption, ar -> { });
  }

    /**
   * Remove matching documents from a collection with the specified write option and return the handler with <code>MongoClientDeleteResult</code> result
   * @param collection the collection
   * @param query query used to match documents
   * @param writeOption the write option to use
   * @return 
   */
  public rx.Single<io.vertx.ext.mongo.MongoClientDeleteResult> rxRemoveDocumentsWithOptions(java.lang.String collection, io.vertx.core.json.JsonObject query, io.vertx.ext.mongo.WriteOption writeOption) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      removeDocumentsWithOptions(collection, query, writeOption, fut);
    }));
  }

  /**
   * Remove a single matching document from a collection and return the handler with <code>MongoClientDeleteResult</code> result
   * @param collection the collection
   * @param query query used to match document
   * @param resultHandler will be called with a {@link io.vertx.ext.mongo.MongoClientDeleteResult} when complete
   * @return 
   */
  public io.vertx.rxjava.ext.mongo.MongoClient removeDocument(java.lang.String collection, io.vertx.core.json.JsonObject query, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.ext.mongo.MongoClientDeleteResult>> resultHandler) { 
    delegate.removeDocument(collection, query, resultHandler);
    return this;
  }

  /**
   * Remove a single matching document from a collection and return the handler with <code>MongoClientDeleteResult</code> result
   * @param collection the collection
   * @param query query used to match document
   * @return 
   */
  public io.vertx.rxjava.ext.mongo.MongoClient removeDocument(java.lang.String collection, io.vertx.core.json.JsonObject query) {
    return 
removeDocument(collection, query, ar -> { });
  }

    /**
   * Remove a single matching document from a collection and return the handler with <code>MongoClientDeleteResult</code> result
   * @param collection the collection
   * @param query query used to match document
   * @return 
   */
  public rx.Single<io.vertx.ext.mongo.MongoClientDeleteResult> rxRemoveDocument(java.lang.String collection, io.vertx.core.json.JsonObject query) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      removeDocument(collection, query, fut);
    }));
  }

  /**
   * Remove a single matching document from a collection with the specified write option and return the handler with <code>MongoClientDeleteResult</code> result
   * @param collection the collection
   * @param query query used to match document
   * @param writeOption the write option to use
   * @param resultHandler will be called with a {@link io.vertx.ext.mongo.MongoClientDeleteResult} when complete
   * @return 
   */
  public io.vertx.rxjava.ext.mongo.MongoClient removeDocumentWithOptions(java.lang.String collection, io.vertx.core.json.JsonObject query, io.vertx.ext.mongo.WriteOption writeOption, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.ext.mongo.MongoClientDeleteResult>> resultHandler) { 
    delegate.removeDocumentWithOptions(collection, query, writeOption, resultHandler);
    return this;
  }

  /**
   * Remove a single matching document from a collection with the specified write option and return the handler with <code>MongoClientDeleteResult</code> result
   * @param collection the collection
   * @param query query used to match document
   * @param writeOption the write option to use
   * @return 
   */
  public io.vertx.rxjava.ext.mongo.MongoClient removeDocumentWithOptions(java.lang.String collection, io.vertx.core.json.JsonObject query, io.vertx.ext.mongo.WriteOption writeOption) {
    return 
removeDocumentWithOptions(collection, query, writeOption, ar -> { });
  }

    /**
   * Remove a single matching document from a collection with the specified write option and return the handler with <code>MongoClientDeleteResult</code> result
   * @param collection the collection
   * @param query query used to match document
   * @param writeOption the write option to use
   * @return 
   */
  public rx.Single<io.vertx.ext.mongo.MongoClientDeleteResult> rxRemoveDocumentWithOptions(java.lang.String collection, io.vertx.core.json.JsonObject query, io.vertx.ext.mongo.WriteOption writeOption) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      removeDocumentWithOptions(collection, query, writeOption, fut);
    }));
  }

  /**
   * Create a new collection
   * @param collectionName the name of the collection
   * @param resultHandler will be called when complete
   * @return 
   */
  public io.vertx.rxjava.ext.mongo.MongoClient createCollection(java.lang.String collectionName, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.Void>> resultHandler) { 
    delegate.createCollection(collectionName, resultHandler);
    return this;
  }

  /**
   * Create a new collection
   * @param collectionName the name of the collection
   * @return 
   */
  public io.vertx.rxjava.ext.mongo.MongoClient createCollection(java.lang.String collectionName) {
    return 
createCollection(collectionName, ar -> { });
  }

    /**
   * Create a new collection
   * @param collectionName the name of the collection
   * @return 
   */
  public rx.Single<java.lang.Void> rxCreateCollection(java.lang.String collectionName) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      createCollection(collectionName, fut);
    }));
  }

  /**
   * Create a new collection with options
   * @param collectionName the name of the collection
   * @param collectionOptions options of the collection
   * @param resultHandler will be called when complete
   * @return 
   */
  public io.vertx.rxjava.ext.mongo.MongoClient createCollectionWithOptions(java.lang.String collectionName, io.vertx.ext.mongo.CreateCollectionOptions collectionOptions, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.Void>> resultHandler) { 
    delegate.createCollectionWithOptions(collectionName, collectionOptions, resultHandler);
    return this;
  }

  /**
   * Create a new collection with options
   * @param collectionName the name of the collection
   * @param collectionOptions options of the collection
   * @return 
   */
  public io.vertx.rxjava.ext.mongo.MongoClient createCollectionWithOptions(java.lang.String collectionName, io.vertx.ext.mongo.CreateCollectionOptions collectionOptions) {
    return 
createCollectionWithOptions(collectionName, collectionOptions, ar -> { });
  }

    /**
   * Create a new collection with options
   * @param collectionName the name of the collection
   * @param collectionOptions options of the collection
   * @return 
   */
  public rx.Single<java.lang.Void> rxCreateCollectionWithOptions(java.lang.String collectionName, io.vertx.ext.mongo.CreateCollectionOptions collectionOptions) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      createCollectionWithOptions(collectionName, collectionOptions, fut);
    }));
  }

  /**
   * Get a list of all collections in the database.
   * @param resultHandler will be called with a list of collections.
   * @return 
   */
  public io.vertx.rxjava.ext.mongo.MongoClient getCollections(io.vertx.core.Handler<io.vertx.core.AsyncResult<java.util.List<java.lang.String>>> resultHandler) { 
    delegate.getCollections(resultHandler);
    return this;
  }

  /**
   * Get a list of all collections in the database.
   * @return 
   */
  public io.vertx.rxjava.ext.mongo.MongoClient getCollections() {
    return 
getCollections(ar -> { });
  }

    /**
   * Get a list of all collections in the database.
   * @return 
   */
  public rx.Single<java.util.List<java.lang.String>> rxGetCollections() { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      getCollections(fut);
    }));
  }

  /**
   * Drop a collection
   * @param collection the collection
   * @param resultHandler will be called when complete
   * @return 
   */
  public io.vertx.rxjava.ext.mongo.MongoClient dropCollection(java.lang.String collection, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.Void>> resultHandler) { 
    delegate.dropCollection(collection, resultHandler);
    return this;
  }

  /**
   * Drop a collection
   * @param collection the collection
   * @return 
   */
  public io.vertx.rxjava.ext.mongo.MongoClient dropCollection(java.lang.String collection) {
    return 
dropCollection(collection, ar -> { });
  }

    /**
   * Drop a collection
   * @param collection the collection
   * @return 
   */
  public rx.Single<java.lang.Void> rxDropCollection(java.lang.String collection) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      dropCollection(collection, fut);
    }));
  }

  /**
   * Creates an index.
   * @param collection the collection
   * @param key A document that contains the field and value pairs where the field is the index key and the value describes the type of index for that field. For an ascending index on a field, specify a value of 1; for descending index, specify a value of -1.
   * @param resultHandler will be called when complete
   * @return 
   */
  public io.vertx.rxjava.ext.mongo.MongoClient createIndex(java.lang.String collection, io.vertx.core.json.JsonObject key, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.Void>> resultHandler) { 
    delegate.createIndex(collection, key, resultHandler);
    return this;
  }

  /**
   * Creates an index.
   * @param collection the collection
   * @param key A document that contains the field and value pairs where the field is the index key and the value describes the type of index for that field. For an ascending index on a field, specify a value of 1; for descending index, specify a value of -1.
   * @return 
   */
  public io.vertx.rxjava.ext.mongo.MongoClient createIndex(java.lang.String collection, io.vertx.core.json.JsonObject key) {
    return 
createIndex(collection, key, ar -> { });
  }

    /**
   * Creates an index.
   * @param collection the collection
   * @param key A document that contains the field and value pairs where the field is the index key and the value describes the type of index for that field. For an ascending index on a field, specify a value of 1; for descending index, specify a value of -1.
   * @return 
   */
  public rx.Single<java.lang.Void> rxCreateIndex(java.lang.String collection, io.vertx.core.json.JsonObject key) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      createIndex(collection, key, fut);
    }));
  }

  /**
   * Creates an index.
   * @param collection the collection
   * @param key A document that contains the field and value pairs where the field is the index key and the value describes the type of index for that field. For an ascending index on a field, specify a value of 1; for descending index, specify a value of -1.
   * @param options the options for the index
   * @param resultHandler will be called when complete
   * @return 
   */
  public io.vertx.rxjava.ext.mongo.MongoClient createIndexWithOptions(java.lang.String collection, io.vertx.core.json.JsonObject key, io.vertx.ext.mongo.IndexOptions options, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.Void>> resultHandler) { 
    delegate.createIndexWithOptions(collection, key, options, resultHandler);
    return this;
  }

  /**
   * Creates an index.
   * @param collection the collection
   * @param key A document that contains the field and value pairs where the field is the index key and the value describes the type of index for that field. For an ascending index on a field, specify a value of 1; for descending index, specify a value of -1.
   * @param options the options for the index
   * @return 
   */
  public io.vertx.rxjava.ext.mongo.MongoClient createIndexWithOptions(java.lang.String collection, io.vertx.core.json.JsonObject key, io.vertx.ext.mongo.IndexOptions options) {
    return 
createIndexWithOptions(collection, key, options, ar -> { });
  }

    /**
   * Creates an index.
   * @param collection the collection
   * @param key A document that contains the field and value pairs where the field is the index key and the value describes the type of index for that field. For an ascending index on a field, specify a value of 1; for descending index, specify a value of -1.
   * @param options the options for the index
   * @return 
   */
  public rx.Single<java.lang.Void> rxCreateIndexWithOptions(java.lang.String collection, io.vertx.core.json.JsonObject key, io.vertx.ext.mongo.IndexOptions options) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      createIndexWithOptions(collection, key, options, fut);
    }));
  }

  /**
   * creates an indexes
   * @param collection the collection
   * @param indexes A model that contains pairs of document and indexOptions, document contains the field and value pairs where the field is the index key and the value describes the type of index for that field. For an ascending index on a field, specify a value of 1; for descending index, specify a value of -1.
   * @param resultHandler will be called when complete
   * @return 
   */
  public io.vertx.rxjava.ext.mongo.MongoClient createIndexes(java.lang.String collection, java.util.List<io.vertx.ext.mongo.IndexModel> indexes, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.Void>> resultHandler) { 
    delegate.createIndexes(collection, indexes, resultHandler);
    return this;
  }

  /**
   * creates an indexes
   * @param collection the collection
   * @param indexes A model that contains pairs of document and indexOptions, document contains the field and value pairs where the field is the index key and the value describes the type of index for that field. For an ascending index on a field, specify a value of 1; for descending index, specify a value of -1.
   * @return 
   */
  public io.vertx.rxjava.ext.mongo.MongoClient createIndexes(java.lang.String collection, java.util.List<io.vertx.ext.mongo.IndexModel> indexes) {
    return 
createIndexes(collection, indexes, ar -> { });
  }

    /**
   * creates an indexes
   * @param collection the collection
   * @param indexes A model that contains pairs of document and indexOptions, document contains the field and value pairs where the field is the index key and the value describes the type of index for that field. For an ascending index on a field, specify a value of 1; for descending index, specify a value of -1.
   * @return 
   */
  public rx.Single<java.lang.Void> rxCreateIndexes(java.lang.String collection, java.util.List<io.vertx.ext.mongo.IndexModel> indexes) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      createIndexes(collection, indexes, fut);
    }));
  }

  /**
   * Get all the indexes in this collection.
   * @param collection the collection
   * @param resultHandler will be called when complete
   * @return 
   */
  public io.vertx.rxjava.ext.mongo.MongoClient listIndexes(java.lang.String collection, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.core.json.JsonArray>> resultHandler) { 
    delegate.listIndexes(collection, resultHandler);
    return this;
  }

  /**
   * Get all the indexes in this collection.
   * @param collection the collection
   * @return 
   */
  public io.vertx.rxjava.ext.mongo.MongoClient listIndexes(java.lang.String collection) {
    return 
listIndexes(collection, ar -> { });
  }

    /**
   * Get all the indexes in this collection.
   * @param collection the collection
   * @return 
   */
  public rx.Single<io.vertx.core.json.JsonArray> rxListIndexes(java.lang.String collection) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      listIndexes(collection, fut);
    }));
  }

  /**
   * Drops the index given its name.
   * @param collection the collection
   * @param indexName the name of the index to remove
   * @param resultHandler will be called when complete
   * @return 
   */
  public io.vertx.rxjava.ext.mongo.MongoClient dropIndex(java.lang.String collection, java.lang.String indexName, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.Void>> resultHandler) { 
    delegate.dropIndex(collection, indexName, resultHandler);
    return this;
  }

  /**
   * Drops the index given its name.
   * @param collection the collection
   * @param indexName the name of the index to remove
   * @return 
   */
  public io.vertx.rxjava.ext.mongo.MongoClient dropIndex(java.lang.String collection, java.lang.String indexName) {
    return 
dropIndex(collection, indexName, ar -> { });
  }

    /**
   * Drops the index given its name.
   * @param collection the collection
   * @param indexName the name of the index to remove
   * @return 
   */
  public rx.Single<java.lang.Void> rxDropIndex(java.lang.String collection, java.lang.String indexName) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      dropIndex(collection, indexName, fut);
    }));
  }

  /**
   * Run an arbitrary MongoDB command.
   * @param commandName the name of the command
   * @param command the command
   * @param resultHandler will be called with the result.
   * @return 
   */
  public io.vertx.rxjava.ext.mongo.MongoClient runCommand(java.lang.String commandName, io.vertx.core.json.JsonObject command, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.core.json.JsonObject>> resultHandler) { 
    delegate.runCommand(commandName, command, resultHandler);
    return this;
  }

  /**
   * Run an arbitrary MongoDB command.
   * @param commandName the name of the command
   * @param command the command
   * @return 
   */
  public io.vertx.rxjava.ext.mongo.MongoClient runCommand(java.lang.String commandName, io.vertx.core.json.JsonObject command) {
    return 
runCommand(commandName, command, ar -> { });
  }

    /**
   * Run an arbitrary MongoDB command.
   * @param commandName the name of the command
   * @param command the command
   * @return 
   */
  public rx.Single<io.vertx.core.json.JsonObject> rxRunCommand(java.lang.String commandName, io.vertx.core.json.JsonObject command) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      runCommand(commandName, command, fut);
    }));
  }

  /**
   * Gets the distinct values of the specified field name.
   * Return a JsonArray containing distinct values (eg: [ 1 , 89 ])
   * @param collection the collection
   * @param fieldName the field name
   * @param resultClassname 
   * @param resultHandler will be provided with array of values.
   * @return 
   */
  public io.vertx.rxjava.ext.mongo.MongoClient distinct(java.lang.String collection, java.lang.String fieldName, java.lang.String resultClassname, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.core.json.JsonArray>> resultHandler) { 
    delegate.distinct(collection, fieldName, resultClassname, resultHandler);
    return this;
  }

  /**
   * Gets the distinct values of the specified field name.
   * Return a JsonArray containing distinct values (eg: [ 1 , 89 ])
   * @param collection the collection
   * @param fieldName the field name
   * @param resultClassname 
   * @return 
   */
  public io.vertx.rxjava.ext.mongo.MongoClient distinct(java.lang.String collection, java.lang.String fieldName, java.lang.String resultClassname) {
    return 
distinct(collection, fieldName, resultClassname, ar -> { });
  }

    /**
   * Gets the distinct values of the specified field name.
   * Return a JsonArray containing distinct values (eg: [ 1 , 89 ])
   * @param collection the collection
   * @param fieldName the field name
   * @param resultClassname 
   * @return 
   */
  public rx.Single<io.vertx.core.json.JsonArray> rxDistinct(java.lang.String collection, java.lang.String fieldName, java.lang.String resultClassname) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      distinct(collection, fieldName, resultClassname, fut);
    }));
  }

  /**
   * Gets the distinct values of the specified field name.
   * Return a JsonArray containing distinct values (eg: [ 1 , 89 ])
   * @param collection the collection
   * @param fieldName the field name
   * @param resultClassname 
   * @param distinctOptions options (e.g. collation)
   * @param resultHandler will be provided with array of values.
   * @return 
   */
  public io.vertx.rxjava.ext.mongo.MongoClient distinct(java.lang.String collection, java.lang.String fieldName, java.lang.String resultClassname, io.vertx.ext.mongo.DistinctOptions distinctOptions, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.core.json.JsonArray>> resultHandler) { 
    delegate.distinct(collection, fieldName, resultClassname, distinctOptions, resultHandler);
    return this;
  }

  /**
   * Gets the distinct values of the specified field name.
   * Return a JsonArray containing distinct values (eg: [ 1 , 89 ])
   * @param collection the collection
   * @param fieldName the field name
   * @param resultClassname 
   * @param distinctOptions options (e.g. collation)
   * @return 
   */
  public io.vertx.rxjava.ext.mongo.MongoClient distinct(java.lang.String collection, java.lang.String fieldName, java.lang.String resultClassname, io.vertx.ext.mongo.DistinctOptions distinctOptions) {
    return 
distinct(collection, fieldName, resultClassname, distinctOptions, ar -> { });
  }

    /**
   * Gets the distinct values of the specified field name.
   * Return a JsonArray containing distinct values (eg: [ 1 , 89 ])
   * @param collection the collection
   * @param fieldName the field name
   * @param resultClassname 
   * @param distinctOptions options (e.g. collation)
   * @return 
   */
  public rx.Single<io.vertx.core.json.JsonArray> rxDistinct(java.lang.String collection, java.lang.String fieldName, java.lang.String resultClassname, io.vertx.ext.mongo.DistinctOptions distinctOptions) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      distinct(collection, fieldName, resultClassname, distinctOptions, fut);
    }));
  }

  /**
   * Gets the distinct values of the specified field name filtered by specified query.
   * Return a JsonArray containing distinct values (eg: [ 1 , 89 ])
   * @param collection the collection
   * @param fieldName the field name
   * @param resultClassname 
   * @param query the query
   * @param resultHandler will be provided with array of values.
   * @return 
   */
  public io.vertx.rxjava.ext.mongo.MongoClient distinctWithQuery(java.lang.String collection, java.lang.String fieldName, java.lang.String resultClassname, io.vertx.core.json.JsonObject query, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.core.json.JsonArray>> resultHandler) { 
    delegate.distinctWithQuery(collection, fieldName, resultClassname, query, resultHandler);
    return this;
  }

  /**
   * Gets the distinct values of the specified field name filtered by specified query.
   * Return a JsonArray containing distinct values (eg: [ 1 , 89 ])
   * @param collection the collection
   * @param fieldName the field name
   * @param resultClassname 
   * @param query the query
   * @return 
   */
  public io.vertx.rxjava.ext.mongo.MongoClient distinctWithQuery(java.lang.String collection, java.lang.String fieldName, java.lang.String resultClassname, io.vertx.core.json.JsonObject query) {
    return 
distinctWithQuery(collection, fieldName, resultClassname, query, ar -> { });
  }

    /**
   * Gets the distinct values of the specified field name filtered by specified query.
   * Return a JsonArray containing distinct values (eg: [ 1 , 89 ])
   * @param collection the collection
   * @param fieldName the field name
   * @param resultClassname 
   * @param query the query
   * @return 
   */
  public rx.Single<io.vertx.core.json.JsonArray> rxDistinctWithQuery(java.lang.String collection, java.lang.String fieldName, java.lang.String resultClassname, io.vertx.core.json.JsonObject query) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      distinctWithQuery(collection, fieldName, resultClassname, query, fut);
    }));
  }

  /**
   * Gets the distinct values of the specified field name filtered by specified query.
   * Return a JsonArray containing distinct values (eg: [ 1 , 89 ])
   * @param collection the collection
   * @param fieldName the field name
   * @param resultClassname 
   * @param query the query
   * @param distinctOptions options (e.g. collation)
   * @param resultHandler will be provided with array of values.
   * @return 
   */
  public io.vertx.rxjava.ext.mongo.MongoClient distinctWithQuery(java.lang.String collection, java.lang.String fieldName, java.lang.String resultClassname, io.vertx.core.json.JsonObject query, io.vertx.ext.mongo.DistinctOptions distinctOptions, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.core.json.JsonArray>> resultHandler) { 
    delegate.distinctWithQuery(collection, fieldName, resultClassname, query, distinctOptions, resultHandler);
    return this;
  }

  /**
   * Gets the distinct values of the specified field name filtered by specified query.
   * Return a JsonArray containing distinct values (eg: [ 1 , 89 ])
   * @param collection the collection
   * @param fieldName the field name
   * @param resultClassname 
   * @param query the query
   * @param distinctOptions options (e.g. collation)
   * @return 
   */
  public io.vertx.rxjava.ext.mongo.MongoClient distinctWithQuery(java.lang.String collection, java.lang.String fieldName, java.lang.String resultClassname, io.vertx.core.json.JsonObject query, io.vertx.ext.mongo.DistinctOptions distinctOptions) {
    return 
distinctWithQuery(collection, fieldName, resultClassname, query, distinctOptions, ar -> { });
  }

    /**
   * Gets the distinct values of the specified field name filtered by specified query.
   * Return a JsonArray containing distinct values (eg: [ 1 , 89 ])
   * @param collection the collection
   * @param fieldName the field name
   * @param resultClassname 
   * @param query the query
   * @param distinctOptions options (e.g. collation)
   * @return 
   */
  public rx.Single<io.vertx.core.json.JsonArray> rxDistinctWithQuery(java.lang.String collection, java.lang.String fieldName, java.lang.String resultClassname, io.vertx.core.json.JsonObject query, io.vertx.ext.mongo.DistinctOptions distinctOptions) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      distinctWithQuery(collection, fieldName, resultClassname, query, distinctOptions, fut);
    }));
  }

  /**
   * Gets the distinct values of the specified field name.
   * This method use batchCursor for returning each found value.
   * Each value is a json fragment with fieldName key (eg: {"num": 1}).
   * @param collection the collection
   * @param fieldName the field name
   * @param resultClassname 
   * @return a  emitting json fragments
   */
  public io.vertx.rxjava.core.streams.ReadStream<io.vertx.core.json.JsonObject> distinctBatch(java.lang.String collection, java.lang.String fieldName, java.lang.String resultClassname) { 
    io.vertx.rxjava.core.streams.ReadStream<io.vertx.core.json.JsonObject> ret = io.vertx.rxjava.core.streams.ReadStream.newInstance((io.vertx.core.streams.ReadStream)delegate.distinctBatch(collection, fieldName, resultClassname), TypeArg.unknown());
    return ret;
  }

  /**
   * Gets the distinct values of the specified field name.
   * This method use batchCursor for returning each found value.
   * Each value is a json fragment with fieldName key (eg: {"num": 1}).
   * @param collection the collection
   * @param fieldName the field name
   * @param resultClassname 
   * @param distinctOptions options (e.g. collation)
   * @return a  emitting json fragments
   */
  public io.vertx.rxjava.core.streams.ReadStream<io.vertx.core.json.JsonObject> distinctBatch(java.lang.String collection, java.lang.String fieldName, java.lang.String resultClassname, io.vertx.ext.mongo.DistinctOptions distinctOptions) { 
    io.vertx.rxjava.core.streams.ReadStream<io.vertx.core.json.JsonObject> ret = io.vertx.rxjava.core.streams.ReadStream.newInstance((io.vertx.core.streams.ReadStream)delegate.distinctBatch(collection, fieldName, resultClassname, distinctOptions), TypeArg.unknown());
    return ret;
  }

  /**
   * Gets the distinct values of the specified field name filtered by specified query.
   * This method use batchCursor for returning each found value.
   * Each value is a json fragment with fieldName key (eg: {"num": 1}).
   * @param collection the collection
   * @param fieldName the field name
   * @param resultClassname 
   * @param query the query
   * @return a  emitting json fragments
   */
  public io.vertx.rxjava.core.streams.ReadStream<io.vertx.core.json.JsonObject> distinctBatchWithQuery(java.lang.String collection, java.lang.String fieldName, java.lang.String resultClassname, io.vertx.core.json.JsonObject query) { 
    io.vertx.rxjava.core.streams.ReadStream<io.vertx.core.json.JsonObject> ret = io.vertx.rxjava.core.streams.ReadStream.newInstance((io.vertx.core.streams.ReadStream)delegate.distinctBatchWithQuery(collection, fieldName, resultClassname, query), TypeArg.unknown());
    return ret;
  }

  /**
   * Gets the distinct values of the specified field name filtered by specified query.
   * This method use batchCursor for returning each found value.
   * Each value is a json fragment with fieldName key (eg: {"num": 1}).
   * @param collection the collection
   * @param fieldName the field name
   * @param resultClassname 
   * @param query the query
   * @param distinctOptions options (e.g. collation)
   * @return a  emitting json fragments
   */
  public io.vertx.rxjava.core.streams.ReadStream<io.vertx.core.json.JsonObject> distinctBatchWithQuery(java.lang.String collection, java.lang.String fieldName, java.lang.String resultClassname, io.vertx.core.json.JsonObject query, io.vertx.ext.mongo.DistinctOptions distinctOptions) { 
    io.vertx.rxjava.core.streams.ReadStream<io.vertx.core.json.JsonObject> ret = io.vertx.rxjava.core.streams.ReadStream.newInstance((io.vertx.core.streams.ReadStream)delegate.distinctBatchWithQuery(collection, fieldName, resultClassname, query, distinctOptions), TypeArg.unknown());
    return ret;
  }

  /**
   * Gets the distinct values of the specified field name filtered by specified query.
   * This method use batchCursor for returning each found value.
   * Each value is a json fragment with fieldName key (eg: {"num": 1}).
   * @param collection the collection
   * @param fieldName the field name
   * @param resultClassname 
   * @param query the query
   * @param batchSize the number of documents to load in a batch
   * @return a  emitting json fragments
   */
  public io.vertx.rxjava.core.streams.ReadStream<io.vertx.core.json.JsonObject> distinctBatchWithQuery(java.lang.String collection, java.lang.String fieldName, java.lang.String resultClassname, io.vertx.core.json.JsonObject query, int batchSize) { 
    io.vertx.rxjava.core.streams.ReadStream<io.vertx.core.json.JsonObject> ret = io.vertx.rxjava.core.streams.ReadStream.newInstance((io.vertx.core.streams.ReadStream)delegate.distinctBatchWithQuery(collection, fieldName, resultClassname, query, batchSize), TypeArg.unknown());
    return ret;
  }

  /**
   * Gets the distinct values of the specified field name filtered by specified query.
   * This method use batchCursor for returning each found value.
   * Each value is a json fragment with fieldName key (eg: {"num": 1}).
   * @param collection the collection
   * @param fieldName the field name
   * @param resultClassname 
   * @param query the query
   * @param batchSize the number of documents to load in a batch
   * @param distinctOptions options (e.g. collation)
   * @return a  emitting json fragments
   */
  public io.vertx.rxjava.core.streams.ReadStream<io.vertx.core.json.JsonObject> distinctBatchWithQuery(java.lang.String collection, java.lang.String fieldName, java.lang.String resultClassname, io.vertx.core.json.JsonObject query, int batchSize, io.vertx.ext.mongo.DistinctOptions distinctOptions) { 
    io.vertx.rxjava.core.streams.ReadStream<io.vertx.core.json.JsonObject> ret = io.vertx.rxjava.core.streams.ReadStream.newInstance((io.vertx.core.streams.ReadStream)delegate.distinctBatchWithQuery(collection, fieldName, resultClassname, query, batchSize, distinctOptions), TypeArg.unknown());
    return ret;
  }

  /**
   * Run aggregate MongoDB command with default {@link io.vertx.ext.mongo.AggregateOptions}.
   * @param collection the collection
   * @param pipeline aggregation pipeline to be executed
   * @return 
   */
  public io.vertx.rxjava.core.streams.ReadStream<io.vertx.core.json.JsonObject> aggregate(java.lang.String collection, io.vertx.core.json.JsonArray pipeline) { 
    io.vertx.rxjava.core.streams.ReadStream<io.vertx.core.json.JsonObject> ret = io.vertx.rxjava.core.streams.ReadStream.newInstance((io.vertx.core.streams.ReadStream)delegate.aggregate(collection, pipeline), TypeArg.unknown());
    return ret;
  }

  /**
   * Run aggregate MongoDB command.
   * @param collection the collection
   * @param pipeline aggregation pipeline to be executed
   * @param options options to configure the aggregation command
   * @return 
   */
  public io.vertx.rxjava.core.streams.ReadStream<io.vertx.core.json.JsonObject> aggregateWithOptions(java.lang.String collection, io.vertx.core.json.JsonArray pipeline, io.vertx.ext.mongo.AggregateOptions options) { 
    io.vertx.rxjava.core.streams.ReadStream<io.vertx.core.json.JsonObject> ret = io.vertx.rxjava.core.streams.ReadStream.newInstance((io.vertx.core.streams.ReadStream)delegate.aggregateWithOptions(collection, pipeline, options), TypeArg.unknown());
    return ret;
  }

  /**
   * Creates a {@link io.vertx.rxjava.ext.mongo.MongoGridFsClient} used to interact with Mongo GridFS.
   * @param resultHandler the {@link io.vertx.rxjava.ext.mongo.MongoGridFsClient} to interact with the bucket named bucketName
   * @return 
   */
  public io.vertx.rxjava.ext.mongo.MongoClient createDefaultGridFsBucketService(io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.ext.mongo.MongoGridFsClient>> resultHandler) { 
    delegate.createDefaultGridFsBucketService(new io.vertx.lang.rx.DelegatingHandler<>(resultHandler, ar -> ar.map(event -> io.vertx.rxjava.ext.mongo.MongoGridFsClient.newInstance((io.vertx.ext.mongo.MongoGridFsClient)event))));
    return this;
  }

  /**
   * Creates a {@link io.vertx.rxjava.ext.mongo.MongoGridFsClient} used to interact with Mongo GridFS.
   * @return 
   */
  public io.vertx.rxjava.ext.mongo.MongoClient createDefaultGridFsBucketService() {
    return 
createDefaultGridFsBucketService(ar -> { });
  }

    /**
   * Creates a {@link io.vertx.rxjava.ext.mongo.MongoGridFsClient} used to interact with Mongo GridFS.
   * @return 
   */
  public rx.Single<io.vertx.rxjava.ext.mongo.MongoGridFsClient> rxCreateDefaultGridFsBucketService() { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      createDefaultGridFsBucketService(fut);
    }));
  }

  /**
   * Creates a {@link io.vertx.rxjava.ext.mongo.MongoGridFsClient} used to interact with Mongo GridFS.
   * @param bucketName the name of the GridFS bucket
   * @param resultHandler the {@link io.vertx.rxjava.ext.mongo.MongoGridFsClient} to interact with the bucket named bucketName
   * @return 
   */
  public io.vertx.rxjava.ext.mongo.MongoClient createGridFsBucketService(java.lang.String bucketName, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.ext.mongo.MongoGridFsClient>> resultHandler) { 
    delegate.createGridFsBucketService(bucketName, new io.vertx.lang.rx.DelegatingHandler<>(resultHandler, ar -> ar.map(event -> io.vertx.rxjava.ext.mongo.MongoGridFsClient.newInstance((io.vertx.ext.mongo.MongoGridFsClient)event))));
    return this;
  }

  /**
   * Creates a {@link io.vertx.rxjava.ext.mongo.MongoGridFsClient} used to interact with Mongo GridFS.
   * @param bucketName the name of the GridFS bucket
   * @return 
   */
  public io.vertx.rxjava.ext.mongo.MongoClient createGridFsBucketService(java.lang.String bucketName) {
    return 
createGridFsBucketService(bucketName, ar -> { });
  }

    /**
   * Creates a {@link io.vertx.rxjava.ext.mongo.MongoGridFsClient} used to interact with Mongo GridFS.
   * @param bucketName the name of the GridFS bucket
   * @return 
   */
  public rx.Single<io.vertx.rxjava.ext.mongo.MongoGridFsClient> rxCreateGridFsBucketService(java.lang.String bucketName) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      createGridFsBucketService(bucketName, fut);
    }));
  }

  /**
   * Close the client and release its resources
   * @param handler 
   */
  public void close(io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.Void>> handler) { 
    delegate.close(handler);
  }

  /**
   * Close the client and release its resources
   */
  public void close() {
    close(ar -> { });
  }

    /**
   * Close the client and release its resources
   * @return 
   */
  public rx.Single<java.lang.Void> rxClose() { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      close(fut);
    }));
  }

  /**
   * Watch the collection change.
   * @param collection the collection
   * @param pipeline watching pipeline to be executed
   * @param withUpdatedDoc whether to get updated fullDocument for "update" operation
   * @param batchSize the number of documents to load in a batch
   * @return 
   */
  public io.vertx.rxjava.core.streams.ReadStream<com.mongodb.client.model.changestream.ChangeStreamDocument<io.vertx.core.json.JsonObject>> watch(java.lang.String collection, io.vertx.core.json.JsonArray pipeline, boolean withUpdatedDoc, int batchSize) { 
    io.vertx.rxjava.core.streams.ReadStream<com.mongodb.client.model.changestream.ChangeStreamDocument<io.vertx.core.json.JsonObject>> ret = io.vertx.rxjava.core.streams.ReadStream.newInstance((io.vertx.core.streams.ReadStream)delegate.watch(collection, pipeline, withUpdatedDoc, batchSize), TypeArg.unknown());
    return ret;
  }

  /**
   * The name of the default pool
   */
  public static final java.lang.String DEFAULT_POOL_NAME = io.vertx.ext.mongo.MongoClient.DEFAULT_POOL_NAME;
  /**
   * The name of the default database
   */
  public static final java.lang.String DEFAULT_DB_NAME = io.vertx.ext.mongo.MongoClient.DEFAULT_DB_NAME;
  public static MongoClient newInstance(io.vertx.ext.mongo.MongoClient arg) {
    return arg != null ? new MongoClient(arg) : null;
  }

}
