/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava.ext.mail;

import rx.Observable;
import rx.Single;
import io.vertx.rx.java.RxHelper;
import io.vertx.rx.java.WriteStreamSubscriber;
import io.vertx.rx.java.SingleOnSubscribeAdapter;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * SMTP mail client for Vert.x
 * <p>
 * A simple asynchronous API for sending mails from Vert.x applications
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.mail.MailClient original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.ext.mail.MailClient.class)
public class MailClient {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    MailClient that = (MailClient) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<MailClient> __TYPE_ARG = new TypeArg<>(    obj -> new MailClient((io.vertx.ext.mail.MailClient) obj),
    MailClient::getDelegate
  );

  private final io.vertx.ext.mail.MailClient delegate;
  
  public MailClient(io.vertx.ext.mail.MailClient delegate) {
    this.delegate = delegate;
  }

  public MailClient(Object delegate) {
    this.delegate = (io.vertx.ext.mail.MailClient)delegate;
  }

  public io.vertx.ext.mail.MailClient getDelegate() {
    return delegate;
  }

  /**
   * Create a non shared instance of the mail client.
   * @param vertx the Vertx instance the operation will be run in
   * @param config MailConfig configuration to be used for sending mails
   * @return MailClient instance that can then be used to send multiple mails
   */
  public static io.vertx.rxjava.ext.mail.MailClient create(io.vertx.rxjava.core.Vertx vertx, io.vertx.ext.mail.MailConfig config) { 
    io.vertx.rxjava.ext.mail.MailClient ret = io.vertx.rxjava.ext.mail.MailClient.newInstance((io.vertx.ext.mail.MailClient)io.vertx.ext.mail.MailClient.create(vertx.getDelegate(), config));
    return ret;
  }

  /**
   * Create a Mail client which shares its connection pool with any other Mail clients created with the same
   * pool name
   * @param vertx the Vert.x instance
   * @param config the configuration
   * @param poolName the pool name
   * @return the client
   */
  public static io.vertx.rxjava.ext.mail.MailClient createShared(io.vertx.rxjava.core.Vertx vertx, io.vertx.ext.mail.MailConfig config, java.lang.String poolName) { 
    io.vertx.rxjava.ext.mail.MailClient ret = io.vertx.rxjava.ext.mail.MailClient.newInstance((io.vertx.ext.mail.MailClient)io.vertx.ext.mail.MailClient.createShared(vertx.getDelegate(), config, poolName));
    return ret;
  }

  /**
   * Like {@link io.vertx.rxjava.ext.mail.MailClient#createShared} but with the default pool name
   * @param vertx the Vert.x instance
   * @param config the configuration
   * @return the client
   */
  public static io.vertx.rxjava.ext.mail.MailClient createShared(io.vertx.rxjava.core.Vertx vertx, io.vertx.ext.mail.MailConfig config) { 
    io.vertx.rxjava.ext.mail.MailClient ret = io.vertx.rxjava.ext.mail.MailClient.newInstance((io.vertx.ext.mail.MailClient)io.vertx.ext.mail.MailClient.createShared(vertx.getDelegate(), config));
    return ret;
  }

  /**
   * send a single mail via MailClient
   * @param email MailMessage object containing the mail text, from/to, attachments etc
   * @param resultHandler will be called when the operation is finished or it fails (may be null to ignore the result)
   * @return this MailClient instance so the method can be used fluently
   */
  public io.vertx.rxjava.ext.mail.MailClient sendMail(io.vertx.ext.mail.MailMessage email, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.ext.mail.MailResult>> resultHandler) { 
    delegate.sendMail(email, resultHandler);
    return this;
  }

  /**
   * send a single mail via MailClient
   * @param email MailMessage object containing the mail text, from/to, attachments etc
   * @return this MailClient instance so the method can be used fluently
   */
  public io.vertx.rxjava.ext.mail.MailClient sendMail(io.vertx.ext.mail.MailMessage email) {
    return 
sendMail(email, ar -> { });
  }

    /**
   * send a single mail via MailClient
   * @param email MailMessage object containing the mail text, from/to, attachments etc
   * @return this MailClient instance so the method can be used fluently
   */
  public rx.Single<io.vertx.ext.mail.MailResult> rxSendMail(io.vertx.ext.mail.MailMessage email) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      sendMail(email, fut);
    }));
  }

  /**
   * Close the MailClient
   * @param closedHandler will be called after it is closed.
   */
  public void close(io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.Void>> closedHandler) { 
    delegate.close(closedHandler);
  }

  /**
   * Close the MailClient
   */
  public void close() {
    close(ar -> { });
  }

    /**
   * Close the MailClient
   * @return 
   */
  public rx.Single<java.lang.Void> rxClose() { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      close(fut);
    }));
  }

  /**
   * The name of the default pool
   */
  public static final java.lang.String DEFAULT_POOL_NAME = io.vertx.ext.mail.MailClient.DEFAULT_POOL_NAME;
  public static MailClient newInstance(io.vertx.ext.mail.MailClient arg) {
    return arg != null ? new MailClient(arg) : null;
  }

}
