/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava.ext.jdbc;

import rx.Observable;
import rx.Single;
import io.vertx.rx.java.RxHelper;
import io.vertx.rx.java.WriteStreamSubscriber;
import io.vertx.rx.java.SingleOnSubscribeAdapter;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * An asynchronous client interface for interacting with a JDBC compliant database
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.jdbc.JDBCClient original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.ext.jdbc.JDBCClient.class)
public class JDBCClient extends io.vertx.rxjava.ext.sql.SQLClient {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    JDBCClient that = (JDBCClient) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<JDBCClient> __TYPE_ARG = new TypeArg<>(    obj -> new JDBCClient((io.vertx.ext.jdbc.JDBCClient) obj),
    JDBCClient::getDelegate
  );

  private final io.vertx.ext.jdbc.JDBCClient delegate;
  
  public JDBCClient(io.vertx.ext.jdbc.JDBCClient delegate) {
    super(delegate);
    this.delegate = delegate;
  }

  public JDBCClient(Object delegate) {
    super((io.vertx.ext.jdbc.JDBCClient)delegate);
    this.delegate = (io.vertx.ext.jdbc.JDBCClient)delegate;
  }

  public io.vertx.ext.jdbc.JDBCClient getDelegate() {
    return delegate;
  }

  /**
   * Execute a one shot SQL statement that returns a single SQL row. This method will reduce the boilerplate code by
   * getting a connection from the pool (this object) and return it back after the execution. Only the first result
   * from the result set is returned.
   * @param sql the statement to execute
   * @param handler the result handler
   * @return self
   */
  public io.vertx.rxjava.ext.sql.SQLOperations querySingle(java.lang.String sql, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.core.json.JsonArray>> handler) { 
    delegate.querySingle(sql, handler);
    return this;
  }

  /**
   * Execute a one shot SQL statement that returns a single SQL row. This method will reduce the boilerplate code by
   * getting a connection from the pool (this object) and return it back after the execution. Only the first result
   * from the result set is returned.
   * @param sql the statement to execute
   * @return self
   */
  public io.vertx.rxjava.ext.sql.SQLOperations querySingle(java.lang.String sql) {
    return 
querySingle(sql, ar -> { });
  }

    /**
   * Execute a one shot SQL statement that returns a single SQL row. This method will reduce the boilerplate code by
   * getting a connection from the pool (this object) and return it back after the execution. Only the first result
   * from the result set is returned.
   * @param sql the statement to execute
   * @return self
   */
  public rx.Single<io.vertx.core.json.JsonArray> rxQuerySingle(java.lang.String sql) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      querySingle(sql, fut);
    }));
  }

  /**
   * Execute a one shot SQL statement with arguments that returns a single SQL row. This method will reduce the
   * boilerplate code by getting a connection from the pool (this object) and return it back after the execution.
   * Only the first result from the result set is returned.
   * @param sql the statement to execute
   * @param arguments the arguments
   * @param handler the result handler
   * @return self
   */
  public io.vertx.rxjava.ext.sql.SQLOperations querySingleWithParams(java.lang.String sql, io.vertx.core.json.JsonArray arguments, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.core.json.JsonArray>> handler) { 
    delegate.querySingleWithParams(sql, arguments, handler);
    return this;
  }

  /**
   * Execute a one shot SQL statement with arguments that returns a single SQL row. This method will reduce the
   * boilerplate code by getting a connection from the pool (this object) and return it back after the execution.
   * Only the first result from the result set is returned.
   * @param sql the statement to execute
   * @param arguments the arguments
   * @return self
   */
  public io.vertx.rxjava.ext.sql.SQLOperations querySingleWithParams(java.lang.String sql, io.vertx.core.json.JsonArray arguments) {
    return 
querySingleWithParams(sql, arguments, ar -> { });
  }

    /**
   * Execute a one shot SQL statement with arguments that returns a single SQL row. This method will reduce the
   * boilerplate code by getting a connection from the pool (this object) and return it back after the execution.
   * Only the first result from the result set is returned.
   * @param sql the statement to execute
   * @param arguments the arguments
   * @return self
   */
  public rx.Single<io.vertx.core.json.JsonArray> rxQuerySingleWithParams(java.lang.String sql, io.vertx.core.json.JsonArray arguments) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      querySingleWithParams(sql, arguments, fut);
    }));
  }

  /**
   * Create a JDBC client which maintains its own data source.
   * @param vertx the Vert.x instance
   * @param config the configuration
   * @return the client
   */
  public static io.vertx.rxjava.ext.jdbc.JDBCClient create(io.vertx.rxjava.core.Vertx vertx, io.vertx.core.json.JsonObject config) { 
    io.vertx.rxjava.ext.jdbc.JDBCClient ret = io.vertx.rxjava.ext.jdbc.JDBCClient.newInstance((io.vertx.ext.jdbc.JDBCClient)io.vertx.ext.jdbc.JDBCClient.create(vertx.getDelegate(), config));
    return ret;
  }

  /**
   * Create a JDBC client which shares its data source with any other JDBC clients created with the same
   * data source name
   * @param vertx the Vert.x instance
   * @param config the configuration
   * @param dataSourceName the data source name
   * @return the client
   */
  public static io.vertx.rxjava.ext.jdbc.JDBCClient createShared(io.vertx.rxjava.core.Vertx vertx, io.vertx.core.json.JsonObject config, java.lang.String dataSourceName) { 
    io.vertx.rxjava.ext.jdbc.JDBCClient ret = io.vertx.rxjava.ext.jdbc.JDBCClient.newInstance((io.vertx.ext.jdbc.JDBCClient)io.vertx.ext.jdbc.JDBCClient.createShared(vertx.getDelegate(), config, dataSourceName));
    return ret;
  }

  /**
   * Like {@link io.vertx.rxjava.ext.jdbc.JDBCClient#createShared} but with the default data source name
   * @param vertx the Vert.x instance
   * @param config the configuration
   * @return the client
   */
  public static io.vertx.rxjava.ext.jdbc.JDBCClient createShared(io.vertx.rxjava.core.Vertx vertx, io.vertx.core.json.JsonObject config) { 
    io.vertx.rxjava.ext.jdbc.JDBCClient ret = io.vertx.rxjava.ext.jdbc.JDBCClient.newInstance((io.vertx.ext.jdbc.JDBCClient)io.vertx.ext.jdbc.JDBCClient.createShared(vertx.getDelegate(), config));
    return ret;
  }

  /**
   * The default data source provider is C3P0
   */
  public static final java.lang.String DEFAULT_PROVIDER_CLASS = io.vertx.ext.jdbc.JDBCClient.DEFAULT_PROVIDER_CLASS;
  /**
   * The name of the default data source
   */
  public static final java.lang.String DEFAULT_DS_NAME = io.vertx.ext.jdbc.JDBCClient.DEFAULT_DS_NAME;
  public static JDBCClient newInstance(io.vertx.ext.jdbc.JDBCClient arg) {
    return arg != null ? new JDBCClient(arg) : null;
  }

}
