/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava.ext.healthchecks;

import rx.Observable;
import rx.Single;
import io.vertx.rx.java.RxHelper;
import io.vertx.rx.java.WriteStreamSubscriber;
import io.vertx.rx.java.SingleOnSubscribeAdapter;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.healthchecks.HealthChecks original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.ext.healthchecks.HealthChecks.class)
public class HealthChecks {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    HealthChecks that = (HealthChecks) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<HealthChecks> __TYPE_ARG = new TypeArg<>(    obj -> new HealthChecks((io.vertx.ext.healthchecks.HealthChecks) obj),
    HealthChecks::getDelegate
  );

  private final io.vertx.ext.healthchecks.HealthChecks delegate;
  
  public HealthChecks(io.vertx.ext.healthchecks.HealthChecks delegate) {
    this.delegate = delegate;
  }

  public HealthChecks(Object delegate) {
    this.delegate = (io.vertx.ext.healthchecks.HealthChecks)delegate;
  }

  public io.vertx.ext.healthchecks.HealthChecks getDelegate() {
    return delegate;
  }

  /**
   * Creates a new instance of the default implementation of {@link io.vertx.rxjava.ext.healthchecks.HealthChecks}.
   * @param vertx the instance of Vert.x, must not be <code>null</code>
   * @return the created instance
   */
  public static io.vertx.rxjava.ext.healthchecks.HealthChecks create(io.vertx.rxjava.core.Vertx vertx) { 
    io.vertx.rxjava.ext.healthchecks.HealthChecks ret = io.vertx.rxjava.ext.healthchecks.HealthChecks.newInstance((io.vertx.ext.healthchecks.HealthChecks)io.vertx.ext.healthchecks.HealthChecks.create(vertx.getDelegate()));
    return ret;
  }

  /**
   * Registers a health check procedure.
   * <p>
   * The procedure is a  taking a  of {@link io.vertx.ext.healthchecks.Status} as parameter.
   * Procedures are asynchronous, and <strong>must</strong> complete or fail the given .
   * If the future object is failed, the procedure outcome is considered as `DOWN`. If the future is
   * completed without any object, the procedure outcome is considered as `UP`. If the future is completed
   * with a (not-null) {@link io.vertx.ext.healthchecks.Status}, the procedure outcome is the received status.
   * <p>
   * This method uses a 1s timeout. Use {@link io.vertx.rxjava.ext.healthchecks.HealthChecks#register} to configure the timeout.
   * @param name the name of the procedure, must not be <code>null</code> or empty
   * @param procedure the procedure, must not be <code>null</code>
   * @return the current {@link io.vertx.rxjava.ext.healthchecks.HealthChecks}
   */
  public io.vertx.rxjava.ext.healthchecks.HealthChecks register(java.lang.String name, io.vertx.core.Handler<io.vertx.rxjava.core.Promise<io.vertx.ext.healthchecks.Status>> procedure) { 
    delegate.register(name, new io.vertx.lang.rx.DelegatingHandler<>(procedure, event -> io.vertx.rxjava.core.Promise.newInstance((io.vertx.core.Promise)event, TypeArg.unknown())));
    return this;
  }

  /**
   * Registers a health check procedure.
   * <p>
   * The procedure is a  taking a  of {@link io.vertx.ext.healthchecks.Status} as parameter.
   * Procedures are asynchronous, and <strong>must</strong> complete or fail the given .
   * If the future object is failed, the procedure outcome is considered as `DOWN`. If the future is
   * completed without any object, the procedure outcome is considered as `UP`. If the future is completed
   * with a (not-null) {@link io.vertx.ext.healthchecks.Status}, the procedure outcome is the received status.
   * @param name the name of the procedure, must not be <code>null</code> or empty
   * @param timeout the procedure timeout in milliseconds
   * @param procedure the procedure, must not be <code>null</code>
   * @return the current {@link io.vertx.rxjava.ext.healthchecks.HealthChecks}
   */
  public io.vertx.rxjava.ext.healthchecks.HealthChecks register(java.lang.String name, long timeout, io.vertx.core.Handler<io.vertx.rxjava.core.Promise<io.vertx.ext.healthchecks.Status>> procedure) { 
    io.vertx.rxjava.ext.healthchecks.HealthChecks ret = io.vertx.rxjava.ext.healthchecks.HealthChecks.newInstance((io.vertx.ext.healthchecks.HealthChecks)delegate.register(name, timeout, new io.vertx.lang.rx.DelegatingHandler<>(procedure, event -> io.vertx.rxjava.core.Promise.newInstance((io.vertx.core.Promise)event, TypeArg.unknown()))));
    return ret;
  }

  /**
   * Unregisters a procedure.
   * @param name the name of the procedure
   * @return the current {@link io.vertx.rxjava.ext.healthchecks.HealthChecks}
   */
  public io.vertx.rxjava.ext.healthchecks.HealthChecks unregister(java.lang.String name) { 
    delegate.unregister(name);
    return this;
  }

  /**
   * Invokes the registered procedures and computes the outcome.
   * @param resultHandler the result handler, must not be <code>null</code>. The handler received the computed .
   * @return the current {@link io.vertx.rxjava.ext.healthchecks.HealthChecks}
   */
  public io.vertx.rxjava.ext.healthchecks.HealthChecks invoke(io.vertx.core.Handler<io.vertx.core.json.JsonObject> resultHandler) { 
    delegate.invoke(resultHandler);
    return this;
  }

  /**
   * Invokes the registered procedure with the given name and sub-procedures. It computes the overall
   * outcome.
   * @param name 
   * @param resultHandler the result handler, must not be <code>null</code>. The handler received an  marked as failed if the procedure with the given name cannot be found or invoked.
   * @return the current {@link io.vertx.rxjava.ext.healthchecks.HealthChecks}
   */
  public io.vertx.rxjava.ext.healthchecks.HealthChecks invoke(java.lang.String name, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.core.json.JsonObject>> resultHandler) { 
    delegate.invoke(name, resultHandler);
    return this;
  }

  /**
   * Invokes the registered procedure with the given name and sub-procedures. It computes the overall
   * outcome.
   * @param name 
   * @return the current {@link io.vertx.rxjava.ext.healthchecks.HealthChecks}
   */
  public io.vertx.rxjava.ext.healthchecks.HealthChecks invoke(java.lang.String name) {
    return 
invoke(name, ar -> { });
  }

    /**
   * Invokes the registered procedure with the given name and sub-procedures. It computes the overall
   * outcome.
   * @param name 
   * @return the current {@link io.vertx.rxjava.ext.healthchecks.HealthChecks}
   */
  public rx.Single<io.vertx.core.json.JsonObject> rxInvoke(java.lang.String name) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      invoke(name, fut);
    }));
  }

  /**
   * Invokes the registered procedures.
   * @param resultHandler the result handler, must not be <code>null</code>. The handler received the computed {@link io.vertx.ext.healthchecks.CheckResult}.
   */
  public void checkStatus(io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.ext.healthchecks.CheckResult>> resultHandler) { 
    delegate.checkStatus(resultHandler);
  }

  /**
   * Invokes the registered procedures.
   */
  public void checkStatus() {
    checkStatus(ar -> { });
  }

    /**
   * Invokes the registered procedures.
   * @return 
   */
  public rx.Single<io.vertx.ext.healthchecks.CheckResult> rxCheckStatus() { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      checkStatus(fut);
    }));
  }

  /**
   * Invokes the registered procedure with the given name and sub-procedures.
   * @param name 
   * @param resultHandler the result handler, must not be <code>null</code>. The handler received an  marked as failed if the procedure with the given name cannot be found or invoked.
   */
  public void checkStatus(java.lang.String name, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.ext.healthchecks.CheckResult>> resultHandler) { 
    delegate.checkStatus(name, resultHandler);
  }

  /**
   * Invokes the registered procedure with the given name and sub-procedures.
   * @param name 
   */
  public void checkStatus(java.lang.String name) {
    checkStatus(name, ar -> { });
  }

    /**
   * Invokes the registered procedure with the given name and sub-procedures.
   * @param name 
   * @return 
   */
  public rx.Single<io.vertx.ext.healthchecks.CheckResult> rxCheckStatus(java.lang.String name) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      checkStatus(name, fut);
    }));
  }

  public static HealthChecks newInstance(io.vertx.ext.healthchecks.HealthChecks arg) {
    return arg != null ? new HealthChecks(arg) : null;
  }

}
