/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava.ext.eventbus.bridge.tcp;

import rx.Observable;
import rx.Single;
import io.vertx.rx.java.RxHelper;
import io.vertx.rx.java.WriteStreamSubscriber;
import io.vertx.rx.java.SingleOnSubscribeAdapter;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * TCP EventBus bridge for Vert.x
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.eventbus.bridge.tcp.TcpEventBusBridge original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.ext.eventbus.bridge.tcp.TcpEventBusBridge.class)
public class TcpEventBusBridge {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    TcpEventBusBridge that = (TcpEventBusBridge) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<TcpEventBusBridge> __TYPE_ARG = new TypeArg<>(    obj -> new TcpEventBusBridge((io.vertx.ext.eventbus.bridge.tcp.TcpEventBusBridge) obj),
    TcpEventBusBridge::getDelegate
  );

  private final io.vertx.ext.eventbus.bridge.tcp.TcpEventBusBridge delegate;
  
  public TcpEventBusBridge(io.vertx.ext.eventbus.bridge.tcp.TcpEventBusBridge delegate) {
    this.delegate = delegate;
  }

  public TcpEventBusBridge(Object delegate) {
    this.delegate = (io.vertx.ext.eventbus.bridge.tcp.TcpEventBusBridge)delegate;
  }

  public io.vertx.ext.eventbus.bridge.tcp.TcpEventBusBridge getDelegate() {
    return delegate;
  }

  public static io.vertx.rxjava.ext.eventbus.bridge.tcp.TcpEventBusBridge create(io.vertx.rxjava.core.Vertx vertx) { 
    io.vertx.rxjava.ext.eventbus.bridge.tcp.TcpEventBusBridge ret = io.vertx.rxjava.ext.eventbus.bridge.tcp.TcpEventBusBridge.newInstance((io.vertx.ext.eventbus.bridge.tcp.TcpEventBusBridge)io.vertx.ext.eventbus.bridge.tcp.TcpEventBusBridge.create(vertx.getDelegate()));
    return ret;
  }

  public static io.vertx.rxjava.ext.eventbus.bridge.tcp.TcpEventBusBridge create(io.vertx.rxjava.core.Vertx vertx, io.vertx.ext.bridge.BridgeOptions options) { 
    io.vertx.rxjava.ext.eventbus.bridge.tcp.TcpEventBusBridge ret = io.vertx.rxjava.ext.eventbus.bridge.tcp.TcpEventBusBridge.newInstance((io.vertx.ext.eventbus.bridge.tcp.TcpEventBusBridge)io.vertx.ext.eventbus.bridge.tcp.TcpEventBusBridge.create(vertx.getDelegate(), options));
    return ret;
  }

  public static io.vertx.rxjava.ext.eventbus.bridge.tcp.TcpEventBusBridge create(io.vertx.rxjava.core.Vertx vertx, io.vertx.ext.bridge.BridgeOptions options, io.vertx.core.net.NetServerOptions netServerOptions) { 
    io.vertx.rxjava.ext.eventbus.bridge.tcp.TcpEventBusBridge ret = io.vertx.rxjava.ext.eventbus.bridge.tcp.TcpEventBusBridge.newInstance((io.vertx.ext.eventbus.bridge.tcp.TcpEventBusBridge)io.vertx.ext.eventbus.bridge.tcp.TcpEventBusBridge.create(vertx.getDelegate(), options, netServerOptions));
    return ret;
  }

  public static io.vertx.rxjava.ext.eventbus.bridge.tcp.TcpEventBusBridge create(io.vertx.rxjava.core.Vertx vertx, io.vertx.ext.bridge.BridgeOptions options, io.vertx.core.net.NetServerOptions netServerOptions, io.vertx.core.Handler<io.vertx.rxjava.ext.eventbus.bridge.tcp.BridgeEvent> eventHandler) { 
    io.vertx.rxjava.ext.eventbus.bridge.tcp.TcpEventBusBridge ret = io.vertx.rxjava.ext.eventbus.bridge.tcp.TcpEventBusBridge.newInstance((io.vertx.ext.eventbus.bridge.tcp.TcpEventBusBridge)io.vertx.ext.eventbus.bridge.tcp.TcpEventBusBridge.create(vertx.getDelegate(), options, netServerOptions, new io.vertx.lang.rx.DelegatingHandler<>(eventHandler, event -> io.vertx.rxjava.ext.eventbus.bridge.tcp.BridgeEvent.newInstance((io.vertx.ext.eventbus.bridge.tcp.BridgeEvent)event))));
    return ret;
  }

  /**
   * Listen on default port 7000 with a handler to report the state of the socket listen operation.
   * @param handler the result handler
   * @return self
   */
  public io.vertx.rxjava.ext.eventbus.bridge.tcp.TcpEventBusBridge listen(io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.ext.eventbus.bridge.tcp.TcpEventBusBridge>> handler) { 
    delegate.listen(new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.ext.eventbus.bridge.tcp.TcpEventBusBridge.newInstance((io.vertx.ext.eventbus.bridge.tcp.TcpEventBusBridge)event))));
    return this;
  }

  /**
   * Listen on default port 7000 with a handler to report the state of the socket listen operation.
   * @return self
   */
  public io.vertx.rxjava.ext.eventbus.bridge.tcp.TcpEventBusBridge listen() {
    return 
listen(ar -> { });
  }

    /**
   * Listen on default port 7000 with a handler to report the state of the socket listen operation.
   * @return self
   */
  public rx.Single<io.vertx.rxjava.ext.eventbus.bridge.tcp.TcpEventBusBridge> rxListen() { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      listen(fut);
    }));
  }

  /**
   * Listen on specific port and bind to specific address
   * @param port tcp port
   * @param address tcp address to the bind
   * @param handler the result handler
   * @return self
   */
  public io.vertx.rxjava.ext.eventbus.bridge.tcp.TcpEventBusBridge listen(int port, java.lang.String address, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.ext.eventbus.bridge.tcp.TcpEventBusBridge>> handler) { 
    delegate.listen(port, address, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.ext.eventbus.bridge.tcp.TcpEventBusBridge.newInstance((io.vertx.ext.eventbus.bridge.tcp.TcpEventBusBridge)event))));
    return this;
  }

  /**
   * Listen on specific port and bind to specific address
   * @param port tcp port
   * @param address tcp address to the bind
   * @return self
   */
  public io.vertx.rxjava.ext.eventbus.bridge.tcp.TcpEventBusBridge listen(int port, java.lang.String address) {
    return 
listen(port, address, ar -> { });
  }

    /**
   * Listen on specific port and bind to specific address
   * @param port tcp port
   * @param address tcp address to the bind
   * @return self
   */
  public rx.Single<io.vertx.rxjava.ext.eventbus.bridge.tcp.TcpEventBusBridge> rxListen(int port, java.lang.String address) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      listen(port, address, fut);
    }));
  }

  /**
   * Listen on specific port
   * @param port tcp port
   * @param handler the result handler
   * @return self
   */
  public io.vertx.rxjava.ext.eventbus.bridge.tcp.TcpEventBusBridge listen(int port, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.ext.eventbus.bridge.tcp.TcpEventBusBridge>> handler) { 
    delegate.listen(port, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.ext.eventbus.bridge.tcp.TcpEventBusBridge.newInstance((io.vertx.ext.eventbus.bridge.tcp.TcpEventBusBridge)event))));
    return this;
  }

  /**
   * Listen on specific port
   * @param port tcp port
   * @return self
   */
  public io.vertx.rxjava.ext.eventbus.bridge.tcp.TcpEventBusBridge listen(int port) {
    return 
listen(port, ar -> { });
  }

    /**
   * Listen on specific port
   * @param port tcp port
   * @return self
   */
  public rx.Single<io.vertx.rxjava.ext.eventbus.bridge.tcp.TcpEventBusBridge> rxListen(int port) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      listen(port, fut);
    }));
  }

  /**
   * Close the current socket.
   * @param handler the result handler
   */
  public void close(io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.Void>> handler) { 
    delegate.close(handler);
  }

  /**
   * Close the current socket.
   */
  public void close() {
    close(ar -> { });
  }

    /**
   * Close the current socket.
   * @return 
   */
  public rx.Single<java.lang.Void> rxClose() { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      close(fut);
    }));
  }

  public static TcpEventBusBridge newInstance(io.vertx.ext.eventbus.bridge.tcp.TcpEventBusBridge arg) {
    return arg != null ? new TcpEventBusBridge(arg) : null;
  }

}
