/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava.ext.auth.sqlclient;

import rx.Observable;
import rx.Single;
import io.vertx.rx.java.RxHelper;
import io.vertx.rx.java.WriteStreamSubscriber;
import io.vertx.rx.java.SingleOnSubscribeAdapter;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * Utility to create users/roles/permissions. This is a helper class and not intended to be a full user
 * management utility. While the standard authentication and authorization interfaces will require usually
 * read only access to the database, in order to use this API a full read/write access must be granted.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.auth.sqlclient.SqlUserUtil original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.ext.auth.sqlclient.SqlUserUtil.class)
public class SqlUserUtil {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SqlUserUtil that = (SqlUserUtil) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<SqlUserUtil> __TYPE_ARG = new TypeArg<>(    obj -> new SqlUserUtil((io.vertx.ext.auth.sqlclient.SqlUserUtil) obj),
    SqlUserUtil::getDelegate
  );

  private final io.vertx.ext.auth.sqlclient.SqlUserUtil delegate;
  
  public SqlUserUtil(io.vertx.ext.auth.sqlclient.SqlUserUtil delegate) {
    this.delegate = delegate;
  }

  public SqlUserUtil(Object delegate) {
    this.delegate = (io.vertx.ext.auth.sqlclient.SqlUserUtil)delegate;
  }

  public io.vertx.ext.auth.sqlclient.SqlUserUtil getDelegate() {
    return delegate;
  }

  /**
   * Create an instance of the user helper.
   * @param client the client with write rights to the database.
   * @return the instance
   */
  public static io.vertx.rxjava.ext.auth.sqlclient.SqlUserUtil create(io.vertx.rxjava.sqlclient.SqlClient client) { 
    io.vertx.rxjava.ext.auth.sqlclient.SqlUserUtil ret = io.vertx.rxjava.ext.auth.sqlclient.SqlUserUtil.newInstance((io.vertx.ext.auth.sqlclient.SqlUserUtil)io.vertx.ext.auth.sqlclient.SqlUserUtil.create(client.getDelegate()));
    return ret;
  }

  /**
   * Create an instance of the user helper with custom queries.
   * @param client the client with write rights to the database.
   * @param insertUserSQL 
   * @param insertUserRoleSQL 
   * @param insertRolePermissionSQL 
   * @return the instance
   */
  public static io.vertx.rxjava.ext.auth.sqlclient.SqlUserUtil create(io.vertx.rxjava.sqlclient.SqlClient client, java.lang.String insertUserSQL, java.lang.String insertUserRoleSQL, java.lang.String insertRolePermissionSQL) { 
    io.vertx.rxjava.ext.auth.sqlclient.SqlUserUtil ret = io.vertx.rxjava.ext.auth.sqlclient.SqlUserUtil.newInstance((io.vertx.ext.auth.sqlclient.SqlUserUtil)io.vertx.ext.auth.sqlclient.SqlUserUtil.create(client.getDelegate(), insertUserSQL, insertUserRoleSQL, insertRolePermissionSQL));
    return ret;
  }

  /**
   * Insert a user into a database.
   * @param username the username to be set
   * @param password the passsword in clear text, will be adapted following the definitions of the defined strategy
   * @param resultHandler the ResultHandler will be provided with the result of the operation
   * @return fluent self
   */
  public io.vertx.rxjava.ext.auth.sqlclient.SqlUserUtil createUser(java.lang.String username, java.lang.String password, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.Void>> resultHandler) { 
    delegate.createUser(username, password, resultHandler);
    return this;
  }

  /**
   * Insert a user into a database.
   * @param username the username to be set
   * @param password the passsword in clear text, will be adapted following the definitions of the defined strategy
   * @return fluent self
   */
  public io.vertx.rxjava.ext.auth.sqlclient.SqlUserUtil createUser(java.lang.String username, java.lang.String password) {
    return 
createUser(username, password, ar -> { });
  }

    /**
   * Insert a user into a database.
   * @param username the username to be set
   * @param password the passsword in clear text, will be adapted following the definitions of the defined strategy
   * @return fluent self
   */
  public rx.Single<java.lang.Void> rxCreateUser(java.lang.String username, java.lang.String password) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      createUser(username, password, fut);
    }));
  }

  /**
   * Insert a user into a database.
   * @param username the username to be set
   * @param hash the password hash, as result of {@link io.vertx.rxjava.ext.auth.HashingStrategy#hash}
   * @param resultHandler the ResultHandler will be provided with the result of the operation
   * @return fluent self
   */
  public io.vertx.rxjava.ext.auth.sqlclient.SqlUserUtil createHashedUser(java.lang.String username, java.lang.String hash, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.Void>> resultHandler) { 
    delegate.createHashedUser(username, hash, resultHandler);
    return this;
  }

  /**
   * Insert a user into a database.
   * @param username the username to be set
   * @param hash the password hash, as result of {@link io.vertx.rxjava.ext.auth.HashingStrategy#hash}
   * @return fluent self
   */
  public io.vertx.rxjava.ext.auth.sqlclient.SqlUserUtil createHashedUser(java.lang.String username, java.lang.String hash) {
    return 
createHashedUser(username, hash, ar -> { });
  }

    /**
   * Insert a user into a database.
   * @param username the username to be set
   * @param hash the password hash, as result of {@link io.vertx.rxjava.ext.auth.HashingStrategy#hash}
   * @return fluent self
   */
  public rx.Single<java.lang.Void> rxCreateHashedUser(java.lang.String username, java.lang.String hash) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      createHashedUser(username, hash, fut);
    }));
  }

  /**
   * Insert a user role into a database.
   * @param username the username to be set
   * @param role a to be set
   * @param resultHandler the ResultHandler will be provided with the result of the operation
   * @return fluent self
   */
  public io.vertx.rxjava.ext.auth.sqlclient.SqlUserUtil createUserRole(java.lang.String username, java.lang.String role, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.Void>> resultHandler) { 
    delegate.createUserRole(username, role, resultHandler);
    return this;
  }

  /**
   * Insert a user role into a database.
   * @param username the username to be set
   * @param role a to be set
   * @return fluent self
   */
  public io.vertx.rxjava.ext.auth.sqlclient.SqlUserUtil createUserRole(java.lang.String username, java.lang.String role) {
    return 
createUserRole(username, role, ar -> { });
  }

    /**
   * Insert a user role into a database.
   * @param username the username to be set
   * @param role a to be set
   * @return fluent self
   */
  public rx.Single<java.lang.Void> rxCreateUserRole(java.lang.String username, java.lang.String role) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      createUserRole(username, role, fut);
    }));
  }

  /**
   * Insert a role permission into a database.
   * @param role a to be set
   * @param permission the permission to be set
   * @param resultHandler the ResultHandler will be provided with the result of the operation
   * @return fluent self
   */
  public io.vertx.rxjava.ext.auth.sqlclient.SqlUserUtil createRolePermission(java.lang.String role, java.lang.String permission, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.Void>> resultHandler) { 
    delegate.createRolePermission(role, permission, resultHandler);
    return this;
  }

  /**
   * Insert a role permission into a database.
   * @param role a to be set
   * @param permission the permission to be set
   * @return fluent self
   */
  public io.vertx.rxjava.ext.auth.sqlclient.SqlUserUtil createRolePermission(java.lang.String role, java.lang.String permission) {
    return 
createRolePermission(role, permission, ar -> { });
  }

    /**
   * Insert a role permission into a database.
   * @param role a to be set
   * @param permission the permission to be set
   * @return fluent self
   */
  public rx.Single<java.lang.Void> rxCreateRolePermission(java.lang.String role, java.lang.String permission) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      createRolePermission(role, permission, fut);
    }));
  }

  public static SqlUserUtil newInstance(io.vertx.ext.auth.sqlclient.SqlUserUtil arg) {
    return arg != null ? new SqlUserUtil(arg) : null;
  }

}
