/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava.ext.auth.oauth2.providers;

import rx.Observable;
import rx.Single;
import io.vertx.rx.java.RxHelper;
import io.vertx.rx.java.WriteStreamSubscriber;
import io.vertx.rx.java.SingleOnSubscribeAdapter;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * Simplified factory to create an  for IBM Cloud.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.auth.oauth2.providers.IBMCloudAuth original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.ext.auth.oauth2.providers.IBMCloudAuth.class)
public class IBMCloudAuth extends io.vertx.rxjava.ext.auth.oauth2.providers.OpenIDConnectAuth {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    IBMCloudAuth that = (IBMCloudAuth) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<IBMCloudAuth> __TYPE_ARG = new TypeArg<>(    obj -> new IBMCloudAuth((io.vertx.ext.auth.oauth2.providers.IBMCloudAuth) obj),
    IBMCloudAuth::getDelegate
  );

  private final io.vertx.ext.auth.oauth2.providers.IBMCloudAuth delegate;
  
  public IBMCloudAuth(io.vertx.ext.auth.oauth2.providers.IBMCloudAuth delegate) {
    super(delegate);
    this.delegate = delegate;
  }

  public IBMCloudAuth(Object delegate) {
    super((io.vertx.ext.auth.oauth2.providers.IBMCloudAuth)delegate);
    this.delegate = (io.vertx.ext.auth.oauth2.providers.IBMCloudAuth)delegate;
  }

  public io.vertx.ext.auth.oauth2.providers.IBMCloudAuth getDelegate() {
    return delegate;
  }

  /**
   * Create a OAuth2Auth provider for IBM Cloud
   * @param vertx 
   * @param region the region to use
   * @param clientId the client id given to you by IBM Cloud
   * @param clientSecret the client secret given to you by IBM Cloud
   * @param guid the guid of your application given to you by IBM Cloud
   * @return 
   */
  public static io.vertx.rxjava.ext.auth.oauth2.OAuth2Auth create(io.vertx.rxjava.core.Vertx vertx, java.lang.String region, java.lang.String clientId, java.lang.String clientSecret, java.lang.String guid) { 
    io.vertx.rxjava.ext.auth.oauth2.OAuth2Auth ret = io.vertx.rxjava.ext.auth.oauth2.OAuth2Auth.newInstance((io.vertx.ext.auth.oauth2.OAuth2Auth)io.vertx.ext.auth.oauth2.providers.IBMCloudAuth.create(vertx.getDelegate(), region, clientId, clientSecret, guid));
    return ret;
  }

  /**
   * Create a OAuth2Auth provider for IBM Cloud
   * @param vertx 
   * @param region the region to use
   * @param clientId the client id given to you by IBM Cloud
   * @param clientSecret the client secret given to you by IBM Cloud
   * @param guid the guid of your application given to you by IBM Cloud
   * @param httpClientOptions custom http client options
   * @return 
   */
  public static io.vertx.rxjava.ext.auth.oauth2.OAuth2Auth create(io.vertx.rxjava.core.Vertx vertx, java.lang.String region, java.lang.String clientId, java.lang.String clientSecret, java.lang.String guid, io.vertx.core.http.HttpClientOptions httpClientOptions) { 
    io.vertx.rxjava.ext.auth.oauth2.OAuth2Auth ret = io.vertx.rxjava.ext.auth.oauth2.OAuth2Auth.newInstance((io.vertx.ext.auth.oauth2.OAuth2Auth)io.vertx.ext.auth.oauth2.providers.IBMCloudAuth.create(vertx.getDelegate(), region, clientId, clientSecret, guid, httpClientOptions));
    return ret;
  }

  /**
   * Create a OAuth2Auth provider for OpenID Connect Discovery. The discovery will use the default site in the
   * configuration options and attempt to load the well known descriptor. If a site is provided (for example when
   * running on a custom instance) that site will be used to do the lookup.
   * <p>
   * If the discovered config includes a json web key url, it will be also fetched and the JWKs will be loaded
   * into the OAuth provider so tokens can be decoded.
   * @param vertx the vertx instance
   * @param config the initial config
   * @param handler the instantiated Oauth2 provider instance handler
   */
  public static void discover(io.vertx.rxjava.core.Vertx vertx, io.vertx.ext.auth.oauth2.OAuth2Options config, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.ext.auth.oauth2.OAuth2Auth>> handler) { 
    io.vertx.ext.auth.oauth2.providers.IBMCloudAuth.discover(vertx.getDelegate(), config, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.ext.auth.oauth2.OAuth2Auth.newInstance((io.vertx.ext.auth.oauth2.OAuth2Auth)event))));
  }

  /**
   * Create a OAuth2Auth provider for OpenID Connect Discovery. The discovery will use the default site in the
   * configuration options and attempt to load the well known descriptor. If a site is provided (for example when
   * running on a custom instance) that site will be used to do the lookup.
   * <p>
   * If the discovered config includes a json web key url, it will be also fetched and the JWKs will be loaded
   * into the OAuth provider so tokens can be decoded.
   * @param vertx the vertx instance
   * @param config the initial config
   */
  public static void discover(io.vertx.rxjava.core.Vertx vertx, io.vertx.ext.auth.oauth2.OAuth2Options config) {
    discover(vertx, config, ar -> { });
  }

    /**
   * Create a OAuth2Auth provider for OpenID Connect Discovery. The discovery will use the default site in the
   * configuration options and attempt to load the well known descriptor. If a site is provided (for example when
   * running on a custom instance) that site will be used to do the lookup.
   * <p>
   * If the discovered config includes a json web key url, it will be also fetched and the JWKs will be loaded
   * into the OAuth provider so tokens can be decoded.
   * @param vertx the vertx instance
   * @param config the initial config
   * @return 
   */
  public static rx.Single<io.vertx.rxjava.ext.auth.oauth2.OAuth2Auth> rxDiscover(io.vertx.rxjava.core.Vertx vertx, io.vertx.ext.auth.oauth2.OAuth2Options config) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      discover(vertx, config, fut);
    }));
  }

  public static IBMCloudAuth newInstance(io.vertx.ext.auth.oauth2.providers.IBMCloudAuth arg) {
    return arg != null ? new IBMCloudAuth(arg) : null;
  }

}
