/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava.ext.auth.mongo;

import rx.Observable;
import rx.Single;
import io.vertx.rx.java.RxHelper;
import io.vertx.rx.java.WriteStreamSubscriber;
import io.vertx.rx.java.SingleOnSubscribeAdapter;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * Utility to create users/roles/permissions. This is a helper class and not intended to be a full user
 * management utility. While the standard authentication and authorization interfaces will require usually
 * read only access to the database, in order to use this API a full read/write access must be granted.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.auth.mongo.MongoUserUtil original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.ext.auth.mongo.MongoUserUtil.class)
public class MongoUserUtil {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    MongoUserUtil that = (MongoUserUtil) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<MongoUserUtil> __TYPE_ARG = new TypeArg<>(    obj -> new MongoUserUtil((io.vertx.ext.auth.mongo.MongoUserUtil) obj),
    MongoUserUtil::getDelegate
  );

  private final io.vertx.ext.auth.mongo.MongoUserUtil delegate;
  
  public MongoUserUtil(io.vertx.ext.auth.mongo.MongoUserUtil delegate) {
    this.delegate = delegate;
  }

  public MongoUserUtil(Object delegate) {
    this.delegate = (io.vertx.ext.auth.mongo.MongoUserUtil)delegate;
  }

  public io.vertx.ext.auth.mongo.MongoUserUtil getDelegate() {
    return delegate;
  }

  /**
   * Create an instance of the user helper.
   * @param client the client with write rights to the database.
   * @return the instance
   */
  public static io.vertx.rxjava.ext.auth.mongo.MongoUserUtil create(io.vertx.rxjava.ext.mongo.MongoClient client) { 
    io.vertx.rxjava.ext.auth.mongo.MongoUserUtil ret = io.vertx.rxjava.ext.auth.mongo.MongoUserUtil.newInstance((io.vertx.ext.auth.mongo.MongoUserUtil)io.vertx.ext.auth.mongo.MongoUserUtil.create(client.getDelegate()));
    return ret;
  }

  /**
   * Create an instance of the user helper with custom queries.
   * @param client the client with write rights to the database.
   * @param authenticationOptions 
   * @param authorizationOptions 
   * @return the instance
   */
  public static io.vertx.rxjava.ext.auth.mongo.MongoUserUtil create(io.vertx.rxjava.ext.mongo.MongoClient client, io.vertx.ext.auth.mongo.MongoAuthenticationOptions authenticationOptions, io.vertx.ext.auth.mongo.MongoAuthorizationOptions authorizationOptions) { 
    io.vertx.rxjava.ext.auth.mongo.MongoUserUtil ret = io.vertx.rxjava.ext.auth.mongo.MongoUserUtil.newInstance((io.vertx.ext.auth.mongo.MongoUserUtil)io.vertx.ext.auth.mongo.MongoUserUtil.create(client.getDelegate(), authenticationOptions, authorizationOptions));
    return ret;
  }

  /**
   * Insert a user into a database.
   * @param username the username to be set
   * @param password the password in clear text, will be adapted following the definitions of the defined strategy
   * @param resultHandler the ResultHandler will be provided with the result of the operation and the created user document identifier
   * @return fluent self
   */
  public io.vertx.rxjava.ext.auth.mongo.MongoUserUtil createUser(java.lang.String username, java.lang.String password, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.String>> resultHandler) { 
    delegate.createUser(username, password, resultHandler);
    return this;
  }

  /**
   * Insert a user into a database.
   * @param username the username to be set
   * @param password the password in clear text, will be adapted following the definitions of the defined strategy
   * @return fluent self
   */
  public io.vertx.rxjava.ext.auth.mongo.MongoUserUtil createUser(java.lang.String username, java.lang.String password) {
    return 
createUser(username, password, ar -> { });
  }

    /**
   * Insert a user into a database.
   * @param username the username to be set
   * @param password the password in clear text, will be adapted following the definitions of the defined strategy
   * @return fluent self
   */
  public rx.Single<java.lang.String> rxCreateUser(java.lang.String username, java.lang.String password) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      createUser(username, password, fut);
    }));
  }

  /**
   * Insert a user into a database.
   * @param username the username to be set
   * @param hash the password hash, as result of {@link io.vertx.rxjava.ext.auth.HashingStrategy#hash}
   * @param resultHandler the ResultHandler will be provided with the result of the operation and the created user document identifier
   * @return fluent self
   */
  public io.vertx.rxjava.ext.auth.mongo.MongoUserUtil createHashedUser(java.lang.String username, java.lang.String hash, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.String>> resultHandler) { 
    delegate.createHashedUser(username, hash, resultHandler);
    return this;
  }

  /**
   * Insert a user into a database.
   * @param username the username to be set
   * @param hash the password hash, as result of {@link io.vertx.rxjava.ext.auth.HashingStrategy#hash}
   * @return fluent self
   */
  public io.vertx.rxjava.ext.auth.mongo.MongoUserUtil createHashedUser(java.lang.String username, java.lang.String hash) {
    return 
createHashedUser(username, hash, ar -> { });
  }

    /**
   * Insert a user into a database.
   * @param username the username to be set
   * @param hash the password hash, as result of {@link io.vertx.rxjava.ext.auth.HashingStrategy#hash}
   * @return fluent self
   */
  public rx.Single<java.lang.String> rxCreateHashedUser(java.lang.String username, java.lang.String hash) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      createHashedUser(username, hash, fut);
    }));
  }

  /**
   * Insert a user role into a database.
   * @param username the username to be set
   * @param roles a to be set
   * @param permissions a to be set
   * @param resultHandler the ResultHandler will be provided with the result of the operation and the created user document identifier
   * @return fluent self
   */
  public io.vertx.rxjava.ext.auth.mongo.MongoUserUtil createUserRolesAndPermissions(java.lang.String username, java.util.List<java.lang.String> roles, java.util.List<java.lang.String> permissions, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.String>> resultHandler) { 
    delegate.createUserRolesAndPermissions(username, roles, permissions, resultHandler);
    return this;
  }

  /**
   * Insert a user role into a database.
   * @param username the username to be set
   * @param roles a to be set
   * @param permissions a to be set
   * @return fluent self
   */
  public io.vertx.rxjava.ext.auth.mongo.MongoUserUtil createUserRolesAndPermissions(java.lang.String username, java.util.List<java.lang.String> roles, java.util.List<java.lang.String> permissions) {
    return 
createUserRolesAndPermissions(username, roles, permissions, ar -> { });
  }

    /**
   * Insert a user role into a database.
   * @param username the username to be set
   * @param roles a to be set
   * @param permissions a to be set
   * @return fluent self
   */
  public rx.Single<java.lang.String> rxCreateUserRolesAndPermissions(java.lang.String username, java.util.List<java.lang.String> roles, java.util.List<java.lang.String> permissions) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      createUserRolesAndPermissions(username, roles, permissions, fut);
    }));
  }

  public static MongoUserUtil newInstance(io.vertx.ext.auth.mongo.MongoUserUtil arg) {
    return arg != null ? new MongoUserUtil(arg) : null;
  }

}
