/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava.ext.auth.jwt;

import rx.Observable;
import rx.Single;
import io.vertx.rx.java.RxHelper;
import io.vertx.rx.java.WriteStreamSubscriber;
import io.vertx.rx.java.SingleOnSubscribeAdapter;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * Factory interface for creating JWT based {@link io.vertx.rxjava.ext.auth.authentication.AuthenticationProvider} instances.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.auth.jwt.JWTAuth original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.ext.auth.jwt.JWTAuth.class)
public class JWTAuth extends io.vertx.rxjava.ext.auth.authentication.AuthenticationProvider {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    JWTAuth that = (JWTAuth) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<JWTAuth> __TYPE_ARG = new TypeArg<>(    obj -> new JWTAuth((io.vertx.ext.auth.jwt.JWTAuth) obj),
    JWTAuth::getDelegate
  );

  private final io.vertx.ext.auth.jwt.JWTAuth delegate;
  
  public JWTAuth(io.vertx.ext.auth.jwt.JWTAuth delegate) {
    super(delegate);
    this.delegate = delegate;
  }

  public JWTAuth(Object delegate) {
    super((io.vertx.ext.auth.jwt.JWTAuth)delegate);
    this.delegate = (io.vertx.ext.auth.jwt.JWTAuth)delegate;
  }

  public io.vertx.ext.auth.jwt.JWTAuth getDelegate() {
    return delegate;
  }

  /**
   * Create a JWT auth provider
   * @param vertx the Vertx instance
   * @param config the config
   * @return the auth provider
   */
  public static io.vertx.rxjava.ext.auth.jwt.JWTAuth create(io.vertx.rxjava.core.Vertx vertx, io.vertx.ext.auth.jwt.JWTAuthOptions config) { 
    io.vertx.rxjava.ext.auth.jwt.JWTAuth ret = io.vertx.rxjava.ext.auth.jwt.JWTAuth.newInstance((io.vertx.ext.auth.jwt.JWTAuth)io.vertx.ext.auth.jwt.JWTAuth.create(vertx.getDelegate(), config));
    return ret;
  }

  /**
   * Generate a new JWT token.
   * @param claims Json with user defined claims for a list of official claims
   * @param options extra options for the generation
   * @return JWT encoded token
   */
  public java.lang.String generateToken(io.vertx.core.json.JsonObject claims, io.vertx.ext.auth.JWTOptions options) { 
    java.lang.String ret = delegate.generateToken(claims, options);
    return ret;
  }

  /**
   * Generate a new JWT token.
   * @param claims Json with user defined claims for a list of official claims
   * @return JWT encoded token
   */
  public java.lang.String generateToken(io.vertx.core.json.JsonObject claims) { 
    java.lang.String ret = delegate.generateToken(claims);
    return ret;
  }

  public static JWTAuth newInstance(io.vertx.ext.auth.jwt.JWTAuth arg) {
    return arg != null ? new JWTAuth(arg) : null;
  }

}
