/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava.ext.auth.authorization;

import rx.Observable;
import rx.Single;
import io.vertx.rx.java.RxHelper;
import io.vertx.rx.java.WriteStreamSubscriber;
import io.vertx.rx.java.SingleOnSubscribeAdapter;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * Represents a permission Note that the permission can optionally be assigned
 * to a specific resource
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.auth.authorization.PermissionBasedAuthorization original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.ext.auth.authorization.PermissionBasedAuthorization.class)
public class PermissionBasedAuthorization extends io.vertx.rxjava.ext.auth.authorization.Authorization {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    PermissionBasedAuthorization that = (PermissionBasedAuthorization) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<PermissionBasedAuthorization> __TYPE_ARG = new TypeArg<>(    obj -> new PermissionBasedAuthorization((io.vertx.ext.auth.authorization.PermissionBasedAuthorization) obj),
    PermissionBasedAuthorization::getDelegate
  );

  private final io.vertx.ext.auth.authorization.PermissionBasedAuthorization delegate;
  
  public PermissionBasedAuthorization(io.vertx.ext.auth.authorization.PermissionBasedAuthorization delegate) {
    super(delegate);
    this.delegate = delegate;
  }

  public PermissionBasedAuthorization(Object delegate) {
    super((io.vertx.ext.auth.authorization.PermissionBasedAuthorization)delegate);
    this.delegate = (io.vertx.ext.auth.authorization.PermissionBasedAuthorization)delegate;
  }

  public io.vertx.ext.auth.authorization.PermissionBasedAuthorization getDelegate() {
    return delegate;
  }

  public static io.vertx.rxjava.ext.auth.authorization.PermissionBasedAuthorization create(java.lang.String permission) { 
    io.vertx.rxjava.ext.auth.authorization.PermissionBasedAuthorization ret = io.vertx.rxjava.ext.auth.authorization.PermissionBasedAuthorization.newInstance((io.vertx.ext.auth.authorization.PermissionBasedAuthorization)io.vertx.ext.auth.authorization.PermissionBasedAuthorization.create(permission));
    return ret;
  }

  /**
   * returns the value of the permission
   * @return 
   */
  public java.lang.String getPermission() { 
    java.lang.String ret = delegate.getPermission();
    return ret;
  }

  /**
   * returns an optional resource that the permission is assigned-on
   * @return 
   */
  public java.lang.String getResource() { 
    java.lang.String ret = delegate.getResource();
    return ret;
  }

  /**
   * sets an optional resource that the permission is assigned-on
   * @param resource 
   * @return 
   */
  public io.vertx.rxjava.ext.auth.authorization.PermissionBasedAuthorization setResource(java.lang.String resource) { 
    delegate.setResource(resource);
    return this;
  }

  public static PermissionBasedAuthorization newInstance(io.vertx.ext.auth.authorization.PermissionBasedAuthorization arg) {
    return arg != null ? new PermissionBasedAuthorization(arg) : null;
  }

}
